/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies capacity units configured for your index. You can add and remove capacity units to tune an index to your
 * requirements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityUnitsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityUnitsConfiguration.Builder, CapacityUnitsConfiguration> {
    private static final SdkField<Integer> STORAGE_CAPACITY_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StorageCapacityUnits").getter(getter(CapacityUnitsConfiguration::storageCapacityUnits))
            .setter(setter(Builder::storageCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageCapacityUnits").build())
            .build();

    private static final SdkField<Integer> QUERY_CAPACITY_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("QueryCapacityUnits").getter(getter(CapacityUnitsConfiguration::queryCapacityUnits))
            .setter(setter(Builder::queryCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryCapacityUnits").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_CAPACITY_UNITS_FIELD,
            QUERY_CAPACITY_UNITS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer storageCapacityUnits;

    private final Integer queryCapacityUnits;

    private CapacityUnitsConfiguration(BuilderImpl builder) {
        this.storageCapacityUnits = builder.storageCapacityUnits;
        this.queryCapacityUnits = builder.queryCapacityUnits;
    }

    /**
     * <p>
     * The amount of extra storage capacity for an index. Each capacity unit provides 150 Gb of storage space or 500,000
     * documents, whichever is reached first.
     * </p>
     * 
     * @return The amount of extra storage capacity for an index. Each capacity unit provides 150 Gb of storage space or
     *         500,000 documents, whichever is reached first.
     */
    public final Integer storageCapacityUnits() {
        return storageCapacityUnits;
    }

    /**
     * <p>
     * The amount of extra query capacity for an index. Each capacity unit provides 0.5 queries per second and 40,000
     * queries per day.
     * </p>
     * 
     * @return The amount of extra query capacity for an index. Each capacity unit provides 0.5 queries per second and
     *         40,000 queries per day.
     */
    public final Integer queryCapacityUnits() {
        return queryCapacityUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(storageCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(queryCapacityUnits());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityUnitsConfiguration)) {
            return false;
        }
        CapacityUnitsConfiguration other = (CapacityUnitsConfiguration) obj;
        return Objects.equals(storageCapacityUnits(), other.storageCapacityUnits())
                && Objects.equals(queryCapacityUnits(), other.queryCapacityUnits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityUnitsConfiguration").add("StorageCapacityUnits", storageCapacityUnits())
                .add("QueryCapacityUnits", queryCapacityUnits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorageCapacityUnits":
            return Optional.ofNullable(clazz.cast(storageCapacityUnits()));
        case "QueryCapacityUnits":
            return Optional.ofNullable(clazz.cast(queryCapacityUnits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CapacityUnitsConfiguration, T> g) {
        return obj -> g.apply((CapacityUnitsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityUnitsConfiguration> {
        /**
         * <p>
         * The amount of extra storage capacity for an index. Each capacity unit provides 150 Gb of storage space or
         * 500,000 documents, whichever is reached first.
         * </p>
         * 
         * @param storageCapacityUnits
         *        The amount of extra storage capacity for an index. Each capacity unit provides 150 Gb of storage space
         *        or 500,000 documents, whichever is reached first.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageCapacityUnits(Integer storageCapacityUnits);

        /**
         * <p>
         * The amount of extra query capacity for an index. Each capacity unit provides 0.5 queries per second and
         * 40,000 queries per day.
         * </p>
         * 
         * @param queryCapacityUnits
         *        The amount of extra query capacity for an index. Each capacity unit provides 0.5 queries per second
         *        and 40,000 queries per day.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryCapacityUnits(Integer queryCapacityUnits);
    }

    static final class BuilderImpl implements Builder {
        private Integer storageCapacityUnits;

        private Integer queryCapacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityUnitsConfiguration model) {
            storageCapacityUnits(model.storageCapacityUnits);
            queryCapacityUnits(model.queryCapacityUnits);
        }

        public final Integer getStorageCapacityUnits() {
            return storageCapacityUnits;
        }

        @Override
        public final Builder storageCapacityUnits(Integer storageCapacityUnits) {
            this.storageCapacityUnits = storageCapacityUnits;
            return this;
        }

        public final void setStorageCapacityUnits(Integer storageCapacityUnits) {
            this.storageCapacityUnits = storageCapacityUnits;
        }

        public final Integer getQueryCapacityUnits() {
            return queryCapacityUnits;
        }

        @Override
        public final Builder queryCapacityUnits(Integer queryCapacityUnits) {
            this.queryCapacityUnits = queryCapacityUnits;
            return this;
        }

        public final void setQueryCapacityUnits(Integer queryCapacityUnits) {
            this.queryCapacityUnits = queryCapacityUnits;
        }

        @Override
        public CapacityUnitsConfiguration build() {
            return new CapacityUnitsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
