/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides configuration information for indexing Salesforce custom articles.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SalesforceCustomKnowledgeArticleTypeConfiguration
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<SalesforceCustomKnowledgeArticleTypeConfiguration.Builder, SalesforceCustomKnowledgeArticleTypeConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(SalesforceCustomKnowledgeArticleTypeConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DOCUMENT_DATA_FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentDataFieldName")
            .getter(getter(SalesforceCustomKnowledgeArticleTypeConfiguration::documentDataFieldName))
            .setter(setter(Builder::documentDataFieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentDataFieldName").build())
            .build();

    private static final SdkField<String> DOCUMENT_TITLE_FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentTitleFieldName")
            .getter(getter(SalesforceCustomKnowledgeArticleTypeConfiguration::documentTitleFieldName))
            .setter(setter(Builder::documentTitleFieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentTitleFieldName").build())
            .build();

    private static final SdkField<List<DataSourceToIndexFieldMapping>> FIELD_MAPPINGS_FIELD = SdkField
            .<List<DataSourceToIndexFieldMapping>> builder(MarshallingType.LIST)
            .memberName("FieldMappings")
            .getter(getter(SalesforceCustomKnowledgeArticleTypeConfiguration::fieldMappings))
            .setter(setter(Builder::fieldMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSourceToIndexFieldMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSourceToIndexFieldMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            DOCUMENT_DATA_FIELD_NAME_FIELD, DOCUMENT_TITLE_FIELD_NAME_FIELD, FIELD_MAPPINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String documentDataFieldName;

    private final String documentTitleFieldName;

    private final List<DataSourceToIndexFieldMapping> fieldMappings;

    private SalesforceCustomKnowledgeArticleTypeConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.documentDataFieldName = builder.documentDataFieldName;
        this.documentTitleFieldName = builder.documentTitleFieldName;
        this.fieldMappings = builder.fieldMappings;
    }

    /**
     * <p>
     * The name of the configuration.
     * </p>
     * 
     * @return The name of the configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the field in the custom knowledge article that contains the document data to index.
     * </p>
     * 
     * @return The name of the field in the custom knowledge article that contains the document data to index.
     */
    public final String documentDataFieldName() {
        return documentDataFieldName;
    }

    /**
     * <p>
     * The name of the field in the custom knowledge article that contains the document title.
     * </p>
     * 
     * @return The name of the field in the custom knowledge article that contains the document title.
     */
    public final String documentTitleFieldName() {
        return documentTitleFieldName;
    }

    /**
     * Returns true if the FieldMappings property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFieldMappings() {
        return fieldMappings != null && !(fieldMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more objects that map fields in the custom knowledge article to fields in the Amazon Kendra index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFieldMappings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more objects that map fields in the custom knowledge article to fields in the Amazon Kendra index.
     */
    public final List<DataSourceToIndexFieldMapping> fieldMappings() {
        return fieldMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(documentDataFieldName());
        hashCode = 31 * hashCode + Objects.hashCode(documentTitleFieldName());
        hashCode = 31 * hashCode + Objects.hashCode(hasFieldMappings() ? fieldMappings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceCustomKnowledgeArticleTypeConfiguration)) {
            return false;
        }
        SalesforceCustomKnowledgeArticleTypeConfiguration other = (SalesforceCustomKnowledgeArticleTypeConfiguration) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(documentDataFieldName(), other.documentDataFieldName())
                && Objects.equals(documentTitleFieldName(), other.documentTitleFieldName())
                && hasFieldMappings() == other.hasFieldMappings() && Objects.equals(fieldMappings(), other.fieldMappings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SalesforceCustomKnowledgeArticleTypeConfiguration").add("Name", name())
                .add("DocumentDataFieldName", documentDataFieldName()).add("DocumentTitleFieldName", documentTitleFieldName())
                .add("FieldMappings", hasFieldMappings() ? fieldMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DocumentDataFieldName":
            return Optional.ofNullable(clazz.cast(documentDataFieldName()));
        case "DocumentTitleFieldName":
            return Optional.ofNullable(clazz.cast(documentTitleFieldName()));
        case "FieldMappings":
            return Optional.ofNullable(clazz.cast(fieldMappings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SalesforceCustomKnowledgeArticleTypeConfiguration, T> g) {
        return obj -> g.apply((SalesforceCustomKnowledgeArticleTypeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SalesforceCustomKnowledgeArticleTypeConfiguration> {
        /**
         * <p>
         * The name of the configuration.
         * </p>
         * 
         * @param name
         *        The name of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the field in the custom knowledge article that contains the document data to index.
         * </p>
         * 
         * @param documentDataFieldName
         *        The name of the field in the custom knowledge article that contains the document data to index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentDataFieldName(String documentDataFieldName);

        /**
         * <p>
         * The name of the field in the custom knowledge article that contains the document title.
         * </p>
         * 
         * @param documentTitleFieldName
         *        The name of the field in the custom knowledge article that contains the document title.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentTitleFieldName(String documentTitleFieldName);

        /**
         * <p>
         * One or more objects that map fields in the custom knowledge article to fields in the Amazon Kendra index.
         * </p>
         * 
         * @param fieldMappings
         *        One or more objects that map fields in the custom knowledge article to fields in the Amazon Kendra
         *        index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings);

        /**
         * <p>
         * One or more objects that map fields in the custom knowledge article to fields in the Amazon Kendra index.
         * </p>
         * 
         * @param fieldMappings
         *        One or more objects that map fields in the custom knowledge article to fields in the Amazon Kendra
         *        index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldMappings(DataSourceToIndexFieldMapping... fieldMappings);

        /**
         * <p>
         * One or more objects that map fields in the custom knowledge article to fields in the Amazon Kendra index.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DataSourceToIndexFieldMapping>.Builder}
         * avoiding the need to create one manually via {@link List<DataSourceToIndexFieldMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DataSourceToIndexFieldMapping>.Builder#build()} is called
         * immediately and its result is passed to {@link #fieldMappings(List<DataSourceToIndexFieldMapping>)}.
         * 
         * @param fieldMappings
         *        a consumer that will call methods on {@link List<DataSourceToIndexFieldMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldMappings(List<DataSourceToIndexFieldMapping>)
         */
        Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder>... fieldMappings);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String documentDataFieldName;

        private String documentTitleFieldName;

        private List<DataSourceToIndexFieldMapping> fieldMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SalesforceCustomKnowledgeArticleTypeConfiguration model) {
            name(model.name);
            documentDataFieldName(model.documentDataFieldName);
            documentTitleFieldName(model.documentTitleFieldName);
            fieldMappings(model.fieldMappings);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDocumentDataFieldName() {
            return documentDataFieldName;
        }

        @Override
        public final Builder documentDataFieldName(String documentDataFieldName) {
            this.documentDataFieldName = documentDataFieldName;
            return this;
        }

        public final void setDocumentDataFieldName(String documentDataFieldName) {
            this.documentDataFieldName = documentDataFieldName;
        }

        public final String getDocumentTitleFieldName() {
            return documentTitleFieldName;
        }

        @Override
        public final Builder documentTitleFieldName(String documentTitleFieldName) {
            this.documentTitleFieldName = documentTitleFieldName;
            return this;
        }

        public final void setDocumentTitleFieldName(String documentTitleFieldName) {
            this.documentTitleFieldName = documentTitleFieldName;
        }

        public final Collection<DataSourceToIndexFieldMapping.Builder> getFieldMappings() {
            if (fieldMappings instanceof SdkAutoConstructList) {
                return null;
            }
            return fieldMappings != null ? fieldMappings.stream().map(DataSourceToIndexFieldMapping::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copy(fieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(DataSourceToIndexFieldMapping... fieldMappings) {
            fieldMappings(Arrays.asList(fieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder>... fieldMappings) {
            fieldMappings(Stream.of(fieldMappings).map(c -> DataSourceToIndexFieldMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(fieldMappings);
        }

        @Override
        public SalesforceCustomKnowledgeArticleTypeConfiguration build() {
            return new SalesforceCustomKnowledgeArticleTypeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
