/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDataSourcesResponse extends KendraResponse implements
        ToCopyableBuilder<ListDataSourcesResponse.Builder, ListDataSourcesResponse> {
    private static final SdkField<List<DataSourceSummary>> SUMMARY_ITEMS_FIELD = SdkField
            .<List<DataSourceSummary>> builder(MarshallingType.LIST)
            .memberName("SummaryItems")
            .getter(getter(ListDataSourcesResponse::summaryItems))
            .setter(setter(Builder::summaryItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SummaryItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSourceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSourceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDataSourcesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARY_ITEMS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DataSourceSummary> summaryItems;

    private final String nextToken;

    private ListDataSourcesResponse(BuilderImpl builder) {
        super(builder);
        this.summaryItems = builder.summaryItems;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the SummaryItems property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSummaryItems() {
        return summaryItems != null && !(summaryItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of summary information for one or more data sources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSummaryItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of summary information for one or more data sources.
     */
    public final List<DataSourceSummary> summaryItems() {
        return summaryItems;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent request to
     * retrieve the next set of data sources.
     * </p>
     * 
     * @return If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent request
     *         to retrieve the next set of data sources.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSummaryItems() ? summaryItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataSourcesResponse)) {
            return false;
        }
        ListDataSourcesResponse other = (ListDataSourcesResponse) obj;
        return hasSummaryItems() == other.hasSummaryItems() && Objects.equals(summaryItems(), other.summaryItems())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDataSourcesResponse").add("SummaryItems", hasSummaryItems() ? summaryItems() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SummaryItems":
            return Optional.ofNullable(clazz.cast(summaryItems()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDataSourcesResponse, T> g) {
        return obj -> g.apply((ListDataSourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDataSourcesResponse> {
        /**
         * <p>
         * An array of summary information for one or more data sources.
         * </p>
         * 
         * @param summaryItems
         *        An array of summary information for one or more data sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaryItems(Collection<DataSourceSummary> summaryItems);

        /**
         * <p>
         * An array of summary information for one or more data sources.
         * </p>
         * 
         * @param summaryItems
         *        An array of summary information for one or more data sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaryItems(DataSourceSummary... summaryItems);

        /**
         * <p>
         * An array of summary information for one or more data sources.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DataSourceSummary>.Builder} avoiding the
         * need to create one manually via {@link List<DataSourceSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DataSourceSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #summaryItems(List<DataSourceSummary>)}.
         * 
         * @param summaryItems
         *        a consumer that will call methods on {@link List<DataSourceSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summaryItems(List<DataSourceSummary>)
         */
        Builder summaryItems(Consumer<DataSourceSummary.Builder>... summaryItems);

        /**
         * <p>
         * If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent request to
         * retrieve the next set of data sources.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent
         *        request to retrieve the next set of data sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends KendraResponse.BuilderImpl implements Builder {
        private List<DataSourceSummary> summaryItems = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataSourcesResponse model) {
            super(model);
            summaryItems(model.summaryItems);
            nextToken(model.nextToken);
        }

        public final List<DataSourceSummary.Builder> getSummaryItems() {
            List<DataSourceSummary.Builder> result = DataSourceSummaryListCopier.copyToBuilder(this.summaryItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder summaryItems(Collection<DataSourceSummary> summaryItems) {
            this.summaryItems = DataSourceSummaryListCopier.copy(summaryItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaryItems(DataSourceSummary... summaryItems) {
            summaryItems(Arrays.asList(summaryItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaryItems(Consumer<DataSourceSummary.Builder>... summaryItems) {
            summaryItems(Stream.of(summaryItems).map(c -> DataSourceSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSummaryItems(Collection<DataSourceSummary.BuilderImpl> summaryItems) {
            this.summaryItems = DataSourceSummaryListCopier.copyFromBuilder(summaryItems);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDataSourcesResponse build() {
            return new ListDataSourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
