/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Access Control List files for the documents in a data source. For the format of the file, see <a
 * href="https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html">Access control for S3 data sources</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessControlListConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AccessControlListConfiguration.Builder, AccessControlListConfiguration> {
    private static final SdkField<String> KEY_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyPath").getter(getter(AccessControlListConfiguration::keyPath)).setter(setter(Builder::keyPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String keyPath;

    private AccessControlListConfiguration(BuilderImpl builder) {
        this.keyPath = builder.keyPath;
    }

    /**
     * <p>
     * Path to the AWS S3 bucket that contains the ACL files.
     * </p>
     * 
     * @return Path to the AWS S3 bucket that contains the ACL files.
     */
    public final String keyPath() {
        return keyPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessControlListConfiguration)) {
            return false;
        }
        AccessControlListConfiguration other = (AccessControlListConfiguration) obj;
        return Objects.equals(keyPath(), other.keyPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessControlListConfiguration").add("KeyPath", keyPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyPath":
            return Optional.ofNullable(clazz.cast(keyPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessControlListConfiguration, T> g) {
        return obj -> g.apply((AccessControlListConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessControlListConfiguration> {
        /**
         * <p>
         * Path to the AWS S3 bucket that contains the ACL files.
         * </p>
         * 
         * @param keyPath
         *        Path to the AWS S3 bucket that contains the ACL files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPath(String keyPath);
    }

    static final class BuilderImpl implements Builder {
        private String keyPath;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessControlListConfiguration model) {
            keyPath(model.keyPath);
        }

        public final String getKeyPath() {
            return keyPath;
        }

        @Override
        public final Builder keyPath(String keyPath) {
            this.keyPath = keyPath;
            return this;
        }

        public final void setKeyPath(String keyPath) {
            this.keyPath = keyPath;
        }

        @Override
        public AccessControlListConfiguration build() {
            return new AccessControlListConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
