/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDataSourceResponse extends KendraResponse implements
        ToCopyableBuilder<DescribeDataSourceResponse.Builder, DescribeDataSourceResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(DescribeDataSourceResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(DescribeDataSourceResponse::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeDataSourceResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(DescribeDataSourceResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<DataSourceConfiguration> CONFIGURATION_FIELD = SdkField
            .<DataSourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(DescribeDataSourceResponse::configuration)).setter(setter(Builder::configuration))
            .constructor(DataSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(DescribeDataSourceResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(DescribeDataSourceResponse::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeDataSourceResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeDataSourceResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Schedule").getter(getter(DescribeDataSourceResponse::schedule)).setter(setter(Builder::schedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeDataSourceResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(DescribeDataSourceResponse::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, INDEX_ID_FIELD,
            NAME_FIELD, TYPE_FIELD, CONFIGURATION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, DESCRIPTION_FIELD, STATUS_FIELD,
            SCHEDULE_FIELD, ROLE_ARN_FIELD, ERROR_MESSAGE_FIELD));

    private final String id;

    private final String indexId;

    private final String name;

    private final String type;

    private final DataSourceConfiguration configuration;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String description;

    private final String status;

    private final String schedule;

    private final String roleArn;

    private final String errorMessage;

    private DescribeDataSourceResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.indexId = builder.indexId;
        this.name = builder.name;
        this.type = builder.type;
        this.configuration = builder.configuration;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.description = builder.description;
        this.status = builder.status;
        this.schedule = builder.schedule;
        this.roleArn = builder.roleArn;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The identifier of the data source.
     * </p>
     * 
     * @return The identifier of the data source.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The identifier of the index that contains the data source.
     * </p>
     * 
     * @return The identifier of the index that contains the data source.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The name that you gave the data source when it was created.
     * </p>
     * 
     * @return The name that you gave the data source when it was created.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of the data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the data source.
     * @see DataSourceType
     */
    public final DataSourceType type() {
        return DataSourceType.fromValue(type);
    }

    /**
     * <p>
     * The type of the data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the data source.
     * @see DataSourceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Information that describes where the data source is located and how the data source is configured. The specific
     * information in the description depends on the data source provider.
     * </p>
     * 
     * @return Information that describes where the data source is located and how the data source is configured. The
     *         specific information in the description depends on the data source provider.
     */
    public final DataSourceConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * The Unix timestamp of when the data source was created.
     * </p>
     * 
     * @return The Unix timestamp of when the data source was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Unix timestamp of when the data source was last updated.
     * </p>
     * 
     * @return The Unix timestamp of when the data source was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The description of the data source.
     * </p>
     * 
     * @return The description of the data source.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The current status of the data source. When the status is <code>ACTIVE</code> the data source is ready to use.
     * When the status is <code>FAILED</code>, the <code>ErrorMessage</code> field contains the reason that the data
     * source failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataSourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the data source. When the status is <code>ACTIVE</code> the data source is ready to
     *         use. When the status is <code>FAILED</code>, the <code>ErrorMessage</code> field contains the reason that
     *         the data source failed.
     * @see DataSourceStatus
     */
    public final DataSourceStatus status() {
        return DataSourceStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the data source. When the status is <code>ACTIVE</code> the data source is ready to use.
     * When the status is <code>FAILED</code>, the <code>ErrorMessage</code> field contains the reason that the data
     * source failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataSourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the data source. When the status is <code>ACTIVE</code> the data source is ready to
     *         use. When the status is <code>FAILED</code>, the <code>ErrorMessage</code> field contains the reason that
     *         the data source failed.
     * @see DataSourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The schedule that Amazon Kendra will update the data source.
     * </p>
     * 
     * @return The schedule that Amazon Kendra will update the data source.
     */
    public final String schedule() {
        return schedule;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role that enables the data source to access its resources.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role that enables the data source to access its resources.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains a
     * description of the error that caused the data source to fail.
     * </p>
     * 
     * @return When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field
     *         contains a description of the error that caused the data source to fail.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDataSourceResponse)) {
            return false;
        }
        DescribeDataSourceResponse other = (DescribeDataSourceResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(indexId(), other.indexId())
                && Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(configuration(), other.configuration()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(description(), other.description())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(schedule(), other.schedule())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDataSourceResponse").add("Id", id()).add("IndexId", indexId()).add("Name", name())
                .add("Type", typeAsString()).add("Configuration", configuration()).add("CreatedAt", createdAt())
                .add("UpdatedAt", updatedAt()).add("Description", description()).add("Status", statusAsString())
                .add("Schedule", schedule()).add("RoleArn", roleArn()).add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDataSourceResponse, T> g) {
        return obj -> g.apply((DescribeDataSourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDataSourceResponse> {
        /**
         * <p>
         * The identifier of the data source.
         * </p>
         * 
         * @param id
         *        The identifier of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The identifier of the index that contains the data source.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index that contains the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The name that you gave the data source when it was created.
         * </p>
         * 
         * @param name
         *        The name that you gave the data source when it was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of the data source.
         * </p>
         * 
         * @param type
         *        The type of the data source.
         * @see DataSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the data source.
         * </p>
         * 
         * @param type
         *        The type of the data source.
         * @see DataSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceType
         */
        Builder type(DataSourceType type);

        /**
         * <p>
         * Information that describes where the data source is located and how the data source is configured. The
         * specific information in the description depends on the data source provider.
         * </p>
         * 
         * @param configuration
         *        Information that describes where the data source is located and how the data source is configured. The
         *        specific information in the description depends on the data source provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(DataSourceConfiguration configuration);

        /**
         * <p>
         * Information that describes where the data source is located and how the data source is configured. The
         * specific information in the description depends on the data source provider.
         * </p>
         * This is a convenience that creates an instance of the {@link DataSourceConfiguration.Builder} avoiding the
         * need to create one manually via {@link DataSourceConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataSourceConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #configuration(DataSourceConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link DataSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(DataSourceConfiguration)
         */
        default Builder configuration(Consumer<DataSourceConfiguration.Builder> configuration) {
            return configuration(DataSourceConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The Unix timestamp of when the data source was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp of when the data source was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Unix timestamp of when the data source was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The Unix timestamp of when the data source was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The description of the data source.
         * </p>
         * 
         * @param description
         *        The description of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The current status of the data source. When the status is <code>ACTIVE</code> the data source is ready to
         * use. When the status is <code>FAILED</code>, the <code>ErrorMessage</code> field contains the reason that the
         * data source failed.
         * </p>
         * 
         * @param status
         *        The current status of the data source. When the status is <code>ACTIVE</code> the data source is ready
         *        to use. When the status is <code>FAILED</code>, the <code>ErrorMessage</code> field contains the
         *        reason that the data source failed.
         * @see DataSourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the data source. When the status is <code>ACTIVE</code> the data source is ready to
         * use. When the status is <code>FAILED</code>, the <code>ErrorMessage</code> field contains the reason that the
         * data source failed.
         * </p>
         * 
         * @param status
         *        The current status of the data source. When the status is <code>ACTIVE</code> the data source is ready
         *        to use. When the status is <code>FAILED</code>, the <code>ErrorMessage</code> field contains the
         *        reason that the data source failed.
         * @see DataSourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceStatus
         */
        Builder status(DataSourceStatus status);

        /**
         * <p>
         * The schedule that Amazon Kendra will update the data source.
         * </p>
         * 
         * @param schedule
         *        The schedule that Amazon Kendra will update the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(String schedule);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role that enables the data source to access its resources.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the role that enables the data source to access its resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains
         * a description of the error that caused the data source to fail.
         * </p>
         * 
         * @param errorMessage
         *        When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field
         *        contains a description of the error that caused the data source to fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl extends KendraResponse.BuilderImpl implements Builder {
        private String id;

        private String indexId;

        private String name;

        private String type;

        private DataSourceConfiguration configuration;

        private Instant createdAt;

        private Instant updatedAt;

        private String description;

        private String status;

        private String schedule;

        private String roleArn;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDataSourceResponse model) {
            super(model);
            id(model.id);
            indexId(model.indexId);
            name(model.name);
            type(model.type);
            configuration(model.configuration);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            description(model.description);
            status(model.status);
            schedule(model.schedule);
            roleArn(model.roleArn);
            errorMessage(model.errorMessage);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getIndexId() {
            return indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DataSourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final DataSourceConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(DataSourceConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(DataSourceConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataSourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getSchedule() {
            return schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public DescribeDataSourceResponse build() {
            return new DescribeDataSourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
