/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchPutDocumentRequest extends KendraRequest implements
        ToCopyableBuilder<BatchPutDocumentRequest.Builder, BatchPutDocumentRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(BatchPutDocumentRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(BatchPutDocumentRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<List<Document>> DOCUMENTS_FIELD = SdkField
            .<List<Document>> builder(MarshallingType.LIST)
            .memberName("Documents")
            .getter(getter(BatchPutDocumentRequest::documents))
            .setter(setter(Builder::documents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Documents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Document> builder(MarshallingType.SDK_POJO)
                                            .constructor(Document::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD,
            ROLE_ARN_FIELD, DOCUMENTS_FIELD));

    private final String indexId;

    private final String roleArn;

    private final List<Document> documents;

    private BatchPutDocumentRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.roleArn = builder.roleArn;
        this.documents = builder.documents;
    }

    /**
     * <p>
     * The identifier of the index to add the documents to. You need to create the index first using the
     * <code>CreateIndex</code> operation.
     * </p>
     * 
     * @return The identifier of the index to add the documents to. You need to create the index first using the
     *         <code>CreateIndex</code> operation.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a role that is allowed to run the <code>BatchPutDocument</code> operation. For
     * more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for Amazon
     * Kendra</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a role that is allowed to run the <code>BatchPutDocument</code>
     *         operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for Amazon Kendra</a>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * Returns true if the Documents property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDocuments() {
        return documents != null && !(documents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more documents to add to the index.
     * </p>
     * <p>
     * Documents can include custom attributes. For example, 'DataSourceId' and 'DataSourceSyncJobId' are custom
     * attributes that provide information on the synchronization of documents running on a data source. Note,
     * 'DataSourceSyncJobId' could be an optional custom attribute as Amazon Kendra will use the ID of a running sync
     * job.
     * </p>
     * <p>
     * Documents have the following file size limits.
     * </p>
     * <ul>
     * <li>
     * <p>
     * 5 MB total size for inline documents
     * </p>
     * </li>
     * <li>
     * <p>
     * 50 MB total size for files from an S3 bucket
     * </p>
     * </li>
     * <li>
     * <p>
     * 5 MB extracted text for any file
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about file size and transaction per second quotas, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDocuments()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more documents to add to the index.</p>
     *         <p>
     *         Documents can include custom attributes. For example, 'DataSourceId' and 'DataSourceSyncJobId' are custom
     *         attributes that provide information on the synchronization of documents running on a data source. Note,
     *         'DataSourceSyncJobId' could be an optional custom attribute as Amazon Kendra will use the ID of a running
     *         sync job.
     *         </p>
     *         <p>
     *         Documents have the following file size limits.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         5 MB total size for inline documents
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         50 MB total size for files from an S3 bucket
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         5 MB extracted text for any file
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about file size and transaction per second quotas, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.
     */
    public final List<Document> documents() {
        return documents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasDocuments() ? documents() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutDocumentRequest)) {
            return false;
        }
        BatchPutDocumentRequest other = (BatchPutDocumentRequest) obj;
        return Objects.equals(indexId(), other.indexId()) && Objects.equals(roleArn(), other.roleArn())
                && hasDocuments() == other.hasDocuments() && Objects.equals(documents(), other.documents());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchPutDocumentRequest").add("IndexId", indexId()).add("RoleArn", roleArn())
                .add("Documents", hasDocuments() ? documents() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Documents":
            return Optional.ofNullable(clazz.cast(documents()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchPutDocumentRequest, T> g) {
        return obj -> g.apply((BatchPutDocumentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchPutDocumentRequest> {
        /**
         * <p>
         * The identifier of the index to add the documents to. You need to create the index first using the
         * <code>CreateIndex</code> operation.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index to add the documents to. You need to create the index first using the
         *        <code>CreateIndex</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a role that is allowed to run the <code>BatchPutDocument</code> operation.
         * For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for
         * Amazon Kendra</a>.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of a role that is allowed to run the <code>BatchPutDocument</code>
         *        operation. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for Amazon Kendra</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * One or more documents to add to the index.
         * </p>
         * <p>
         * Documents can include custom attributes. For example, 'DataSourceId' and 'DataSourceSyncJobId' are custom
         * attributes that provide information on the synchronization of documents running on a data source. Note,
         * 'DataSourceSyncJobId' could be an optional custom attribute as Amazon Kendra will use the ID of a running
         * sync job.
         * </p>
         * <p>
         * Documents have the following file size limits.
         * </p>
         * <ul>
         * <li>
         * <p>
         * 5 MB total size for inline documents
         * </p>
         * </li>
         * <li>
         * <p>
         * 50 MB total size for files from an S3 bucket
         * </p>
         * </li>
         * <li>
         * <p>
         * 5 MB extracted text for any file
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about file size and transaction per second quotas, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.
         * </p>
         * 
         * @param documents
         *        One or more documents to add to the index.</p>
         *        <p>
         *        Documents can include custom attributes. For example, 'DataSourceId' and 'DataSourceSyncJobId' are
         *        custom attributes that provide information on the synchronization of documents running on a data
         *        source. Note, 'DataSourceSyncJobId' could be an optional custom attribute as Amazon Kendra will use
         *        the ID of a running sync job.
         *        </p>
         *        <p>
         *        Documents have the following file size limits.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        5 MB total size for inline documents
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        50 MB total size for files from an S3 bucket
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        5 MB extracted text for any file
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about file size and transaction per second quotas, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documents(Collection<Document> documents);

        /**
         * <p>
         * One or more documents to add to the index.
         * </p>
         * <p>
         * Documents can include custom attributes. For example, 'DataSourceId' and 'DataSourceSyncJobId' are custom
         * attributes that provide information on the synchronization of documents running on a data source. Note,
         * 'DataSourceSyncJobId' could be an optional custom attribute as Amazon Kendra will use the ID of a running
         * sync job.
         * </p>
         * <p>
         * Documents have the following file size limits.
         * </p>
         * <ul>
         * <li>
         * <p>
         * 5 MB total size for inline documents
         * </p>
         * </li>
         * <li>
         * <p>
         * 50 MB total size for files from an S3 bucket
         * </p>
         * </li>
         * <li>
         * <p>
         * 5 MB extracted text for any file
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about file size and transaction per second quotas, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.
         * </p>
         * 
         * @param documents
         *        One or more documents to add to the index.</p>
         *        <p>
         *        Documents can include custom attributes. For example, 'DataSourceId' and 'DataSourceSyncJobId' are
         *        custom attributes that provide information on the synchronization of documents running on a data
         *        source. Note, 'DataSourceSyncJobId' could be an optional custom attribute as Amazon Kendra will use
         *        the ID of a running sync job.
         *        </p>
         *        <p>
         *        Documents have the following file size limits.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        5 MB total size for inline documents
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        50 MB total size for files from an S3 bucket
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        5 MB extracted text for any file
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about file size and transaction per second quotas, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documents(Document... documents);

        /**
         * <p>
         * One or more documents to add to the index.
         * </p>
         * <p>
         * Documents can include custom attributes. For example, 'DataSourceId' and 'DataSourceSyncJobId' are custom
         * attributes that provide information on the synchronization of documents running on a data source. Note,
         * 'DataSourceSyncJobId' could be an optional custom attribute as Amazon Kendra will use the ID of a running
         * sync job.
         * </p>
         * <p>
         * Documents have the following file size limits.
         * </p>
         * <ul>
         * <li>
         * <p>
         * 5 MB total size for inline documents
         * </p>
         * </li>
         * <li>
         * <p>
         * 50 MB total size for files from an S3 bucket
         * </p>
         * </li>
         * <li>
         * <p>
         * 5 MB extracted text for any file
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about file size and transaction per second quotas, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Document>.Builder} avoiding the need to
         * create one manually via {@link List<Document>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Document>.Builder#build()} is called immediately and its
         * result is passed to {@link #documents(List<Document>)}.
         * 
         * @param documents
         *        a consumer that will call methods on {@link List<Document>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documents(List<Document>)
         */
        Builder documents(Consumer<Document.Builder>... documents);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String indexId;

        private String roleArn;

        private List<Document> documents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutDocumentRequest model) {
            super(model);
            indexId(model.indexId);
            roleArn(model.roleArn);
            documents(model.documents);
        }

        public final String getIndexId() {
            return indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final List<Document.Builder> getDocuments() {
            List<Document.Builder> result = DocumentListCopier.copyToBuilder(this.documents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder documents(Collection<Document> documents) {
            this.documents = DocumentListCopier.copy(documents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documents(Document... documents) {
            documents(Arrays.asList(documents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documents(Consumer<Document.Builder>... documents) {
            documents(Stream.of(documents).map(c -> Document.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDocuments(Collection<Document.BuilderImpl> documents) {
            this.documents = DocumentListCopier.copyFromBuilder(documents);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchPutDocumentRequest build() {
            return new BatchPutDocumentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
