/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A single query suggestion.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Suggestion implements SdkPojo, Serializable, ToCopyableBuilder<Suggestion.Builder, Suggestion> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Suggestion::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<SuggestionValue> VALUE_FIELD = SdkField.<SuggestionValue> builder(MarshallingType.SDK_POJO)
            .memberName("Value").getter(getter(Suggestion::value)).setter(setter(Builder::value))
            .constructor(SuggestionValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final SuggestionValue value;

    private Suggestion(BuilderImpl builder) {
        this.id = builder.id;
        this.value = builder.value;
    }

    /**
     * <p>
     * The unique UUID (universally unique identifier) of a single query suggestion.
     * </p>
     * 
     * @return The unique UUID (universally unique identifier) of a single query suggestion.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The value for the unique UUID (universally unique identifier) of a single query suggestion.
     * </p>
     * <p>
     * The value is the text string of a suggestion.
     * </p>
     * 
     * @return The value for the unique UUID (universally unique identifier) of a single query suggestion.</p>
     *         <p>
     *         The value is the text string of a suggestion.
     */
    public final SuggestionValue value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Suggestion)) {
            return false;
        }
        Suggestion other = (Suggestion) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Suggestion").add("Id", id()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Suggestion, T> g) {
        return obj -> g.apply((Suggestion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Suggestion> {
        /**
         * <p>
         * The unique UUID (universally unique identifier) of a single query suggestion.
         * </p>
         * 
         * @param id
         *        The unique UUID (universally unique identifier) of a single query suggestion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The value for the unique UUID (universally unique identifier) of a single query suggestion.
         * </p>
         * <p>
         * The value is the text string of a suggestion.
         * </p>
         * 
         * @param value
         *        The value for the unique UUID (universally unique identifier) of a single query suggestion.</p>
         *        <p>
         *        The value is the text string of a suggestion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(SuggestionValue value);

        /**
         * <p>
         * The value for the unique UUID (universally unique identifier) of a single query suggestion.
         * </p>
         * <p>
         * The value is the text string of a suggestion.
         * </p>
         * This is a convenience that creates an instance of the {@link SuggestionValue.Builder} avoiding the need to
         * create one manually via {@link SuggestionValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link SuggestionValue.Builder#build()} is called immediately and its
         * result is passed to {@link #value(SuggestionValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link SuggestionValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(SuggestionValue)
         */
        default Builder value(Consumer<SuggestionValue.Builder> value) {
            return value(SuggestionValue.builder().applyMutation(value).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private SuggestionValue value;

        private BuilderImpl() {
        }

        private BuilderImpl(Suggestion model) {
            id(model.id);
            value(model.value);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final SuggestionValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        @Override
        public final Builder value(SuggestionValue value) {
            this.value = value;
            return this;
        }

        public final void setValue(SuggestionValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public Suggestion build() {
            return new Suggestion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
