/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetQuerySuggestionsRequest extends KendraRequest implements
        ToCopyableBuilder<GetQuerySuggestionsRequest.Builder, GetQuerySuggestionsRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(GetQuerySuggestionsRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<String> QUERY_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryText").getter(getter(GetQuerySuggestionsRequest::queryText)).setter(setter(Builder::queryText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryText").build()).build();

    private static final SdkField<Integer> MAX_SUGGESTIONS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxSuggestionsCount").getter(getter(GetQuerySuggestionsRequest::maxSuggestionsCount))
            .setter(setter(Builder::maxSuggestionsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSuggestionsCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD,
            QUERY_TEXT_FIELD, MAX_SUGGESTIONS_COUNT_FIELD));

    private final String indexId;

    private final String queryText;

    private final Integer maxSuggestionsCount;

    private GetQuerySuggestionsRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.queryText = builder.queryText;
        this.maxSuggestionsCount = builder.maxSuggestionsCount;
    }

    /**
     * <p>
     * The identifier of the index you want to get query suggestions from.
     * </p>
     * 
     * @return The identifier of the index you want to get query suggestions from.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The text of a user's query to generate query suggestions.
     * </p>
     * <p>
     * A query is suggested if the query prefix matches what a user starts to type as their query.
     * </p>
     * <p>
     * Amazon Kendra does not show any suggestions if a user types fewer than two characters or more than 60 characters.
     * A query must also have at least one search result and contain at least one word of more than four characters.
     * </p>
     * 
     * @return The text of a user's query to generate query suggestions.</p>
     *         <p>
     *         A query is suggested if the query prefix matches what a user starts to type as their query.
     *         </p>
     *         <p>
     *         Amazon Kendra does not show any suggestions if a user types fewer than two characters or more than 60
     *         characters. A query must also have at least one search result and contain at least one word of more than
     *         four characters.
     */
    public final String queryText() {
        return queryText;
    }

    /**
     * <p>
     * The maximum number of query suggestions you want to show to your users.
     * </p>
     * 
     * @return The maximum number of query suggestions you want to show to your users.
     */
    public final Integer maxSuggestionsCount() {
        return maxSuggestionsCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(queryText());
        hashCode = 31 * hashCode + Objects.hashCode(maxSuggestionsCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQuerySuggestionsRequest)) {
            return false;
        }
        GetQuerySuggestionsRequest other = (GetQuerySuggestionsRequest) obj;
        return Objects.equals(indexId(), other.indexId()) && Objects.equals(queryText(), other.queryText())
                && Objects.equals(maxSuggestionsCount(), other.maxSuggestionsCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetQuerySuggestionsRequest").add("IndexId", indexId()).add("QueryText", queryText())
                .add("MaxSuggestionsCount", maxSuggestionsCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "QueryText":
            return Optional.ofNullable(clazz.cast(queryText()));
        case "MaxSuggestionsCount":
            return Optional.ofNullable(clazz.cast(maxSuggestionsCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetQuerySuggestionsRequest, T> g) {
        return obj -> g.apply((GetQuerySuggestionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetQuerySuggestionsRequest> {
        /**
         * <p>
         * The identifier of the index you want to get query suggestions from.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index you want to get query suggestions from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The text of a user's query to generate query suggestions.
         * </p>
         * <p>
         * A query is suggested if the query prefix matches what a user starts to type as their query.
         * </p>
         * <p>
         * Amazon Kendra does not show any suggestions if a user types fewer than two characters or more than 60
         * characters. A query must also have at least one search result and contain at least one word of more than four
         * characters.
         * </p>
         * 
         * @param queryText
         *        The text of a user's query to generate query suggestions.</p>
         *        <p>
         *        A query is suggested if the query prefix matches what a user starts to type as their query.
         *        </p>
         *        <p>
         *        Amazon Kendra does not show any suggestions if a user types fewer than two characters or more than 60
         *        characters. A query must also have at least one search result and contain at least one word of more
         *        than four characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryText(String queryText);

        /**
         * <p>
         * The maximum number of query suggestions you want to show to your users.
         * </p>
         * 
         * @param maxSuggestionsCount
         *        The maximum number of query suggestions you want to show to your users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSuggestionsCount(Integer maxSuggestionsCount);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String indexId;

        private String queryText;

        private Integer maxSuggestionsCount;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQuerySuggestionsRequest model) {
            super(model);
            indexId(model.indexId);
            queryText(model.queryText);
            maxSuggestionsCount(model.maxSuggestionsCount);
        }

        public final String getIndexId() {
            return indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        public final String getQueryText() {
            return queryText;
        }

        @Override
        public final Builder queryText(String queryText) {
            this.queryText = queryText;
            return this;
        }

        public final void setQueryText(String queryText) {
            this.queryText = queryText;
        }

        public final Integer getMaxSuggestionsCount() {
            return maxSuggestionsCount;
        }

        @Override
        public final Builder maxSuggestionsCount(Integer maxSuggestionsCount) {
            this.maxSuggestionsCount = maxSuggestionsCount;
            return this;
        }

        public final void setMaxSuggestionsCount(Integer maxSuggestionsCount) {
            this.maxSuggestionsCount = maxSuggestionsCount;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetQuerySuggestionsRequest build() {
            return new GetQuerySuggestionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
