/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration information to connect to Amazon WorkDocs as your data source.
 * </p>
 * <p>
 * Amazon WorkDocs connector is available in Oregon, North Virginia, Sydney, Singapore and Ireland regions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkDocsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkDocsConfiguration.Builder, WorkDocsConfiguration> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationId").getter(getter(WorkDocsConfiguration::organizationId))
            .setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final SdkField<Boolean> CRAWL_COMMENTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CrawlComments").getter(getter(WorkDocsConfiguration::crawlComments))
            .setter(setter(Builder::crawlComments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlComments").build()).build();

    private static final SdkField<Boolean> USE_CHANGE_LOG_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseChangeLog").getter(getter(WorkDocsConfiguration::useChangeLog)).setter(setter(Builder::useChangeLog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseChangeLog").build()).build();

    private static final SdkField<List<String>> INCLUSION_PATTERNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InclusionPatterns")
            .getter(getter(WorkDocsConfiguration::inclusionPatterns))
            .setter(setter(Builder::inclusionPatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionPatterns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXCLUSION_PATTERNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExclusionPatterns")
            .getter(getter(WorkDocsConfiguration::exclusionPatterns))
            .setter(setter(Builder::exclusionPatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionPatterns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DataSourceToIndexFieldMapping>> FIELD_MAPPINGS_FIELD = SdkField
            .<List<DataSourceToIndexFieldMapping>> builder(MarshallingType.LIST)
            .memberName("FieldMappings")
            .getter(getter(WorkDocsConfiguration::fieldMappings))
            .setter(setter(Builder::fieldMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSourceToIndexFieldMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSourceToIndexFieldMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD, CRAWL_COMMENTS_FIELD, USE_CHANGE_LOG_FIELD,
                    INCLUSION_PATTERNS_FIELD, EXCLUSION_PATTERNS_FIELD, FIELD_MAPPINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String organizationId;

    private final Boolean crawlComments;

    private final Boolean useChangeLog;

    private final List<String> inclusionPatterns;

    private final List<String> exclusionPatterns;

    private final List<DataSourceToIndexFieldMapping> fieldMappings;

    private WorkDocsConfiguration(BuilderImpl builder) {
        this.organizationId = builder.organizationId;
        this.crawlComments = builder.crawlComments;
        this.useChangeLog = builder.useChangeLog;
        this.inclusionPatterns = builder.inclusionPatterns;
        this.exclusionPatterns = builder.exclusionPatterns;
        this.fieldMappings = builder.fieldMappings;
    }

    /**
     * <p>
     * The identifier of the directory corresponding to your Amazon WorkDocs site repository.
     * </p>
     * <p>
     * You can find the organization ID in the <a href="https://console.aws.amazon.com/directoryservicev2/">AWS
     * Directory Service</a> by going to <b>Active Directory</b>, then <b>Directories</b>. Your Amazon WorkDocs site
     * directory has an ID, which is the organization ID. You can also set up a new Amazon WorkDocs directory in the AWS
     * Directory Service console and enable a Amazon WorkDocs site for the directory in the Amazon WorkDocs console.
     * </p>
     * 
     * @return The identifier of the directory corresponding to your Amazon WorkDocs site repository.</p>
     *         <p>
     *         You can find the organization ID in the <a href="https://console.aws.amazon.com/directoryservicev2/">AWS
     *         Directory Service</a> by going to <b>Active Directory</b>, then <b>Directories</b>. Your Amazon WorkDocs
     *         site directory has an ID, which is the organization ID. You can also set up a new Amazon WorkDocs
     *         directory in the AWS Directory Service console and enable a Amazon WorkDocs site for the directory in the
     *         Amazon WorkDocs console.
     */
    public final String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * <code>TRUE</code> to include comments on documents in your index. Including comments in your index means each
     * comment is a document that can be searched on.
     * </p>
     * <p>
     * The default is set to <code>FALSE</code>.
     * </p>
     * 
     * @return <code>TRUE</code> to include comments on documents in your index. Including comments in your index means
     *         each comment is a document that can be searched on.</p>
     *         <p>
     *         The default is set to <code>FALSE</code>.
     */
    public final Boolean crawlComments() {
        return crawlComments;
    }

    /**
     * <p>
     * <code>TRUE</code> to use the change logs to update documents in your index instead of scanning all documents.
     * </p>
     * <p>
     * If you are syncing your Amazon WorkDocs data source with your index for the first time, all documents are
     * scanned. After your first sync, you can use the change logs to update your documents in your index for future
     * syncs.
     * </p>
     * <p>
     * The default is set to <code>FALSE</code>.
     * </p>
     * 
     * @return <code>TRUE</code> to use the change logs to update documents in your index instead of scanning all
     *         documents.</p>
     *         <p>
     *         If you are syncing your Amazon WorkDocs data source with your index for the first time, all documents are
     *         scanned. After your first sync, you can use the change logs to update your documents in your index for
     *         future syncs.
     *         </p>
     *         <p>
     *         The default is set to <code>FALSE</code>.
     */
    public final Boolean useChangeLog() {
        return useChangeLog;
    }

    /**
     * Returns true if the InclusionPatterns property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasInclusionPatterns() {
        return inclusionPatterns != null && !(inclusionPatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of regular expression patterns to include certain files in your Amazon WorkDocs site repository. Files
     * that match the patterns are included in the index. Files that don't match the patterns are excluded from the
     * index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes
     * precedence and the file isn’t included in the index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInclusionPatterns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of regular expression patterns to include certain files in your Amazon WorkDocs site repository.
     *         Files that match the patterns are included in the index. Files that don't match the patterns are excluded
     *         from the index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion
     *         pattern takes precedence and the file isn’t included in the index.
     */
    public final List<String> inclusionPatterns() {
        return inclusionPatterns;
    }

    /**
     * Returns true if the ExclusionPatterns property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasExclusionPatterns() {
        return exclusionPatterns != null && !(exclusionPatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of regular expression patterns to exclude certain files in your Amazon WorkDocs site repository. Files
     * that match the patterns are excluded from the index. Files that don’t match the patterns are included in the
     * index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes
     * precedence and the file isn’t included in the index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExclusionPatterns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of regular expression patterns to exclude certain files in your Amazon WorkDocs site repository.
     *         Files that match the patterns are excluded from the index. Files that don’t match the patterns are
     *         included in the index. If a file matches both an inclusion pattern and an exclusion pattern, the
     *         exclusion pattern takes precedence and the file isn’t included in the index.
     */
    public final List<String> exclusionPatterns() {
        return exclusionPatterns;
    }

    /**
     * Returns true if the FieldMappings property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFieldMappings() {
        return fieldMappings != null && !(fieldMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DataSourceToIndexFieldMapping</code> objects that map Amazon WorkDocs field names to custom index
     * field names in Amazon Kendra. You must first create the custom index fields using the <code>UpdateIndex</code>
     * operation before you map to Amazon WorkDocs fields. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping Data Source Fields</a>. The Amazon
     * WorkDocs data source field names need to exist in your Amazon WorkDocs custom metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFieldMappings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code>DataSourceToIndexFieldMapping</code> objects that map Amazon WorkDocs field names to
     *         custom index field names in Amazon Kendra. You must first create the custom index fields using the
     *         <code>UpdateIndex</code> operation before you map to Amazon WorkDocs fields. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping Data Source Fields</a>.
     *         The Amazon WorkDocs data source field names need to exist in your Amazon WorkDocs custom metadata.
     */
    public final List<DataSourceToIndexFieldMapping> fieldMappings() {
        return fieldMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(crawlComments());
        hashCode = 31 * hashCode + Objects.hashCode(useChangeLog());
        hashCode = 31 * hashCode + Objects.hashCode(hasInclusionPatterns() ? inclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExclusionPatterns() ? exclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFieldMappings() ? fieldMappings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkDocsConfiguration)) {
            return false;
        }
        WorkDocsConfiguration other = (WorkDocsConfiguration) obj;
        return Objects.equals(organizationId(), other.organizationId()) && Objects.equals(crawlComments(), other.crawlComments())
                && Objects.equals(useChangeLog(), other.useChangeLog()) && hasInclusionPatterns() == other.hasInclusionPatterns()
                && Objects.equals(inclusionPatterns(), other.inclusionPatterns())
                && hasExclusionPatterns() == other.hasExclusionPatterns()
                && Objects.equals(exclusionPatterns(), other.exclusionPatterns())
                && hasFieldMappings() == other.hasFieldMappings() && Objects.equals(fieldMappings(), other.fieldMappings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkDocsConfiguration").add("OrganizationId", organizationId())
                .add("CrawlComments", crawlComments()).add("UseChangeLog", useChangeLog())
                .add("InclusionPatterns", hasInclusionPatterns() ? inclusionPatterns() : null)
                .add("ExclusionPatterns", hasExclusionPatterns() ? exclusionPatterns() : null)
                .add("FieldMappings", hasFieldMappings() ? fieldMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "CrawlComments":
            return Optional.ofNullable(clazz.cast(crawlComments()));
        case "UseChangeLog":
            return Optional.ofNullable(clazz.cast(useChangeLog()));
        case "InclusionPatterns":
            return Optional.ofNullable(clazz.cast(inclusionPatterns()));
        case "ExclusionPatterns":
            return Optional.ofNullable(clazz.cast(exclusionPatterns()));
        case "FieldMappings":
            return Optional.ofNullable(clazz.cast(fieldMappings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkDocsConfiguration, T> g) {
        return obj -> g.apply((WorkDocsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkDocsConfiguration> {
        /**
         * <p>
         * The identifier of the directory corresponding to your Amazon WorkDocs site repository.
         * </p>
         * <p>
         * You can find the organization ID in the <a href="https://console.aws.amazon.com/directoryservicev2/">AWS
         * Directory Service</a> by going to <b>Active Directory</b>, then <b>Directories</b>. Your Amazon WorkDocs site
         * directory has an ID, which is the organization ID. You can also set up a new Amazon WorkDocs directory in the
         * AWS Directory Service console and enable a Amazon WorkDocs site for the directory in the Amazon WorkDocs
         * console.
         * </p>
         * 
         * @param organizationId
         *        The identifier of the directory corresponding to your Amazon WorkDocs site repository.</p>
         *        <p>
         *        You can find the organization ID in the <a
         *        href="https://console.aws.amazon.com/directoryservicev2/">AWS Directory Service</a> by going to
         *        <b>Active Directory</b>, then <b>Directories</b>. Your Amazon WorkDocs site directory has an ID, which
         *        is the organization ID. You can also set up a new Amazon WorkDocs directory in the AWS Directory
         *        Service console and enable a Amazon WorkDocs site for the directory in the Amazon WorkDocs console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * <code>TRUE</code> to include comments on documents in your index. Including comments in your index means each
         * comment is a document that can be searched on.
         * </p>
         * <p>
         * The default is set to <code>FALSE</code>.
         * </p>
         * 
         * @param crawlComments
         *        <code>TRUE</code> to include comments on documents in your index. Including comments in your index
         *        means each comment is a document that can be searched on.</p>
         *        <p>
         *        The default is set to <code>FALSE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlComments(Boolean crawlComments);

        /**
         * <p>
         * <code>TRUE</code> to use the change logs to update documents in your index instead of scanning all documents.
         * </p>
         * <p>
         * If you are syncing your Amazon WorkDocs data source with your index for the first time, all documents are
         * scanned. After your first sync, you can use the change logs to update your documents in your index for future
         * syncs.
         * </p>
         * <p>
         * The default is set to <code>FALSE</code>.
         * </p>
         * 
         * @param useChangeLog
         *        <code>TRUE</code> to use the change logs to update documents in your index instead of scanning all
         *        documents.</p>
         *        <p>
         *        If you are syncing your Amazon WorkDocs data source with your index for the first time, all documents
         *        are scanned. After your first sync, you can use the change logs to update your documents in your index
         *        for future syncs.
         *        </p>
         *        <p>
         *        The default is set to <code>FALSE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useChangeLog(Boolean useChangeLog);

        /**
         * <p>
         * A list of regular expression patterns to include certain files in your Amazon WorkDocs site repository. Files
         * that match the patterns are included in the index. Files that don't match the patterns are excluded from the
         * index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes
         * precedence and the file isn’t included in the index.
         * </p>
         * 
         * @param inclusionPatterns
         *        A list of regular expression patterns to include certain files in your Amazon WorkDocs site
         *        repository. Files that match the patterns are included in the index. Files that don't match the
         *        patterns are excluded from the index. If a file matches both an inclusion pattern and an exclusion
         *        pattern, the exclusion pattern takes precedence and the file isn’t included in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusionPatterns(Collection<String> inclusionPatterns);

        /**
         * <p>
         * A list of regular expression patterns to include certain files in your Amazon WorkDocs site repository. Files
         * that match the patterns are included in the index. Files that don't match the patterns are excluded from the
         * index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes
         * precedence and the file isn’t included in the index.
         * </p>
         * 
         * @param inclusionPatterns
         *        A list of regular expression patterns to include certain files in your Amazon WorkDocs site
         *        repository. Files that match the patterns are included in the index. Files that don't match the
         *        patterns are excluded from the index. If a file matches both an inclusion pattern and an exclusion
         *        pattern, the exclusion pattern takes precedence and the file isn’t included in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusionPatterns(String... inclusionPatterns);

        /**
         * <p>
         * A list of regular expression patterns to exclude certain files in your Amazon WorkDocs site repository. Files
         * that match the patterns are excluded from the index. Files that don’t match the patterns are included in the
         * index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes
         * precedence and the file isn’t included in the index.
         * </p>
         * 
         * @param exclusionPatterns
         *        A list of regular expression patterns to exclude certain files in your Amazon WorkDocs site
         *        repository. Files that match the patterns are excluded from the index. Files that don’t match the
         *        patterns are included in the index. If a file matches both an inclusion pattern and an exclusion
         *        pattern, the exclusion pattern takes precedence and the file isn’t included in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionPatterns(Collection<String> exclusionPatterns);

        /**
         * <p>
         * A list of regular expression patterns to exclude certain files in your Amazon WorkDocs site repository. Files
         * that match the patterns are excluded from the index. Files that don’t match the patterns are included in the
         * index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes
         * precedence and the file isn’t included in the index.
         * </p>
         * 
         * @param exclusionPatterns
         *        A list of regular expression patterns to exclude certain files in your Amazon WorkDocs site
         *        repository. Files that match the patterns are excluded from the index. Files that don’t match the
         *        patterns are included in the index. If a file matches both an inclusion pattern and an exclusion
         *        pattern, the exclusion pattern takes precedence and the file isn’t included in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionPatterns(String... exclusionPatterns);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map Amazon WorkDocs field names to custom
         * index field names in Amazon Kendra. You must first create the custom index fields using the
         * <code>UpdateIndex</code> operation before you map to Amazon WorkDocs fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping Data Source Fields</a>. The
         * Amazon WorkDocs data source field names need to exist in your Amazon WorkDocs custom metadata.
         * </p>
         * 
         * @param fieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map Amazon WorkDocs field names to
         *        custom index field names in Amazon Kendra. You must first create the custom index fields using the
         *        <code>UpdateIndex</code> operation before you map to Amazon WorkDocs fields. For more information, see
         *        <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping Data Source
         *        Fields</a>. The Amazon WorkDocs data source field names need to exist in your Amazon WorkDocs custom
         *        metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map Amazon WorkDocs field names to custom
         * index field names in Amazon Kendra. You must first create the custom index fields using the
         * <code>UpdateIndex</code> operation before you map to Amazon WorkDocs fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping Data Source Fields</a>. The
         * Amazon WorkDocs data source field names need to exist in your Amazon WorkDocs custom metadata.
         * </p>
         * 
         * @param fieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map Amazon WorkDocs field names to
         *        custom index field names in Amazon Kendra. You must first create the custom index fields using the
         *        <code>UpdateIndex</code> operation before you map to Amazon WorkDocs fields. For more information, see
         *        <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping Data Source
         *        Fields</a>. The Amazon WorkDocs data source field names need to exist in your Amazon WorkDocs custom
         *        metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldMappings(DataSourceToIndexFieldMapping... fieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map Amazon WorkDocs field names to custom
         * index field names in Amazon Kendra. You must first create the custom index fields using the
         * <code>UpdateIndex</code> operation before you map to Amazon WorkDocs fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping Data Source Fields</a>. The
         * Amazon WorkDocs data source field names need to exist in your Amazon WorkDocs custom metadata.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DataSourceToIndexFieldMapping>.Builder}
         * avoiding the need to create one manually via {@link List<DataSourceToIndexFieldMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DataSourceToIndexFieldMapping>.Builder#build()} is called
         * immediately and its result is passed to {@link #fieldMappings(List<DataSourceToIndexFieldMapping>)}.
         * 
         * @param fieldMappings
         *        a consumer that will call methods on {@link List<DataSourceToIndexFieldMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldMappings(List<DataSourceToIndexFieldMapping>)
         */
        Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder>... fieldMappings);
    }

    static final class BuilderImpl implements Builder {
        private String organizationId;

        private Boolean crawlComments;

        private Boolean useChangeLog;

        private List<String> inclusionPatterns = DefaultSdkAutoConstructList.getInstance();

        private List<String> exclusionPatterns = DefaultSdkAutoConstructList.getInstance();

        private List<DataSourceToIndexFieldMapping> fieldMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WorkDocsConfiguration model) {
            organizationId(model.organizationId);
            crawlComments(model.crawlComments);
            useChangeLog(model.useChangeLog);
            inclusionPatterns(model.inclusionPatterns);
            exclusionPatterns(model.exclusionPatterns);
            fieldMappings(model.fieldMappings);
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public final Boolean getCrawlComments() {
            return crawlComments;
        }

        @Override
        public final Builder crawlComments(Boolean crawlComments) {
            this.crawlComments = crawlComments;
            return this;
        }

        public final void setCrawlComments(Boolean crawlComments) {
            this.crawlComments = crawlComments;
        }

        public final Boolean getUseChangeLog() {
            return useChangeLog;
        }

        @Override
        public final Builder useChangeLog(Boolean useChangeLog) {
            this.useChangeLog = useChangeLog;
            return this;
        }

        public final void setUseChangeLog(Boolean useChangeLog) {
            this.useChangeLog = useChangeLog;
        }

        public final Collection<String> getInclusionPatterns() {
            if (inclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return inclusionPatterns;
        }

        @Override
        public final Builder inclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionPatterns(String... inclusionPatterns) {
            inclusionPatterns(Arrays.asList(inclusionPatterns));
            return this;
        }

        public final void setInclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
        }

        public final Collection<String> getExclusionPatterns() {
            if (exclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return exclusionPatterns;
        }

        @Override
        public final Builder exclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionPatterns(String... exclusionPatterns) {
            exclusionPatterns(Arrays.asList(exclusionPatterns));
            return this;
        }

        public final void setExclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier
                    .copyToBuilder(this.fieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copy(fieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(DataSourceToIndexFieldMapping... fieldMappings) {
            fieldMappings(Arrays.asList(fieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder>... fieldMappings) {
            fieldMappings(Stream.of(fieldMappings).map(c -> DataSourceToIndexFieldMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(fieldMappings);
        }

        @Override
        public WorkDocsConfiguration build() {
            return new WorkDocsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
