/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information for your content sources, such as data sources, FAQs, and content indexed directly via <a
 * href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html">BatchPutDocument</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContentSourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ContentSourceConfiguration.Builder, ContentSourceConfiguration> {
    private static final SdkField<List<String>> DATA_SOURCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DataSourceIds")
            .getter(getter(ContentSourceConfiguration::dataSourceIds))
            .setter(setter(Builder::dataSourceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> FAQ_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FaqIds")
            .getter(getter(ContentSourceConfiguration::faqIds))
            .setter(setter(Builder::faqIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaqIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DIRECT_PUT_CONTENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DirectPutContent").getter(getter(ContentSourceConfiguration::directPutContent))
            .setter(setter(Builder::directPutContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectPutContent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_IDS_FIELD,
            FAQ_IDS_FIELD, DIRECT_PUT_CONTENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> dataSourceIds;

    private final List<String> faqIds;

    private final Boolean directPutContent;

    private ContentSourceConfiguration(BuilderImpl builder) {
        this.dataSourceIds = builder.dataSourceIds;
        this.faqIds = builder.faqIds;
        this.directPutContent = builder.directPutContent;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataSourceIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataSourceIds() {
        return dataSourceIds != null && !(dataSourceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifier of the data sources you want to use for your Amazon Kendra experience.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataSourceIds} method.
     * </p>
     * 
     * @return The identifier of the data sources you want to use for your Amazon Kendra experience.
     */
    public final List<String> dataSourceIds() {
        return dataSourceIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the FaqIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFaqIds() {
        return faqIds != null && !(faqIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifier of the FAQs that you want to use for your Amazon Kendra experience.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFaqIds} method.
     * </p>
     * 
     * @return The identifier of the FAQs that you want to use for your Amazon Kendra experience.
     */
    public final List<String> faqIds() {
        return faqIds;
    }

    /**
     * <p>
     * <code>TRUE</code> to use documents you indexed directly using the <code>BatchPutDocument</code> operation.
     * </p>
     * 
     * @return <code>TRUE</code> to use documents you indexed directly using the <code>BatchPutDocument</code>
     *         operation.
     */
    public final Boolean directPutContent() {
        return directPutContent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDataSourceIds() ? dataSourceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFaqIds() ? faqIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(directPutContent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentSourceConfiguration)) {
            return false;
        }
        ContentSourceConfiguration other = (ContentSourceConfiguration) obj;
        return hasDataSourceIds() == other.hasDataSourceIds() && Objects.equals(dataSourceIds(), other.dataSourceIds())
                && hasFaqIds() == other.hasFaqIds() && Objects.equals(faqIds(), other.faqIds())
                && Objects.equals(directPutContent(), other.directPutContent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContentSourceConfiguration").add("DataSourceIds", hasDataSourceIds() ? dataSourceIds() : null)
                .add("FaqIds", hasFaqIds() ? faqIds() : null).add("DirectPutContent", directPutContent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSourceIds":
            return Optional.ofNullable(clazz.cast(dataSourceIds()));
        case "FaqIds":
            return Optional.ofNullable(clazz.cast(faqIds()));
        case "DirectPutContent":
            return Optional.ofNullable(clazz.cast(directPutContent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContentSourceConfiguration, T> g) {
        return obj -> g.apply((ContentSourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContentSourceConfiguration> {
        /**
         * <p>
         * The identifier of the data sources you want to use for your Amazon Kendra experience.
         * </p>
         * 
         * @param dataSourceIds
         *        The identifier of the data sources you want to use for your Amazon Kendra experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceIds(Collection<String> dataSourceIds);

        /**
         * <p>
         * The identifier of the data sources you want to use for your Amazon Kendra experience.
         * </p>
         * 
         * @param dataSourceIds
         *        The identifier of the data sources you want to use for your Amazon Kendra experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceIds(String... dataSourceIds);

        /**
         * <p>
         * The identifier of the FAQs that you want to use for your Amazon Kendra experience.
         * </p>
         * 
         * @param faqIds
         *        The identifier of the FAQs that you want to use for your Amazon Kendra experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faqIds(Collection<String> faqIds);

        /**
         * <p>
         * The identifier of the FAQs that you want to use for your Amazon Kendra experience.
         * </p>
         * 
         * @param faqIds
         *        The identifier of the FAQs that you want to use for your Amazon Kendra experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faqIds(String... faqIds);

        /**
         * <p>
         * <code>TRUE</code> to use documents you indexed directly using the <code>BatchPutDocument</code> operation.
         * </p>
         * 
         * @param directPutContent
         *        <code>TRUE</code> to use documents you indexed directly using the <code>BatchPutDocument</code>
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directPutContent(Boolean directPutContent);
    }

    static final class BuilderImpl implements Builder {
        private List<String> dataSourceIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> faqIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean directPutContent;

        private BuilderImpl() {
        }

        private BuilderImpl(ContentSourceConfiguration model) {
            dataSourceIds(model.dataSourceIds);
            faqIds(model.faqIds);
            directPutContent(model.directPutContent);
        }

        public final Collection<String> getDataSourceIds() {
            if (dataSourceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return dataSourceIds;
        }

        public final void setDataSourceIds(Collection<String> dataSourceIds) {
            this.dataSourceIds = DataSourceIdListCopier.copy(dataSourceIds);
        }

        @Override
        @Transient
        public final Builder dataSourceIds(Collection<String> dataSourceIds) {
            this.dataSourceIds = DataSourceIdListCopier.copy(dataSourceIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dataSourceIds(String... dataSourceIds) {
            dataSourceIds(Arrays.asList(dataSourceIds));
            return this;
        }

        public final Collection<String> getFaqIds() {
            if (faqIds instanceof SdkAutoConstructList) {
                return null;
            }
            return faqIds;
        }

        public final void setFaqIds(Collection<String> faqIds) {
            this.faqIds = FaqIdsListCopier.copy(faqIds);
        }

        @Override
        @Transient
        public final Builder faqIds(Collection<String> faqIds) {
            this.faqIds = FaqIdsListCopier.copy(faqIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder faqIds(String... faqIds) {
            faqIds(Arrays.asList(faqIds));
            return this;
        }

        public final Boolean getDirectPutContent() {
            return directPutContent;
        }

        public final void setDirectPutContent(Boolean directPutContent) {
            this.directPutContent = directPutContent;
        }

        @Override
        @Transient
        public final Builder directPutContent(Boolean directPutContent) {
            this.directPutContent = directPutContent;
            return this;
        }

        @Override
        public ContentSourceConfiguration build() {
            return new ContentSourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
