/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGroupsOlderThanOrderingIdResponse extends KendraResponse implements
        ToCopyableBuilder<ListGroupsOlderThanOrderingIdResponse.Builder, ListGroupsOlderThanOrderingIdResponse> {
    private static final SdkField<List<GroupSummary>> GROUPS_SUMMARIES_FIELD = SdkField
            .<List<GroupSummary>> builder(MarshallingType.LIST)
            .memberName("GroupsSummaries")
            .getter(getter(ListGroupsOlderThanOrderingIdResponse::groupsSummaries))
            .setter(setter(Builder::groupsSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupsSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroupSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListGroupsOlderThanOrderingIdResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUPS_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<GroupSummary> groupsSummaries;

    private final String nextToken;

    private ListGroupsOlderThanOrderingIdResponse(BuilderImpl builder) {
        super(builder);
        this.groupsSummaries = builder.groupsSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupsSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGroupsSummaries() {
        return groupsSummaries != null && !(groupsSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary information for list of groups that are mapped to users before a given ordering or timestamp identifier.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupsSummaries} method.
     * </p>
     * 
     * @return Summary information for list of groups that are mapped to users before a given ordering or timestamp
     *         identifier.
     */
    public final List<GroupSummary> groupsSummaries() {
        return groupsSummaries;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent request to
     * retrieve the next set of groups that are mapped to users before a given ordering or timestamp identifier.
     * </p>
     * 
     * @return If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent request
     *         to retrieve the next set of groups that are mapped to users before a given ordering or timestamp
     *         identifier.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupsSummaries() ? groupsSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupsOlderThanOrderingIdResponse)) {
            return false;
        }
        ListGroupsOlderThanOrderingIdResponse other = (ListGroupsOlderThanOrderingIdResponse) obj;
        return hasGroupsSummaries() == other.hasGroupsSummaries() && Objects.equals(groupsSummaries(), other.groupsSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListGroupsOlderThanOrderingIdResponse")
                .add("GroupsSummaries", hasGroupsSummaries() ? groupsSummaries() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupsSummaries":
            return Optional.ofNullable(clazz.cast(groupsSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGroupsOlderThanOrderingIdResponse, T> g) {
        return obj -> g.apply((ListGroupsOlderThanOrderingIdResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListGroupsOlderThanOrderingIdResponse> {
        /**
         * <p>
         * Summary information for list of groups that are mapped to users before a given ordering or timestamp
         * identifier.
         * </p>
         * 
         * @param groupsSummaries
         *        Summary information for list of groups that are mapped to users before a given ordering or timestamp
         *        identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupsSummaries(Collection<GroupSummary> groupsSummaries);

        /**
         * <p>
         * Summary information for list of groups that are mapped to users before a given ordering or timestamp
         * identifier.
         * </p>
         * 
         * @param groupsSummaries
         *        Summary information for list of groups that are mapped to users before a given ordering or timestamp
         *        identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupsSummaries(GroupSummary... groupsSummaries);

        /**
         * <p>
         * Summary information for list of groups that are mapped to users before a given ordering or timestamp
         * identifier.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GroupSummary>.Builder} avoiding the need to
         * create one manually via {@link List<GroupSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GroupSummary>.Builder#build()} is called immediately and its
         * result is passed to {@link #groupsSummaries(List<GroupSummary>)}.
         * 
         * @param groupsSummaries
         *        a consumer that will call methods on {@link List<GroupSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupsSummaries(List<GroupSummary>)
         */
        Builder groupsSummaries(Consumer<GroupSummary.Builder>... groupsSummaries);

        /**
         * <p>
         * If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent request to
         * retrieve the next set of groups that are mapped to users before a given ordering or timestamp identifier.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent
         *        request to retrieve the next set of groups that are mapped to users before a given ordering or
         *        timestamp identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends KendraResponse.BuilderImpl implements Builder {
        private List<GroupSummary> groupsSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupsOlderThanOrderingIdResponse model) {
            super(model);
            groupsSummaries(model.groupsSummaries);
            nextToken(model.nextToken);
        }

        public final List<GroupSummary.Builder> getGroupsSummaries() {
            List<GroupSummary.Builder> result = ListOfGroupSummariesCopier.copyToBuilder(this.groupsSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupsSummaries(Collection<GroupSummary.BuilderImpl> groupsSummaries) {
            this.groupsSummaries = ListOfGroupSummariesCopier.copyFromBuilder(groupsSummaries);
        }

        @Override
        @Transient
        public final Builder groupsSummaries(Collection<GroupSummary> groupsSummaries) {
            this.groupsSummaries = ListOfGroupSummariesCopier.copy(groupsSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder groupsSummaries(GroupSummary... groupsSummaries) {
            groupsSummaries(Arrays.asList(groupsSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder groupsSummaries(Consumer<GroupSummary.Builder>... groupsSummaries) {
            groupsSummaries(Stream.of(groupsSummaries).map(c -> GroupSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListGroupsOlderThanOrderingIdResponse build() {
            return new ListGroupsOlderThanOrderingIdResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
