/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration information to fetch access levels of groups and users from an Amazon Web Services Single
 * Sign On identity source. This is useful for setting up user context filtering, where Amazon Kendra filters search
 * results for different users based on their group's access to documents. You can also map your users to their groups
 * for user context filtering using the <a
 * href="https://docs.aws.amazon.com/kendra/latest/dg/API_PutPrincipalMapping.html">PutPrincipalMapping operation</a>.
 * </p>
 * <p>
 * To set up an Amazon Web Services SSO identity source in the console to use with Amazon Kendra, see <a
 * href="https://docs.aws.amazon.com/kendra/latest/dg/getting-started-aws-sso.html">Getting started with an Amazon Web
 * Services SSO identity source</a>. You must also grant the required permissions to use Amazon Web Services SSO with
 * Amazon Kendra. For more information, see <a
 * href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html#iam-roles-aws-sso">IAM roles for Amazon Web
 * Services SSO</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserGroupResolutionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<UserGroupResolutionConfiguration.Builder, UserGroupResolutionConfiguration> {
    private static final SdkField<String> USER_GROUP_RESOLUTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserGroupResolutionMode")
            .getter(getter(UserGroupResolutionConfiguration::userGroupResolutionModeAsString))
            .setter(setter(Builder::userGroupResolutionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupResolutionMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(USER_GROUP_RESOLUTION_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userGroupResolutionMode;

    private UserGroupResolutionConfiguration(BuilderImpl builder) {
        this.userGroupResolutionMode = builder.userGroupResolutionMode;
    }

    /**
     * <p>
     * The identity store provider (mode) you want to use to fetch access levels of groups and users. Amazon Web
     * Services Single Sign On is currently the only available mode. Your users and groups must exist in an Amazon Web
     * Services SSO identity source in order to use this mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #userGroupResolutionMode} will return {@link UserGroupResolutionMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #userGroupResolutionModeAsString}.
     * </p>
     * 
     * @return The identity store provider (mode) you want to use to fetch access levels of groups and users. Amazon Web
     *         Services Single Sign On is currently the only available mode. Your users and groups must exist in an
     *         Amazon Web Services SSO identity source in order to use this mode.
     * @see UserGroupResolutionMode
     */
    public final UserGroupResolutionMode userGroupResolutionMode() {
        return UserGroupResolutionMode.fromValue(userGroupResolutionMode);
    }

    /**
     * <p>
     * The identity store provider (mode) you want to use to fetch access levels of groups and users. Amazon Web
     * Services Single Sign On is currently the only available mode. Your users and groups must exist in an Amazon Web
     * Services SSO identity source in order to use this mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #userGroupResolutionMode} will return {@link UserGroupResolutionMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #userGroupResolutionModeAsString}.
     * </p>
     * 
     * @return The identity store provider (mode) you want to use to fetch access levels of groups and users. Amazon Web
     *         Services Single Sign On is currently the only available mode. Your users and groups must exist in an
     *         Amazon Web Services SSO identity source in order to use this mode.
     * @see UserGroupResolutionMode
     */
    public final String userGroupResolutionModeAsString() {
        return userGroupResolutionMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userGroupResolutionModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserGroupResolutionConfiguration)) {
            return false;
        }
        UserGroupResolutionConfiguration other = (UserGroupResolutionConfiguration) obj;
        return Objects.equals(userGroupResolutionModeAsString(), other.userGroupResolutionModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserGroupResolutionConfiguration")
                .add("UserGroupResolutionMode", userGroupResolutionModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserGroupResolutionMode":
            return Optional.ofNullable(clazz.cast(userGroupResolutionModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserGroupResolutionConfiguration, T> g) {
        return obj -> g.apply((UserGroupResolutionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserGroupResolutionConfiguration> {
        /**
         * <p>
         * The identity store provider (mode) you want to use to fetch access levels of groups and users. Amazon Web
         * Services Single Sign On is currently the only available mode. Your users and groups must exist in an Amazon
         * Web Services SSO identity source in order to use this mode.
         * </p>
         * 
         * @param userGroupResolutionMode
         *        The identity store provider (mode) you want to use to fetch access levels of groups and users. Amazon
         *        Web Services Single Sign On is currently the only available mode. Your users and groups must exist in
         *        an Amazon Web Services SSO identity source in order to use this mode.
         * @see UserGroupResolutionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserGroupResolutionMode
         */
        Builder userGroupResolutionMode(String userGroupResolutionMode);

        /**
         * <p>
         * The identity store provider (mode) you want to use to fetch access levels of groups and users. Amazon Web
         * Services Single Sign On is currently the only available mode. Your users and groups must exist in an Amazon
         * Web Services SSO identity source in order to use this mode.
         * </p>
         * 
         * @param userGroupResolutionMode
         *        The identity store provider (mode) you want to use to fetch access levels of groups and users. Amazon
         *        Web Services Single Sign On is currently the only available mode. Your users and groups must exist in
         *        an Amazon Web Services SSO identity source in order to use this mode.
         * @see UserGroupResolutionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserGroupResolutionMode
         */
        Builder userGroupResolutionMode(UserGroupResolutionMode userGroupResolutionMode);
    }

    static final class BuilderImpl implements Builder {
        private String userGroupResolutionMode;

        private BuilderImpl() {
        }

        private BuilderImpl(UserGroupResolutionConfiguration model) {
            userGroupResolutionMode(model.userGroupResolutionMode);
        }

        public final String getUserGroupResolutionMode() {
            return userGroupResolutionMode;
        }

        public final void setUserGroupResolutionMode(String userGroupResolutionMode) {
            this.userGroupResolutionMode = userGroupResolutionMode;
        }

        @Override
        @Transient
        public final Builder userGroupResolutionMode(String userGroupResolutionMode) {
            this.userGroupResolutionMode = userGroupResolutionMode;
            return this;
        }

        @Override
        @Transient
        public final Builder userGroupResolutionMode(UserGroupResolutionMode userGroupResolutionMode) {
            this.userGroupResolutionMode(userGroupResolutionMode == null ? null : userGroupResolutionMode.toString());
            return this;
        }

        @Override
        public UserGroupResolutionConfiguration build() {
            return new UserGroupResolutionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
