/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateQuerySuggestionsBlockListRequest extends KendraRequest implements
        ToCopyableBuilder<CreateQuerySuggestionsBlockListRequest.Builder, CreateQuerySuggestionsBlockListRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(CreateQuerySuggestionsBlockListRequest::indexId))
            .setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateQuerySuggestionsBlockListRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateQuerySuggestionsBlockListRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<S3Path> SOURCE_S3_PATH_FIELD = SdkField.<S3Path> builder(MarshallingType.SDK_POJO)
            .memberName("SourceS3Path").getter(getter(CreateQuerySuggestionsBlockListRequest::sourceS3Path))
            .setter(setter(Builder::sourceS3Path)).constructor(S3Path::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceS3Path").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateQuerySuggestionsBlockListRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateQuerySuggestionsBlockListRequest::roleArn))
            .setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateQuerySuggestionsBlockListRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, SOURCE_S3_PATH_FIELD, CLIENT_TOKEN_FIELD, ROLE_ARN_FIELD, TAGS_FIELD));

    private final String indexId;

    private final String name;

    private final String description;

    private final S3Path sourceS3Path;

    private final String clientToken;

    private final String roleArn;

    private final List<Tag> tags;

    private CreateQuerySuggestionsBlockListRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.name = builder.name;
        this.description = builder.description;
        this.sourceS3Path = builder.sourceS3Path;
        this.clientToken = builder.clientToken;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier of the index you want to create a query suggestions block list for.
     * </p>
     * 
     * @return The identifier of the index you want to create a query suggestions block list for.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * A user friendly name for the block list.
     * </p>
     * <p>
     * For example, the block list named 'offensive-words' includes all offensive words that could appear in user
     * queries and need to be blocked from suggestions.
     * </p>
     * 
     * @return A user friendly name for the block list.</p>
     *         <p>
     *         For example, the block list named 'offensive-words' includes all offensive words that could appear in
     *         user queries and need to be blocked from suggestions.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A user-friendly description for the block list.
     * </p>
     * <p>
     * For example, the description
     * "List of all offensive words that can appear in user queries and need to be blocked from suggestions."
     * </p>
     * 
     * @return A user-friendly description for the block list.</p>
     *         <p>
     *         For example, the description
     *         "List of all offensive words that can appear in user queries and need to be blocked from suggestions."
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The S3 path to your block list text file in your S3 bucket.
     * </p>
     * <p>
     * Each block word or phrase should be on a separate line in a text file.
     * </p>
     * <p>
     * For information on the current quota limits for block lists, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.
     * </p>
     * 
     * @return The S3 path to your block list text file in your S3 bucket.</p>
     *         <p>
     *         Each block word or phrase should be on a separate line in a text file.
     *         </p>
     *         <p>
     *         For information on the current quota limits for block lists, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.
     */
    public final S3Path sourceS3Path() {
        return sourceS3Path;
    }

    /**
     * <p>
     * A token that you provide to identify the request to create a query suggestions block list.
     * </p>
     * 
     * @return A token that you provide to identify the request to create a query suggestions block list.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The IAM (Identity and Access Management) role used by Amazon Kendra to access the block list text file in your S3
     * bucket.
     * </p>
     * <p>
     * You need permissions to the role ARN (Amazon Resource Name). The role needs S3 read permissions to your file in
     * S3 and needs to give STS (Security Token Service) assume role permissions to Amazon Kendra.
     * </p>
     * 
     * @return The IAM (Identity and Access Management) role used by Amazon Kendra to access the block list text file in
     *         your S3 bucket.</p>
     *         <p>
     *         You need permissions to the role ARN (Amazon Resource Name). The role needs S3 read permissions to your
     *         file in S3 and needs to give STS (Security Token Service) assume role permissions to Amazon Kendra.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A tag that you can assign to a block list that categorizes the block list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A tag that you can assign to a block list that categorizes the block list.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(sourceS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQuerySuggestionsBlockListRequest)) {
            return false;
        }
        CreateQuerySuggestionsBlockListRequest other = (CreateQuerySuggestionsBlockListRequest) obj;
        return Objects.equals(indexId(), other.indexId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(sourceS3Path(), other.sourceS3Path())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(roleArn(), other.roleArn())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateQuerySuggestionsBlockListRequest").add("IndexId", indexId()).add("Name", name())
                .add("Description", description()).add("SourceS3Path", sourceS3Path()).add("ClientToken", clientToken())
                .add("RoleArn", roleArn()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "SourceS3Path":
            return Optional.ofNullable(clazz.cast(sourceS3Path()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateQuerySuggestionsBlockListRequest, T> g) {
        return obj -> g.apply((CreateQuerySuggestionsBlockListRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateQuerySuggestionsBlockListRequest> {
        /**
         * <p>
         * The identifier of the index you want to create a query suggestions block list for.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index you want to create a query suggestions block list for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * A user friendly name for the block list.
         * </p>
         * <p>
         * For example, the block list named 'offensive-words' includes all offensive words that could appear in user
         * queries and need to be blocked from suggestions.
         * </p>
         * 
         * @param name
         *        A user friendly name for the block list.</p>
         *        <p>
         *        For example, the block list named 'offensive-words' includes all offensive words that could appear in
         *        user queries and need to be blocked from suggestions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A user-friendly description for the block list.
         * </p>
         * <p>
         * For example, the description
         * "List of all offensive words that can appear in user queries and need to be blocked from suggestions."
         * </p>
         * 
         * @param description
         *        A user-friendly description for the block list.</p>
         *        <p>
         *        For example, the description
         *        "List of all offensive words that can appear in user queries and need to be blocked from suggestions."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The S3 path to your block list text file in your S3 bucket.
         * </p>
         * <p>
         * Each block word or phrase should be on a separate line in a text file.
         * </p>
         * <p>
         * For information on the current quota limits for block lists, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.
         * </p>
         * 
         * @param sourceS3Path
         *        The S3 path to your block list text file in your S3 bucket.</p>
         *        <p>
         *        Each block word or phrase should be on a separate line in a text file.
         *        </p>
         *        <p>
         *        For information on the current quota limits for block lists, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceS3Path(S3Path sourceS3Path);

        /**
         * <p>
         * The S3 path to your block list text file in your S3 bucket.
         * </p>
         * <p>
         * Each block word or phrase should be on a separate line in a text file.
         * </p>
         * <p>
         * For information on the current quota limits for block lists, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link S3Path.Builder} avoiding the need to create one
         * manually via {@link S3Path#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Path.Builder#build()} is called immediately and its result is
         * passed to {@link #sourceS3Path(S3Path)}.
         * 
         * @param sourceS3Path
         *        a consumer that will call methods on {@link S3Path.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceS3Path(S3Path)
         */
        default Builder sourceS3Path(Consumer<S3Path.Builder> sourceS3Path) {
            return sourceS3Path(S3Path.builder().applyMutation(sourceS3Path).build());
        }

        /**
         * <p>
         * A token that you provide to identify the request to create a query suggestions block list.
         * </p>
         * 
         * @param clientToken
         *        A token that you provide to identify the request to create a query suggestions block list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The IAM (Identity and Access Management) role used by Amazon Kendra to access the block list text file in
         * your S3 bucket.
         * </p>
         * <p>
         * You need permissions to the role ARN (Amazon Resource Name). The role needs S3 read permissions to your file
         * in S3 and needs to give STS (Security Token Service) assume role permissions to Amazon Kendra.
         * </p>
         * 
         * @param roleArn
         *        The IAM (Identity and Access Management) role used by Amazon Kendra to access the block list text file
         *        in your S3 bucket.</p>
         *        <p>
         *        You need permissions to the role ARN (Amazon Resource Name). The role needs S3 read permissions to
         *        your file in S3 and needs to give STS (Security Token Service) assume role permissions to Amazon
         *        Kendra.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A tag that you can assign to a block list that categorizes the block list.
         * </p>
         * 
         * @param tags
         *        A tag that you can assign to a block list that categorizes the block list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A tag that you can assign to a block list that categorizes the block list.
         * </p>
         * 
         * @param tags
         *        A tag that you can assign to a block list that categorizes the block list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A tag that you can assign to a block list that categorizes the block list.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String indexId;

        private String name;

        private String description;

        private S3Path sourceS3Path;

        private String clientToken;

        private String roleArn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQuerySuggestionsBlockListRequest model) {
            super(model);
            indexId(model.indexId);
            name(model.name);
            description(model.description);
            sourceS3Path(model.sourceS3Path);
            clientToken(model.clientToken);
            roleArn(model.roleArn);
            tags(model.tags);
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        @Transient
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final S3Path.Builder getSourceS3Path() {
            return sourceS3Path != null ? sourceS3Path.toBuilder() : null;
        }

        public final void setSourceS3Path(S3Path.BuilderImpl sourceS3Path) {
            this.sourceS3Path = sourceS3Path != null ? sourceS3Path.build() : null;
        }

        @Override
        @Transient
        public final Builder sourceS3Path(S3Path sourceS3Path) {
            this.sourceS3Path = sourceS3Path;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateQuerySuggestionsBlockListRequest build() {
            return new CreateQuerySuggestionsBlockListRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
