/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateEntitiesFromExperienceResponse extends KendraResponse implements
        ToCopyableBuilder<DisassociateEntitiesFromExperienceResponse.Builder, DisassociateEntitiesFromExperienceResponse> {
    private static final SdkField<List<FailedEntity>> FAILED_ENTITY_LIST_FIELD = SdkField
            .<List<FailedEntity>> builder(MarshallingType.LIST)
            .memberName("FailedEntityList")
            .getter(getter(DisassociateEntitiesFromExperienceResponse::failedEntityList))
            .setter(setter(Builder::failedEntityList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedEntityList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FailedEntity> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedEntity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_ENTITY_LIST_FIELD));

    private final List<FailedEntity> failedEntityList;

    private DisassociateEntitiesFromExperienceResponse(BuilderImpl builder) {
        super(builder);
        this.failedEntityList = builder.failedEntityList;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedEntityList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailedEntityList() {
        return failedEntityList != null && !(failedEntityList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists the users or groups in your Amazon Web Services SSO identity source that failed to properly remove access
     * to your Amazon Kendra experience.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedEntityList} method.
     * </p>
     * 
     * @return Lists the users or groups in your Amazon Web Services SSO identity source that failed to properly remove
     *         access to your Amazon Kendra experience.
     */
    public final List<FailedEntity> failedEntityList() {
        return failedEntityList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedEntityList() ? failedEntityList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateEntitiesFromExperienceResponse)) {
            return false;
        }
        DisassociateEntitiesFromExperienceResponse other = (DisassociateEntitiesFromExperienceResponse) obj;
        return hasFailedEntityList() == other.hasFailedEntityList()
                && Objects.equals(failedEntityList(), other.failedEntityList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateEntitiesFromExperienceResponse")
                .add("FailedEntityList", hasFailedEntityList() ? failedEntityList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedEntityList":
            return Optional.ofNullable(clazz.cast(failedEntityList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateEntitiesFromExperienceResponse, T> g) {
        return obj -> g.apply((DisassociateEntitiesFromExperienceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateEntitiesFromExperienceResponse> {
        /**
         * <p>
         * Lists the users or groups in your Amazon Web Services SSO identity source that failed to properly remove
         * access to your Amazon Kendra experience.
         * </p>
         * 
         * @param failedEntityList
         *        Lists the users or groups in your Amazon Web Services SSO identity source that failed to properly
         *        remove access to your Amazon Kendra experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedEntityList(Collection<FailedEntity> failedEntityList);

        /**
         * <p>
         * Lists the users or groups in your Amazon Web Services SSO identity source that failed to properly remove
         * access to your Amazon Kendra experience.
         * </p>
         * 
         * @param failedEntityList
         *        Lists the users or groups in your Amazon Web Services SSO identity source that failed to properly
         *        remove access to your Amazon Kendra experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedEntityList(FailedEntity... failedEntityList);

        /**
         * <p>
         * Lists the users or groups in your Amazon Web Services SSO identity source that failed to properly remove
         * access to your Amazon Kendra experience.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FailedEntity>.Builder} avoiding the need to
         * create one manually via {@link List<FailedEntity>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FailedEntity>.Builder#build()} is called immediately and its
         * result is passed to {@link #failedEntityList(List<FailedEntity>)}.
         * 
         * @param failedEntityList
         *        a consumer that will call methods on {@link List<FailedEntity>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedEntityList(List<FailedEntity>)
         */
        Builder failedEntityList(Consumer<FailedEntity.Builder>... failedEntityList);
    }

    static final class BuilderImpl extends KendraResponse.BuilderImpl implements Builder {
        private List<FailedEntity> failedEntityList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateEntitiesFromExperienceResponse model) {
            super(model);
            failedEntityList(model.failedEntityList);
        }

        public final List<FailedEntity.Builder> getFailedEntityList() {
            List<FailedEntity.Builder> result = FailedEntityListCopier.copyToBuilder(this.failedEntityList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedEntityList(Collection<FailedEntity.BuilderImpl> failedEntityList) {
            this.failedEntityList = FailedEntityListCopier.copyFromBuilder(failedEntityList);
        }

        @Override
        @Transient
        public final Builder failedEntityList(Collection<FailedEntity> failedEntityList) {
            this.failedEntityList = FailedEntityListCopier.copy(failedEntityList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder failedEntityList(FailedEntity... failedEntityList) {
            failedEntityList(Arrays.asList(failedEntityList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder failedEntityList(Consumer<FailedEntity.Builder>... failedEntityList) {
            failedEntityList(Stream.of(failedEntityList).map(c -> FailedEntity.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DisassociateEntitiesFromExperienceResponse build() {
            return new DisassociateEntitiesFromExperienceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
