/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides configuration information for a token configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserTokenConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<UserTokenConfiguration.Builder, UserTokenConfiguration> {
    private static final SdkField<JwtTokenTypeConfiguration> JWT_TOKEN_TYPE_CONFIGURATION_FIELD = SdkField
            .<JwtTokenTypeConfiguration> builder(MarshallingType.SDK_POJO).memberName("JwtTokenTypeConfiguration")
            .getter(getter(UserTokenConfiguration::jwtTokenTypeConfiguration)).setter(setter(Builder::jwtTokenTypeConfiguration))
            .constructor(JwtTokenTypeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JwtTokenTypeConfiguration").build())
            .build();

    private static final SdkField<JsonTokenTypeConfiguration> JSON_TOKEN_TYPE_CONFIGURATION_FIELD = SdkField
            .<JsonTokenTypeConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("JsonTokenTypeConfiguration")
            .getter(getter(UserTokenConfiguration::jsonTokenTypeConfiguration))
            .setter(setter(Builder::jsonTokenTypeConfiguration))
            .constructor(JsonTokenTypeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JsonTokenTypeConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            JWT_TOKEN_TYPE_CONFIGURATION_FIELD, JSON_TOKEN_TYPE_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final JwtTokenTypeConfiguration jwtTokenTypeConfiguration;

    private final JsonTokenTypeConfiguration jsonTokenTypeConfiguration;

    private UserTokenConfiguration(BuilderImpl builder) {
        this.jwtTokenTypeConfiguration = builder.jwtTokenTypeConfiguration;
        this.jsonTokenTypeConfiguration = builder.jsonTokenTypeConfiguration;
    }

    /**
     * <p>
     * Information about the JWT token type configuration.
     * </p>
     * 
     * @return Information about the JWT token type configuration.
     */
    public final JwtTokenTypeConfiguration jwtTokenTypeConfiguration() {
        return jwtTokenTypeConfiguration;
    }

    /**
     * <p>
     * Information about the JSON token type configuration.
     * </p>
     * 
     * @return Information about the JSON token type configuration.
     */
    public final JsonTokenTypeConfiguration jsonTokenTypeConfiguration() {
        return jsonTokenTypeConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jwtTokenTypeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(jsonTokenTypeConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserTokenConfiguration)) {
            return false;
        }
        UserTokenConfiguration other = (UserTokenConfiguration) obj;
        return Objects.equals(jwtTokenTypeConfiguration(), other.jwtTokenTypeConfiguration())
                && Objects.equals(jsonTokenTypeConfiguration(), other.jsonTokenTypeConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserTokenConfiguration").add("JwtTokenTypeConfiguration", jwtTokenTypeConfiguration())
                .add("JsonTokenTypeConfiguration", jsonTokenTypeConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JwtTokenTypeConfiguration":
            return Optional.ofNullable(clazz.cast(jwtTokenTypeConfiguration()));
        case "JsonTokenTypeConfiguration":
            return Optional.ofNullable(clazz.cast(jsonTokenTypeConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserTokenConfiguration, T> g) {
        return obj -> g.apply((UserTokenConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserTokenConfiguration> {
        /**
         * <p>
         * Information about the JWT token type configuration.
         * </p>
         * 
         * @param jwtTokenTypeConfiguration
         *        Information about the JWT token type configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jwtTokenTypeConfiguration(JwtTokenTypeConfiguration jwtTokenTypeConfiguration);

        /**
         * <p>
         * Information about the JWT token type configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link JwtTokenTypeConfiguration.Builder} avoiding the
         * need to create one manually via {@link JwtTokenTypeConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link JwtTokenTypeConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #jwtTokenTypeConfiguration(JwtTokenTypeConfiguration)}.
         * 
         * @param jwtTokenTypeConfiguration
         *        a consumer that will call methods on {@link JwtTokenTypeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jwtTokenTypeConfiguration(JwtTokenTypeConfiguration)
         */
        default Builder jwtTokenTypeConfiguration(Consumer<JwtTokenTypeConfiguration.Builder> jwtTokenTypeConfiguration) {
            return jwtTokenTypeConfiguration(JwtTokenTypeConfiguration.builder().applyMutation(jwtTokenTypeConfiguration).build());
        }

        /**
         * <p>
         * Information about the JSON token type configuration.
         * </p>
         * 
         * @param jsonTokenTypeConfiguration
         *        Information about the JSON token type configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonTokenTypeConfiguration(JsonTokenTypeConfiguration jsonTokenTypeConfiguration);

        /**
         * <p>
         * Information about the JSON token type configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link JsonTokenTypeConfiguration.Builder} avoiding the
         * need to create one manually via {@link JsonTokenTypeConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link JsonTokenTypeConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #jsonTokenTypeConfiguration(JsonTokenTypeConfiguration)}.
         * 
         * @param jsonTokenTypeConfiguration
         *        a consumer that will call methods on {@link JsonTokenTypeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jsonTokenTypeConfiguration(JsonTokenTypeConfiguration)
         */
        default Builder jsonTokenTypeConfiguration(Consumer<JsonTokenTypeConfiguration.Builder> jsonTokenTypeConfiguration) {
            return jsonTokenTypeConfiguration(JsonTokenTypeConfiguration.builder().applyMutation(jsonTokenTypeConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private JwtTokenTypeConfiguration jwtTokenTypeConfiguration;

        private JsonTokenTypeConfiguration jsonTokenTypeConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UserTokenConfiguration model) {
            jwtTokenTypeConfiguration(model.jwtTokenTypeConfiguration);
            jsonTokenTypeConfiguration(model.jsonTokenTypeConfiguration);
        }

        public final JwtTokenTypeConfiguration.Builder getJwtTokenTypeConfiguration() {
            return jwtTokenTypeConfiguration != null ? jwtTokenTypeConfiguration.toBuilder() : null;
        }

        public final void setJwtTokenTypeConfiguration(JwtTokenTypeConfiguration.BuilderImpl jwtTokenTypeConfiguration) {
            this.jwtTokenTypeConfiguration = jwtTokenTypeConfiguration != null ? jwtTokenTypeConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder jwtTokenTypeConfiguration(JwtTokenTypeConfiguration jwtTokenTypeConfiguration) {
            this.jwtTokenTypeConfiguration = jwtTokenTypeConfiguration;
            return this;
        }

        public final JsonTokenTypeConfiguration.Builder getJsonTokenTypeConfiguration() {
            return jsonTokenTypeConfiguration != null ? jsonTokenTypeConfiguration.toBuilder() : null;
        }

        public final void setJsonTokenTypeConfiguration(JsonTokenTypeConfiguration.BuilderImpl jsonTokenTypeConfiguration) {
            this.jsonTokenTypeConfiguration = jsonTokenTypeConfiguration != null ? jsonTokenTypeConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder jsonTokenTypeConfiguration(JsonTokenTypeConfiguration jsonTokenTypeConfiguration) {
            this.jsonTokenTypeConfiguration = jsonTokenTypeConfiguration;
            return this;
        }

        @Override
        public UserTokenConfiguration build() {
            return new UserTokenConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
