/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.BatchPutDocumentResponseFailedDocument;
import software.amazon.awssdk.services.kendra.model.BatchPutDocumentResponseFailedDocumentsCopier;
import software.amazon.awssdk.services.kendra.model.KendraResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchPutDocumentResponse
extends KendraResponse
implements ToCopyableBuilder<Builder, BatchPutDocumentResponse> {
    private static final SdkField<List<BatchPutDocumentResponseFailedDocument>> FAILED_DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FailedDocuments").getter(BatchPutDocumentResponse.getter(BatchPutDocumentResponse::failedDocuments)).setter(BatchPutDocumentResponse.setter(Builder::failedDocuments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedDocuments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchPutDocumentResponseFailedDocument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_DOCUMENTS_FIELD));
    private final List<BatchPutDocumentResponseFailedDocument> failedDocuments;

    private BatchPutDocumentResponse(BuilderImpl builder) {
        super(builder);
        this.failedDocuments = builder.failedDocuments;
    }

    public final boolean hasFailedDocuments() {
        return this.failedDocuments != null && !(this.failedDocuments instanceof SdkAutoConstructList);
    }

    public final List<BatchPutDocumentResponseFailedDocument> failedDocuments() {
        return this.failedDocuments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedDocuments() ? this.failedDocuments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutDocumentResponse)) {
            return false;
        }
        BatchPutDocumentResponse other = (BatchPutDocumentResponse)((Object)obj);
        return this.hasFailedDocuments() == other.hasFailedDocuments() && Objects.equals(this.failedDocuments(), other.failedDocuments());
    }

    public final String toString() {
        return ToString.builder((String)"BatchPutDocumentResponse").add("FailedDocuments", this.hasFailedDocuments() ? this.failedDocuments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailedDocuments": {
                return Optional.ofNullable(clazz.cast(this.failedDocuments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchPutDocumentResponse, T> g) {
        return obj -> g.apply((BatchPutDocumentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraResponse.BuilderImpl
    implements Builder {
        private List<BatchPutDocumentResponseFailedDocument> failedDocuments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutDocumentResponse model) {
            super(model);
            this.failedDocuments(model.failedDocuments);
        }

        public final List<BatchPutDocumentResponseFailedDocument.Builder> getFailedDocuments() {
            List<BatchPutDocumentResponseFailedDocument.Builder> result = BatchPutDocumentResponseFailedDocumentsCopier.copyToBuilder(this.failedDocuments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedDocuments(Collection<BatchPutDocumentResponseFailedDocument.BuilderImpl> failedDocuments) {
            this.failedDocuments = BatchPutDocumentResponseFailedDocumentsCopier.copyFromBuilder(failedDocuments);
        }

        @Override
        @Transient
        public final Builder failedDocuments(Collection<BatchPutDocumentResponseFailedDocument> failedDocuments) {
            this.failedDocuments = BatchPutDocumentResponseFailedDocumentsCopier.copy(failedDocuments);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder failedDocuments(BatchPutDocumentResponseFailedDocument ... failedDocuments) {
            this.failedDocuments(Arrays.asList(failedDocuments));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder failedDocuments(Consumer<BatchPutDocumentResponseFailedDocument.Builder> ... failedDocuments) {
            this.failedDocuments(Stream.of(failedDocuments).map(c -> (BatchPutDocumentResponseFailedDocument)((BatchPutDocumentResponseFailedDocument.Builder)BatchPutDocumentResponseFailedDocument.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchPutDocumentResponse build() {
            return new BatchPutDocumentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KendraResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchPutDocumentResponse> {
        public Builder failedDocuments(Collection<BatchPutDocumentResponseFailedDocument> var1);

        public Builder failedDocuments(BatchPutDocumentResponseFailedDocument ... var1);

        public Builder failedDocuments(Consumer<BatchPutDocumentResponseFailedDocument.Builder> ... var1);
    }
}

