/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.kendra.model.AccessDeniedException;
import software.amazon.awssdk.services.kendra.model.AssociateEntitiesToExperienceRequest;
import software.amazon.awssdk.services.kendra.model.AssociateEntitiesToExperienceResponse;
import software.amazon.awssdk.services.kendra.model.AssociatePersonasToEntitiesRequest;
import software.amazon.awssdk.services.kendra.model.AssociatePersonasToEntitiesResponse;
import software.amazon.awssdk.services.kendra.model.BatchDeleteDocumentRequest;
import software.amazon.awssdk.services.kendra.model.BatchDeleteDocumentResponse;
import software.amazon.awssdk.services.kendra.model.BatchGetDocumentStatusRequest;
import software.amazon.awssdk.services.kendra.model.BatchGetDocumentStatusResponse;
import software.amazon.awssdk.services.kendra.model.BatchPutDocumentRequest;
import software.amazon.awssdk.services.kendra.model.BatchPutDocumentResponse;
import software.amazon.awssdk.services.kendra.model.ClearQuerySuggestionsRequest;
import software.amazon.awssdk.services.kendra.model.ClearQuerySuggestionsResponse;
import software.amazon.awssdk.services.kendra.model.ConflictException;
import software.amazon.awssdk.services.kendra.model.CreateDataSourceRequest;
import software.amazon.awssdk.services.kendra.model.CreateDataSourceResponse;
import software.amazon.awssdk.services.kendra.model.CreateExperienceRequest;
import software.amazon.awssdk.services.kendra.model.CreateExperienceResponse;
import software.amazon.awssdk.services.kendra.model.CreateFaqRequest;
import software.amazon.awssdk.services.kendra.model.CreateFaqResponse;
import software.amazon.awssdk.services.kendra.model.CreateIndexRequest;
import software.amazon.awssdk.services.kendra.model.CreateIndexResponse;
import software.amazon.awssdk.services.kendra.model.CreateQuerySuggestionsBlockListRequest;
import software.amazon.awssdk.services.kendra.model.CreateQuerySuggestionsBlockListResponse;
import software.amazon.awssdk.services.kendra.model.CreateThesaurusRequest;
import software.amazon.awssdk.services.kendra.model.CreateThesaurusResponse;
import software.amazon.awssdk.services.kendra.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.kendra.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.kendra.model.DeleteExperienceRequest;
import software.amazon.awssdk.services.kendra.model.DeleteExperienceResponse;
import software.amazon.awssdk.services.kendra.model.DeleteFaqRequest;
import software.amazon.awssdk.services.kendra.model.DeleteFaqResponse;
import software.amazon.awssdk.services.kendra.model.DeleteIndexRequest;
import software.amazon.awssdk.services.kendra.model.DeleteIndexResponse;
import software.amazon.awssdk.services.kendra.model.DeletePrincipalMappingRequest;
import software.amazon.awssdk.services.kendra.model.DeletePrincipalMappingResponse;
import software.amazon.awssdk.services.kendra.model.DeleteQuerySuggestionsBlockListRequest;
import software.amazon.awssdk.services.kendra.model.DeleteQuerySuggestionsBlockListResponse;
import software.amazon.awssdk.services.kendra.model.DeleteThesaurusRequest;
import software.amazon.awssdk.services.kendra.model.DeleteThesaurusResponse;
import software.amazon.awssdk.services.kendra.model.DescribeDataSourceRequest;
import software.amazon.awssdk.services.kendra.model.DescribeDataSourceResponse;
import software.amazon.awssdk.services.kendra.model.DescribeExperienceRequest;
import software.amazon.awssdk.services.kendra.model.DescribeExperienceResponse;
import software.amazon.awssdk.services.kendra.model.DescribeFaqRequest;
import software.amazon.awssdk.services.kendra.model.DescribeFaqResponse;
import software.amazon.awssdk.services.kendra.model.DescribeIndexRequest;
import software.amazon.awssdk.services.kendra.model.DescribeIndexResponse;
import software.amazon.awssdk.services.kendra.model.DescribePrincipalMappingRequest;
import software.amazon.awssdk.services.kendra.model.DescribePrincipalMappingResponse;
import software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsBlockListRequest;
import software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsBlockListResponse;
import software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsConfigRequest;
import software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsConfigResponse;
import software.amazon.awssdk.services.kendra.model.DescribeThesaurusRequest;
import software.amazon.awssdk.services.kendra.model.DescribeThesaurusResponse;
import software.amazon.awssdk.services.kendra.model.DisassociateEntitiesFromExperienceRequest;
import software.amazon.awssdk.services.kendra.model.DisassociateEntitiesFromExperienceResponse;
import software.amazon.awssdk.services.kendra.model.DisassociatePersonasFromEntitiesRequest;
import software.amazon.awssdk.services.kendra.model.DisassociatePersonasFromEntitiesResponse;
import software.amazon.awssdk.services.kendra.model.GetQuerySuggestionsRequest;
import software.amazon.awssdk.services.kendra.model.GetQuerySuggestionsResponse;
import software.amazon.awssdk.services.kendra.model.GetSnapshotsRequest;
import software.amazon.awssdk.services.kendra.model.GetSnapshotsResponse;
import software.amazon.awssdk.services.kendra.model.InternalServerException;
import software.amazon.awssdk.services.kendra.model.InvalidRequestException;
import software.amazon.awssdk.services.kendra.model.KendraException;
import software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsRequest;
import software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsResponse;
import software.amazon.awssdk.services.kendra.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.kendra.model.ListDataSourcesResponse;
import software.amazon.awssdk.services.kendra.model.ListEntityPersonasRequest;
import software.amazon.awssdk.services.kendra.model.ListEntityPersonasResponse;
import software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesRequest;
import software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesResponse;
import software.amazon.awssdk.services.kendra.model.ListExperiencesRequest;
import software.amazon.awssdk.services.kendra.model.ListExperiencesResponse;
import software.amazon.awssdk.services.kendra.model.ListFaqsRequest;
import software.amazon.awssdk.services.kendra.model.ListFaqsResponse;
import software.amazon.awssdk.services.kendra.model.ListGroupsOlderThanOrderingIdRequest;
import software.amazon.awssdk.services.kendra.model.ListGroupsOlderThanOrderingIdResponse;
import software.amazon.awssdk.services.kendra.model.ListIndicesRequest;
import software.amazon.awssdk.services.kendra.model.ListIndicesResponse;
import software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsRequest;
import software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsResponse;
import software.amazon.awssdk.services.kendra.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.kendra.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.kendra.model.ListThesauriRequest;
import software.amazon.awssdk.services.kendra.model.ListThesauriResponse;
import software.amazon.awssdk.services.kendra.model.PutPrincipalMappingRequest;
import software.amazon.awssdk.services.kendra.model.PutPrincipalMappingResponse;
import software.amazon.awssdk.services.kendra.model.QueryRequest;
import software.amazon.awssdk.services.kendra.model.QueryResponse;
import software.amazon.awssdk.services.kendra.model.ResourceAlreadyExistException;
import software.amazon.awssdk.services.kendra.model.ResourceInUseException;
import software.amazon.awssdk.services.kendra.model.ResourceNotFoundException;
import software.amazon.awssdk.services.kendra.model.ResourceUnavailableException;
import software.amazon.awssdk.services.kendra.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.kendra.model.StartDataSourceSyncJobRequest;
import software.amazon.awssdk.services.kendra.model.StartDataSourceSyncJobResponse;
import software.amazon.awssdk.services.kendra.model.StopDataSourceSyncJobRequest;
import software.amazon.awssdk.services.kendra.model.StopDataSourceSyncJobResponse;
import software.amazon.awssdk.services.kendra.model.SubmitFeedbackRequest;
import software.amazon.awssdk.services.kendra.model.SubmitFeedbackResponse;
import software.amazon.awssdk.services.kendra.model.TagResourceRequest;
import software.amazon.awssdk.services.kendra.model.TagResourceResponse;
import software.amazon.awssdk.services.kendra.model.ThrottlingException;
import software.amazon.awssdk.services.kendra.model.UntagResourceRequest;
import software.amazon.awssdk.services.kendra.model.UntagResourceResponse;
import software.amazon.awssdk.services.kendra.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.kendra.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.kendra.model.UpdateExperienceRequest;
import software.amazon.awssdk.services.kendra.model.UpdateExperienceResponse;
import software.amazon.awssdk.services.kendra.model.UpdateIndexRequest;
import software.amazon.awssdk.services.kendra.model.UpdateIndexResponse;
import software.amazon.awssdk.services.kendra.model.UpdateQuerySuggestionsBlockListRequest;
import software.amazon.awssdk.services.kendra.model.UpdateQuerySuggestionsBlockListResponse;
import software.amazon.awssdk.services.kendra.model.UpdateQuerySuggestionsConfigRequest;
import software.amazon.awssdk.services.kendra.model.UpdateQuerySuggestionsConfigResponse;
import software.amazon.awssdk.services.kendra.model.UpdateThesaurusRequest;
import software.amazon.awssdk.services.kendra.model.UpdateThesaurusResponse;
import software.amazon.awssdk.services.kendra.model.ValidationException;
import software.amazon.awssdk.services.kendra.paginators.GetSnapshotsIterable;
import software.amazon.awssdk.services.kendra.paginators.ListDataSourceSyncJobsIterable;
import software.amazon.awssdk.services.kendra.paginators.ListDataSourcesIterable;
import software.amazon.awssdk.services.kendra.paginators.ListEntityPersonasIterable;
import software.amazon.awssdk.services.kendra.paginators.ListExperienceEntitiesIterable;
import software.amazon.awssdk.services.kendra.paginators.ListExperiencesIterable;
import software.amazon.awssdk.services.kendra.paginators.ListIndicesIterable;

/**
 * Service client for accessing kendra. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Kendra is a service for indexing large document sets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface KendraClient extends SdkClient {
    String SERVICE_NAME = "kendra";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "kendra";

    /**
     * Create a {@link KendraClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static KendraClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link KendraClient}.
     */
    static KendraClientBuilder builder() {
        return new DefaultKendraClientBuilder();
    }

    /**
     * <p>
     * Grants users or groups in your Amazon Web Services SSO identity source access to your Amazon Kendra experience.
     * You can create an Amazon Kendra experience such as a search application. For more information on creating a
     * search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     *
     * @param associateEntitiesToExperienceRequest
     * @return Result of the AssociateEntitiesToExperience operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ResourceAlreadyExistException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.AssociateEntitiesToExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/AssociateEntitiesToExperience"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateEntitiesToExperienceResponse associateEntitiesToExperience(
            AssociateEntitiesToExperienceRequest associateEntitiesToExperienceRequest) throws ValidationException,
            ResourceNotFoundException, ResourceAlreadyExistException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants users or groups in your Amazon Web Services SSO identity source access to your Amazon Kendra experience.
     * You can create an Amazon Kendra experience such as a search application. For more information on creating a
     * search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateEntitiesToExperienceRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateEntitiesToExperienceRequest#builder()}
     * </p>
     *
     * @param associateEntitiesToExperienceRequest
     *        A {@link Consumer} that will call methods on {@link AssociateEntitiesToExperienceRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateEntitiesToExperience operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ResourceAlreadyExistException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.AssociateEntitiesToExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/AssociateEntitiesToExperience"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateEntitiesToExperienceResponse associateEntitiesToExperience(
            Consumer<AssociateEntitiesToExperienceRequest.Builder> associateEntitiesToExperienceRequest)
            throws ValidationException, ResourceNotFoundException, ResourceAlreadyExistException, ThrottlingException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return associateEntitiesToExperience(AssociateEntitiesToExperienceRequest.builder()
                .applyMutation(associateEntitiesToExperienceRequest).build());
    }

    /**
     * <p>
     * Defines the specific permissions of users or groups in your Amazon Web Services SSO identity source with access
     * to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For
     * more information on creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     *
     * @param associatePersonasToEntitiesRequest
     * @return Result of the AssociatePersonasToEntities operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ResourceAlreadyExistException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.AssociatePersonasToEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/AssociatePersonasToEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociatePersonasToEntitiesResponse associatePersonasToEntities(
            AssociatePersonasToEntitiesRequest associatePersonasToEntitiesRequest) throws ValidationException,
            ResourceNotFoundException, ResourceAlreadyExistException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines the specific permissions of users or groups in your Amazon Web Services SSO identity source with access
     * to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For
     * more information on creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociatePersonasToEntitiesRequest.Builder}
     * avoiding the need to create one manually via {@link AssociatePersonasToEntitiesRequest#builder()}
     * </p>
     *
     * @param associatePersonasToEntitiesRequest
     *        A {@link Consumer} that will call methods on {@link AssociatePersonasToEntitiesRequest.Builder} to create
     *        a request.
     * @return Result of the AssociatePersonasToEntities operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ResourceAlreadyExistException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.AssociatePersonasToEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/AssociatePersonasToEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociatePersonasToEntitiesResponse associatePersonasToEntities(
            Consumer<AssociatePersonasToEntitiesRequest.Builder> associatePersonasToEntitiesRequest) throws ValidationException,
            ResourceNotFoundException, ResourceAlreadyExistException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return associatePersonasToEntities(AssociatePersonasToEntitiesRequest.builder()
                .applyMutation(associatePersonasToEntitiesRequest).build());
    }

    /**
     * <p>
     * Removes one or more documents from an index. The documents must have been added with the
     * <code>BatchPutDocument</code> operation.
     * </p>
     * <p>
     * The documents are deleted asynchronously. You can see the progress of the deletion by using Amazon Web Services
     * CloudWatch. Any error messages related to the processing of the batch are sent to you CloudWatch log.
     * </p>
     *
     * @param batchDeleteDocumentRequest
     * @return Result of the BatchDeleteDocument operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.BatchDeleteDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/BatchDeleteDocument" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchDeleteDocumentResponse batchDeleteDocument(BatchDeleteDocumentRequest batchDeleteDocumentRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more documents from an index. The documents must have been added with the
     * <code>BatchPutDocument</code> operation.
     * </p>
     * <p>
     * The documents are deleted asynchronously. You can see the progress of the deletion by using Amazon Web Services
     * CloudWatch. Any error messages related to the processing of the batch are sent to you CloudWatch log.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteDocumentRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDeleteDocumentRequest#builder()}
     * </p>
     *
     * @param batchDeleteDocumentRequest
     *        A {@link Consumer} that will call methods on {@link BatchDeleteDocumentRequest.Builder} to create a
     *        request.
     * @return Result of the BatchDeleteDocument operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.BatchDeleteDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/BatchDeleteDocument" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchDeleteDocumentResponse batchDeleteDocument(
            Consumer<BatchDeleteDocumentRequest.Builder> batchDeleteDocumentRequest) throws ValidationException,
            ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, KendraException {
        return batchDeleteDocument(BatchDeleteDocumentRequest.builder().applyMutation(batchDeleteDocumentRequest).build());
    }

    /**
     * <p>
     * Returns the indexing status for one or more documents submitted with the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html"> BatchPutDocument</a> operation.
     * </p>
     * <p>
     * When you use the <code>BatchPutDocument</code> operation, documents are indexed asynchronously. You can use the
     * <code>BatchGetDocumentStatus</code> operation to get the current status of a list of documents so that you can
     * determine if they have been successfully indexed.
     * </p>
     * <p>
     * You can also use the <code>BatchGetDocumentStatus</code> operation to check the status of the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchDeleteDocument.html"> BatchDeleteDocument</a>
     * operation. When a document is deleted from the index, Amazon Kendra returns <code>NOT_FOUND</code> as the status.
     * </p>
     *
     * @param batchGetDocumentStatusRequest
     * @return Result of the BatchGetDocumentStatus operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.BatchGetDocumentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/BatchGetDocumentStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchGetDocumentStatusResponse batchGetDocumentStatus(BatchGetDocumentStatusRequest batchGetDocumentStatusRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the indexing status for one or more documents submitted with the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html"> BatchPutDocument</a> operation.
     * </p>
     * <p>
     * When you use the <code>BatchPutDocument</code> operation, documents are indexed asynchronously. You can use the
     * <code>BatchGetDocumentStatus</code> operation to get the current status of a list of documents so that you can
     * determine if they have been successfully indexed.
     * </p>
     * <p>
     * You can also use the <code>BatchGetDocumentStatus</code> operation to check the status of the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchDeleteDocument.html"> BatchDeleteDocument</a>
     * operation. When a document is deleted from the index, Amazon Kendra returns <code>NOT_FOUND</code> as the status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetDocumentStatusRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetDocumentStatusRequest#builder()}
     * </p>
     *
     * @param batchGetDocumentStatusRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetDocumentStatusRequest.Builder} to create a
     *        request.
     * @return Result of the BatchGetDocumentStatus operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.BatchGetDocumentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/BatchGetDocumentStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchGetDocumentStatusResponse batchGetDocumentStatus(
            Consumer<BatchGetDocumentStatusRequest.Builder> batchGetDocumentStatusRequest) throws ValidationException,
            ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, KendraException {
        return batchGetDocumentStatus(BatchGetDocumentStatusRequest.builder().applyMutation(batchGetDocumentStatusRequest)
                .build());
    }

    /**
     * <p>
     * Adds one or more documents to an index.
     * </p>
     * <p>
     * The <code>BatchPutDocument</code> operation enables you to ingest inline documents or a set of documents stored
     * in an Amazon S3 bucket. Use this operation to ingest your text and unstructured text into an index, add custom
     * attributes to the documents, and to attach an access control list to the documents added to the index.
     * </p>
     * <p>
     * The documents are indexed asynchronously. You can see the progress of the batch using Amazon Web Services
     * CloudWatch. Any error messages related to processing the batch are sent to your Amazon Web Services CloudWatch
     * log.
     * </p>
     *
     * @param batchPutDocumentRequest
     * @return Result of the BatchPutDocument operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws ServiceQuotaExceededException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.BatchPutDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/BatchPutDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchPutDocumentResponse batchPutDocument(BatchPutDocumentRequest batchPutDocumentRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more documents to an index.
     * </p>
     * <p>
     * The <code>BatchPutDocument</code> operation enables you to ingest inline documents or a set of documents stored
     * in an Amazon S3 bucket. Use this operation to ingest your text and unstructured text into an index, add custom
     * attributes to the documents, and to attach an access control list to the documents added to the index.
     * </p>
     * <p>
     * The documents are indexed asynchronously. You can see the progress of the batch using Amazon Web Services
     * CloudWatch. Any error messages related to processing the batch are sent to your Amazon Web Services CloudWatch
     * log.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchPutDocumentRequest.Builder} avoiding the need
     * to create one manually via {@link BatchPutDocumentRequest#builder()}
     * </p>
     *
     * @param batchPutDocumentRequest
     *        A {@link Consumer} that will call methods on {@link BatchPutDocumentRequest.Builder} to create a request.
     * @return Result of the BatchPutDocument operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws ServiceQuotaExceededException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.BatchPutDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/BatchPutDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchPutDocumentResponse batchPutDocument(Consumer<BatchPutDocumentRequest.Builder> batchPutDocumentRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return batchPutDocument(BatchPutDocumentRequest.builder().applyMutation(batchPutDocumentRequest).build());
    }

    /**
     * <p>
     * Clears existing query suggestions from an index.
     * </p>
     * <p>
     * This deletes existing suggestions only, not the queries in the query log. After you clear suggestions, Amazon
     * Kendra learns new suggestions based on new queries added to the query log from the time you cleared suggestions.
     * If you do not see any new suggestions, then please allow Amazon Kendra to collect enough queries to learn new
     * suggestions.
     * </p>
     * <p>
     * <code>ClearQuerySuggestions</code> is currently not supported in the Amazon Web Services GovCloud (US-West)
     * region.
     * </p>
     *
     * @param clearQuerySuggestionsRequest
     * @return Result of the ClearQuerySuggestions operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ClearQuerySuggestions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ClearQuerySuggestions" target="_top">AWS
     *      API Documentation</a>
     */
    default ClearQuerySuggestionsResponse clearQuerySuggestions(ClearQuerySuggestionsRequest clearQuerySuggestionsRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, ConflictException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Clears existing query suggestions from an index.
     * </p>
     * <p>
     * This deletes existing suggestions only, not the queries in the query log. After you clear suggestions, Amazon
     * Kendra learns new suggestions based on new queries added to the query log from the time you cleared suggestions.
     * If you do not see any new suggestions, then please allow Amazon Kendra to collect enough queries to learn new
     * suggestions.
     * </p>
     * <p>
     * <code>ClearQuerySuggestions</code> is currently not supported in the Amazon Web Services GovCloud (US-West)
     * region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ClearQuerySuggestionsRequest.Builder} avoiding the
     * need to create one manually via {@link ClearQuerySuggestionsRequest#builder()}
     * </p>
     *
     * @param clearQuerySuggestionsRequest
     *        A {@link Consumer} that will call methods on {@link ClearQuerySuggestionsRequest.Builder} to create a
     *        request.
     * @return Result of the ClearQuerySuggestions operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ClearQuerySuggestions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ClearQuerySuggestions" target="_top">AWS
     *      API Documentation</a>
     */
    default ClearQuerySuggestionsResponse clearQuerySuggestions(
            Consumer<ClearQuerySuggestionsRequest.Builder> clearQuerySuggestionsRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, ConflictException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, KendraException {
        return clearQuerySuggestions(ClearQuerySuggestionsRequest.builder().applyMutation(clearQuerySuggestionsRequest).build());
    }

    /**
     * <p>
     * Creates a data source that you want to use with an Amazon Kendra index.
     * </p>
     * <p>
     * You specify a name, data source connector type and description for your data source. You also specify
     * configuration information for the data source connector.
     * </p>
     * <p>
     * <code>CreateDataSource</code> is a synchronous operation. The operation returns 200 if the data source was
     * successfully created. Otherwise, an exception is raised.
     * </p>
     * <p>
     * Amazon S3 and <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-custom.html">custom</a> data
     * sources are the only supported data sources in the Amazon Web Services GovCloud (US-West) region.
     * </p>
     *
     * @param createDataSourceRequest
     * @return Result of the CreateDataSource operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ResourceAlreadyExistException
     * @throws ServiceQuotaExceededException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.CreateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDataSourceResponse createDataSource(CreateDataSourceRequest createDataSourceRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, ResourceAlreadyExistException,
            ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a data source that you want to use with an Amazon Kendra index.
     * </p>
     * <p>
     * You specify a name, data source connector type and description for your data source. You also specify
     * configuration information for the data source connector.
     * </p>
     * <p>
     * <code>CreateDataSource</code> is a synchronous operation. The operation returns 200 if the data source was
     * successfully created. Otherwise, an exception is raised.
     * </p>
     * <p>
     * Amazon S3 and <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-custom.html">custom</a> data
     * sources are the only supported data sources in the Amazon Web Services GovCloud (US-West) region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDataSourceRequest#builder()}
     * </p>
     *
     * @param createDataSourceRequest
     *        A {@link Consumer} that will call methods on {@link CreateDataSourceRequest.Builder} to create a request.
     * @return Result of the CreateDataSource operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ResourceAlreadyExistException
     * @throws ServiceQuotaExceededException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.CreateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDataSourceResponse createDataSource(Consumer<CreateDataSourceRequest.Builder> createDataSourceRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, ResourceAlreadyExistException,
            ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, KendraException {
        return createDataSource(CreateDataSourceRequest.builder().applyMutation(createDataSourceRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Kendra experience such as a search application. For more information on creating a search
     * application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     *
     * @param createExperienceRequest
     * @return Result of the CreateExperience operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ServiceQuotaExceededException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.CreateExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateExperience" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateExperienceResponse createExperience(CreateExperienceRequest createExperienceRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, ServiceQuotaExceededException,
            ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Kendra experience such as a search application. For more information on creating a search
     * application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateExperienceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateExperienceRequest#builder()}
     * </p>
     *
     * @param createExperienceRequest
     *        A {@link Consumer} that will call methods on {@link CreateExperienceRequest.Builder} to create a request.
     * @return Result of the CreateExperience operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ServiceQuotaExceededException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.CreateExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateExperience" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateExperienceResponse createExperience(Consumer<CreateExperienceRequest.Builder> createExperienceRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, ServiceQuotaExceededException,
            ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            KendraException {
        return createExperience(CreateExperienceRequest.builder().applyMutation(createExperienceRequest).build());
    }

    /**
     * <p>
     * Creates an new set of frequently asked question (FAQ) questions and answers.
     * </p>
     * <p>
     * Adding FAQs to an index is an asynchronous operation.
     * </p>
     *
     * @param createFaqRequest
     * @return Result of the CreateFaq operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.CreateFaq
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateFaq" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFaqResponse createFaq(CreateFaqRequest createFaqRequest) throws ValidationException, ConflictException,
            ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an new set of frequently asked question (FAQ) questions and answers.
     * </p>
     * <p>
     * Adding FAQs to an index is an asynchronous operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFaqRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFaqRequest#builder()}
     * </p>
     *
     * @param createFaqRequest
     *        A {@link Consumer} that will call methods on {@link CreateFaqRequest.Builder} to create a request.
     * @return Result of the CreateFaq operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.CreateFaq
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateFaq" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFaqResponse createFaq(Consumer<CreateFaqRequest.Builder> createFaqRequest) throws ValidationException,
            ConflictException, ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return createFaq(CreateFaqRequest.builder().applyMutation(createFaqRequest).build());
    }

    /**
     * <p>
     * Creates a new Amazon Kendra index. Index creation is an asynchronous operation. To determine if index creation
     * has completed, check the <code>Status</code> field returned from a call to <code>DescribeIndex</code>. The
     * <code>Status</code> field is set to <code>ACTIVE</code> when the index is ready to use.
     * </p>
     * <p>
     * Once the index is active you can index your documents using the <code>BatchPutDocument</code> operation or using
     * one of the supported data sources.
     * </p>
     *
     * @param createIndexRequest
     * @return Result of the CreateIndex operation returned by the service.
     * @throws ValidationException
     * @throws ResourceAlreadyExistException
     * @throws ServiceQuotaExceededException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.CreateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateIndexResponse createIndex(CreateIndexRequest createIndexRequest) throws ValidationException,
            ResourceAlreadyExistException, ServiceQuotaExceededException, ThrottlingException, AccessDeniedException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Amazon Kendra index. Index creation is an asynchronous operation. To determine if index creation
     * has completed, check the <code>Status</code> field returned from a call to <code>DescribeIndex</code>. The
     * <code>Status</code> field is set to <code>ACTIVE</code> when the index is ready to use.
     * </p>
     * <p>
     * Once the index is active you can index your documents using the <code>BatchPutDocument</code> operation or using
     * one of the supported data sources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIndexRequest.Builder} avoiding the need to
     * create one manually via {@link CreateIndexRequest#builder()}
     * </p>
     *
     * @param createIndexRequest
     *        A {@link Consumer} that will call methods on {@link CreateIndexRequest.Builder} to create a request.
     * @return Result of the CreateIndex operation returned by the service.
     * @throws ValidationException
     * @throws ResourceAlreadyExistException
     * @throws ServiceQuotaExceededException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.CreateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateIndexResponse createIndex(Consumer<CreateIndexRequest.Builder> createIndexRequest) throws ValidationException,
            ResourceAlreadyExistException, ServiceQuotaExceededException, ThrottlingException, AccessDeniedException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return createIndex(CreateIndexRequest.builder().applyMutation(createIndexRequest).build());
    }

    /**
     * <p>
     * Creates a block list to exlcude certain queries from suggestions.
     * </p>
     * <p>
     * Any query that contains words or phrases specified in the block list is blocked or filtered out from being shown
     * as a suggestion.
     * </p>
     * <p>
     * You need to provide the file location of your block list text file in your S3 bucket. In your text file, enter
     * each block word or phrase on a separate line.
     * </p>
     * <p>
     * For information on the current quota limits for block lists, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.
     * </p>
     * <p>
     * <code>CreateQuerySuggestionsBlockList</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     *
     * @param createQuerySuggestionsBlockListRequest
     * @return Result of the CreateQuerySuggestionsBlockList operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws ServiceQuotaExceededException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.CreateQuerySuggestionsBlockList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateQuerySuggestionsBlockList"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateQuerySuggestionsBlockListResponse createQuerySuggestionsBlockList(
            CreateQuerySuggestionsBlockListRequest createQuerySuggestionsBlockListRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ServiceQuotaExceededException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a block list to exlcude certain queries from suggestions.
     * </p>
     * <p>
     * Any query that contains words or phrases specified in the block list is blocked or filtered out from being shown
     * as a suggestion.
     * </p>
     * <p>
     * You need to provide the file location of your block list text file in your S3 bucket. In your text file, enter
     * each block word or phrase on a separate line.
     * </p>
     * <p>
     * For information on the current quota limits for block lists, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.
     * </p>
     * <p>
     * <code>CreateQuerySuggestionsBlockList</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateQuerySuggestionsBlockListRequest.Builder}
     * avoiding the need to create one manually via {@link CreateQuerySuggestionsBlockListRequest#builder()}
     * </p>
     *
     * @param createQuerySuggestionsBlockListRequest
     *        A {@link Consumer} that will call methods on {@link CreateQuerySuggestionsBlockListRequest.Builder} to
     *        create a request.
     * @return Result of the CreateQuerySuggestionsBlockList operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws ServiceQuotaExceededException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.CreateQuerySuggestionsBlockList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateQuerySuggestionsBlockList"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateQuerySuggestionsBlockListResponse createQuerySuggestionsBlockList(
            Consumer<CreateQuerySuggestionsBlockListRequest.Builder> createQuerySuggestionsBlockListRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ServiceQuotaExceededException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            KendraException {
        return createQuerySuggestionsBlockList(CreateQuerySuggestionsBlockListRequest.builder()
                .applyMutation(createQuerySuggestionsBlockListRequest).build());
    }

    /**
     * <p>
     * Creates a thesaurus for an index. The thesaurus contains a list of synonyms in Solr format.
     * </p>
     *
     * @param createThesaurusRequest
     * @return Result of the CreateThesaurus operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.CreateThesaurus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateThesaurus" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateThesaurusResponse createThesaurus(CreateThesaurusRequest createThesaurusRequest) throws ValidationException,
            ConflictException, ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a thesaurus for an index. The thesaurus contains a list of synonyms in Solr format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateThesaurusRequest.Builder} avoiding the need
     * to create one manually via {@link CreateThesaurusRequest#builder()}
     * </p>
     *
     * @param createThesaurusRequest
     *        A {@link Consumer} that will call methods on {@link CreateThesaurusRequest.Builder} to create a request.
     * @return Result of the CreateThesaurus operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.CreateThesaurus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateThesaurus" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateThesaurusResponse createThesaurus(Consumer<CreateThesaurusRequest.Builder> createThesaurusRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, KendraException {
        return createThesaurus(CreateThesaurusRequest.builder().applyMutation(createThesaurusRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Kendra data source. An exception is not thrown if the data source is already being deleted.
     * While the data source is being deleted, the <code>Status</code> field returned by a call to the
     * <code>DescribeDataSource</code> operation is set to <code>DELETING</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/delete-data-source.html">Deleting Data Sources</a>.
     * </p>
     *
     * @param deleteDataSourceRequest
     * @return Result of the DeleteDataSource operation returned by the service.
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DeleteDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDataSourceResponse deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest)
            throws AccessDeniedException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Kendra data source. An exception is not thrown if the data source is already being deleted.
     * While the data source is being deleted, the <code>Status</code> field returned by a call to the
     * <code>DescribeDataSource</code> operation is set to <code>DELETING</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/delete-data-source.html">Deleting Data Sources</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDataSourceRequest#builder()}
     * </p>
     *
     * @param deleteDataSourceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDataSourceRequest.Builder} to create a request.
     * @return Result of the DeleteDataSource operation returned by the service.
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DeleteDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDataSourceResponse deleteDataSource(Consumer<DeleteDataSourceRequest.Builder> deleteDataSourceRequest)
            throws AccessDeniedException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return deleteDataSource(DeleteDataSourceRequest.builder().applyMutation(deleteDataSourceRequest).build());
    }

    /**
     * <p>
     * Deletes your Amazon Kendra experience such as a search application. For more information on creating a search
     * application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     *
     * @param deleteExperienceRequest
     * @return Result of the DeleteExperience operation returned by the service.
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DeleteExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteExperience" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteExperienceResponse deleteExperience(DeleteExperienceRequest deleteExperienceRequest)
            throws AccessDeniedException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes your Amazon Kendra experience such as a search application. For more information on creating a search
     * application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteExperienceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteExperienceRequest#builder()}
     * </p>
     *
     * @param deleteExperienceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteExperienceRequest.Builder} to create a request.
     * @return Result of the DeleteExperience operation returned by the service.
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DeleteExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteExperience" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteExperienceResponse deleteExperience(Consumer<DeleteExperienceRequest.Builder> deleteExperienceRequest)
            throws AccessDeniedException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return deleteExperience(DeleteExperienceRequest.builder().applyMutation(deleteExperienceRequest).build());
    }

    /**
     * <p>
     * Removes an FAQ from an index.
     * </p>
     *
     * @param deleteFaqRequest
     * @return Result of the DeleteFaq operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DeleteFaq
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteFaq" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFaqResponse deleteFaq(DeleteFaqRequest deleteFaqRequest) throws ValidationException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an FAQ from an index.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFaqRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFaqRequest#builder()}
     * </p>
     *
     * @param deleteFaqRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFaqRequest.Builder} to create a request.
     * @return Result of the DeleteFaq operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DeleteFaq
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteFaq" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFaqResponse deleteFaq(Consumer<DeleteFaqRequest.Builder> deleteFaqRequest) throws ValidationException,
            ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, KendraException {
        return deleteFaq(DeleteFaqRequest.builder().applyMutation(deleteFaqRequest).build());
    }

    /**
     * <p>
     * Deletes an existing Amazon Kendra index. An exception is not thrown if the index is already being deleted. While
     * the index is being deleted, the <code>Status</code> field returned by a call to the <code>DescribeIndex</code>
     * operation is set to <code>DELETING</code>.
     * </p>
     *
     * @param deleteIndexRequest
     * @return Result of the DeleteIndex operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DeleteIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteIndexResponse deleteIndex(DeleteIndexRequest deleteIndexRequest) throws ValidationException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing Amazon Kendra index. An exception is not thrown if the index is already being deleted. While
     * the index is being deleted, the <code>Status</code> field returned by a call to the <code>DescribeIndex</code>
     * operation is set to <code>DELETING</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIndexRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteIndexRequest#builder()}
     * </p>
     *
     * @param deleteIndexRequest
     *        A {@link Consumer} that will call methods on {@link DeleteIndexRequest.Builder} to create a request.
     * @return Result of the DeleteIndex operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DeleteIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteIndexResponse deleteIndex(Consumer<DeleteIndexRequest.Builder> deleteIndexRequest) throws ValidationException,
            ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, KendraException {
        return deleteIndex(DeleteIndexRequest.builder().applyMutation(deleteIndexRequest).build());
    }

    /**
     * <p>
     * Deletes a group so that all users and sub groups that belong to the group can no longer access documents only
     * available to that group.
     * </p>
     * <p>
     * For example, after deleting the group "Summer Interns", all interns who belonged to that group no longer see
     * intern-only documents in their search results.
     * </p>
     * <p>
     * If you want to delete or replace users or sub groups of a group, you need to use the
     * <code>PutPrincipalMapping</code> operation. For example, if a user in the group "Engineering" leaves the
     * engineering team and another user takes their place, you provide an updated list of users or sub groups that
     * belong to the "Engineering" group when calling <code>PutPrincipalMapping</code>. You can update your internal
     * list of users or sub groups and input this list when calling <code>PutPrincipalMapping</code>.
     * </p>
     * <p>
     * <code>DeletePrincipalMapping</code> is currently not supported in the Amazon Web Services GovCloud (US-West)
     * region.
     * </p>
     *
     * @param deletePrincipalMappingRequest
     * @return Result of the DeletePrincipalMapping operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DeletePrincipalMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeletePrincipalMapping" target="_top">AWS
     *      API Documentation</a>
     */
    default DeletePrincipalMappingResponse deletePrincipalMapping(DeletePrincipalMappingRequest deletePrincipalMappingRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a group so that all users and sub groups that belong to the group can no longer access documents only
     * available to that group.
     * </p>
     * <p>
     * For example, after deleting the group "Summer Interns", all interns who belonged to that group no longer see
     * intern-only documents in their search results.
     * </p>
     * <p>
     * If you want to delete or replace users or sub groups of a group, you need to use the
     * <code>PutPrincipalMapping</code> operation. For example, if a user in the group "Engineering" leaves the
     * engineering team and another user takes their place, you provide an updated list of users or sub groups that
     * belong to the "Engineering" group when calling <code>PutPrincipalMapping</code>. You can update your internal
     * list of users or sub groups and input this list when calling <code>PutPrincipalMapping</code>.
     * </p>
     * <p>
     * <code>DeletePrincipalMapping</code> is currently not supported in the Amazon Web Services GovCloud (US-West)
     * region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePrincipalMappingRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePrincipalMappingRequest#builder()}
     * </p>
     *
     * @param deletePrincipalMappingRequest
     *        A {@link Consumer} that will call methods on {@link DeletePrincipalMappingRequest.Builder} to create a
     *        request.
     * @return Result of the DeletePrincipalMapping operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DeletePrincipalMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeletePrincipalMapping" target="_top">AWS
     *      API Documentation</a>
     */
    default DeletePrincipalMappingResponse deletePrincipalMapping(
            Consumer<DeletePrincipalMappingRequest.Builder> deletePrincipalMappingRequest) throws ValidationException,
            ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, KendraException {
        return deletePrincipalMapping(DeletePrincipalMappingRequest.builder().applyMutation(deletePrincipalMappingRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a block list used for query suggestions for an index.
     * </p>
     * <p>
     * A deleted block list might not take effect right away. Amazon Kendra needs to refresh the entire suggestions list
     * to add back the queries that were previously blocked.
     * </p>
     * <p>
     * <code>DeleteQuerySuggestionsBlockList</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     *
     * @param deleteQuerySuggestionsBlockListRequest
     * @return Result of the DeleteQuerySuggestionsBlockList operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DeleteQuerySuggestionsBlockList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteQuerySuggestionsBlockList"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteQuerySuggestionsBlockListResponse deleteQuerySuggestionsBlockList(
            DeleteQuerySuggestionsBlockListRequest deleteQuerySuggestionsBlockListRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a block list used for query suggestions for an index.
     * </p>
     * <p>
     * A deleted block list might not take effect right away. Amazon Kendra needs to refresh the entire suggestions list
     * to add back the queries that were previously blocked.
     * </p>
     * <p>
     * <code>DeleteQuerySuggestionsBlockList</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteQuerySuggestionsBlockListRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteQuerySuggestionsBlockListRequest#builder()}
     * </p>
     *
     * @param deleteQuerySuggestionsBlockListRequest
     *        A {@link Consumer} that will call methods on {@link DeleteQuerySuggestionsBlockListRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteQuerySuggestionsBlockList operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DeleteQuerySuggestionsBlockList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteQuerySuggestionsBlockList"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteQuerySuggestionsBlockListResponse deleteQuerySuggestionsBlockList(
            Consumer<DeleteQuerySuggestionsBlockListRequest.Builder> deleteQuerySuggestionsBlockListRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return deleteQuerySuggestionsBlockList(DeleteQuerySuggestionsBlockListRequest.builder()
                .applyMutation(deleteQuerySuggestionsBlockListRequest).build());
    }

    /**
     * <p>
     * Deletes an existing Amazon Kendra thesaurus.
     * </p>
     *
     * @param deleteThesaurusRequest
     * @return Result of the DeleteThesaurus operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DeleteThesaurus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteThesaurus" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteThesaurusResponse deleteThesaurus(DeleteThesaurusRequest deleteThesaurusRequest) throws ValidationException,
            ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing Amazon Kendra thesaurus.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteThesaurusRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteThesaurusRequest#builder()}
     * </p>
     *
     * @param deleteThesaurusRequest
     *        A {@link Consumer} that will call methods on {@link DeleteThesaurusRequest.Builder} to create a request.
     * @return Result of the DeleteThesaurus operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DeleteThesaurus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteThesaurus" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteThesaurusResponse deleteThesaurus(Consumer<DeleteThesaurusRequest.Builder> deleteThesaurusRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return deleteThesaurus(DeleteThesaurusRequest.builder().applyMutation(deleteThesaurusRequest).build());
    }

    /**
     * <p>
     * Gets information about a Amazon Kendra data source.
     * </p>
     *
     * @param describeDataSourceRequest
     * @return Result of the DescribeDataSource operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DescribeDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDataSourceResponse describeDataSource(DescribeDataSourceRequest describeDataSourceRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a Amazon Kendra data source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataSourceRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDataSourceRequest#builder()}
     * </p>
     *
     * @param describeDataSourceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDataSourceRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeDataSource operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DescribeDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDataSourceResponse describeDataSource(Consumer<DescribeDataSourceRequest.Builder> describeDataSourceRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return describeDataSource(DescribeDataSourceRequest.builder().applyMutation(describeDataSourceRequest).build());
    }

    /**
     * <p>
     * Gets information about your Amazon Kendra experience such as a search application. For more information on
     * creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     *
     * @param describeExperienceRequest
     * @return Result of the DescribeExperience operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DescribeExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeExperience" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeExperienceResponse describeExperience(DescribeExperienceRequest describeExperienceRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about your Amazon Kendra experience such as a search application. For more information on
     * creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeExperienceRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeExperienceRequest#builder()}
     * </p>
     *
     * @param describeExperienceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeExperienceRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeExperience operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DescribeExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeExperience" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeExperienceResponse describeExperience(Consumer<DescribeExperienceRequest.Builder> describeExperienceRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return describeExperience(DescribeExperienceRequest.builder().applyMutation(describeExperienceRequest).build());
    }

    /**
     * <p>
     * Gets information about an FAQ list.
     * </p>
     *
     * @param describeFaqRequest
     * @return Result of the DescribeFaq operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DescribeFaq
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeFaq" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeFaqResponse describeFaq(DescribeFaqRequest describeFaqRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an FAQ list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFaqRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeFaqRequest#builder()}
     * </p>
     *
     * @param describeFaqRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFaqRequest.Builder} to create a request.
     * @return Result of the DescribeFaq operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DescribeFaq
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeFaq" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeFaqResponse describeFaq(Consumer<DescribeFaqRequest.Builder> describeFaqRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, KendraException {
        return describeFaq(DescribeFaqRequest.builder().applyMutation(describeFaqRequest).build());
    }

    /**
     * <p>
     * Describes an existing Amazon Kendra index
     * </p>
     *
     * @param describeIndexRequest
     * @return Result of the DescribeIndex operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DescribeIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeIndexResponse describeIndex(DescribeIndexRequest describeIndexRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an existing Amazon Kendra index
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeIndexRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeIndexRequest#builder()}
     * </p>
     *
     * @param describeIndexRequest
     *        A {@link Consumer} that will call methods on {@link DescribeIndexRequest.Builder} to create a request.
     * @return Result of the DescribeIndex operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DescribeIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeIndexResponse describeIndex(Consumer<DescribeIndexRequest.Builder> describeIndexRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return describeIndex(DescribeIndexRequest.builder().applyMutation(describeIndexRequest).build());
    }

    /**
     * <p>
     * Describes the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.
     * This includes information on the status of actions currently processing or yet to be processed, when actions were
     * last updated, when actions were received by Amazon Kendra, the latest action that should process and apply after
     * other actions, and useful error messages if an action could not be processed.
     * </p>
     * <p>
     * <code>DescribePrincipalMapping</code> is currently not supported in the Amazon Web Services GovCloud (US-West)
     * region.
     * </p>
     *
     * @param describePrincipalMappingRequest
     * @return Result of the DescribePrincipalMapping operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DescribePrincipalMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribePrincipalMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePrincipalMappingResponse describePrincipalMapping(
            DescribePrincipalMappingRequest describePrincipalMappingRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.
     * This includes information on the status of actions currently processing or yet to be processed, when actions were
     * last updated, when actions were received by Amazon Kendra, the latest action that should process and apply after
     * other actions, and useful error messages if an action could not be processed.
     * </p>
     * <p>
     * <code>DescribePrincipalMapping</code> is currently not supported in the Amazon Web Services GovCloud (US-West)
     * region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePrincipalMappingRequest.Builder} avoiding
     * the need to create one manually via {@link DescribePrincipalMappingRequest#builder()}
     * </p>
     *
     * @param describePrincipalMappingRequest
     *        A {@link Consumer} that will call methods on {@link DescribePrincipalMappingRequest.Builder} to create a
     *        request.
     * @return Result of the DescribePrincipalMapping operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DescribePrincipalMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribePrincipalMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePrincipalMappingResponse describePrincipalMapping(
            Consumer<DescribePrincipalMappingRequest.Builder> describePrincipalMappingRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, KendraException {
        return describePrincipalMapping(DescribePrincipalMappingRequest.builder().applyMutation(describePrincipalMappingRequest)
                .build());
    }

    /**
     * <p>
     * Describes a block list used for query suggestions for an index.
     * </p>
     * <p>
     * This is used to check the current settings that are applied to a block list.
     * </p>
     * <p>
     * <code>DescribeQuerySuggestionsBlockList</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     *
     * @param describeQuerySuggestionsBlockListRequest
     * @return Result of the DescribeQuerySuggestionsBlockList operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DescribeQuerySuggestionsBlockList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeQuerySuggestionsBlockList"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeQuerySuggestionsBlockListResponse describeQuerySuggestionsBlockList(
            DescribeQuerySuggestionsBlockListRequest describeQuerySuggestionsBlockListRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a block list used for query suggestions for an index.
     * </p>
     * <p>
     * This is used to check the current settings that are applied to a block list.
     * </p>
     * <p>
     * <code>DescribeQuerySuggestionsBlockList</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeQuerySuggestionsBlockListRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeQuerySuggestionsBlockListRequest#builder()}
     * </p>
     *
     * @param describeQuerySuggestionsBlockListRequest
     *        A {@link Consumer} that will call methods on {@link DescribeQuerySuggestionsBlockListRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeQuerySuggestionsBlockList operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DescribeQuerySuggestionsBlockList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeQuerySuggestionsBlockList"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeQuerySuggestionsBlockListResponse describeQuerySuggestionsBlockList(
            Consumer<DescribeQuerySuggestionsBlockListRequest.Builder> describeQuerySuggestionsBlockListRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return describeQuerySuggestionsBlockList(DescribeQuerySuggestionsBlockListRequest.builder()
                .applyMutation(describeQuerySuggestionsBlockListRequest).build());
    }

    /**
     * <p>
     * Describes the settings of query suggestions for an index.
     * </p>
     * <p>
     * This is used to check the current settings applied to query suggestions.
     * </p>
     * <p>
     * <code>DescribeQuerySuggestionsConfig</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     *
     * @param describeQuerySuggestionsConfigRequest
     * @return Result of the DescribeQuerySuggestionsConfig operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DescribeQuerySuggestionsConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeQuerySuggestionsConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeQuerySuggestionsConfigResponse describeQuerySuggestionsConfig(
            DescribeQuerySuggestionsConfigRequest describeQuerySuggestionsConfigRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the settings of query suggestions for an index.
     * </p>
     * <p>
     * This is used to check the current settings applied to query suggestions.
     * </p>
     * <p>
     * <code>DescribeQuerySuggestionsConfig</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeQuerySuggestionsConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeQuerySuggestionsConfigRequest#builder()}
     * </p>
     *
     * @param describeQuerySuggestionsConfigRequest
     *        A {@link Consumer} that will call methods on {@link DescribeQuerySuggestionsConfigRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeQuerySuggestionsConfig operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DescribeQuerySuggestionsConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeQuerySuggestionsConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeQuerySuggestionsConfigResponse describeQuerySuggestionsConfig(
            Consumer<DescribeQuerySuggestionsConfigRequest.Builder> describeQuerySuggestionsConfigRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return describeQuerySuggestionsConfig(DescribeQuerySuggestionsConfigRequest.builder()
                .applyMutation(describeQuerySuggestionsConfigRequest).build());
    }

    /**
     * <p>
     * Describes an existing Amazon Kendra thesaurus.
     * </p>
     *
     * @param describeThesaurusRequest
     * @return Result of the DescribeThesaurus operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DescribeThesaurus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeThesaurus" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeThesaurusResponse describeThesaurus(DescribeThesaurusRequest describeThesaurusRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an existing Amazon Kendra thesaurus.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeThesaurusRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeThesaurusRequest#builder()}
     * </p>
     *
     * @param describeThesaurusRequest
     *        A {@link Consumer} that will call methods on {@link DescribeThesaurusRequest.Builder} to create a request.
     * @return Result of the DescribeThesaurus operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DescribeThesaurus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeThesaurus" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeThesaurusResponse describeThesaurus(Consumer<DescribeThesaurusRequest.Builder> describeThesaurusRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return describeThesaurus(DescribeThesaurusRequest.builder().applyMutation(describeThesaurusRequest).build());
    }

    /**
     * <p>
     * Prevents users or groups in your Amazon Web Services SSO identity source from accessing your Amazon Kendra
     * experience. You can create an Amazon Kendra experience such as a search application. For more information on
     * creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     *
     * @param disassociateEntitiesFromExperienceRequest
     * @return Result of the DisassociateEntitiesFromExperience operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DisassociateEntitiesFromExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DisassociateEntitiesFromExperience"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateEntitiesFromExperienceResponse disassociateEntitiesFromExperience(
            DisassociateEntitiesFromExperienceRequest disassociateEntitiesFromExperienceRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Prevents users or groups in your Amazon Web Services SSO identity source from accessing your Amazon Kendra
     * experience. You can create an Amazon Kendra experience such as a search application. For more information on
     * creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateEntitiesFromExperienceRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateEntitiesFromExperienceRequest#builder()}
     * </p>
     *
     * @param disassociateEntitiesFromExperienceRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateEntitiesFromExperienceRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateEntitiesFromExperience operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DisassociateEntitiesFromExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DisassociateEntitiesFromExperience"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateEntitiesFromExperienceResponse disassociateEntitiesFromExperience(
            Consumer<DisassociateEntitiesFromExperienceRequest.Builder> disassociateEntitiesFromExperienceRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return disassociateEntitiesFromExperience(DisassociateEntitiesFromExperienceRequest.builder()
                .applyMutation(disassociateEntitiesFromExperienceRequest).build());
    }

    /**
     * <p>
     * Removes the specific permissions of users or groups in your Amazon Web Services SSO identity source with access
     * to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For
     * more information on creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     *
     * @param disassociatePersonasFromEntitiesRequest
     * @return Result of the DisassociatePersonasFromEntities operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DisassociatePersonasFromEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DisassociatePersonasFromEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociatePersonasFromEntitiesResponse disassociatePersonasFromEntities(
            DisassociatePersonasFromEntitiesRequest disassociatePersonasFromEntitiesRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specific permissions of users or groups in your Amazon Web Services SSO identity source with access
     * to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For
     * more information on creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociatePersonasFromEntitiesRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociatePersonasFromEntitiesRequest#builder()}
     * </p>
     *
     * @param disassociatePersonasFromEntitiesRequest
     *        A {@link Consumer} that will call methods on {@link DisassociatePersonasFromEntitiesRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociatePersonasFromEntities operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.DisassociatePersonasFromEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DisassociatePersonasFromEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociatePersonasFromEntitiesResponse disassociatePersonasFromEntities(
            Consumer<DisassociatePersonasFromEntitiesRequest.Builder> disassociatePersonasFromEntitiesRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return disassociatePersonasFromEntities(DisassociatePersonasFromEntitiesRequest.builder()
                .applyMutation(disassociatePersonasFromEntitiesRequest).build());
    }

    /**
     * <p>
     * Fetches the queries that are suggested to your users.
     * </p>
     * <p>
     * <code>GetQuerySuggestions</code> is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     * </p>
     *
     * @param getQuerySuggestionsRequest
     * @return Result of the GetQuerySuggestions operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws ServiceQuotaExceededException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.GetQuerySuggestions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/GetQuerySuggestions" target="_top">AWS
     *      API Documentation</a>
     */
    default GetQuerySuggestionsResponse getQuerySuggestions(GetQuerySuggestionsRequest getQuerySuggestionsRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ServiceQuotaExceededException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetches the queries that are suggested to your users.
     * </p>
     * <p>
     * <code>GetQuerySuggestions</code> is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQuerySuggestionsRequest.Builder} avoiding the
     * need to create one manually via {@link GetQuerySuggestionsRequest#builder()}
     * </p>
     *
     * @param getQuerySuggestionsRequest
     *        A {@link Consumer} that will call methods on {@link GetQuerySuggestionsRequest.Builder} to create a
     *        request.
     * @return Result of the GetQuerySuggestions operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws ServiceQuotaExceededException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.GetQuerySuggestions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/GetQuerySuggestions" target="_top">AWS
     *      API Documentation</a>
     */
    default GetQuerySuggestionsResponse getQuerySuggestions(
            Consumer<GetQuerySuggestionsRequest.Builder> getQuerySuggestionsRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ServiceQuotaExceededException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return getQuerySuggestions(GetQuerySuggestionsRequest.builder().applyMutation(getQuerySuggestionsRequest).build());
    }

    /**
     * <p>
     * Retrieves search metrics data. The data provides a snapshot of how your users interact with your search
     * application and how effective the application is.
     * </p>
     *
     * @param getSnapshotsRequest
     * @return Result of the GetSnapshots operation returned by the service.
     * @throws InvalidRequestException
     *         The input to the request is not valid.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.GetSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/GetSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSnapshotsResponse getSnapshots(GetSnapshotsRequest getSnapshotsRequest) throws InvalidRequestException,
            ResourceNotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves search metrics data. The data provides a snapshot of how your users interact with your search
     * application and how effective the application is.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSnapshotsRequest.Builder} avoiding the need to
     * create one manually via {@link GetSnapshotsRequest#builder()}
     * </p>
     *
     * @param getSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link GetSnapshotsRequest.Builder} to create a request.
     * @return Result of the GetSnapshots operation returned by the service.
     * @throws InvalidRequestException
     *         The input to the request is not valid.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.GetSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/GetSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSnapshotsResponse getSnapshots(Consumer<GetSnapshotsRequest.Builder> getSnapshotsRequest)
            throws InvalidRequestException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, KendraException {
        return getSnapshots(GetSnapshotsRequest.builder().applyMutation(getSnapshotsRequest).build());
    }

    /**
     * <p>
     * Retrieves search metrics data. The data provides a snapshot of how your users interact with your search
     * application and how effective the application is.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getSnapshots(software.amazon.awssdk.services.kendra.model.GetSnapshotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.GetSnapshotsIterable responses = client.getSnapshotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kendra.paginators.GetSnapshotsIterable responses = client.getSnapshotsPaginator(request);
     *     for (software.amazon.awssdk.services.kendra.model.GetSnapshotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.GetSnapshotsIterable responses = client.getSnapshotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSnapshots(software.amazon.awssdk.services.kendra.model.GetSnapshotsRequest)} operation.</b>
     * </p>
     *
     * @param getSnapshotsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The input to the request is not valid.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.GetSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/GetSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSnapshotsIterable getSnapshotsPaginator(GetSnapshotsRequest getSnapshotsRequest) throws InvalidRequestException,
            ResourceNotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves search metrics data. The data provides a snapshot of how your users interact with your search
     * application and how effective the application is.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getSnapshots(software.amazon.awssdk.services.kendra.model.GetSnapshotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.GetSnapshotsIterable responses = client.getSnapshotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kendra.paginators.GetSnapshotsIterable responses = client.getSnapshotsPaginator(request);
     *     for (software.amazon.awssdk.services.kendra.model.GetSnapshotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.GetSnapshotsIterable responses = client.getSnapshotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSnapshots(software.amazon.awssdk.services.kendra.model.GetSnapshotsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSnapshotsRequest.Builder} avoiding the need to
     * create one manually via {@link GetSnapshotsRequest#builder()}
     * </p>
     *
     * @param getSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link GetSnapshotsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The input to the request is not valid.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.GetSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/GetSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSnapshotsIterable getSnapshotsPaginator(Consumer<GetSnapshotsRequest.Builder> getSnapshotsRequest)
            throws InvalidRequestException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, KendraException {
        return getSnapshotsPaginator(GetSnapshotsRequest.builder().applyMutation(getSnapshotsRequest).build());
    }

    /**
     * <p>
     * Gets statistics about synchronizing Amazon Kendra with a data source.
     * </p>
     *
     * @param listDataSourceSyncJobsRequest
     * @return Result of the ListDataSourceSyncJobs operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListDataSourceSyncJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListDataSourceSyncJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDataSourceSyncJobsResponse listDataSourceSyncJobs(ListDataSourceSyncJobsRequest listDataSourceSyncJobsRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets statistics about synchronizing Amazon Kendra with a data source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourceSyncJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataSourceSyncJobsRequest#builder()}
     * </p>
     *
     * @param listDataSourceSyncJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListDataSourceSyncJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListDataSourceSyncJobs operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListDataSourceSyncJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListDataSourceSyncJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDataSourceSyncJobsResponse listDataSourceSyncJobs(
            Consumer<ListDataSourceSyncJobsRequest.Builder> listDataSourceSyncJobsRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, KendraException {
        return listDataSourceSyncJobs(ListDataSourceSyncJobsRequest.builder().applyMutation(listDataSourceSyncJobsRequest)
                .build());
    }

    /**
     * <p>
     * Gets statistics about synchronizing Amazon Kendra with a data source.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataSourceSyncJobs(software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListDataSourceSyncJobsIterable responses = client.listDataSourceSyncJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kendra.paginators.ListDataSourceSyncJobsIterable responses = client
     *             .listDataSourceSyncJobsPaginator(request);
     *     for (software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListDataSourceSyncJobsIterable responses = client.listDataSourceSyncJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSourceSyncJobs(software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataSourceSyncJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListDataSourceSyncJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListDataSourceSyncJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDataSourceSyncJobsIterable listDataSourceSyncJobsPaginator(
            ListDataSourceSyncJobsRequest listDataSourceSyncJobsRequest) throws ValidationException, ResourceNotFoundException,
            ThrottlingException, AccessDeniedException, ConflictException, InternalServerException, AwsServiceException,
            SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets statistics about synchronizing Amazon Kendra with a data source.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataSourceSyncJobs(software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListDataSourceSyncJobsIterable responses = client.listDataSourceSyncJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kendra.paginators.ListDataSourceSyncJobsIterable responses = client
     *             .listDataSourceSyncJobsPaginator(request);
     *     for (software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListDataSourceSyncJobsIterable responses = client.listDataSourceSyncJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSourceSyncJobs(software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourceSyncJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataSourceSyncJobsRequest#builder()}
     * </p>
     *
     * @param listDataSourceSyncJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListDataSourceSyncJobsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListDataSourceSyncJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListDataSourceSyncJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDataSourceSyncJobsIterable listDataSourceSyncJobsPaginator(
            Consumer<ListDataSourceSyncJobsRequest.Builder> listDataSourceSyncJobsRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, KendraException {
        return listDataSourceSyncJobsPaginator(ListDataSourceSyncJobsRequest.builder()
                .applyMutation(listDataSourceSyncJobsRequest).build());
    }

    /**
     * <p>
     * Lists the data sources that you have created.
     * </p>
     *
     * @param listDataSourcesRequest
     * @return Result of the ListDataSources operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ThrottlingException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSourcesResponse listDataSources(ListDataSourcesRequest listDataSourcesRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the data sources that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDataSourcesRequest#builder()}
     * </p>
     *
     * @param listDataSourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListDataSourcesRequest.Builder} to create a request.
     * @return Result of the ListDataSources operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ThrottlingException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSourcesResponse listDataSources(Consumer<ListDataSourcesRequest.Builder> listDataSourcesRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return listDataSources(ListDataSourcesRequest.builder().applyMutation(listDataSourcesRequest).build());
    }

    /**
     * <p>
     * Lists the data sources that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataSources(software.amazon.awssdk.services.kendra.model.ListDataSourcesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListDataSourcesIterable responses = client.listDataSourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kendra.paginators.ListDataSourcesIterable responses = client
     *             .listDataSourcesPaginator(request);
     *     for (software.amazon.awssdk.services.kendra.model.ListDataSourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListDataSourcesIterable responses = client.listDataSourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSources(software.amazon.awssdk.services.kendra.model.ListDataSourcesRequest)} operation.</b>
     * </p>
     *
     * @param listDataSourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ThrottlingException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSourcesIterable listDataSourcesPaginator(ListDataSourcesRequest listDataSourcesRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the data sources that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataSources(software.amazon.awssdk.services.kendra.model.ListDataSourcesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListDataSourcesIterable responses = client.listDataSourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kendra.paginators.ListDataSourcesIterable responses = client
     *             .listDataSourcesPaginator(request);
     *     for (software.amazon.awssdk.services.kendra.model.ListDataSourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListDataSourcesIterable responses = client.listDataSourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSources(software.amazon.awssdk.services.kendra.model.ListDataSourcesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDataSourcesRequest#builder()}
     * </p>
     *
     * @param listDataSourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListDataSourcesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ThrottlingException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSourcesIterable listDataSourcesPaginator(Consumer<ListDataSourcesRequest.Builder> listDataSourcesRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return listDataSourcesPaginator(ListDataSourcesRequest.builder().applyMutation(listDataSourcesRequest).build());
    }

    /**
     * <p>
     * Lists specific permissions of users and groups with access to your Amazon Kendra experience.
     * </p>
     *
     * @param listEntityPersonasRequest
     * @return Result of the ListEntityPersonas operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ThrottlingException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListEntityPersonas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListEntityPersonas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEntityPersonasResponse listEntityPersonas(ListEntityPersonasRequest listEntityPersonasRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists specific permissions of users and groups with access to your Amazon Kendra experience.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntityPersonasRequest.Builder} avoiding the
     * need to create one manually via {@link ListEntityPersonasRequest#builder()}
     * </p>
     *
     * @param listEntityPersonasRequest
     *        A {@link Consumer} that will call methods on {@link ListEntityPersonasRequest.Builder} to create a
     *        request.
     * @return Result of the ListEntityPersonas operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ThrottlingException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListEntityPersonas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListEntityPersonas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEntityPersonasResponse listEntityPersonas(Consumer<ListEntityPersonasRequest.Builder> listEntityPersonasRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return listEntityPersonas(ListEntityPersonasRequest.builder().applyMutation(listEntityPersonasRequest).build());
    }

    /**
     * <p>
     * Lists specific permissions of users and groups with access to your Amazon Kendra experience.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntityPersonas(software.amazon.awssdk.services.kendra.model.ListEntityPersonasRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListEntityPersonasIterable responses = client.listEntityPersonasPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kendra.paginators.ListEntityPersonasIterable responses = client
     *             .listEntityPersonasPaginator(request);
     *     for (software.amazon.awssdk.services.kendra.model.ListEntityPersonasResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListEntityPersonasIterable responses = client.listEntityPersonasPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntityPersonas(software.amazon.awssdk.services.kendra.model.ListEntityPersonasRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEntityPersonasRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ThrottlingException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListEntityPersonas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListEntityPersonas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEntityPersonasIterable listEntityPersonasPaginator(ListEntityPersonasRequest listEntityPersonasRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists specific permissions of users and groups with access to your Amazon Kendra experience.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntityPersonas(software.amazon.awssdk.services.kendra.model.ListEntityPersonasRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListEntityPersonasIterable responses = client.listEntityPersonasPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kendra.paginators.ListEntityPersonasIterable responses = client
     *             .listEntityPersonasPaginator(request);
     *     for (software.amazon.awssdk.services.kendra.model.ListEntityPersonasResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListEntityPersonasIterable responses = client.listEntityPersonasPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntityPersonas(software.amazon.awssdk.services.kendra.model.ListEntityPersonasRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntityPersonasRequest.Builder} avoiding the
     * need to create one manually via {@link ListEntityPersonasRequest#builder()}
     * </p>
     *
     * @param listEntityPersonasRequest
     *        A {@link Consumer} that will call methods on {@link ListEntityPersonasRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ThrottlingException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListEntityPersonas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListEntityPersonas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEntityPersonasIterable listEntityPersonasPaginator(
            Consumer<ListEntityPersonasRequest.Builder> listEntityPersonasRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, KendraException {
        return listEntityPersonasPaginator(ListEntityPersonasRequest.builder().applyMutation(listEntityPersonasRequest).build());
    }

    /**
     * <p>
     * Lists users or groups in your Amazon Web Services SSO identity source that are granted access to your Amazon
     * Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information
     * on creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     *
     * @param listExperienceEntitiesRequest
     * @return Result of the ListExperienceEntities operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ThrottlingException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListExperienceEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListExperienceEntities" target="_top">AWS
     *      API Documentation</a>
     */
    default ListExperienceEntitiesResponse listExperienceEntities(ListExperienceEntitiesRequest listExperienceEntitiesRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists users or groups in your Amazon Web Services SSO identity source that are granted access to your Amazon
     * Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information
     * on creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExperienceEntitiesRequest.Builder} avoiding the
     * need to create one manually via {@link ListExperienceEntitiesRequest#builder()}
     * </p>
     *
     * @param listExperienceEntitiesRequest
     *        A {@link Consumer} that will call methods on {@link ListExperienceEntitiesRequest.Builder} to create a
     *        request.
     * @return Result of the ListExperienceEntities operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ThrottlingException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListExperienceEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListExperienceEntities" target="_top">AWS
     *      API Documentation</a>
     */
    default ListExperienceEntitiesResponse listExperienceEntities(
            Consumer<ListExperienceEntitiesRequest.Builder> listExperienceEntitiesRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, KendraException {
        return listExperienceEntities(ListExperienceEntitiesRequest.builder().applyMutation(listExperienceEntitiesRequest)
                .build());
    }

    /**
     * <p>
     * Lists users or groups in your Amazon Web Services SSO identity source that are granted access to your Amazon
     * Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information
     * on creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExperienceEntities(software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListExperienceEntitiesIterable responses = client.listExperienceEntitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kendra.paginators.ListExperienceEntitiesIterable responses = client
     *             .listExperienceEntitiesPaginator(request);
     *     for (software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListExperienceEntitiesIterable responses = client.listExperienceEntitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExperienceEntities(software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listExperienceEntitiesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ThrottlingException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListExperienceEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListExperienceEntities" target="_top">AWS
     *      API Documentation</a>
     */
    default ListExperienceEntitiesIterable listExperienceEntitiesPaginator(
            ListExperienceEntitiesRequest listExperienceEntitiesRequest) throws ValidationException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists users or groups in your Amazon Web Services SSO identity source that are granted access to your Amazon
     * Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information
     * on creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExperienceEntities(software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListExperienceEntitiesIterable responses = client.listExperienceEntitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kendra.paginators.ListExperienceEntitiesIterable responses = client
     *             .listExperienceEntitiesPaginator(request);
     *     for (software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListExperienceEntitiesIterable responses = client.listExperienceEntitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExperienceEntities(software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExperienceEntitiesRequest.Builder} avoiding the
     * need to create one manually via {@link ListExperienceEntitiesRequest#builder()}
     * </p>
     *
     * @param listExperienceEntitiesRequest
     *        A {@link Consumer} that will call methods on {@link ListExperienceEntitiesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ThrottlingException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListExperienceEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListExperienceEntities" target="_top">AWS
     *      API Documentation</a>
     */
    default ListExperienceEntitiesIterable listExperienceEntitiesPaginator(
            Consumer<ListExperienceEntitiesRequest.Builder> listExperienceEntitiesRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, KendraException {
        return listExperienceEntitiesPaginator(ListExperienceEntitiesRequest.builder()
                .applyMutation(listExperienceEntitiesRequest).build());
    }

    /**
     * <p>
     * Lists one or more Amazon Kendra experiences. You can create an Amazon Kendra experience such as a search
     * application. For more information on creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     *
     * @param listExperiencesRequest
     * @return Result of the ListExperiences operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ThrottlingException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListExperiences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListExperiences" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExperiencesResponse listExperiences(ListExperiencesRequest listExperiencesRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists one or more Amazon Kendra experiences. You can create an Amazon Kendra experience such as a search
     * application. For more information on creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExperiencesRequest.Builder} avoiding the need
     * to create one manually via {@link ListExperiencesRequest#builder()}
     * </p>
     *
     * @param listExperiencesRequest
     *        A {@link Consumer} that will call methods on {@link ListExperiencesRequest.Builder} to create a request.
     * @return Result of the ListExperiences operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ThrottlingException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListExperiences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListExperiences" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExperiencesResponse listExperiences(Consumer<ListExperiencesRequest.Builder> listExperiencesRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return listExperiences(ListExperiencesRequest.builder().applyMutation(listExperiencesRequest).build());
    }

    /**
     * <p>
     * Lists one or more Amazon Kendra experiences. You can create an Amazon Kendra experience such as a search
     * application. For more information on creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExperiences(software.amazon.awssdk.services.kendra.model.ListExperiencesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListExperiencesIterable responses = client.listExperiencesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kendra.paginators.ListExperiencesIterable responses = client
     *             .listExperiencesPaginator(request);
     *     for (software.amazon.awssdk.services.kendra.model.ListExperiencesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListExperiencesIterable responses = client.listExperiencesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExperiences(software.amazon.awssdk.services.kendra.model.ListExperiencesRequest)} operation.</b>
     * </p>
     *
     * @param listExperiencesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ThrottlingException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListExperiences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListExperiences" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExperiencesIterable listExperiencesPaginator(ListExperiencesRequest listExperiencesRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists one or more Amazon Kendra experiences. You can create an Amazon Kendra experience such as a search
     * application. For more information on creating a search application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExperiences(software.amazon.awssdk.services.kendra.model.ListExperiencesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListExperiencesIterable responses = client.listExperiencesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kendra.paginators.ListExperiencesIterable responses = client
     *             .listExperiencesPaginator(request);
     *     for (software.amazon.awssdk.services.kendra.model.ListExperiencesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListExperiencesIterable responses = client.listExperiencesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExperiences(software.amazon.awssdk.services.kendra.model.ListExperiencesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExperiencesRequest.Builder} avoiding the need
     * to create one manually via {@link ListExperiencesRequest#builder()}
     * </p>
     *
     * @param listExperiencesRequest
     *        A {@link Consumer} that will call methods on {@link ListExperiencesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ThrottlingException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListExperiences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListExperiences" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExperiencesIterable listExperiencesPaginator(Consumer<ListExperiencesRequest.Builder> listExperiencesRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return listExperiencesPaginator(ListExperiencesRequest.builder().applyMutation(listExperiencesRequest).build());
    }

    /**
     * <p>
     * Gets a list of FAQ lists associated with an index.
     * </p>
     *
     * @param listFaqsRequest
     * @return Result of the ListFaqs operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListFaqs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListFaqs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFaqsResponse listFaqs(ListFaqsRequest listFaqsRequest) throws ValidationException, ResourceNotFoundException,
            ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of FAQ lists associated with an index.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFaqsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFaqsRequest#builder()}
     * </p>
     *
     * @param listFaqsRequest
     *        A {@link Consumer} that will call methods on {@link ListFaqsRequest.Builder} to create a request.
     * @return Result of the ListFaqs operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListFaqs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListFaqs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFaqsResponse listFaqs(Consumer<ListFaqsRequest.Builder> listFaqsRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, KendraException {
        return listFaqs(ListFaqsRequest.builder().applyMutation(listFaqsRequest).build());
    }

    /**
     * <p>
     * Provides a list of groups that are mapped to users before a given ordering or timestamp identifier.
     * </p>
     * <p>
     * <code>ListGroupsOlderThanOrderingId</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     *
     * @param listGroupsOlderThanOrderingIdRequest
     * @return Result of the ListGroupsOlderThanOrderingId operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListGroupsOlderThanOrderingId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListGroupsOlderThanOrderingId"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGroupsOlderThanOrderingIdResponse listGroupsOlderThanOrderingId(
            ListGroupsOlderThanOrderingIdRequest listGroupsOlderThanOrderingIdRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of groups that are mapped to users before a given ordering or timestamp identifier.
     * </p>
     * <p>
     * <code>ListGroupsOlderThanOrderingId</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsOlderThanOrderingIdRequest.Builder}
     * avoiding the need to create one manually via {@link ListGroupsOlderThanOrderingIdRequest#builder()}
     * </p>
     *
     * @param listGroupsOlderThanOrderingIdRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupsOlderThanOrderingIdRequest.Builder} to
     *        create a request.
     * @return Result of the ListGroupsOlderThanOrderingId operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListGroupsOlderThanOrderingId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListGroupsOlderThanOrderingId"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGroupsOlderThanOrderingIdResponse listGroupsOlderThanOrderingId(
            Consumer<ListGroupsOlderThanOrderingIdRequest.Builder> listGroupsOlderThanOrderingIdRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return listGroupsOlderThanOrderingId(ListGroupsOlderThanOrderingIdRequest.builder()
                .applyMutation(listGroupsOlderThanOrderingIdRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon Kendra indexes that you have created.
     * </p>
     *
     * @param listIndicesRequest
     * @return Result of the ListIndices operation returned by the service.
     * @throws ValidationException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListIndices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListIndices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIndicesResponse listIndices(ListIndicesRequest listIndicesRequest) throws ValidationException,
            ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Kendra indexes that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIndicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListIndicesRequest#builder()}
     * </p>
     *
     * @param listIndicesRequest
     *        A {@link Consumer} that will call methods on {@link ListIndicesRequest.Builder} to create a request.
     * @return Result of the ListIndices operation returned by the service.
     * @throws ValidationException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListIndices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListIndices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIndicesResponse listIndices(Consumer<ListIndicesRequest.Builder> listIndicesRequest) throws ValidationException,
            ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            KendraException {
        return listIndices(ListIndicesRequest.builder().applyMutation(listIndicesRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon Kendra indexes that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listIndices(software.amazon.awssdk.services.kendra.model.ListIndicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListIndicesIterable responses = client.listIndicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kendra.paginators.ListIndicesIterable responses = client.listIndicesPaginator(request);
     *     for (software.amazon.awssdk.services.kendra.model.ListIndicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListIndicesIterable responses = client.listIndicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIndices(software.amazon.awssdk.services.kendra.model.ListIndicesRequest)} operation.</b>
     * </p>
     *
     * @param listIndicesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListIndices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListIndices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIndicesIterable listIndicesPaginator(ListIndicesRequest listIndicesRequest) throws ValidationException,
            ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Kendra indexes that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listIndices(software.amazon.awssdk.services.kendra.model.ListIndicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListIndicesIterable responses = client.listIndicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kendra.paginators.ListIndicesIterable responses = client.listIndicesPaginator(request);
     *     for (software.amazon.awssdk.services.kendra.model.ListIndicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendra.paginators.ListIndicesIterable responses = client.listIndicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIndices(software.amazon.awssdk.services.kendra.model.ListIndicesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIndicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListIndicesRequest#builder()}
     * </p>
     *
     * @param listIndicesRequest
     *        A {@link Consumer} that will call methods on {@link ListIndicesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListIndices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListIndices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIndicesIterable listIndicesPaginator(Consumer<ListIndicesRequest.Builder> listIndicesRequest)
            throws ValidationException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, KendraException {
        return listIndicesPaginator(ListIndicesRequest.builder().applyMutation(listIndicesRequest).build());
    }

    /**
     * <p>
     * Lists the block lists used for query suggestions for an index.
     * </p>
     * <p>
     * For information on the current quota limits for block lists, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.
     * </p>
     * <p>
     * <code>ListQuerySuggestionsBlockLists</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     *
     * @param listQuerySuggestionsBlockListsRequest
     * @return Result of the ListQuerySuggestionsBlockLists operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListQuerySuggestionsBlockLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListQuerySuggestionsBlockLists"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQuerySuggestionsBlockListsResponse listQuerySuggestionsBlockLists(
            ListQuerySuggestionsBlockListsRequest listQuerySuggestionsBlockListsRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the block lists used for query suggestions for an index.
     * </p>
     * <p>
     * For information on the current quota limits for block lists, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.
     * </p>
     * <p>
     * <code>ListQuerySuggestionsBlockLists</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQuerySuggestionsBlockListsRequest.Builder}
     * avoiding the need to create one manually via {@link ListQuerySuggestionsBlockListsRequest#builder()}
     * </p>
     *
     * @param listQuerySuggestionsBlockListsRequest
     *        A {@link Consumer} that will call methods on {@link ListQuerySuggestionsBlockListsRequest.Builder} to
     *        create a request.
     * @return Result of the ListQuerySuggestionsBlockLists operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListQuerySuggestionsBlockLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListQuerySuggestionsBlockLists"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQuerySuggestionsBlockListsResponse listQuerySuggestionsBlockLists(
            Consumer<ListQuerySuggestionsBlockListsRequest.Builder> listQuerySuggestionsBlockListsRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return listQuerySuggestionsBlockLists(ListQuerySuggestionsBlockListsRequest.builder()
                .applyMutation(listQuerySuggestionsBlockListsRequest).build());
    }

    /**
     * <p>
     * Gets a list of tags associated with a specified resource. Indexes, FAQs, and data sources can have tags
     * associated with them.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     * @throws ResourceUnavailableException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, ResourceUnavailableException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of tags associated with a specified resource. Indexes, FAQs, and data sources can have tags
     * associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     * @throws ResourceUnavailableException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            ResourceUnavailableException, ThrottlingException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, KendraException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon Kendra thesauri associated with an index.
     * </p>
     *
     * @param listThesauriRequest
     * @return Result of the ListThesauri operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListThesauri
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListThesauri" target="_top">AWS API
     *      Documentation</a>
     */
    default ListThesauriResponse listThesauri(ListThesauriRequest listThesauriRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Kendra thesauri associated with an index.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListThesauriRequest.Builder} avoiding the need to
     * create one manually via {@link ListThesauriRequest#builder()}
     * </p>
     *
     * @param listThesauriRequest
     *        A {@link Consumer} that will call methods on {@link ListThesauriRequest.Builder} to create a request.
     * @return Result of the ListThesauri operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.ListThesauri
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListThesauri" target="_top">AWS API
     *      Documentation</a>
     */
    default ListThesauriResponse listThesauri(Consumer<ListThesauriRequest.Builder> listThesauriRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return listThesauri(ListThesauriRequest.builder().applyMutation(listThesauriRequest).build());
    }

    /**
     * <p>
     * Maps users to their groups so that you only need to provide the user ID when you issue the query.
     * </p>
     * <p>
     * You can also map sub groups to groups. For example, the group "Company Intellectual Property Teams" includes sub
     * groups "Research" and "Engineering". These sub groups include their own list of users or people who work in these
     * teams. Only users who work in research and engineering, and therefore belong in the intellectual property group,
     * can see top-secret company documents in their search results.
     * </p>
     * <p>
     * You map users to their groups when you want to filter search results for different users based on their group’s
     * access to documents. For more information on filtering search results for different users, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html">Filtering on user context</a>.
     * </p>
     * <p>
     * If more than five <code>PUT</code> actions for a group are currently processing, a validation exception is
     * thrown.
     * </p>
     * <p>
     * <code>PutPrincipalMapping</code> is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     * </p>
     *
     * @param putPrincipalMappingRequest
     * @return Result of the PutPrincipalMapping operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws ServiceQuotaExceededException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.PutPrincipalMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/PutPrincipalMapping" target="_top">AWS
     *      API Documentation</a>
     */
    default PutPrincipalMappingResponse putPrincipalMapping(PutPrincipalMappingRequest putPrincipalMappingRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Maps users to their groups so that you only need to provide the user ID when you issue the query.
     * </p>
     * <p>
     * You can also map sub groups to groups. For example, the group "Company Intellectual Property Teams" includes sub
     * groups "Research" and "Engineering". These sub groups include their own list of users or people who work in these
     * teams. Only users who work in research and engineering, and therefore belong in the intellectual property group,
     * can see top-secret company documents in their search results.
     * </p>
     * <p>
     * You map users to their groups when you want to filter search results for different users based on their group’s
     * access to documents. For more information on filtering search results for different users, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html">Filtering on user context</a>.
     * </p>
     * <p>
     * If more than five <code>PUT</code> actions for a group are currently processing, a validation exception is
     * thrown.
     * </p>
     * <p>
     * <code>PutPrincipalMapping</code> is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutPrincipalMappingRequest.Builder} avoiding the
     * need to create one manually via {@link PutPrincipalMappingRequest#builder()}
     * </p>
     *
     * @param putPrincipalMappingRequest
     *        A {@link Consumer} that will call methods on {@link PutPrincipalMappingRequest.Builder} to create a
     *        request.
     * @return Result of the PutPrincipalMapping operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws ServiceQuotaExceededException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.PutPrincipalMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/PutPrincipalMapping" target="_top">AWS
     *      API Documentation</a>
     */
    default PutPrincipalMappingResponse putPrincipalMapping(
            Consumer<PutPrincipalMappingRequest.Builder> putPrincipalMappingRequest) throws ValidationException,
            ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return putPrincipalMapping(PutPrincipalMappingRequest.builder().applyMutation(putPrincipalMappingRequest).build());
    }

    /**
     * <p>
     * Searches an active index. Use this API to search your documents using query. The <code>Query</code> operation
     * enables to do faceted search and to filter results based on document attributes.
     * </p>
     * <p>
     * It also enables you to provide user context that Amazon Kendra uses to enforce document access control in the
     * search results.
     * </p>
     * <p>
     * Amazon Kendra searches your index for text content and question and answer (FAQ) content. By default the response
     * contains three types of results.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Relevant passages
     * </p>
     * </li>
     * <li>
     * <p>
     * Matching FAQs
     * </p>
     * </li>
     * <li>
     * <p>
     * Relevant documents
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can specify that the query return only one type of result using the <code>QueryResultTypeConfig</code>
     * parameter.
     * </p>
     * <p>
     * Each query returns the 100 most relevant results.
     * </p>
     *
     * @param queryRequest
     * @return Result of the Query operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws ServiceQuotaExceededException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.Query
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/Query" target="_top">AWS API
     *      Documentation</a>
     */
    default QueryResponse query(QueryRequest queryRequest) throws ValidationException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ServiceQuotaExceededException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches an active index. Use this API to search your documents using query. The <code>Query</code> operation
     * enables to do faceted search and to filter results based on document attributes.
     * </p>
     * <p>
     * It also enables you to provide user context that Amazon Kendra uses to enforce document access control in the
     * search results.
     * </p>
     * <p>
     * Amazon Kendra searches your index for text content and question and answer (FAQ) content. By default the response
     * contains three types of results.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Relevant passages
     * </p>
     * </li>
     * <li>
     * <p>
     * Matching FAQs
     * </p>
     * </li>
     * <li>
     * <p>
     * Relevant documents
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can specify that the query return only one type of result using the <code>QueryResultTypeConfig</code>
     * parameter.
     * </p>
     * <p>
     * Each query returns the 100 most relevant results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link QueryRequest.Builder} avoiding the need to create
     * one manually via {@link QueryRequest#builder()}
     * </p>
     *
     * @param queryRequest
     *        A {@link Consumer} that will call methods on {@link QueryRequest.Builder} to create a request.
     * @return Result of the Query operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws ServiceQuotaExceededException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.Query
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/Query" target="_top">AWS API
     *      Documentation</a>
     */
    default QueryResponse query(Consumer<QueryRequest.Builder> queryRequest) throws ValidationException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ServiceQuotaExceededException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return query(QueryRequest.builder().applyMutation(queryRequest).build());
    }

    /**
     * <p>
     * Starts a synchronization job for a data source. If a synchronization job is already in progress, Amazon Kendra
     * returns a <code>ResourceInUseException</code> exception.
     * </p>
     *
     * @param startDataSourceSyncJobRequest
     * @return Result of the StartDataSourceSyncJob operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ResourceInUseException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.StartDataSourceSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/StartDataSourceSyncJob" target="_top">AWS
     *      API Documentation</a>
     */
    default StartDataSourceSyncJobResponse startDataSourceSyncJob(StartDataSourceSyncJobRequest startDataSourceSyncJobRequest)
            throws ValidationException, ResourceNotFoundException, ResourceInUseException, ThrottlingException,
            AccessDeniedException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a synchronization job for a data source. If a synchronization job is already in progress, Amazon Kendra
     * returns a <code>ResourceInUseException</code> exception.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDataSourceSyncJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartDataSourceSyncJobRequest#builder()}
     * </p>
     *
     * @param startDataSourceSyncJobRequest
     *        A {@link Consumer} that will call methods on {@link StartDataSourceSyncJobRequest.Builder} to create a
     *        request.
     * @return Result of the StartDataSourceSyncJob operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ResourceInUseException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.StartDataSourceSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/StartDataSourceSyncJob" target="_top">AWS
     *      API Documentation</a>
     */
    default StartDataSourceSyncJobResponse startDataSourceSyncJob(
            Consumer<StartDataSourceSyncJobRequest.Builder> startDataSourceSyncJobRequest) throws ValidationException,
            ResourceNotFoundException, ResourceInUseException, ThrottlingException, AccessDeniedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return startDataSourceSyncJob(StartDataSourceSyncJobRequest.builder().applyMutation(startDataSourceSyncJobRequest)
                .build());
    }

    /**
     * <p>
     * Stops a running synchronization job. You can't stop a scheduled synchronization job.
     * </p>
     *
     * @param stopDataSourceSyncJobRequest
     * @return Result of the StopDataSourceSyncJob operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.StopDataSourceSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/StopDataSourceSyncJob" target="_top">AWS
     *      API Documentation</a>
     */
    default StopDataSourceSyncJobResponse stopDataSourceSyncJob(StopDataSourceSyncJobRequest stopDataSourceSyncJobRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a running synchronization job. You can't stop a scheduled synchronization job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopDataSourceSyncJobRequest.Builder} avoiding the
     * need to create one manually via {@link StopDataSourceSyncJobRequest#builder()}
     * </p>
     *
     * @param stopDataSourceSyncJobRequest
     *        A {@link Consumer} that will call methods on {@link StopDataSourceSyncJobRequest.Builder} to create a
     *        request.
     * @return Result of the StopDataSourceSyncJob operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.StopDataSourceSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/StopDataSourceSyncJob" target="_top">AWS
     *      API Documentation</a>
     */
    default StopDataSourceSyncJobResponse stopDataSourceSyncJob(
            Consumer<StopDataSourceSyncJobRequest.Builder> stopDataSourceSyncJobRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, KendraException {
        return stopDataSourceSyncJob(StopDataSourceSyncJobRequest.builder().applyMutation(stopDataSourceSyncJobRequest).build());
    }

    /**
     * <p>
     * Enables you to provide feedback to Amazon Kendra to improve the performance of your index.
     * </p>
     * <p>
     * <code>SubmitFeedback</code> is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     * </p>
     *
     * @param submitFeedbackRequest
     * @return Result of the SubmitFeedback operation returned by the service.
     * @throws ValidationException
     * @throws ResourceUnavailableException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.SubmitFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/SubmitFeedback" target="_top">AWS API
     *      Documentation</a>
     */
    default SubmitFeedbackResponse submitFeedback(SubmitFeedbackRequest submitFeedbackRequest) throws ValidationException,
            ResourceUnavailableException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to provide feedback to Amazon Kendra to improve the performance of your index.
     * </p>
     * <p>
     * <code>SubmitFeedback</code> is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SubmitFeedbackRequest.Builder} avoiding the need to
     * create one manually via {@link SubmitFeedbackRequest#builder()}
     * </p>
     *
     * @param submitFeedbackRequest
     *        A {@link Consumer} that will call methods on {@link SubmitFeedbackRequest.Builder} to create a request.
     * @return Result of the SubmitFeedback operation returned by the service.
     * @throws ValidationException
     * @throws ResourceUnavailableException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.SubmitFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/SubmitFeedback" target="_top">AWS API
     *      Documentation</a>
     */
    default SubmitFeedbackResponse submitFeedback(Consumer<SubmitFeedbackRequest.Builder> submitFeedbackRequest)
            throws ValidationException, ResourceUnavailableException, ResourceNotFoundException, ThrottlingException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return submitFeedback(SubmitFeedbackRequest.builder().applyMutation(submitFeedbackRequest).build());
    }

    /**
     * <p>
     * Adds the specified tag to the specified index, FAQ, or data source resource. If the tag already exists, the
     * existing value is replaced with the new value.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     * @throws ResourceUnavailableException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            ResourceUnavailableException, ThrottlingException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified tag to the specified index, FAQ, or data source resource. If the tag already exists, the
     * existing value is replaced with the new value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     * @throws ResourceUnavailableException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException,
            ResourceUnavailableException, ThrottlingException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, KendraException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag from an index, FAQ, or a data source.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     * @throws ResourceUnavailableException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            ResourceUnavailableException, ThrottlingException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from an index, FAQ, or a data source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     * @throws ResourceUnavailableException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, ResourceUnavailableException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing Amazon Kendra data source.
     * </p>
     *
     * @param updateDataSourceRequest
     * @return Result of the UpdateDataSource operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.UpdateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateDataSourceResponse updateDataSource(UpdateDataSourceRequest updateDataSourceRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Amazon Kendra data source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDataSourceRequest#builder()}
     * </p>
     *
     * @param updateDataSourceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDataSourceRequest.Builder} to create a request.
     * @return Result of the UpdateDataSource operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.UpdateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateDataSourceResponse updateDataSource(Consumer<UpdateDataSourceRequest.Builder> updateDataSourceRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return updateDataSource(UpdateDataSourceRequest.builder().applyMutation(updateDataSourceRequest).build());
    }

    /**
     * <p>
     * Updates your Amazon Kendra experience such as a search application. For more information on creating a search
     * application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     *
     * @param updateExperienceRequest
     * @return Result of the UpdateExperience operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.UpdateExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateExperience" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateExperienceResponse updateExperience(UpdateExperienceRequest updateExperienceRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates your Amazon Kendra experience such as a search application. For more information on creating a search
     * application experience, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateExperienceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateExperienceRequest#builder()}
     * </p>
     *
     * @param updateExperienceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateExperienceRequest.Builder} to create a request.
     * @return Result of the UpdateExperience operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.UpdateExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateExperience" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateExperienceResponse updateExperience(Consumer<UpdateExperienceRequest.Builder> updateExperienceRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return updateExperience(UpdateExperienceRequest.builder().applyMutation(updateExperienceRequest).build());
    }

    /**
     * <p>
     * Updates an existing Amazon Kendra index.
     * </p>
     *
     * @param updateIndexRequest
     * @return Result of the UpdateIndex operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws ServiceQuotaExceededException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.UpdateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateIndexResponse updateIndex(UpdateIndexRequest updateIndexRequest) throws ValidationException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ServiceQuotaExceededException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Amazon Kendra index.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIndexRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateIndexRequest#builder()}
     * </p>
     *
     * @param updateIndexRequest
     *        A {@link Consumer} that will call methods on {@link UpdateIndexRequest.Builder} to create a request.
     * @return Result of the UpdateIndex operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws ServiceQuotaExceededException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.UpdateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateIndexResponse updateIndex(Consumer<UpdateIndexRequest.Builder> updateIndexRequest) throws ValidationException,
            ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return updateIndex(UpdateIndexRequest.builder().applyMutation(updateIndexRequest).build());
    }

    /**
     * <p>
     * Updates a block list used for query suggestions for an index.
     * </p>
     * <p>
     * Updates to a block list might not take effect right away. Amazon Kendra needs to refresh the entire suggestions
     * list to apply any updates to the block list. Other changes not related to the block list apply immediately.
     * </p>
     * <p>
     * If a block list is updating, then you need to wait for the first update to finish before submitting another
     * update.
     * </p>
     * <p>
     * Amazon Kendra supports partial updates, so you only need to provide the fields you want to update.
     * </p>
     * <p>
     * <code>UpdateQuerySuggestionsBlockList</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     *
     * @param updateQuerySuggestionsBlockListRequest
     * @return Result of the UpdateQuerySuggestionsBlockList operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.UpdateQuerySuggestionsBlockList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateQuerySuggestionsBlockList"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateQuerySuggestionsBlockListResponse updateQuerySuggestionsBlockList(
            UpdateQuerySuggestionsBlockListRequest updateQuerySuggestionsBlockListRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a block list used for query suggestions for an index.
     * </p>
     * <p>
     * Updates to a block list might not take effect right away. Amazon Kendra needs to refresh the entire suggestions
     * list to apply any updates to the block list. Other changes not related to the block list apply immediately.
     * </p>
     * <p>
     * If a block list is updating, then you need to wait for the first update to finish before submitting another
     * update.
     * </p>
     * <p>
     * Amazon Kendra supports partial updates, so you only need to provide the fields you want to update.
     * </p>
     * <p>
     * <code>UpdateQuerySuggestionsBlockList</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQuerySuggestionsBlockListRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateQuerySuggestionsBlockListRequest#builder()}
     * </p>
     *
     * @param updateQuerySuggestionsBlockListRequest
     *        A {@link Consumer} that will call methods on {@link UpdateQuerySuggestionsBlockListRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateQuerySuggestionsBlockList operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.UpdateQuerySuggestionsBlockList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateQuerySuggestionsBlockList"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateQuerySuggestionsBlockListResponse updateQuerySuggestionsBlockList(
            Consumer<UpdateQuerySuggestionsBlockListRequest.Builder> updateQuerySuggestionsBlockListRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return updateQuerySuggestionsBlockList(UpdateQuerySuggestionsBlockListRequest.builder()
                .applyMutation(updateQuerySuggestionsBlockListRequest).build());
    }

    /**
     * <p>
     * Updates the settings of query suggestions for an index.
     * </p>
     * <p>
     * Amazon Kendra supports partial updates, so you only need to provide the fields you want to update.
     * </p>
     * <p>
     * If an update is currently processing (i.e. 'happening'), you need to wait for the update to finish before making
     * another update.
     * </p>
     * <p>
     * Updates to query suggestions settings might not take effect right away. The time for your updated settings to
     * take effect depends on the updates made and the number of search queries in your index.
     * </p>
     * <p>
     * You can still enable/disable query suggestions at any time.
     * </p>
     * <p>
     * <code>UpdateQuerySuggestionsConfig</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     *
     * @param updateQuerySuggestionsConfigRequest
     * @return Result of the UpdateQuerySuggestionsConfig operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.UpdateQuerySuggestionsConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateQuerySuggestionsConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateQuerySuggestionsConfigResponse updateQuerySuggestionsConfig(
            UpdateQuerySuggestionsConfigRequest updateQuerySuggestionsConfigRequest) throws ValidationException,
            ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the settings of query suggestions for an index.
     * </p>
     * <p>
     * Amazon Kendra supports partial updates, so you only need to provide the fields you want to update.
     * </p>
     * <p>
     * If an update is currently processing (i.e. 'happening'), you need to wait for the update to finish before making
     * another update.
     * </p>
     * <p>
     * Updates to query suggestions settings might not take effect right away. The time for your updated settings to
     * take effect depends on the updates made and the number of search queries in your index.
     * </p>
     * <p>
     * You can still enable/disable query suggestions at any time.
     * </p>
     * <p>
     * <code>UpdateQuerySuggestionsConfig</code> is currently not supported in the Amazon Web Services GovCloud
     * (US-West) region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQuerySuggestionsConfigRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateQuerySuggestionsConfigRequest#builder()}
     * </p>
     *
     * @param updateQuerySuggestionsConfigRequest
     *        A {@link Consumer} that will call methods on {@link UpdateQuerySuggestionsConfigRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateQuerySuggestionsConfig operation returned by the service.
     * @throws ValidationException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.UpdateQuerySuggestionsConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateQuerySuggestionsConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateQuerySuggestionsConfigResponse updateQuerySuggestionsConfig(
            Consumer<UpdateQuerySuggestionsConfigRequest.Builder> updateQuerySuggestionsConfigRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return updateQuerySuggestionsConfig(UpdateQuerySuggestionsConfigRequest.builder()
                .applyMutation(updateQuerySuggestionsConfigRequest).build());
    }

    /**
     * <p>
     * Updates a thesaurus file associated with an index.
     * </p>
     *
     * @param updateThesaurusRequest
     * @return Result of the UpdateThesaurus operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.UpdateThesaurus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateThesaurus" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateThesaurusResponse updateThesaurus(UpdateThesaurusRequest updateThesaurusRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, KendraException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a thesaurus file associated with an index.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateThesaurusRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateThesaurusRequest#builder()}
     * </p>
     *
     * @param updateThesaurusRequest
     *        A {@link Consumer} that will call methods on {@link UpdateThesaurusRequest.Builder} to create a request.
     * @return Result of the UpdateThesaurus operation returned by the service.
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws AccessDeniedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KendraException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KendraClient.UpdateThesaurus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateThesaurus" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateThesaurusResponse updateThesaurus(Consumer<UpdateThesaurusRequest.Builder> updateThesaurusRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return updateThesaurus(UpdateThesaurusRequest.builder().applyMutation(updateThesaurusRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
