/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ExperienceEntitiesSummaryListCopier {
    static List<ExperienceEntitiesSummary> copy(Collection<? extends ExperienceEntitiesSummary> experienceEntitiesSummaryListParam) {
        List<ExperienceEntitiesSummary> list;
        if (experienceEntitiesSummaryListParam == null || experienceEntitiesSummaryListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ExperienceEntitiesSummary> modifiableList = new ArrayList<>();
            experienceEntitiesSummaryListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ExperienceEntitiesSummary> copyFromBuilder(
            Collection<? extends ExperienceEntitiesSummary.Builder> experienceEntitiesSummaryListParam) {
        List<ExperienceEntitiesSummary> list;
        if (experienceEntitiesSummaryListParam == null || experienceEntitiesSummaryListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ExperienceEntitiesSummary> modifiableList = new ArrayList<>();
            experienceEntitiesSummaryListParam.forEach(entry -> {
                ExperienceEntitiesSummary member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ExperienceEntitiesSummary.Builder> copyToBuilder(
            Collection<? extends ExperienceEntitiesSummary> experienceEntitiesSummaryListParam) {
        List<ExperienceEntitiesSummary.Builder> list;
        if (experienceEntitiesSummaryListParam == null || experienceEntitiesSummaryListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ExperienceEntitiesSummary.Builder> modifiableList = new ArrayList<>();
            experienceEntitiesSummaryListParam.forEach(entry -> {
                ExperienceEntitiesSummary.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
