/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information for an Amazon Kendra data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSourceConfiguration.Builder, DataSourceConfiguration> {
    private static final SdkField<S3DataSourceConfiguration> S3_CONFIGURATION_FIELD = SdkField
            .<S3DataSourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("S3Configuration")
            .getter(getter(DataSourceConfiguration::s3Configuration)).setter(setter(Builder::s3Configuration))
            .constructor(S3DataSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Configuration").build()).build();

    private static final SdkField<SharePointConfiguration> SHARE_POINT_CONFIGURATION_FIELD = SdkField
            .<SharePointConfiguration> builder(MarshallingType.SDK_POJO).memberName("SharePointConfiguration")
            .getter(getter(DataSourceConfiguration::sharePointConfiguration)).setter(setter(Builder::sharePointConfiguration))
            .constructor(SharePointConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharePointConfiguration").build())
            .build();

    private static final SdkField<DatabaseConfiguration> DATABASE_CONFIGURATION_FIELD = SdkField
            .<DatabaseConfiguration> builder(MarshallingType.SDK_POJO).memberName("DatabaseConfiguration")
            .getter(getter(DataSourceConfiguration::databaseConfiguration)).setter(setter(Builder::databaseConfiguration))
            .constructor(DatabaseConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseConfiguration").build())
            .build();

    private static final SdkField<SalesforceConfiguration> SALESFORCE_CONFIGURATION_FIELD = SdkField
            .<SalesforceConfiguration> builder(MarshallingType.SDK_POJO).memberName("SalesforceConfiguration")
            .getter(getter(DataSourceConfiguration::salesforceConfiguration)).setter(setter(Builder::salesforceConfiguration))
            .constructor(SalesforceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SalesforceConfiguration").build())
            .build();

    private static final SdkField<OneDriveConfiguration> ONE_DRIVE_CONFIGURATION_FIELD = SdkField
            .<OneDriveConfiguration> builder(MarshallingType.SDK_POJO).memberName("OneDriveConfiguration")
            .getter(getter(DataSourceConfiguration::oneDriveConfiguration)).setter(setter(Builder::oneDriveConfiguration))
            .constructor(OneDriveConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OneDriveConfiguration").build())
            .build();

    private static final SdkField<ServiceNowConfiguration> SERVICE_NOW_CONFIGURATION_FIELD = SdkField
            .<ServiceNowConfiguration> builder(MarshallingType.SDK_POJO).memberName("ServiceNowConfiguration")
            .getter(getter(DataSourceConfiguration::serviceNowConfiguration)).setter(setter(Builder::serviceNowConfiguration))
            .constructor(ServiceNowConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNowConfiguration").build())
            .build();

    private static final SdkField<ConfluenceConfiguration> CONFLUENCE_CONFIGURATION_FIELD = SdkField
            .<ConfluenceConfiguration> builder(MarshallingType.SDK_POJO).memberName("ConfluenceConfiguration")
            .getter(getter(DataSourceConfiguration::confluenceConfiguration)).setter(setter(Builder::confluenceConfiguration))
            .constructor(ConfluenceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfluenceConfiguration").build())
            .build();

    private static final SdkField<GoogleDriveConfiguration> GOOGLE_DRIVE_CONFIGURATION_FIELD = SdkField
            .<GoogleDriveConfiguration> builder(MarshallingType.SDK_POJO).memberName("GoogleDriveConfiguration")
            .getter(getter(DataSourceConfiguration::googleDriveConfiguration)).setter(setter(Builder::googleDriveConfiguration))
            .constructor(GoogleDriveConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GoogleDriveConfiguration").build())
            .build();

    private static final SdkField<WebCrawlerConfiguration> WEB_CRAWLER_CONFIGURATION_FIELD = SdkField
            .<WebCrawlerConfiguration> builder(MarshallingType.SDK_POJO).memberName("WebCrawlerConfiguration")
            .getter(getter(DataSourceConfiguration::webCrawlerConfiguration)).setter(setter(Builder::webCrawlerConfiguration))
            .constructor(WebCrawlerConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebCrawlerConfiguration").build())
            .build();

    private static final SdkField<WorkDocsConfiguration> WORK_DOCS_CONFIGURATION_FIELD = SdkField
            .<WorkDocsConfiguration> builder(MarshallingType.SDK_POJO).memberName("WorkDocsConfiguration")
            .getter(getter(DataSourceConfiguration::workDocsConfiguration)).setter(setter(Builder::workDocsConfiguration))
            .constructor(WorkDocsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkDocsConfiguration").build())
            .build();

    private static final SdkField<FsxConfiguration> FSX_CONFIGURATION_FIELD = SdkField
            .<FsxConfiguration> builder(MarshallingType.SDK_POJO).memberName("FsxConfiguration")
            .getter(getter(DataSourceConfiguration::fsxConfiguration)).setter(setter(Builder::fsxConfiguration))
            .constructor(FsxConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FsxConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_CONFIGURATION_FIELD,
            SHARE_POINT_CONFIGURATION_FIELD, DATABASE_CONFIGURATION_FIELD, SALESFORCE_CONFIGURATION_FIELD,
            ONE_DRIVE_CONFIGURATION_FIELD, SERVICE_NOW_CONFIGURATION_FIELD, CONFLUENCE_CONFIGURATION_FIELD,
            GOOGLE_DRIVE_CONFIGURATION_FIELD, WEB_CRAWLER_CONFIGURATION_FIELD, WORK_DOCS_CONFIGURATION_FIELD,
            FSX_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3DataSourceConfiguration s3Configuration;

    private final SharePointConfiguration sharePointConfiguration;

    private final DatabaseConfiguration databaseConfiguration;

    private final SalesforceConfiguration salesforceConfiguration;

    private final OneDriveConfiguration oneDriveConfiguration;

    private final ServiceNowConfiguration serviceNowConfiguration;

    private final ConfluenceConfiguration confluenceConfiguration;

    private final GoogleDriveConfiguration googleDriveConfiguration;

    private final WebCrawlerConfiguration webCrawlerConfiguration;

    private final WorkDocsConfiguration workDocsConfiguration;

    private final FsxConfiguration fsxConfiguration;

    private DataSourceConfiguration(BuilderImpl builder) {
        this.s3Configuration = builder.s3Configuration;
        this.sharePointConfiguration = builder.sharePointConfiguration;
        this.databaseConfiguration = builder.databaseConfiguration;
        this.salesforceConfiguration = builder.salesforceConfiguration;
        this.oneDriveConfiguration = builder.oneDriveConfiguration;
        this.serviceNowConfiguration = builder.serviceNowConfiguration;
        this.confluenceConfiguration = builder.confluenceConfiguration;
        this.googleDriveConfiguration = builder.googleDriveConfiguration;
        this.webCrawlerConfiguration = builder.webCrawlerConfiguration;
        this.workDocsConfiguration = builder.workDocsConfiguration;
        this.fsxConfiguration = builder.fsxConfiguration;
    }

    /**
     * <p>
     * Provides information to create a data source connector for a document repository in an Amazon S3 bucket.
     * </p>
     * 
     * @return Provides information to create a data source connector for a document repository in an Amazon S3 bucket.
     */
    public final S3DataSourceConfiguration s3Configuration() {
        return s3Configuration;
    }

    /**
     * <p>
     * Provides information necessary to create a data source connector for a Microsoft SharePoint site.
     * </p>
     * 
     * @return Provides information necessary to create a data source connector for a Microsoft SharePoint site.
     */
    public final SharePointConfiguration sharePointConfiguration() {
        return sharePointConfiguration;
    }

    /**
     * <p>
     * Provides information necessary to create a data source connector for a database.
     * </p>
     * 
     * @return Provides information necessary to create a data source connector for a database.
     */
    public final DatabaseConfiguration databaseConfiguration() {
        return databaseConfiguration;
    }

    /**
     * <p>
     * Provides configuration information for data sources that connect to a Salesforce site.
     * </p>
     * 
     * @return Provides configuration information for data sources that connect to a Salesforce site.
     */
    public final SalesforceConfiguration salesforceConfiguration() {
        return salesforceConfiguration;
    }

    /**
     * <p>
     * Provides configuration for data sources that connect to Microsoft OneDrive.
     * </p>
     * 
     * @return Provides configuration for data sources that connect to Microsoft OneDrive.
     */
    public final OneDriveConfiguration oneDriveConfiguration() {
        return oneDriveConfiguration;
    }

    /**
     * <p>
     * Provides configuration for data sources that connect to ServiceNow instances.
     * </p>
     * 
     * @return Provides configuration for data sources that connect to ServiceNow instances.
     */
    public final ServiceNowConfiguration serviceNowConfiguration() {
        return serviceNowConfiguration;
    }

    /**
     * <p>
     * Provides configuration information for connecting to a Confluence data source.
     * </p>
     * 
     * @return Provides configuration information for connecting to a Confluence data source.
     */
    public final ConfluenceConfiguration confluenceConfiguration() {
        return confluenceConfiguration;
    }

    /**
     * <p>
     * Provides configuration for data sources that connect to Google Drive.
     * </p>
     * 
     * @return Provides configuration for data sources that connect to Google Drive.
     */
    public final GoogleDriveConfiguration googleDriveConfiguration() {
        return googleDriveConfiguration;
    }

    /**
     * Returns the value of the WebCrawlerConfiguration property for this object.
     * 
     * @return The value of the WebCrawlerConfiguration property for this object.
     */
    public final WebCrawlerConfiguration webCrawlerConfiguration() {
        return webCrawlerConfiguration;
    }

    /**
     * <p>
     * Provides the configuration information to connect to Amazon WorkDocs as your data source.
     * </p>
     * 
     * @return Provides the configuration information to connect to Amazon WorkDocs as your data source.
     */
    public final WorkDocsConfiguration workDocsConfiguration() {
        return workDocsConfiguration;
    }

    /**
     * <p>
     * Provides the configuration information to connect to Amazon FSx as your data source.
     * </p>
     * 
     * @return Provides the configuration information to connect to Amazon FSx as your data source.
     */
    public final FsxConfiguration fsxConfiguration() {
        return fsxConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(sharePointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(databaseConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(salesforceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(oneDriveConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNowConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(confluenceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(googleDriveConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(webCrawlerConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(workDocsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(fsxConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceConfiguration)) {
            return false;
        }
        DataSourceConfiguration other = (DataSourceConfiguration) obj;
        return Objects.equals(s3Configuration(), other.s3Configuration())
                && Objects.equals(sharePointConfiguration(), other.sharePointConfiguration())
                && Objects.equals(databaseConfiguration(), other.databaseConfiguration())
                && Objects.equals(salesforceConfiguration(), other.salesforceConfiguration())
                && Objects.equals(oneDriveConfiguration(), other.oneDriveConfiguration())
                && Objects.equals(serviceNowConfiguration(), other.serviceNowConfiguration())
                && Objects.equals(confluenceConfiguration(), other.confluenceConfiguration())
                && Objects.equals(googleDriveConfiguration(), other.googleDriveConfiguration())
                && Objects.equals(webCrawlerConfiguration(), other.webCrawlerConfiguration())
                && Objects.equals(workDocsConfiguration(), other.workDocsConfiguration())
                && Objects.equals(fsxConfiguration(), other.fsxConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSourceConfiguration").add("S3Configuration", s3Configuration())
                .add("SharePointConfiguration", sharePointConfiguration()).add("DatabaseConfiguration", databaseConfiguration())
                .add("SalesforceConfiguration", salesforceConfiguration()).add("OneDriveConfiguration", oneDriveConfiguration())
                .add("ServiceNowConfiguration", serviceNowConfiguration())
                .add("ConfluenceConfiguration", confluenceConfiguration())
                .add("GoogleDriveConfiguration", googleDriveConfiguration())
                .add("WebCrawlerConfiguration", webCrawlerConfiguration()).add("WorkDocsConfiguration", workDocsConfiguration())
                .add("FsxConfiguration", fsxConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Configuration":
            return Optional.ofNullable(clazz.cast(s3Configuration()));
        case "SharePointConfiguration":
            return Optional.ofNullable(clazz.cast(sharePointConfiguration()));
        case "DatabaseConfiguration":
            return Optional.ofNullable(clazz.cast(databaseConfiguration()));
        case "SalesforceConfiguration":
            return Optional.ofNullable(clazz.cast(salesforceConfiguration()));
        case "OneDriveConfiguration":
            return Optional.ofNullable(clazz.cast(oneDriveConfiguration()));
        case "ServiceNowConfiguration":
            return Optional.ofNullable(clazz.cast(serviceNowConfiguration()));
        case "ConfluenceConfiguration":
            return Optional.ofNullable(clazz.cast(confluenceConfiguration()));
        case "GoogleDriveConfiguration":
            return Optional.ofNullable(clazz.cast(googleDriveConfiguration()));
        case "WebCrawlerConfiguration":
            return Optional.ofNullable(clazz.cast(webCrawlerConfiguration()));
        case "WorkDocsConfiguration":
            return Optional.ofNullable(clazz.cast(workDocsConfiguration()));
        case "FsxConfiguration":
            return Optional.ofNullable(clazz.cast(fsxConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSourceConfiguration, T> g) {
        return obj -> g.apply((DataSourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourceConfiguration> {
        /**
         * <p>
         * Provides information to create a data source connector for a document repository in an Amazon S3 bucket.
         * </p>
         * 
         * @param s3Configuration
         *        Provides information to create a data source connector for a document repository in an Amazon S3
         *        bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Configuration(S3DataSourceConfiguration s3Configuration);

        /**
         * <p>
         * Provides information to create a data source connector for a document repository in an Amazon S3 bucket.
         * </p>
         * This is a convenience that creates an instance of the {@link S3DataSourceConfiguration.Builder} avoiding the
         * need to create one manually via {@link S3DataSourceConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3DataSourceConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #s3Configuration(S3DataSourceConfiguration)}.
         * 
         * @param s3Configuration
         *        a consumer that will call methods on {@link S3DataSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Configuration(S3DataSourceConfiguration)
         */
        default Builder s3Configuration(Consumer<S3DataSourceConfiguration.Builder> s3Configuration) {
            return s3Configuration(S3DataSourceConfiguration.builder().applyMutation(s3Configuration).build());
        }

        /**
         * <p>
         * Provides information necessary to create a data source connector for a Microsoft SharePoint site.
         * </p>
         * 
         * @param sharePointConfiguration
         *        Provides information necessary to create a data source connector for a Microsoft SharePoint site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharePointConfiguration(SharePointConfiguration sharePointConfiguration);

        /**
         * <p>
         * Provides information necessary to create a data source connector for a Microsoft SharePoint site.
         * </p>
         * This is a convenience that creates an instance of the {@link SharePointConfiguration.Builder} avoiding the
         * need to create one manually via {@link SharePointConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SharePointConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #sharePointConfiguration(SharePointConfiguration)}.
         * 
         * @param sharePointConfiguration
         *        a consumer that will call methods on {@link SharePointConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sharePointConfiguration(SharePointConfiguration)
         */
        default Builder sharePointConfiguration(Consumer<SharePointConfiguration.Builder> sharePointConfiguration) {
            return sharePointConfiguration(SharePointConfiguration.builder().applyMutation(sharePointConfiguration).build());
        }

        /**
         * <p>
         * Provides information necessary to create a data source connector for a database.
         * </p>
         * 
         * @param databaseConfiguration
         *        Provides information necessary to create a data source connector for a database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseConfiguration(DatabaseConfiguration databaseConfiguration);

        /**
         * <p>
         * Provides information necessary to create a data source connector for a database.
         * </p>
         * This is a convenience that creates an instance of the {@link DatabaseConfiguration.Builder} avoiding the need
         * to create one manually via {@link DatabaseConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DatabaseConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #databaseConfiguration(DatabaseConfiguration)}.
         * 
         * @param databaseConfiguration
         *        a consumer that will call methods on {@link DatabaseConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #databaseConfiguration(DatabaseConfiguration)
         */
        default Builder databaseConfiguration(Consumer<DatabaseConfiguration.Builder> databaseConfiguration) {
            return databaseConfiguration(DatabaseConfiguration.builder().applyMutation(databaseConfiguration).build());
        }

        /**
         * <p>
         * Provides configuration information for data sources that connect to a Salesforce site.
         * </p>
         * 
         * @param salesforceConfiguration
         *        Provides configuration information for data sources that connect to a Salesforce site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder salesforceConfiguration(SalesforceConfiguration salesforceConfiguration);

        /**
         * <p>
         * Provides configuration information for data sources that connect to a Salesforce site.
         * </p>
         * This is a convenience that creates an instance of the {@link SalesforceConfiguration.Builder} avoiding the
         * need to create one manually via {@link SalesforceConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SalesforceConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #salesforceConfiguration(SalesforceConfiguration)}.
         * 
         * @param salesforceConfiguration
         *        a consumer that will call methods on {@link SalesforceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #salesforceConfiguration(SalesforceConfiguration)
         */
        default Builder salesforceConfiguration(Consumer<SalesforceConfiguration.Builder> salesforceConfiguration) {
            return salesforceConfiguration(SalesforceConfiguration.builder().applyMutation(salesforceConfiguration).build());
        }

        /**
         * <p>
         * Provides configuration for data sources that connect to Microsoft OneDrive.
         * </p>
         * 
         * @param oneDriveConfiguration
         *        Provides configuration for data sources that connect to Microsoft OneDrive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oneDriveConfiguration(OneDriveConfiguration oneDriveConfiguration);

        /**
         * <p>
         * Provides configuration for data sources that connect to Microsoft OneDrive.
         * </p>
         * This is a convenience that creates an instance of the {@link OneDriveConfiguration.Builder} avoiding the need
         * to create one manually via {@link OneDriveConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link OneDriveConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #oneDriveConfiguration(OneDriveConfiguration)}.
         * 
         * @param oneDriveConfiguration
         *        a consumer that will call methods on {@link OneDriveConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oneDriveConfiguration(OneDriveConfiguration)
         */
        default Builder oneDriveConfiguration(Consumer<OneDriveConfiguration.Builder> oneDriveConfiguration) {
            return oneDriveConfiguration(OneDriveConfiguration.builder().applyMutation(oneDriveConfiguration).build());
        }

        /**
         * <p>
         * Provides configuration for data sources that connect to ServiceNow instances.
         * </p>
         * 
         * @param serviceNowConfiguration
         *        Provides configuration for data sources that connect to ServiceNow instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNowConfiguration(ServiceNowConfiguration serviceNowConfiguration);

        /**
         * <p>
         * Provides configuration for data sources that connect to ServiceNow instances.
         * </p>
         * This is a convenience that creates an instance of the {@link ServiceNowConfiguration.Builder} avoiding the
         * need to create one manually via {@link ServiceNowConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServiceNowConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #serviceNowConfiguration(ServiceNowConfiguration)}.
         * 
         * @param serviceNowConfiguration
         *        a consumer that will call methods on {@link ServiceNowConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceNowConfiguration(ServiceNowConfiguration)
         */
        default Builder serviceNowConfiguration(Consumer<ServiceNowConfiguration.Builder> serviceNowConfiguration) {
            return serviceNowConfiguration(ServiceNowConfiguration.builder().applyMutation(serviceNowConfiguration).build());
        }

        /**
         * <p>
         * Provides configuration information for connecting to a Confluence data source.
         * </p>
         * 
         * @param confluenceConfiguration
         *        Provides configuration information for connecting to a Confluence data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confluenceConfiguration(ConfluenceConfiguration confluenceConfiguration);

        /**
         * <p>
         * Provides configuration information for connecting to a Confluence data source.
         * </p>
         * This is a convenience that creates an instance of the {@link ConfluenceConfiguration.Builder} avoiding the
         * need to create one manually via {@link ConfluenceConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConfluenceConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #confluenceConfiguration(ConfluenceConfiguration)}.
         * 
         * @param confluenceConfiguration
         *        a consumer that will call methods on {@link ConfluenceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #confluenceConfiguration(ConfluenceConfiguration)
         */
        default Builder confluenceConfiguration(Consumer<ConfluenceConfiguration.Builder> confluenceConfiguration) {
            return confluenceConfiguration(ConfluenceConfiguration.builder().applyMutation(confluenceConfiguration).build());
        }

        /**
         * <p>
         * Provides configuration for data sources that connect to Google Drive.
         * </p>
         * 
         * @param googleDriveConfiguration
         *        Provides configuration for data sources that connect to Google Drive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder googleDriveConfiguration(GoogleDriveConfiguration googleDriveConfiguration);

        /**
         * <p>
         * Provides configuration for data sources that connect to Google Drive.
         * </p>
         * This is a convenience that creates an instance of the {@link GoogleDriveConfiguration.Builder} avoiding the
         * need to create one manually via {@link GoogleDriveConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link GoogleDriveConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #googleDriveConfiguration(GoogleDriveConfiguration)}.
         * 
         * @param googleDriveConfiguration
         *        a consumer that will call methods on {@link GoogleDriveConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #googleDriveConfiguration(GoogleDriveConfiguration)
         */
        default Builder googleDriveConfiguration(Consumer<GoogleDriveConfiguration.Builder> googleDriveConfiguration) {
            return googleDriveConfiguration(GoogleDriveConfiguration.builder().applyMutation(googleDriveConfiguration).build());
        }

        /**
         * Sets the value of the WebCrawlerConfiguration property for this object.
         *
         * @param webCrawlerConfiguration
         *        The new value for the WebCrawlerConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webCrawlerConfiguration(WebCrawlerConfiguration webCrawlerConfiguration);

        /**
         * Sets the value of the WebCrawlerConfiguration property for this object.
         *
         * This is a convenience that creates an instance of the {@link WebCrawlerConfiguration.Builder} avoiding the
         * need to create one manually via {@link WebCrawlerConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link WebCrawlerConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #webCrawlerConfiguration(WebCrawlerConfiguration)}.
         * 
         * @param webCrawlerConfiguration
         *        a consumer that will call methods on {@link WebCrawlerConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webCrawlerConfiguration(WebCrawlerConfiguration)
         */
        default Builder webCrawlerConfiguration(Consumer<WebCrawlerConfiguration.Builder> webCrawlerConfiguration) {
            return webCrawlerConfiguration(WebCrawlerConfiguration.builder().applyMutation(webCrawlerConfiguration).build());
        }

        /**
         * <p>
         * Provides the configuration information to connect to Amazon WorkDocs as your data source.
         * </p>
         * 
         * @param workDocsConfiguration
         *        Provides the configuration information to connect to Amazon WorkDocs as your data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workDocsConfiguration(WorkDocsConfiguration workDocsConfiguration);

        /**
         * <p>
         * Provides the configuration information to connect to Amazon WorkDocs as your data source.
         * </p>
         * This is a convenience that creates an instance of the {@link WorkDocsConfiguration.Builder} avoiding the need
         * to create one manually via {@link WorkDocsConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkDocsConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #workDocsConfiguration(WorkDocsConfiguration)}.
         * 
         * @param workDocsConfiguration
         *        a consumer that will call methods on {@link WorkDocsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workDocsConfiguration(WorkDocsConfiguration)
         */
        default Builder workDocsConfiguration(Consumer<WorkDocsConfiguration.Builder> workDocsConfiguration) {
            return workDocsConfiguration(WorkDocsConfiguration.builder().applyMutation(workDocsConfiguration).build());
        }

        /**
         * <p>
         * Provides the configuration information to connect to Amazon FSx as your data source.
         * </p>
         * 
         * @param fsxConfiguration
         *        Provides the configuration information to connect to Amazon FSx as your data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fsxConfiguration(FsxConfiguration fsxConfiguration);

        /**
         * <p>
         * Provides the configuration information to connect to Amazon FSx as your data source.
         * </p>
         * This is a convenience that creates an instance of the {@link FsxConfiguration.Builder} avoiding the need to
         * create one manually via {@link FsxConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link FsxConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #fsxConfiguration(FsxConfiguration)}.
         * 
         * @param fsxConfiguration
         *        a consumer that will call methods on {@link FsxConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fsxConfiguration(FsxConfiguration)
         */
        default Builder fsxConfiguration(Consumer<FsxConfiguration.Builder> fsxConfiguration) {
            return fsxConfiguration(FsxConfiguration.builder().applyMutation(fsxConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3DataSourceConfiguration s3Configuration;

        private SharePointConfiguration sharePointConfiguration;

        private DatabaseConfiguration databaseConfiguration;

        private SalesforceConfiguration salesforceConfiguration;

        private OneDriveConfiguration oneDriveConfiguration;

        private ServiceNowConfiguration serviceNowConfiguration;

        private ConfluenceConfiguration confluenceConfiguration;

        private GoogleDriveConfiguration googleDriveConfiguration;

        private WebCrawlerConfiguration webCrawlerConfiguration;

        private WorkDocsConfiguration workDocsConfiguration;

        private FsxConfiguration fsxConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceConfiguration model) {
            s3Configuration(model.s3Configuration);
            sharePointConfiguration(model.sharePointConfiguration);
            databaseConfiguration(model.databaseConfiguration);
            salesforceConfiguration(model.salesforceConfiguration);
            oneDriveConfiguration(model.oneDriveConfiguration);
            serviceNowConfiguration(model.serviceNowConfiguration);
            confluenceConfiguration(model.confluenceConfiguration);
            googleDriveConfiguration(model.googleDriveConfiguration);
            webCrawlerConfiguration(model.webCrawlerConfiguration);
            workDocsConfiguration(model.workDocsConfiguration);
            fsxConfiguration(model.fsxConfiguration);
        }

        public final S3DataSourceConfiguration.Builder getS3Configuration() {
            return s3Configuration != null ? s3Configuration.toBuilder() : null;
        }

        public final void setS3Configuration(S3DataSourceConfiguration.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        @Override
        @Transient
        public final Builder s3Configuration(S3DataSourceConfiguration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public final SharePointConfiguration.Builder getSharePointConfiguration() {
            return sharePointConfiguration != null ? sharePointConfiguration.toBuilder() : null;
        }

        public final void setSharePointConfiguration(SharePointConfiguration.BuilderImpl sharePointConfiguration) {
            this.sharePointConfiguration = sharePointConfiguration != null ? sharePointConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder sharePointConfiguration(SharePointConfiguration sharePointConfiguration) {
            this.sharePointConfiguration = sharePointConfiguration;
            return this;
        }

        public final DatabaseConfiguration.Builder getDatabaseConfiguration() {
            return databaseConfiguration != null ? databaseConfiguration.toBuilder() : null;
        }

        public final void setDatabaseConfiguration(DatabaseConfiguration.BuilderImpl databaseConfiguration) {
            this.databaseConfiguration = databaseConfiguration != null ? databaseConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder databaseConfiguration(DatabaseConfiguration databaseConfiguration) {
            this.databaseConfiguration = databaseConfiguration;
            return this;
        }

        public final SalesforceConfiguration.Builder getSalesforceConfiguration() {
            return salesforceConfiguration != null ? salesforceConfiguration.toBuilder() : null;
        }

        public final void setSalesforceConfiguration(SalesforceConfiguration.BuilderImpl salesforceConfiguration) {
            this.salesforceConfiguration = salesforceConfiguration != null ? salesforceConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder salesforceConfiguration(SalesforceConfiguration salesforceConfiguration) {
            this.salesforceConfiguration = salesforceConfiguration;
            return this;
        }

        public final OneDriveConfiguration.Builder getOneDriveConfiguration() {
            return oneDriveConfiguration != null ? oneDriveConfiguration.toBuilder() : null;
        }

        public final void setOneDriveConfiguration(OneDriveConfiguration.BuilderImpl oneDriveConfiguration) {
            this.oneDriveConfiguration = oneDriveConfiguration != null ? oneDriveConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder oneDriveConfiguration(OneDriveConfiguration oneDriveConfiguration) {
            this.oneDriveConfiguration = oneDriveConfiguration;
            return this;
        }

        public final ServiceNowConfiguration.Builder getServiceNowConfiguration() {
            return serviceNowConfiguration != null ? serviceNowConfiguration.toBuilder() : null;
        }

        public final void setServiceNowConfiguration(ServiceNowConfiguration.BuilderImpl serviceNowConfiguration) {
            this.serviceNowConfiguration = serviceNowConfiguration != null ? serviceNowConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder serviceNowConfiguration(ServiceNowConfiguration serviceNowConfiguration) {
            this.serviceNowConfiguration = serviceNowConfiguration;
            return this;
        }

        public final ConfluenceConfiguration.Builder getConfluenceConfiguration() {
            return confluenceConfiguration != null ? confluenceConfiguration.toBuilder() : null;
        }

        public final void setConfluenceConfiguration(ConfluenceConfiguration.BuilderImpl confluenceConfiguration) {
            this.confluenceConfiguration = confluenceConfiguration != null ? confluenceConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder confluenceConfiguration(ConfluenceConfiguration confluenceConfiguration) {
            this.confluenceConfiguration = confluenceConfiguration;
            return this;
        }

        public final GoogleDriveConfiguration.Builder getGoogleDriveConfiguration() {
            return googleDriveConfiguration != null ? googleDriveConfiguration.toBuilder() : null;
        }

        public final void setGoogleDriveConfiguration(GoogleDriveConfiguration.BuilderImpl googleDriveConfiguration) {
            this.googleDriveConfiguration = googleDriveConfiguration != null ? googleDriveConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder googleDriveConfiguration(GoogleDriveConfiguration googleDriveConfiguration) {
            this.googleDriveConfiguration = googleDriveConfiguration;
            return this;
        }

        public final WebCrawlerConfiguration.Builder getWebCrawlerConfiguration() {
            return webCrawlerConfiguration != null ? webCrawlerConfiguration.toBuilder() : null;
        }

        public final void setWebCrawlerConfiguration(WebCrawlerConfiguration.BuilderImpl webCrawlerConfiguration) {
            this.webCrawlerConfiguration = webCrawlerConfiguration != null ? webCrawlerConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder webCrawlerConfiguration(WebCrawlerConfiguration webCrawlerConfiguration) {
            this.webCrawlerConfiguration = webCrawlerConfiguration;
            return this;
        }

        public final WorkDocsConfiguration.Builder getWorkDocsConfiguration() {
            return workDocsConfiguration != null ? workDocsConfiguration.toBuilder() : null;
        }

        public final void setWorkDocsConfiguration(WorkDocsConfiguration.BuilderImpl workDocsConfiguration) {
            this.workDocsConfiguration = workDocsConfiguration != null ? workDocsConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder workDocsConfiguration(WorkDocsConfiguration workDocsConfiguration) {
            this.workDocsConfiguration = workDocsConfiguration;
            return this;
        }

        public final FsxConfiguration.Builder getFsxConfiguration() {
            return fsxConfiguration != null ? fsxConfiguration.toBuilder() : null;
        }

        public final void setFsxConfiguration(FsxConfiguration.BuilderImpl fsxConfiguration) {
            this.fsxConfiguration = fsxConfiguration != null ? fsxConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder fsxConfiguration(FsxConfiguration fsxConfiguration) {
            this.fsxConfiguration = fsxConfiguration;
            return this;
        }

        @Override
        public DataSourceConfiguration build() {
            return new DataSourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
