/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Maps a column or attribute in the data source to an index field. You must first create the fields in the index using
 * the <code>UpdateIndex</code> API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourceToIndexFieldMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSourceToIndexFieldMapping.Builder, DataSourceToIndexFieldMapping> {
    private static final SdkField<String> DATA_SOURCE_FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSourceFieldName").getter(getter(DataSourceToIndexFieldMapping::dataSourceFieldName))
            .setter(setter(Builder::dataSourceFieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceFieldName").build())
            .build();

    private static final SdkField<String> DATE_FIELD_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DateFieldFormat").getter(getter(DataSourceToIndexFieldMapping::dateFieldFormat))
            .setter(setter(Builder::dateFieldFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateFieldFormat").build()).build();

    private static final SdkField<String> INDEX_FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexFieldName").getter(getter(DataSourceToIndexFieldMapping::indexFieldName))
            .setter(setter(Builder::indexFieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexFieldName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD_NAME_FIELD,
            DATE_FIELD_FORMAT_FIELD, INDEX_FIELD_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataSourceFieldName;

    private final String dateFieldFormat;

    private final String indexFieldName;

    private DataSourceToIndexFieldMapping(BuilderImpl builder) {
        this.dataSourceFieldName = builder.dataSourceFieldName;
        this.dateFieldFormat = builder.dateFieldFormat;
        this.indexFieldName = builder.indexFieldName;
    }

    /**
     * <p>
     * The name of the column or attribute in the data source.
     * </p>
     * 
     * @return The name of the column or attribute in the data source.
     */
    public final String dataSourceFieldName() {
        return dataSourceFieldName;
    }

    /**
     * <p>
     * The type of data stored in the column or attribute.
     * </p>
     * 
     * @return The type of data stored in the column or attribute.
     */
    public final String dateFieldFormat() {
        return dateFieldFormat;
    }

    /**
     * <p>
     * The name of the field in the index.
     * </p>
     * 
     * @return The name of the field in the index.
     */
    public final String indexFieldName() {
        return indexFieldName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceFieldName());
        hashCode = 31 * hashCode + Objects.hashCode(dateFieldFormat());
        hashCode = 31 * hashCode + Objects.hashCode(indexFieldName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceToIndexFieldMapping)) {
            return false;
        }
        DataSourceToIndexFieldMapping other = (DataSourceToIndexFieldMapping) obj;
        return Objects.equals(dataSourceFieldName(), other.dataSourceFieldName())
                && Objects.equals(dateFieldFormat(), other.dateFieldFormat())
                && Objects.equals(indexFieldName(), other.indexFieldName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSourceToIndexFieldMapping").add("DataSourceFieldName", dataSourceFieldName())
                .add("DateFieldFormat", dateFieldFormat()).add("IndexFieldName", indexFieldName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSourceFieldName":
            return Optional.ofNullable(clazz.cast(dataSourceFieldName()));
        case "DateFieldFormat":
            return Optional.ofNullable(clazz.cast(dateFieldFormat()));
        case "IndexFieldName":
            return Optional.ofNullable(clazz.cast(indexFieldName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSourceToIndexFieldMapping, T> g) {
        return obj -> g.apply((DataSourceToIndexFieldMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourceToIndexFieldMapping> {
        /**
         * <p>
         * The name of the column or attribute in the data source.
         * </p>
         * 
         * @param dataSourceFieldName
         *        The name of the column or attribute in the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceFieldName(String dataSourceFieldName);

        /**
         * <p>
         * The type of data stored in the column or attribute.
         * </p>
         * 
         * @param dateFieldFormat
         *        The type of data stored in the column or attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateFieldFormat(String dateFieldFormat);

        /**
         * <p>
         * The name of the field in the index.
         * </p>
         * 
         * @param indexFieldName
         *        The name of the field in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexFieldName(String indexFieldName);
    }

    static final class BuilderImpl implements Builder {
        private String dataSourceFieldName;

        private String dateFieldFormat;

        private String indexFieldName;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceToIndexFieldMapping model) {
            dataSourceFieldName(model.dataSourceFieldName);
            dateFieldFormat(model.dateFieldFormat);
            indexFieldName(model.indexFieldName);
        }

        public final String getDataSourceFieldName() {
            return dataSourceFieldName;
        }

        public final void setDataSourceFieldName(String dataSourceFieldName) {
            this.dataSourceFieldName = dataSourceFieldName;
        }

        @Override
        @Transient
        public final Builder dataSourceFieldName(String dataSourceFieldName) {
            this.dataSourceFieldName = dataSourceFieldName;
            return this;
        }

        public final String getDateFieldFormat() {
            return dateFieldFormat;
        }

        public final void setDateFieldFormat(String dateFieldFormat) {
            this.dateFieldFormat = dateFieldFormat;
        }

        @Override
        @Transient
        public final Builder dateFieldFormat(String dateFieldFormat) {
            this.dateFieldFormat = dateFieldFormat;
            return this;
        }

        public final String getIndexFieldName() {
            return indexFieldName;
        }

        public final void setIndexFieldName(String indexFieldName) {
            this.indexFieldName = indexFieldName;
        }

        @Override
        @Transient
        public final Builder indexFieldName(String indexFieldName) {
            this.indexFieldName = indexFieldName;
            return this;
        }

        @Override
        public DataSourceToIndexFieldMapping build() {
            return new DataSourceToIndexFieldMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
