/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration information of users or groups in your Amazon Web Services SSO identity source to grant
 * access your Amazon Kendra experience.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EntityConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EntityConfiguration.Builder, EntityConfiguration> {
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityId").getter(getter(EntityConfiguration::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()).build();

    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityType").getter(getter(EntityConfiguration::entityTypeAsString)).setter(setter(Builder::entityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_ID_FIELD,
            ENTITY_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String entityId;

    private final String entityType;

    private EntityConfiguration(BuilderImpl builder) {
        this.entityId = builder.entityId;
        this.entityType = builder.entityType;
    }

    /**
     * <p>
     * The identifier of a user or group in your Amazon Web Services SSO identity source. For example, a user ID could
     * be an email.
     * </p>
     * 
     * @return The identifier of a user or group in your Amazon Web Services SSO identity source. For example, a user ID
     *         could be an email.
     */
    public final String entityId() {
        return entityId;
    }

    /**
     * <p>
     * Specifies whether you are configuring a <code>User</code> or a <code>Group</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link EntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #entityTypeAsString}.
     * </p>
     * 
     * @return Specifies whether you are configuring a <code>User</code> or a <code>Group</code>.
     * @see EntityType
     */
    public final EntityType entityType() {
        return EntityType.fromValue(entityType);
    }

    /**
     * <p>
     * Specifies whether you are configuring a <code>User</code> or a <code>Group</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link EntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #entityTypeAsString}.
     * </p>
     * 
     * @return Specifies whether you are configuring a <code>User</code> or a <code>Group</code>.
     * @see EntityType
     */
    public final String entityTypeAsString() {
        return entityType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(entityTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityConfiguration)) {
            return false;
        }
        EntityConfiguration other = (EntityConfiguration) obj;
        return Objects.equals(entityId(), other.entityId()) && Objects.equals(entityTypeAsString(), other.entityTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EntityConfiguration").add("EntityId", entityId()).add("EntityType", entityTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EntityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "EntityType":
            return Optional.ofNullable(clazz.cast(entityTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityConfiguration, T> g) {
        return obj -> g.apply((EntityConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EntityConfiguration> {
        /**
         * <p>
         * The identifier of a user or group in your Amazon Web Services SSO identity source. For example, a user ID
         * could be an email.
         * </p>
         * 
         * @param entityId
         *        The identifier of a user or group in your Amazon Web Services SSO identity source. For example, a user
         *        ID could be an email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * Specifies whether you are configuring a <code>User</code> or a <code>Group</code>.
         * </p>
         * 
         * @param entityType
         *        Specifies whether you are configuring a <code>User</code> or a <code>Group</code>.
         * @see EntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityType
         */
        Builder entityType(String entityType);

        /**
         * <p>
         * Specifies whether you are configuring a <code>User</code> or a <code>Group</code>.
         * </p>
         * 
         * @param entityType
         *        Specifies whether you are configuring a <code>User</code> or a <code>Group</code>.
         * @see EntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityType
         */
        Builder entityType(EntityType entityType);
    }

    static final class BuilderImpl implements Builder {
        private String entityId;

        private String entityType;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityConfiguration model) {
            entityId(model.entityId);
            entityType(model.entityType);
        }

        public final String getEntityId() {
            return entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        @Transient
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityType() {
            return entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        @Transient
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        @Transient
        public final Builder entityType(EntityType entityType) {
            this.entityType(entityType == null ? null : entityType.toString());
            return this;
        }

        @Override
        public EntityConfiguration build() {
            return new EntityConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
