/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of users or sub groups that belong to a group. Users and groups are useful for filtering search results to
 * different users based on their group's access to documents.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GroupMembers implements SdkPojo, Serializable, ToCopyableBuilder<GroupMembers.Builder, GroupMembers> {
    private static final SdkField<List<MemberGroup>> MEMBER_GROUPS_FIELD = SdkField
            .<List<MemberGroup>> builder(MarshallingType.LIST)
            .memberName("MemberGroups")
            .getter(getter(GroupMembers::memberGroups))
            .setter(setter(Builder::memberGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MemberGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(MemberGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MemberUser>> MEMBER_USERS_FIELD = SdkField
            .<List<MemberUser>> builder(MarshallingType.LIST)
            .memberName("MemberUsers")
            .getter(getter(GroupMembers::memberUsers))
            .setter(setter(Builder::memberUsers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberUsers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MemberUser> builder(MarshallingType.SDK_POJO)
                                            .constructor(MemberUser::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<S3Path> S3_PATHFOR_GROUP_MEMBERS_FIELD = SdkField.<S3Path> builder(MarshallingType.SDK_POJO)
            .memberName("S3PathforGroupMembers").getter(getter(GroupMembers::s3PathforGroupMembers))
            .setter(setter(Builder::s3PathforGroupMembers)).constructor(S3Path::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3PathforGroupMembers").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_GROUPS_FIELD,
            MEMBER_USERS_FIELD, S3_PATHFOR_GROUP_MEMBERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<MemberGroup> memberGroups;

    private final List<MemberUser> memberUsers;

    private final S3Path s3PathforGroupMembers;

    private GroupMembers(BuilderImpl builder) {
        this.memberGroups = builder.memberGroups;
        this.memberUsers = builder.memberUsers;
        this.s3PathforGroupMembers = builder.s3PathforGroupMembers;
    }

    /**
     * For responses, this returns true if the service returned a value for the MemberGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMemberGroups() {
        return memberGroups != null && !(memberGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of sub groups that belong to a group. For example, the sub groups "Research", "Engineering", and
     * "Sales and Marketing" all belong to the group "Company".
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMemberGroups} method.
     * </p>
     * 
     * @return A list of sub groups that belong to a group. For example, the sub groups "Research", "Engineering", and
     *         "Sales and Marketing" all belong to the group "Company".
     */
    public final List<MemberGroup> memberGroups() {
        return memberGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the MemberUsers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMemberUsers() {
        return memberUsers != null && !(memberUsers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of users that belong to a group. For example, a list of interns all belong to the "Interns" group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMemberUsers} method.
     * </p>
     * 
     * @return A list of users that belong to a group. For example, a list of interns all belong to the "Interns" group.
     */
    public final List<MemberUser> memberUsers() {
        return memberUsers;
    }

    /**
     * <p>
     * If you have more than 1000 users and/or sub groups for a single group, you need to provide the path to the S3
     * file that lists your users and sub groups for a group. Your sub groups can contain more than 1000 users, but the
     * list of sub groups that belong to a group (and/or users) must be no more than 1000.
     * </p>
     * <p>
     * You can download this <a href="https://docs.aws.amazon.com/kendra/latest/dg/samples/group_members.zip">example S3
     * file</a> that uses the correct format for listing group members. Note, <code>dataSourceId</code> is optional. The
     * value of <code>type</code> for a group is always <code>GROUP</code> and for a user it is always <code>USER</code>
     * .
     * </p>
     * 
     * @return If you have more than 1000 users and/or sub groups for a single group, you need to provide the path to
     *         the S3 file that lists your users and sub groups for a group. Your sub groups can contain more than 1000
     *         users, but the list of sub groups that belong to a group (and/or users) must be no more than 1000.</p>
     *         <p>
     *         You can download this <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/samples/group_members.zip">example S3 file</a> that
     *         uses the correct format for listing group members. Note, <code>dataSourceId</code> is optional. The value
     *         of <code>type</code> for a group is always <code>GROUP</code> and for a user it is always
     *         <code>USER</code>.
     */
    public final S3Path s3PathforGroupMembers() {
        return s3PathforGroupMembers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasMemberGroups() ? memberGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMemberUsers() ? memberUsers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(s3PathforGroupMembers());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupMembers)) {
            return false;
        }
        GroupMembers other = (GroupMembers) obj;
        return hasMemberGroups() == other.hasMemberGroups() && Objects.equals(memberGroups(), other.memberGroups())
                && hasMemberUsers() == other.hasMemberUsers() && Objects.equals(memberUsers(), other.memberUsers())
                && Objects.equals(s3PathforGroupMembers(), other.s3PathforGroupMembers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GroupMembers").add("MemberGroups", hasMemberGroups() ? memberGroups() : null)
                .add("MemberUsers", hasMemberUsers() ? memberUsers() : null)
                .add("S3PathforGroupMembers", s3PathforGroupMembers()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MemberGroups":
            return Optional.ofNullable(clazz.cast(memberGroups()));
        case "MemberUsers":
            return Optional.ofNullable(clazz.cast(memberUsers()));
        case "S3PathforGroupMembers":
            return Optional.ofNullable(clazz.cast(s3PathforGroupMembers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GroupMembers, T> g) {
        return obj -> g.apply((GroupMembers) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GroupMembers> {
        /**
         * <p>
         * A list of sub groups that belong to a group. For example, the sub groups "Research", "Engineering", and
         * "Sales and Marketing" all belong to the group "Company".
         * </p>
         * 
         * @param memberGroups
         *        A list of sub groups that belong to a group. For example, the sub groups "Research", "Engineering",
         *        and "Sales and Marketing" all belong to the group "Company".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberGroups(Collection<MemberGroup> memberGroups);

        /**
         * <p>
         * A list of sub groups that belong to a group. For example, the sub groups "Research", "Engineering", and
         * "Sales and Marketing" all belong to the group "Company".
         * </p>
         * 
         * @param memberGroups
         *        A list of sub groups that belong to a group. For example, the sub groups "Research", "Engineering",
         *        and "Sales and Marketing" all belong to the group "Company".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberGroups(MemberGroup... memberGroups);

        /**
         * <p>
         * A list of sub groups that belong to a group. For example, the sub groups "Research", "Engineering", and
         * "Sales and Marketing" all belong to the group "Company".
         * </p>
         * This is a convenience that creates an instance of the {@link List<MemberGroup>.Builder} avoiding the need to
         * create one manually via {@link List<MemberGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MemberGroup>.Builder#build()} is called immediately and its
         * result is passed to {@link #memberGroups(List<MemberGroup>)}.
         * 
         * @param memberGroups
         *        a consumer that will call methods on {@link List<MemberGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memberGroups(List<MemberGroup>)
         */
        Builder memberGroups(Consumer<MemberGroup.Builder>... memberGroups);

        /**
         * <p>
         * A list of users that belong to a group. For example, a list of interns all belong to the "Interns" group.
         * </p>
         * 
         * @param memberUsers
         *        A list of users that belong to a group. For example, a list of interns all belong to the "Interns"
         *        group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberUsers(Collection<MemberUser> memberUsers);

        /**
         * <p>
         * A list of users that belong to a group. For example, a list of interns all belong to the "Interns" group.
         * </p>
         * 
         * @param memberUsers
         *        A list of users that belong to a group. For example, a list of interns all belong to the "Interns"
         *        group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberUsers(MemberUser... memberUsers);

        /**
         * <p>
         * A list of users that belong to a group. For example, a list of interns all belong to the "Interns" group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MemberUser>.Builder} avoiding the need to
         * create one manually via {@link List<MemberUser>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MemberUser>.Builder#build()} is called immediately and its
         * result is passed to {@link #memberUsers(List<MemberUser>)}.
         * 
         * @param memberUsers
         *        a consumer that will call methods on {@link List<MemberUser>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memberUsers(List<MemberUser>)
         */
        Builder memberUsers(Consumer<MemberUser.Builder>... memberUsers);

        /**
         * <p>
         * If you have more than 1000 users and/or sub groups for a single group, you need to provide the path to the S3
         * file that lists your users and sub groups for a group. Your sub groups can contain more than 1000 users, but
         * the list of sub groups that belong to a group (and/or users) must be no more than 1000.
         * </p>
         * <p>
         * You can download this <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/samples/group_members.zip">example S3 file</a> that uses
         * the correct format for listing group members. Note, <code>dataSourceId</code> is optional. The value of
         * <code>type</code> for a group is always <code>GROUP</code> and for a user it is always <code>USER</code>.
         * </p>
         * 
         * @param s3PathforGroupMembers
         *        If you have more than 1000 users and/or sub groups for a single group, you need to provide the path to
         *        the S3 file that lists your users and sub groups for a group. Your sub groups can contain more than
         *        1000 users, but the list of sub groups that belong to a group (and/or users) must be no more than
         *        1000.</p>
         *        <p>
         *        You can download this <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/samples/group_members.zip">example S3 file</a> that
         *        uses the correct format for listing group members. Note, <code>dataSourceId</code> is optional. The
         *        value of <code>type</code> for a group is always <code>GROUP</code> and for a user it is always
         *        <code>USER</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3PathforGroupMembers(S3Path s3PathforGroupMembers);

        /**
         * <p>
         * If you have more than 1000 users and/or sub groups for a single group, you need to provide the path to the S3
         * file that lists your users and sub groups for a group. Your sub groups can contain more than 1000 users, but
         * the list of sub groups that belong to a group (and/or users) must be no more than 1000.
         * </p>
         * <p>
         * You can download this <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/samples/group_members.zip">example S3 file</a> that uses
         * the correct format for listing group members. Note, <code>dataSourceId</code> is optional. The value of
         * <code>type</code> for a group is always <code>GROUP</code> and for a user it is always <code>USER</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link S3Path.Builder} avoiding the need to create one
         * manually via {@link S3Path#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Path.Builder#build()} is called immediately and its result is
         * passed to {@link #s3PathforGroupMembers(S3Path)}.
         * 
         * @param s3PathforGroupMembers
         *        a consumer that will call methods on {@link S3Path.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3PathforGroupMembers(S3Path)
         */
        default Builder s3PathforGroupMembers(Consumer<S3Path.Builder> s3PathforGroupMembers) {
            return s3PathforGroupMembers(S3Path.builder().applyMutation(s3PathforGroupMembers).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<MemberGroup> memberGroups = DefaultSdkAutoConstructList.getInstance();

        private List<MemberUser> memberUsers = DefaultSdkAutoConstructList.getInstance();

        private S3Path s3PathforGroupMembers;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupMembers model) {
            memberGroups(model.memberGroups);
            memberUsers(model.memberUsers);
            s3PathforGroupMembers(model.s3PathforGroupMembers);
        }

        public final List<MemberGroup.Builder> getMemberGroups() {
            List<MemberGroup.Builder> result = MemberGroupsCopier.copyToBuilder(this.memberGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMemberGroups(Collection<MemberGroup.BuilderImpl> memberGroups) {
            this.memberGroups = MemberGroupsCopier.copyFromBuilder(memberGroups);
        }

        @Override
        @Transient
        public final Builder memberGroups(Collection<MemberGroup> memberGroups) {
            this.memberGroups = MemberGroupsCopier.copy(memberGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder memberGroups(MemberGroup... memberGroups) {
            memberGroups(Arrays.asList(memberGroups));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder memberGroups(Consumer<MemberGroup.Builder>... memberGroups) {
            memberGroups(Stream.of(memberGroups).map(c -> MemberGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<MemberUser.Builder> getMemberUsers() {
            List<MemberUser.Builder> result = MemberUsersCopier.copyToBuilder(this.memberUsers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMemberUsers(Collection<MemberUser.BuilderImpl> memberUsers) {
            this.memberUsers = MemberUsersCopier.copyFromBuilder(memberUsers);
        }

        @Override
        @Transient
        public final Builder memberUsers(Collection<MemberUser> memberUsers) {
            this.memberUsers = MemberUsersCopier.copy(memberUsers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder memberUsers(MemberUser... memberUsers) {
            memberUsers(Arrays.asList(memberUsers));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder memberUsers(Consumer<MemberUser.Builder>... memberUsers) {
            memberUsers(Stream.of(memberUsers).map(c -> MemberUser.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final S3Path.Builder getS3PathforGroupMembers() {
            return s3PathforGroupMembers != null ? s3PathforGroupMembers.toBuilder() : null;
        }

        public final void setS3PathforGroupMembers(S3Path.BuilderImpl s3PathforGroupMembers) {
            this.s3PathforGroupMembers = s3PathforGroupMembers != null ? s3PathforGroupMembers.build() : null;
        }

        @Override
        @Transient
        public final Builder s3PathforGroupMembers(S3Path s3PathforGroupMembers) {
            this.s3PathforGroupMembers = s3PathforGroupMembers;
            return this;
        }

        @Override
        public GroupMembers build() {
            return new GroupMembers(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
