/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information that you can use to highlight a search result so that your users can quickly identify terms in
 * the response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Highlight implements SdkPojo, Serializable, ToCopyableBuilder<Highlight.Builder, Highlight> {
    private static final SdkField<Integer> BEGIN_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BeginOffset").getter(getter(Highlight::beginOffset)).setter(setter(Builder::beginOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffset").build()).build();

    private static final SdkField<Integer> END_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EndOffset").getter(getter(Highlight::endOffset)).setter(setter(Builder::endOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffset").build()).build();

    private static final SdkField<Boolean> TOP_ANSWER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TopAnswer").getter(getter(Highlight::topAnswer)).setter(setter(Builder::topAnswer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopAnswer").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Highlight::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEGIN_OFFSET_FIELD,
            END_OFFSET_FIELD, TOP_ANSWER_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer beginOffset;

    private final Integer endOffset;

    private final Boolean topAnswer;

    private final String type;

    private Highlight(BuilderImpl builder) {
        this.beginOffset = builder.beginOffset;
        this.endOffset = builder.endOffset;
        this.topAnswer = builder.topAnswer;
        this.type = builder.type;
    }

    /**
     * <p>
     * The zero-based location in the response string where the highlight starts.
     * </p>
     * 
     * @return The zero-based location in the response string where the highlight starts.
     */
    public final Integer beginOffset() {
        return beginOffset;
    }

    /**
     * <p>
     * The zero-based location in the response string where the highlight ends.
     * </p>
     * 
     * @return The zero-based location in the response string where the highlight ends.
     */
    public final Integer endOffset() {
        return endOffset;
    }

    /**
     * <p>
     * Indicates whether the response is the best response. True if this is the best response; otherwise, false.
     * </p>
     * 
     * @return Indicates whether the response is the best response. True if this is the best response; otherwise, false.
     */
    public final Boolean topAnswer() {
        return topAnswer;
    }

    /**
     * <p>
     * The highlight type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link HighlightType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The highlight type.
     * @see HighlightType
     */
    public final HighlightType type() {
        return HighlightType.fromValue(type);
    }

    /**
     * <p>
     * The highlight type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link HighlightType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The highlight type.
     * @see HighlightType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(beginOffset());
        hashCode = 31 * hashCode + Objects.hashCode(endOffset());
        hashCode = 31 * hashCode + Objects.hashCode(topAnswer());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Highlight)) {
            return false;
        }
        Highlight other = (Highlight) obj;
        return Objects.equals(beginOffset(), other.beginOffset()) && Objects.equals(endOffset(), other.endOffset())
                && Objects.equals(topAnswer(), other.topAnswer()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Highlight").add("BeginOffset", beginOffset()).add("EndOffset", endOffset())
                .add("TopAnswer", topAnswer()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BeginOffset":
            return Optional.ofNullable(clazz.cast(beginOffset()));
        case "EndOffset":
            return Optional.ofNullable(clazz.cast(endOffset()));
        case "TopAnswer":
            return Optional.ofNullable(clazz.cast(topAnswer()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Highlight, T> g) {
        return obj -> g.apply((Highlight) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Highlight> {
        /**
         * <p>
         * The zero-based location in the response string where the highlight starts.
         * </p>
         * 
         * @param beginOffset
         *        The zero-based location in the response string where the highlight starts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beginOffset(Integer beginOffset);

        /**
         * <p>
         * The zero-based location in the response string where the highlight ends.
         * </p>
         * 
         * @param endOffset
         *        The zero-based location in the response string where the highlight ends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endOffset(Integer endOffset);

        /**
         * <p>
         * Indicates whether the response is the best response. True if this is the best response; otherwise, false.
         * </p>
         * 
         * @param topAnswer
         *        Indicates whether the response is the best response. True if this is the best response; otherwise,
         *        false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topAnswer(Boolean topAnswer);

        /**
         * <p>
         * The highlight type.
         * </p>
         * 
         * @param type
         *        The highlight type.
         * @see HighlightType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HighlightType
         */
        Builder type(String type);

        /**
         * <p>
         * The highlight type.
         * </p>
         * 
         * @param type
         *        The highlight type.
         * @see HighlightType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HighlightType
         */
        Builder type(HighlightType type);
    }

    static final class BuilderImpl implements Builder {
        private Integer beginOffset;

        private Integer endOffset;

        private Boolean topAnswer;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Highlight model) {
            beginOffset(model.beginOffset);
            endOffset(model.endOffset);
            topAnswer(model.topAnswer);
            type(model.type);
        }

        public final Integer getBeginOffset() {
            return beginOffset;
        }

        public final void setBeginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
        }

        @Override
        @Transient
        public final Builder beginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
            return this;
        }

        public final Integer getEndOffset() {
            return endOffset;
        }

        public final void setEndOffset(Integer endOffset) {
            this.endOffset = endOffset;
        }

        @Override
        @Transient
        public final Builder endOffset(Integer endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public final Boolean getTopAnswer() {
            return topAnswer;
        }

        public final void setTopAnswer(Boolean topAnswer) {
            this.topAnswer = topAnswer;
        }

        @Override
        @Transient
        public final Builder topAnswer(Boolean topAnswer) {
            this.topAnswer = topAnswer;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(HighlightType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Highlight build() {
            return new Highlight(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
