/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutPrincipalMappingRequest extends KendraRequest implements
        ToCopyableBuilder<PutPrincipalMappingRequest.Builder, PutPrincipalMappingRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(PutPrincipalMappingRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSourceId").getter(getter(PutPrincipalMappingRequest::dataSourceId))
            .setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceId").build()).build();

    private static final SdkField<String> GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupId").getter(getter(PutPrincipalMappingRequest::groupId)).setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()).build();

    private static final SdkField<GroupMembers> GROUP_MEMBERS_FIELD = SdkField.<GroupMembers> builder(MarshallingType.SDK_POJO)
            .memberName("GroupMembers").getter(getter(PutPrincipalMappingRequest::groupMembers))
            .setter(setter(Builder::groupMembers)).constructor(GroupMembers::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupMembers").build()).build();

    private static final SdkField<Long> ORDERING_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("OrderingId").getter(getter(PutPrincipalMappingRequest::orderingId)).setter(setter(Builder::orderingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderingId").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(PutPrincipalMappingRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD,
            DATA_SOURCE_ID_FIELD, GROUP_ID_FIELD, GROUP_MEMBERS_FIELD, ORDERING_ID_FIELD, ROLE_ARN_FIELD));

    private final String indexId;

    private final String dataSourceId;

    private final String groupId;

    private final GroupMembers groupMembers;

    private final Long orderingId;

    private final String roleArn;

    private PutPrincipalMappingRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.dataSourceId = builder.dataSourceId;
        this.groupId = builder.groupId;
        this.groupMembers = builder.groupMembers;
        this.orderingId = builder.orderingId;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The identifier of the index you want to map users to their groups.
     * </p>
     * 
     * @return The identifier of the index you want to map users to their groups.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The identifier of the data source you want to map users to their groups.
     * </p>
     * <p>
     * This is useful if a group is tied to multiple data sources, but you only want the group to access documents of a
     * certain data source. For example, the groups "Research", "Engineering", and "Sales and Marketing" are all tied to
     * the company's documents stored in the data sources Confluence and Salesforce. However, "Sales and Marketing" team
     * only needs access to customer-related documents stored in Salesforce.
     * </p>
     * 
     * @return The identifier of the data source you want to map users to their groups.</p>
     *         <p>
     *         This is useful if a group is tied to multiple data sources, but you only want the group to access
     *         documents of a certain data source. For example, the groups "Research", "Engineering", and
     *         "Sales and Marketing" are all tied to the company's documents stored in the data sources Confluence and
     *         Salesforce. However, "Sales and Marketing" team only needs access to customer-related documents stored in
     *         Salesforce.
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * The identifier of the group you want to map its users to.
     * </p>
     * 
     * @return The identifier of the group you want to map its users to.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * <p>
     * The list that contains your users or sub groups that belong the same group.
     * </p>
     * <p>
     * For example, the group "Company" includes the user "CEO" and the sub groups "Research", "Engineering", and
     * "Sales and Marketing".
     * </p>
     * <p>
     * If you have more than 1000 users and/or sub groups for a single group, you need to provide the path to the S3
     * file that lists your users and sub groups for a group. Your sub groups can contain more than 1000 users, but the
     * list of sub groups that belong to a group (and/or users) must be no more than 1000.
     * </p>
     * 
     * @return The list that contains your users or sub groups that belong the same group.</p>
     *         <p>
     *         For example, the group "Company" includes the user "CEO" and the sub groups "Research", "Engineering",
     *         and "Sales and Marketing".
     *         </p>
     *         <p>
     *         If you have more than 1000 users and/or sub groups for a single group, you need to provide the path to
     *         the S3 file that lists your users and sub groups for a group. Your sub groups can contain more than 1000
     *         users, but the list of sub groups that belong to a group (and/or users) must be no more than 1000.
     */
    public final GroupMembers groupMembers() {
        return groupMembers;
    }

    /**
     * <p>
     * The timestamp identifier you specify to ensure Amazon Kendra does not override the latest <code>PUT</code> action
     * with previous actions. The highest number ID, which is the ordering ID, is the latest action you want to process
     * and apply on top of other actions with lower number IDs. This prevents previous actions with lower number IDs
     * from possibly overriding the latest action.
     * </p>
     * <p>
     * The ordering ID can be the UNIX time of the last update you made to a group members list. You would then provide
     * this list when calling <code>PutPrincipalMapping</code>. This ensures your <code>PUT</code> action for that
     * updated group with the latest members list doesn't get overwritten by earlier <code>PUT</code> actions for the
     * same group which are yet to be processed.
     * </p>
     * <p>
     * The default ordering ID is the current UNIX time in milliseconds that the action was received by Amazon Kendra.
     * </p>
     * 
     * @return The timestamp identifier you specify to ensure Amazon Kendra does not override the latest
     *         <code>PUT</code> action with previous actions. The highest number ID, which is the ordering ID, is the
     *         latest action you want to process and apply on top of other actions with lower number IDs. This prevents
     *         previous actions with lower number IDs from possibly overriding the latest action.</p>
     *         <p>
     *         The ordering ID can be the UNIX time of the last update you made to a group members list. You would then
     *         provide this list when calling <code>PutPrincipalMapping</code>. This ensures your <code>PUT</code>
     *         action for that updated group with the latest members list doesn't get overwritten by earlier
     *         <code>PUT</code> actions for the same group which are yet to be processed.
     *         </p>
     *         <p>
     *         The default ordering ID is the current UNIX time in milliseconds that the action was received by Amazon
     *         Kendra.
     */
    public final Long orderingId() {
        return orderingId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a role that has access to the S3 file that contains your list of users or sub
     * groups that belong to a group.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html#iam-roles-ds">IAM
     * roles for Amazon Kendra</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a role that has access to the S3 file that contains your list of users
     *         or sub groups that belong to a group.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html#iam-roles-ds">IAM roles for Amazon
     *         Kendra</a>.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(groupMembers());
        hashCode = 31 * hashCode + Objects.hashCode(orderingId());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutPrincipalMappingRequest)) {
            return false;
        }
        PutPrincipalMappingRequest other = (PutPrincipalMappingRequest) obj;
        return Objects.equals(indexId(), other.indexId()) && Objects.equals(dataSourceId(), other.dataSourceId())
                && Objects.equals(groupId(), other.groupId()) && Objects.equals(groupMembers(), other.groupMembers())
                && Objects.equals(orderingId(), other.orderingId()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutPrincipalMappingRequest").add("IndexId", indexId()).add("DataSourceId", dataSourceId())
                .add("GroupId", groupId()).add("GroupMembers", groupMembers()).add("OrderingId", orderingId())
                .add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "DataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "GroupMembers":
            return Optional.ofNullable(clazz.cast(groupMembers()));
        case "OrderingId":
            return Optional.ofNullable(clazz.cast(orderingId()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutPrincipalMappingRequest, T> g) {
        return obj -> g.apply((PutPrincipalMappingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutPrincipalMappingRequest> {
        /**
         * <p>
         * The identifier of the index you want to map users to their groups.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index you want to map users to their groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The identifier of the data source you want to map users to their groups.
         * </p>
         * <p>
         * This is useful if a group is tied to multiple data sources, but you only want the group to access documents
         * of a certain data source. For example, the groups "Research", "Engineering", and "Sales and Marketing" are
         * all tied to the company's documents stored in the data sources Confluence and Salesforce. However,
         * "Sales and Marketing" team only needs access to customer-related documents stored in Salesforce.
         * </p>
         * 
         * @param dataSourceId
         *        The identifier of the data source you want to map users to their groups.</p>
         *        <p>
         *        This is useful if a group is tied to multiple data sources, but you only want the group to access
         *        documents of a certain data source. For example, the groups "Research", "Engineering", and
         *        "Sales and Marketing" are all tied to the company's documents stored in the data sources Confluence
         *        and Salesforce. However, "Sales and Marketing" team only needs access to customer-related documents
         *        stored in Salesforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * The identifier of the group you want to map its users to.
         * </p>
         * 
         * @param groupId
         *        The identifier of the group you want to map its users to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * The list that contains your users or sub groups that belong the same group.
         * </p>
         * <p>
         * For example, the group "Company" includes the user "CEO" and the sub groups "Research", "Engineering", and
         * "Sales and Marketing".
         * </p>
         * <p>
         * If you have more than 1000 users and/or sub groups for a single group, you need to provide the path to the S3
         * file that lists your users and sub groups for a group. Your sub groups can contain more than 1000 users, but
         * the list of sub groups that belong to a group (and/or users) must be no more than 1000.
         * </p>
         * 
         * @param groupMembers
         *        The list that contains your users or sub groups that belong the same group.</p>
         *        <p>
         *        For example, the group "Company" includes the user "CEO" and the sub groups "Research", "Engineering",
         *        and "Sales and Marketing".
         *        </p>
         *        <p>
         *        If you have more than 1000 users and/or sub groups for a single group, you need to provide the path to
         *        the S3 file that lists your users and sub groups for a group. Your sub groups can contain more than
         *        1000 users, but the list of sub groups that belong to a group (and/or users) must be no more than
         *        1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupMembers(GroupMembers groupMembers);

        /**
         * <p>
         * The list that contains your users or sub groups that belong the same group.
         * </p>
         * <p>
         * For example, the group "Company" includes the user "CEO" and the sub groups "Research", "Engineering", and
         * "Sales and Marketing".
         * </p>
         * <p>
         * If you have more than 1000 users and/or sub groups for a single group, you need to provide the path to the S3
         * file that lists your users and sub groups for a group. Your sub groups can contain more than 1000 users, but
         * the list of sub groups that belong to a group (and/or users) must be no more than 1000.
         * </p>
         * This is a convenience that creates an instance of the {@link GroupMembers.Builder} avoiding the need to
         * create one manually via {@link GroupMembers#builder()}.
         *
         * When the {@link Consumer} completes, {@link GroupMembers.Builder#build()} is called immediately and its
         * result is passed to {@link #groupMembers(GroupMembers)}.
         * 
         * @param groupMembers
         *        a consumer that will call methods on {@link GroupMembers.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupMembers(GroupMembers)
         */
        default Builder groupMembers(Consumer<GroupMembers.Builder> groupMembers) {
            return groupMembers(GroupMembers.builder().applyMutation(groupMembers).build());
        }

        /**
         * <p>
         * The timestamp identifier you specify to ensure Amazon Kendra does not override the latest <code>PUT</code>
         * action with previous actions. The highest number ID, which is the ordering ID, is the latest action you want
         * to process and apply on top of other actions with lower number IDs. This prevents previous actions with lower
         * number IDs from possibly overriding the latest action.
         * </p>
         * <p>
         * The ordering ID can be the UNIX time of the last update you made to a group members list. You would then
         * provide this list when calling <code>PutPrincipalMapping</code>. This ensures your <code>PUT</code> action
         * for that updated group with the latest members list doesn't get overwritten by earlier <code>PUT</code>
         * actions for the same group which are yet to be processed.
         * </p>
         * <p>
         * The default ordering ID is the current UNIX time in milliseconds that the action was received by Amazon
         * Kendra.
         * </p>
         * 
         * @param orderingId
         *        The timestamp identifier you specify to ensure Amazon Kendra does not override the latest
         *        <code>PUT</code> action with previous actions. The highest number ID, which is the ordering ID, is the
         *        latest action you want to process and apply on top of other actions with lower number IDs. This
         *        prevents previous actions with lower number IDs from possibly overriding the latest action.</p>
         *        <p>
         *        The ordering ID can be the UNIX time of the last update you made to a group members list. You would
         *        then provide this list when calling <code>PutPrincipalMapping</code>. This ensures your
         *        <code>PUT</code> action for that updated group with the latest members list doesn't get overwritten by
         *        earlier <code>PUT</code> actions for the same group which are yet to be processed.
         *        </p>
         *        <p>
         *        The default ordering ID is the current UNIX time in milliseconds that the action was received by
         *        Amazon Kendra.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderingId(Long orderingId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a role that has access to the S3 file that contains your list of users or
         * sub groups that belong to a group.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html#iam-roles-ds">IAM roles for Amazon
         * Kendra</a>.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of a role that has access to the S3 file that contains your list of
         *        users or sub groups that belong to a group.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html#iam-roles-ds">IAM roles for Amazon
         *        Kendra</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String indexId;

        private String dataSourceId;

        private String groupId;

        private GroupMembers groupMembers;

        private Long orderingId;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PutPrincipalMappingRequest model) {
            super(model);
            indexId(model.indexId);
            dataSourceId(model.dataSourceId);
            groupId(model.groupId);
            groupMembers(model.groupMembers);
            orderingId(model.orderingId);
            roleArn(model.roleArn);
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        @Transient
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        @Transient
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        @Transient
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final GroupMembers.Builder getGroupMembers() {
            return groupMembers != null ? groupMembers.toBuilder() : null;
        }

        public final void setGroupMembers(GroupMembers.BuilderImpl groupMembers) {
            this.groupMembers = groupMembers != null ? groupMembers.build() : null;
        }

        @Override
        @Transient
        public final Builder groupMembers(GroupMembers groupMembers) {
            this.groupMembers = groupMembers;
            return this;
        }

        public final Long getOrderingId() {
            return orderingId;
        }

        public final void setOrderingId(Long orderingId) {
            this.orderingId = orderingId;
        }

        @Override
        @Transient
        public final Builder orderingId(Long orderingId) {
            this.orderingId = orderingId;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutPrincipalMappingRequest build() {
            return new PutPrincipalMappingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
