/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the status of documents submitted for indexing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Status implements SdkPojo, Serializable, ToCopyableBuilder<Status.Builder, Status> {
    private static final SdkField<String> DOCUMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentId").getter(getter(Status::documentId)).setter(setter(Builder::documentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentId").build()).build();

    private static final SdkField<String> DOCUMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentStatus").getter(getter(Status::documentStatusAsString)).setter(setter(Builder::documentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentStatus").build()).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureCode").getter(getter(Status::failureCode)).setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCode").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(Status::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_ID_FIELD,
            DOCUMENT_STATUS_FIELD, FAILURE_CODE_FIELD, FAILURE_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String documentId;

    private final String documentStatus;

    private final String failureCode;

    private final String failureReason;

    private Status(BuilderImpl builder) {
        this.documentId = builder.documentId;
        this.documentStatus = builder.documentStatus;
        this.failureCode = builder.failureCode;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * The unique identifier of the document.
     * </p>
     * 
     * @return The unique identifier of the document.
     */
    public final String documentId() {
        return documentId;
    }

    /**
     * <p>
     * The current status of a document.
     * </p>
     * <p>
     * If the document was submitted for deletion, the status is <code>NOT_FOUND</code> after the document is deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #documentStatus}
     * will return {@link DocumentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #documentStatusAsString}.
     * </p>
     * 
     * @return The current status of a document.</p>
     *         <p>
     *         If the document was submitted for deletion, the status is <code>NOT_FOUND</code> after the document is
     *         deleted.
     * @see DocumentStatus
     */
    public final DocumentStatus documentStatus() {
        return DocumentStatus.fromValue(documentStatus);
    }

    /**
     * <p>
     * The current status of a document.
     * </p>
     * <p>
     * If the document was submitted for deletion, the status is <code>NOT_FOUND</code> after the document is deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #documentStatus}
     * will return {@link DocumentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #documentStatusAsString}.
     * </p>
     * 
     * @return The current status of a document.</p>
     *         <p>
     *         If the document was submitted for deletion, the status is <code>NOT_FOUND</code> after the document is
     *         deleted.
     * @see DocumentStatus
     */
    public final String documentStatusAsString() {
        return documentStatus;
    }

    /**
     * <p>
     * Indicates the source of the error.
     * </p>
     * 
     * @return Indicates the source of the error.
     */
    public final String failureCode() {
        return failureCode;
    }

    /**
     * <p>
     * Provides detailed information about why the document couldn't be indexed. Use this information to correct the
     * error before you resubmit the document for indexing.
     * </p>
     * 
     * @return Provides detailed information about why the document couldn't be indexed. Use this information to correct
     *         the error before you resubmit the document for indexing.
     */
    public final String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(documentId());
        hashCode = 31 * hashCode + Objects.hashCode(documentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Status)) {
            return false;
        }
        Status other = (Status) obj;
        return Objects.equals(documentId(), other.documentId())
                && Objects.equals(documentStatusAsString(), other.documentStatusAsString())
                && Objects.equals(failureCode(), other.failureCode()) && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Status").add("DocumentId", documentId()).add("DocumentStatus", documentStatusAsString())
                .add("FailureCode", failureCode()).add("FailureReason", failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentId":
            return Optional.ofNullable(clazz.cast(documentId()));
        case "DocumentStatus":
            return Optional.ofNullable(clazz.cast(documentStatusAsString()));
        case "FailureCode":
            return Optional.ofNullable(clazz.cast(failureCode()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Status, T> g) {
        return obj -> g.apply((Status) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Status> {
        /**
         * <p>
         * The unique identifier of the document.
         * </p>
         * 
         * @param documentId
         *        The unique identifier of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentId(String documentId);

        /**
         * <p>
         * The current status of a document.
         * </p>
         * <p>
         * If the document was submitted for deletion, the status is <code>NOT_FOUND</code> after the document is
         * deleted.
         * </p>
         * 
         * @param documentStatus
         *        The current status of a document.</p>
         *        <p>
         *        If the document was submitted for deletion, the status is <code>NOT_FOUND</code> after the document is
         *        deleted.
         * @see DocumentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentStatus
         */
        Builder documentStatus(String documentStatus);

        /**
         * <p>
         * The current status of a document.
         * </p>
         * <p>
         * If the document was submitted for deletion, the status is <code>NOT_FOUND</code> after the document is
         * deleted.
         * </p>
         * 
         * @param documentStatus
         *        The current status of a document.</p>
         *        <p>
         *        If the document was submitted for deletion, the status is <code>NOT_FOUND</code> after the document is
         *        deleted.
         * @see DocumentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentStatus
         */
        Builder documentStatus(DocumentStatus documentStatus);

        /**
         * <p>
         * Indicates the source of the error.
         * </p>
         * 
         * @param failureCode
         *        Indicates the source of the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * Provides detailed information about why the document couldn't be indexed. Use this information to correct the
         * error before you resubmit the document for indexing.
         * </p>
         * 
         * @param failureReason
         *        Provides detailed information about why the document couldn't be indexed. Use this information to
         *        correct the error before you resubmit the document for indexing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl implements Builder {
        private String documentId;

        private String documentStatus;

        private String failureCode;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(Status model) {
            documentId(model.documentId);
            documentStatus(model.documentStatus);
            failureCode(model.failureCode);
            failureReason(model.failureReason);
        }

        public final String getDocumentId() {
            return documentId;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        @Override
        @Transient
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final String getDocumentStatus() {
            return documentStatus;
        }

        public final void setDocumentStatus(String documentStatus) {
            this.documentStatus = documentStatus;
        }

        @Override
        @Transient
        public final Builder documentStatus(String documentStatus) {
            this.documentStatus = documentStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder documentStatus(DocumentStatus documentStatus) {
            this.documentStatus(documentStatus == null ? null : documentStatus.toString());
            return this;
        }

        public final String getFailureCode() {
            return failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        @Transient
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        @Transient
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public Status build() {
            return new Status(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
