/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The warning code and message that explains a problem with a query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Warning implements SdkPojo, Serializable, ToCopyableBuilder<Warning.Builder, Warning> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(Warning::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Code")
            .getter(getter(Warning::codeAsString)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD, CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String message;

    private final String code;

    private Warning(BuilderImpl builder) {
        this.message = builder.message;
        this.code = builder.code;
    }

    /**
     * <p>
     * The message that explains the problem with the query.
     * </p>
     * 
     * @return The message that explains the problem with the query.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The code used to show the type of warning for the query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link WarningCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return The code used to show the type of warning for the query.
     * @see WarningCode
     */
    public final WarningCode code() {
        return WarningCode.fromValue(code);
    }

    /**
     * <p>
     * The code used to show the type of warning for the query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link WarningCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return The code used to show the type of warning for the query.
     * @see WarningCode
     */
    public final String codeAsString() {
        return code;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(codeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Warning)) {
            return false;
        }
        Warning other = (Warning) obj;
        return Objects.equals(message(), other.message()) && Objects.equals(codeAsString(), other.codeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Warning").add("Message", message()).add("Code", codeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "Code":
            return Optional.ofNullable(clazz.cast(codeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Warning, T> g) {
        return obj -> g.apply((Warning) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Warning> {
        /**
         * <p>
         * The message that explains the problem with the query.
         * </p>
         * 
         * @param message
         *        The message that explains the problem with the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The code used to show the type of warning for the query.
         * </p>
         * 
         * @param code
         *        The code used to show the type of warning for the query.
         * @see WarningCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WarningCode
         */
        Builder code(String code);

        /**
         * <p>
         * The code used to show the type of warning for the query.
         * </p>
         * 
         * @param code
         *        The code used to show the type of warning for the query.
         * @see WarningCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WarningCode
         */
        Builder code(WarningCode code);
    }

    static final class BuilderImpl implements Builder {
        private String message;

        private String code;

        private BuilderImpl() {
        }

        private BuilderImpl(Warning model) {
            message(model.message);
            code(model.code);
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        @Transient
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        @Transient
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        @Transient
        public final Builder code(WarningCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        @Override
        public Warning build() {
            return new Warning(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
