/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.SeedUrlConfiguration;
import software.amazon.awssdk.services.kendra.model.SiteMapsConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Urls
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Urls> {
    private static final SdkField<SeedUrlConfiguration> SEED_URL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SeedUrlConfiguration").getter(Urls.getter(Urls::seedUrlConfiguration)).setter(Urls.setter(Builder::seedUrlConfiguration)).constructor(SeedUrlConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeedUrlConfiguration").build()}).build();
    private static final SdkField<SiteMapsConfiguration> SITE_MAPS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SiteMapsConfiguration").getter(Urls.getter(Urls::siteMapsConfiguration)).setter(Urls.setter(Builder::siteMapsConfiguration)).constructor(SiteMapsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SiteMapsConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEED_URL_CONFIGURATION_FIELD, SITE_MAPS_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final SeedUrlConfiguration seedUrlConfiguration;
    private final SiteMapsConfiguration siteMapsConfiguration;

    private Urls(BuilderImpl builder) {
        this.seedUrlConfiguration = builder.seedUrlConfiguration;
        this.siteMapsConfiguration = builder.siteMapsConfiguration;
    }

    public final SeedUrlConfiguration seedUrlConfiguration() {
        return this.seedUrlConfiguration;
    }

    public final SiteMapsConfiguration siteMapsConfiguration() {
        return this.siteMapsConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.seedUrlConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.siteMapsConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Urls)) {
            return false;
        }
        Urls other = (Urls)obj;
        return Objects.equals(this.seedUrlConfiguration(), other.seedUrlConfiguration()) && Objects.equals(this.siteMapsConfiguration(), other.siteMapsConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"Urls").add("SeedUrlConfiguration", (Object)this.seedUrlConfiguration()).add("SiteMapsConfiguration", (Object)this.siteMapsConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SeedUrlConfiguration": {
                return Optional.ofNullable(clazz.cast(this.seedUrlConfiguration()));
            }
            case "SiteMapsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.siteMapsConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Urls, T> g) {
        return obj -> g.apply((Urls)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SeedUrlConfiguration seedUrlConfiguration;
        private SiteMapsConfiguration siteMapsConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Urls model) {
            this.seedUrlConfiguration(model.seedUrlConfiguration);
            this.siteMapsConfiguration(model.siteMapsConfiguration);
        }

        public final SeedUrlConfiguration.Builder getSeedUrlConfiguration() {
            return this.seedUrlConfiguration != null ? this.seedUrlConfiguration.toBuilder() : null;
        }

        public final void setSeedUrlConfiguration(SeedUrlConfiguration.BuilderImpl seedUrlConfiguration) {
            this.seedUrlConfiguration = seedUrlConfiguration != null ? seedUrlConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder seedUrlConfiguration(SeedUrlConfiguration seedUrlConfiguration) {
            this.seedUrlConfiguration = seedUrlConfiguration;
            return this;
        }

        public final SiteMapsConfiguration.Builder getSiteMapsConfiguration() {
            return this.siteMapsConfiguration != null ? this.siteMapsConfiguration.toBuilder() : null;
        }

        public final void setSiteMapsConfiguration(SiteMapsConfiguration.BuilderImpl siteMapsConfiguration) {
            this.siteMapsConfiguration = siteMapsConfiguration != null ? siteMapsConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder siteMapsConfiguration(SiteMapsConfiguration siteMapsConfiguration) {
            this.siteMapsConfiguration = siteMapsConfiguration;
            return this;
        }

        public Urls build() {
            return new Urls(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Urls> {
        public Builder seedUrlConfiguration(SeedUrlConfiguration var1);

        default public Builder seedUrlConfiguration(Consumer<SeedUrlConfiguration.Builder> seedUrlConfiguration) {
            return this.seedUrlConfiguration((SeedUrlConfiguration)((SeedUrlConfiguration.Builder)SeedUrlConfiguration.builder().applyMutation(seedUrlConfiguration)).build());
        }

        public Builder siteMapsConfiguration(SiteMapsConfiguration var1);

        default public Builder siteMapsConfiguration(Consumer<SiteMapsConfiguration.Builder> siteMapsConfiguration) {
            return this.siteMapsConfiguration((SiteMapsConfiguration)((SiteMapsConfiguration.Builder)SiteMapsConfiguration.builder().applyMutation(siteMapsConfiguration)).build());
        }
    }
}

