/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines configuration for syncing a Salesforce chatter feed. The contents of the object comes from the Salesforce
 * FeedItem table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SalesforceChatterFeedConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SalesforceChatterFeedConfiguration.Builder, SalesforceChatterFeedConfiguration> {
    private static final SdkField<String> DOCUMENT_DATA_FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentDataFieldName").getter(getter(SalesforceChatterFeedConfiguration::documentDataFieldName))
            .setter(setter(Builder::documentDataFieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentDataFieldName").build())
            .build();

    private static final SdkField<String> DOCUMENT_TITLE_FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentTitleFieldName").getter(getter(SalesforceChatterFeedConfiguration::documentTitleFieldName))
            .setter(setter(Builder::documentTitleFieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentTitleFieldName").build())
            .build();

    private static final SdkField<List<DataSourceToIndexFieldMapping>> FIELD_MAPPINGS_FIELD = SdkField
            .<List<DataSourceToIndexFieldMapping>> builder(MarshallingType.LIST)
            .memberName("FieldMappings")
            .getter(getter(SalesforceChatterFeedConfiguration::fieldMappings))
            .setter(setter(Builder::fieldMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSourceToIndexFieldMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSourceToIndexFieldMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INCLUDE_FILTER_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IncludeFilterTypes")
            .getter(getter(SalesforceChatterFeedConfiguration::includeFilterTypesAsStrings))
            .setter(setter(Builder::includeFilterTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeFilterTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DOCUMENT_DATA_FIELD_NAME_FIELD, DOCUMENT_TITLE_FIELD_NAME_FIELD, FIELD_MAPPINGS_FIELD, INCLUDE_FILTER_TYPES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String documentDataFieldName;

    private final String documentTitleFieldName;

    private final List<DataSourceToIndexFieldMapping> fieldMappings;

    private final List<String> includeFilterTypes;

    private SalesforceChatterFeedConfiguration(BuilderImpl builder) {
        this.documentDataFieldName = builder.documentDataFieldName;
        this.documentTitleFieldName = builder.documentTitleFieldName;
        this.fieldMappings = builder.fieldMappings;
        this.includeFilterTypes = builder.includeFilterTypes;
    }

    /**
     * <p>
     * The name of the column in the Salesforce FeedItem table that contains the content to index. Typically this is the
     * <code>Body</code> column.
     * </p>
     * 
     * @return The name of the column in the Salesforce FeedItem table that contains the content to index. Typically
     *         this is the <code>Body</code> column.
     */
    public final String documentDataFieldName() {
        return documentDataFieldName;
    }

    /**
     * <p>
     * The name of the column in the Salesforce FeedItem table that contains the title of the document. This is
     * typically the <code>Title</code> column.
     * </p>
     * 
     * @return The name of the column in the Salesforce FeedItem table that contains the title of the document. This is
     *         typically the <code>Title</code> column.
     */
    public final String documentTitleFieldName() {
        return documentTitleFieldName;
    }

    /**
     * Returns true if the FieldMappings property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFieldMappings() {
        return fieldMappings != null && !(fieldMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Maps fields from a Salesforce chatter feed into Amazon Kendra index fields.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFieldMappings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Maps fields from a Salesforce chatter feed into Amazon Kendra index fields.
     */
    public final List<DataSourceToIndexFieldMapping> fieldMappings() {
        return fieldMappings;
    }

    /**
     * <p>
     * Filters the documents in the feed based on status of the user. When you specify <code>ACTIVE_USERS</code> only
     * documents from users who have an active account are indexed. When you specify <code>STANDARD_USER</code> only
     * documents for Salesforce standard users are documented. You can specify both.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIncludeFilterTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Filters the documents in the feed based on status of the user. When you specify <code>ACTIVE_USERS</code>
     *         only documents from users who have an active account are indexed. When you specify
     *         <code>STANDARD_USER</code> only documents for Salesforce standard users are documented. You can specify
     *         both.
     */
    public final List<SalesforceChatterFeedIncludeFilterType> includeFilterTypes() {
        return SalesforceChatterFeedIncludeFilterTypesCopier.copyStringToEnum(includeFilterTypes);
    }

    /**
     * Returns true if the IncludeFilterTypes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasIncludeFilterTypes() {
        return includeFilterTypes != null && !(includeFilterTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the documents in the feed based on status of the user. When you specify <code>ACTIVE_USERS</code> only
     * documents from users who have an active account are indexed. When you specify <code>STANDARD_USER</code> only
     * documents for Salesforce standard users are documented. You can specify both.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIncludeFilterTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Filters the documents in the feed based on status of the user. When you specify <code>ACTIVE_USERS</code>
     *         only documents from users who have an active account are indexed. When you specify
     *         <code>STANDARD_USER</code> only documents for Salesforce standard users are documented. You can specify
     *         both.
     */
    public final List<String> includeFilterTypesAsStrings() {
        return includeFilterTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(documentDataFieldName());
        hashCode = 31 * hashCode + Objects.hashCode(documentTitleFieldName());
        hashCode = 31 * hashCode + Objects.hashCode(hasFieldMappings() ? fieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIncludeFilterTypes() ? includeFilterTypesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceChatterFeedConfiguration)) {
            return false;
        }
        SalesforceChatterFeedConfiguration other = (SalesforceChatterFeedConfiguration) obj;
        return Objects.equals(documentDataFieldName(), other.documentDataFieldName())
                && Objects.equals(documentTitleFieldName(), other.documentTitleFieldName())
                && hasFieldMappings() == other.hasFieldMappings() && Objects.equals(fieldMappings(), other.fieldMappings())
                && hasIncludeFilterTypes() == other.hasIncludeFilterTypes()
                && Objects.equals(includeFilterTypesAsStrings(), other.includeFilterTypesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SalesforceChatterFeedConfiguration").add("DocumentDataFieldName", documentDataFieldName())
                .add("DocumentTitleFieldName", documentTitleFieldName())
                .add("FieldMappings", hasFieldMappings() ? fieldMappings() : null)
                .add("IncludeFilterTypes", hasIncludeFilterTypes() ? includeFilterTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentDataFieldName":
            return Optional.ofNullable(clazz.cast(documentDataFieldName()));
        case "DocumentTitleFieldName":
            return Optional.ofNullable(clazz.cast(documentTitleFieldName()));
        case "FieldMappings":
            return Optional.ofNullable(clazz.cast(fieldMappings()));
        case "IncludeFilterTypes":
            return Optional.ofNullable(clazz.cast(includeFilterTypesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SalesforceChatterFeedConfiguration, T> g) {
        return obj -> g.apply((SalesforceChatterFeedConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SalesforceChatterFeedConfiguration> {
        /**
         * <p>
         * The name of the column in the Salesforce FeedItem table that contains the content to index. Typically this is
         * the <code>Body</code> column.
         * </p>
         * 
         * @param documentDataFieldName
         *        The name of the column in the Salesforce FeedItem table that contains the content to index. Typically
         *        this is the <code>Body</code> column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentDataFieldName(String documentDataFieldName);

        /**
         * <p>
         * The name of the column in the Salesforce FeedItem table that contains the title of the document. This is
         * typically the <code>Title</code> column.
         * </p>
         * 
         * @param documentTitleFieldName
         *        The name of the column in the Salesforce FeedItem table that contains the title of the document. This
         *        is typically the <code>Title</code> column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentTitleFieldName(String documentTitleFieldName);

        /**
         * <p>
         * Maps fields from a Salesforce chatter feed into Amazon Kendra index fields.
         * </p>
         * 
         * @param fieldMappings
         *        Maps fields from a Salesforce chatter feed into Amazon Kendra index fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings);

        /**
         * <p>
         * Maps fields from a Salesforce chatter feed into Amazon Kendra index fields.
         * </p>
         * 
         * @param fieldMappings
         *        Maps fields from a Salesforce chatter feed into Amazon Kendra index fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldMappings(DataSourceToIndexFieldMapping... fieldMappings);

        /**
         * <p>
         * Maps fields from a Salesforce chatter feed into Amazon Kendra index fields.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DataSourceToIndexFieldMapping>.Builder}
         * avoiding the need to create one manually via {@link List<DataSourceToIndexFieldMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DataSourceToIndexFieldMapping>.Builder#build()} is called
         * immediately and its result is passed to {@link #fieldMappings(List<DataSourceToIndexFieldMapping>)}.
         * 
         * @param fieldMappings
         *        a consumer that will call methods on {@link List<DataSourceToIndexFieldMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldMappings(List<DataSourceToIndexFieldMapping>)
         */
        Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder>... fieldMappings);

        /**
         * <p>
         * Filters the documents in the feed based on status of the user. When you specify <code>ACTIVE_USERS</code>
         * only documents from users who have an active account are indexed. When you specify <code>STANDARD_USER</code>
         * only documents for Salesforce standard users are documented. You can specify both.
         * </p>
         * 
         * @param includeFilterTypes
         *        Filters the documents in the feed based on status of the user. When you specify
         *        <code>ACTIVE_USERS</code> only documents from users who have an active account are indexed. When you
         *        specify <code>STANDARD_USER</code> only documents for Salesforce standard users are documented. You
         *        can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeFilterTypesWithStrings(Collection<String> includeFilterTypes);

        /**
         * <p>
         * Filters the documents in the feed based on status of the user. When you specify <code>ACTIVE_USERS</code>
         * only documents from users who have an active account are indexed. When you specify <code>STANDARD_USER</code>
         * only documents for Salesforce standard users are documented. You can specify both.
         * </p>
         * 
         * @param includeFilterTypes
         *        Filters the documents in the feed based on status of the user. When you specify
         *        <code>ACTIVE_USERS</code> only documents from users who have an active account are indexed. When you
         *        specify <code>STANDARD_USER</code> only documents for Salesforce standard users are documented. You
         *        can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeFilterTypesWithStrings(String... includeFilterTypes);

        /**
         * <p>
         * Filters the documents in the feed based on status of the user. When you specify <code>ACTIVE_USERS</code>
         * only documents from users who have an active account are indexed. When you specify <code>STANDARD_USER</code>
         * only documents for Salesforce standard users are documented. You can specify both.
         * </p>
         * 
         * @param includeFilterTypes
         *        Filters the documents in the feed based on status of the user. When you specify
         *        <code>ACTIVE_USERS</code> only documents from users who have an active account are indexed. When you
         *        specify <code>STANDARD_USER</code> only documents for Salesforce standard users are documented. You
         *        can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeFilterTypes(Collection<SalesforceChatterFeedIncludeFilterType> includeFilterTypes);

        /**
         * <p>
         * Filters the documents in the feed based on status of the user. When you specify <code>ACTIVE_USERS</code>
         * only documents from users who have an active account are indexed. When you specify <code>STANDARD_USER</code>
         * only documents for Salesforce standard users are documented. You can specify both.
         * </p>
         * 
         * @param includeFilterTypes
         *        Filters the documents in the feed based on status of the user. When you specify
         *        <code>ACTIVE_USERS</code> only documents from users who have an active account are indexed. When you
         *        specify <code>STANDARD_USER</code> only documents for Salesforce standard users are documented. You
         *        can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeFilterTypes(SalesforceChatterFeedIncludeFilterType... includeFilterTypes);
    }

    static final class BuilderImpl implements Builder {
        private String documentDataFieldName;

        private String documentTitleFieldName;

        private List<DataSourceToIndexFieldMapping> fieldMappings = DefaultSdkAutoConstructList.getInstance();

        private List<String> includeFilterTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SalesforceChatterFeedConfiguration model) {
            documentDataFieldName(model.documentDataFieldName);
            documentTitleFieldName(model.documentTitleFieldName);
            fieldMappings(model.fieldMappings);
            includeFilterTypesWithStrings(model.includeFilterTypes);
        }

        public final String getDocumentDataFieldName() {
            return documentDataFieldName;
        }

        public final void setDocumentDataFieldName(String documentDataFieldName) {
            this.documentDataFieldName = documentDataFieldName;
        }

        @Override
        @Transient
        public final Builder documentDataFieldName(String documentDataFieldName) {
            this.documentDataFieldName = documentDataFieldName;
            return this;
        }

        public final String getDocumentTitleFieldName() {
            return documentTitleFieldName;
        }

        public final void setDocumentTitleFieldName(String documentTitleFieldName) {
            this.documentTitleFieldName = documentTitleFieldName;
        }

        @Override
        @Transient
        public final Builder documentTitleFieldName(String documentTitleFieldName) {
            this.documentTitleFieldName = documentTitleFieldName;
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier
                    .copyToBuilder(this.fieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(fieldMappings);
        }

        @Override
        @Transient
        public final Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copy(fieldMappings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder fieldMappings(DataSourceToIndexFieldMapping... fieldMappings) {
            fieldMappings(Arrays.asList(fieldMappings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder>... fieldMappings) {
            fieldMappings(Stream.of(fieldMappings).map(c -> DataSourceToIndexFieldMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getIncludeFilterTypes() {
            if (includeFilterTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return includeFilterTypes;
        }

        public final void setIncludeFilterTypes(Collection<String> includeFilterTypes) {
            this.includeFilterTypes = SalesforceChatterFeedIncludeFilterTypesCopier.copy(includeFilterTypes);
        }

        @Override
        @Transient
        public final Builder includeFilterTypesWithStrings(Collection<String> includeFilterTypes) {
            this.includeFilterTypes = SalesforceChatterFeedIncludeFilterTypesCopier.copy(includeFilterTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder includeFilterTypesWithStrings(String... includeFilterTypes) {
            includeFilterTypesWithStrings(Arrays.asList(includeFilterTypes));
            return this;
        }

        @Override
        @Transient
        public final Builder includeFilterTypes(Collection<SalesforceChatterFeedIncludeFilterType> includeFilterTypes) {
            this.includeFilterTypes = SalesforceChatterFeedIncludeFilterTypesCopier.copyEnumToString(includeFilterTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder includeFilterTypes(SalesforceChatterFeedIncludeFilterType... includeFilterTypes) {
            includeFilterTypes(Arrays.asList(includeFilterTypes));
            return this;
        }

        @Override
        public SalesforceChatterFeedConfiguration build() {
            return new SalesforceChatterFeedConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
