/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configuration information for your Amazon Kendra experience. This includes the data source IDs and/or
 * FAQ IDs, and user or group information to grant access to your Amazon Kendra experience.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExperienceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ExperienceConfiguration.Builder, ExperienceConfiguration> {
    private static final SdkField<ContentSourceConfiguration> CONTENT_SOURCE_CONFIGURATION_FIELD = SdkField
            .<ContentSourceConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ContentSourceConfiguration")
            .getter(getter(ExperienceConfiguration::contentSourceConfiguration))
            .setter(setter(Builder::contentSourceConfiguration))
            .constructor(ContentSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentSourceConfiguration").build())
            .build();

    private static final SdkField<UserIdentityConfiguration> USER_IDENTITY_CONFIGURATION_FIELD = SdkField
            .<UserIdentityConfiguration> builder(MarshallingType.SDK_POJO).memberName("UserIdentityConfiguration")
            .getter(getter(ExperienceConfiguration::userIdentityConfiguration))
            .setter(setter(Builder::userIdentityConfiguration)).constructor(UserIdentityConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserIdentityConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONTENT_SOURCE_CONFIGURATION_FIELD, USER_IDENTITY_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final ContentSourceConfiguration contentSourceConfiguration;

    private final UserIdentityConfiguration userIdentityConfiguration;

    private ExperienceConfiguration(BuilderImpl builder) {
        this.contentSourceConfiguration = builder.contentSourceConfiguration;
        this.userIdentityConfiguration = builder.userIdentityConfiguration;
    }

    /**
     * <p>
     * The identifiers of your data sources and FAQs. Or, you can specify that you want to use documents indexed via the
     * <code>BatchPutDocument</code> API. This is the content you want to use for your Amazon Kendra experience.
     * </p>
     * 
     * @return The identifiers of your data sources and FAQs. Or, you can specify that you want to use documents indexed
     *         via the <code>BatchPutDocument</code> API. This is the content you want to use for your Amazon Kendra
     *         experience.
     */
    public final ContentSourceConfiguration contentSourceConfiguration() {
        return contentSourceConfiguration;
    }

    /**
     * <p>
     * The Amazon Web Services SSO field name that contains the identifiers of your users, such as their emails.
     * </p>
     * 
     * @return The Amazon Web Services SSO field name that contains the identifiers of your users, such as their emails.
     */
    public final UserIdentityConfiguration userIdentityConfiguration() {
        return userIdentityConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contentSourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(userIdentityConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperienceConfiguration)) {
            return false;
        }
        ExperienceConfiguration other = (ExperienceConfiguration) obj;
        return Objects.equals(contentSourceConfiguration(), other.contentSourceConfiguration())
                && Objects.equals(userIdentityConfiguration(), other.userIdentityConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExperienceConfiguration").add("ContentSourceConfiguration", contentSourceConfiguration())
                .add("UserIdentityConfiguration", userIdentityConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContentSourceConfiguration":
            return Optional.ofNullable(clazz.cast(contentSourceConfiguration()));
        case "UserIdentityConfiguration":
            return Optional.ofNullable(clazz.cast(userIdentityConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExperienceConfiguration, T> g) {
        return obj -> g.apply((ExperienceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExperienceConfiguration> {
        /**
         * <p>
         * The identifiers of your data sources and FAQs. Or, you can specify that you want to use documents indexed via
         * the <code>BatchPutDocument</code> API. This is the content you want to use for your Amazon Kendra experience.
         * </p>
         * 
         * @param contentSourceConfiguration
         *        The identifiers of your data sources and FAQs. Or, you can specify that you want to use documents
         *        indexed via the <code>BatchPutDocument</code> API. This is the content you want to use for your Amazon
         *        Kendra experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentSourceConfiguration(ContentSourceConfiguration contentSourceConfiguration);

        /**
         * <p>
         * The identifiers of your data sources and FAQs. Or, you can specify that you want to use documents indexed via
         * the <code>BatchPutDocument</code> API. This is the content you want to use for your Amazon Kendra experience.
         * </p>
         * This is a convenience that creates an instance of the {@link ContentSourceConfiguration.Builder} avoiding the
         * need to create one manually via {@link ContentSourceConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContentSourceConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #contentSourceConfiguration(ContentSourceConfiguration)}.
         * 
         * @param contentSourceConfiguration
         *        a consumer that will call methods on {@link ContentSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentSourceConfiguration(ContentSourceConfiguration)
         */
        default Builder contentSourceConfiguration(Consumer<ContentSourceConfiguration.Builder> contentSourceConfiguration) {
            return contentSourceConfiguration(ContentSourceConfiguration.builder().applyMutation(contentSourceConfiguration)
                    .build());
        }

        /**
         * <p>
         * The Amazon Web Services SSO field name that contains the identifiers of your users, such as their emails.
         * </p>
         * 
         * @param userIdentityConfiguration
         *        The Amazon Web Services SSO field name that contains the identifiers of your users, such as their
         *        emails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIdentityConfiguration(UserIdentityConfiguration userIdentityConfiguration);

        /**
         * <p>
         * The Amazon Web Services SSO field name that contains the identifiers of your users, such as their emails.
         * </p>
         * This is a convenience that creates an instance of the {@link UserIdentityConfiguration.Builder} avoiding the
         * need to create one manually via {@link UserIdentityConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserIdentityConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #userIdentityConfiguration(UserIdentityConfiguration)}.
         * 
         * @param userIdentityConfiguration
         *        a consumer that will call methods on {@link UserIdentityConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userIdentityConfiguration(UserIdentityConfiguration)
         */
        default Builder userIdentityConfiguration(Consumer<UserIdentityConfiguration.Builder> userIdentityConfiguration) {
            return userIdentityConfiguration(UserIdentityConfiguration.builder().applyMutation(userIdentityConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ContentSourceConfiguration contentSourceConfiguration;

        private UserIdentityConfiguration userIdentityConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ExperienceConfiguration model) {
            contentSourceConfiguration(model.contentSourceConfiguration);
            userIdentityConfiguration(model.userIdentityConfiguration);
        }

        public final ContentSourceConfiguration.Builder getContentSourceConfiguration() {
            return contentSourceConfiguration != null ? contentSourceConfiguration.toBuilder() : null;
        }

        public final void setContentSourceConfiguration(ContentSourceConfiguration.BuilderImpl contentSourceConfiguration) {
            this.contentSourceConfiguration = contentSourceConfiguration != null ? contentSourceConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder contentSourceConfiguration(ContentSourceConfiguration contentSourceConfiguration) {
            this.contentSourceConfiguration = contentSourceConfiguration;
            return this;
        }

        public final UserIdentityConfiguration.Builder getUserIdentityConfiguration() {
            return userIdentityConfiguration != null ? userIdentityConfiguration.toBuilder() : null;
        }

        public final void setUserIdentityConfiguration(UserIdentityConfiguration.BuilderImpl userIdentityConfiguration) {
            this.userIdentityConfiguration = userIdentityConfiguration != null ? userIdentityConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder userIdentityConfiguration(UserIdentityConfiguration userIdentityConfiguration) {
            this.userIdentityConfiguration = userIdentityConfiguration;
            return this;
        }

        @Override
        public ExperienceConfiguration build() {
            return new ExperienceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
