/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration information for the JSON token type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JsonTokenTypeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<JsonTokenTypeConfiguration.Builder, JsonTokenTypeConfiguration> {
    private static final SdkField<String> USER_NAME_ATTRIBUTE_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserNameAttributeField").getter(getter(JsonTokenTypeConfiguration::userNameAttributeField))
            .setter(setter(Builder::userNameAttributeField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserNameAttributeField").build())
            .build();

    private static final SdkField<String> GROUP_ATTRIBUTE_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupAttributeField").getter(getter(JsonTokenTypeConfiguration::groupAttributeField))
            .setter(setter(Builder::groupAttributeField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupAttributeField").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            USER_NAME_ATTRIBUTE_FIELD_FIELD, GROUP_ATTRIBUTE_FIELD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userNameAttributeField;

    private final String groupAttributeField;

    private JsonTokenTypeConfiguration(BuilderImpl builder) {
        this.userNameAttributeField = builder.userNameAttributeField;
        this.groupAttributeField = builder.groupAttributeField;
    }

    /**
     * <p>
     * The user name attribute field.
     * </p>
     * 
     * @return The user name attribute field.
     */
    public final String userNameAttributeField() {
        return userNameAttributeField;
    }

    /**
     * <p>
     * The group attribute field.
     * </p>
     * 
     * @return The group attribute field.
     */
    public final String groupAttributeField() {
        return groupAttributeField;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userNameAttributeField());
        hashCode = 31 * hashCode + Objects.hashCode(groupAttributeField());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JsonTokenTypeConfiguration)) {
            return false;
        }
        JsonTokenTypeConfiguration other = (JsonTokenTypeConfiguration) obj;
        return Objects.equals(userNameAttributeField(), other.userNameAttributeField())
                && Objects.equals(groupAttributeField(), other.groupAttributeField());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JsonTokenTypeConfiguration").add("UserNameAttributeField", userNameAttributeField())
                .add("GroupAttributeField", groupAttributeField()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserNameAttributeField":
            return Optional.ofNullable(clazz.cast(userNameAttributeField()));
        case "GroupAttributeField":
            return Optional.ofNullable(clazz.cast(groupAttributeField()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JsonTokenTypeConfiguration, T> g) {
        return obj -> g.apply((JsonTokenTypeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JsonTokenTypeConfiguration> {
        /**
         * <p>
         * The user name attribute field.
         * </p>
         * 
         * @param userNameAttributeField
         *        The user name attribute field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userNameAttributeField(String userNameAttributeField);

        /**
         * <p>
         * The group attribute field.
         * </p>
         * 
         * @param groupAttributeField
         *        The group attribute field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupAttributeField(String groupAttributeField);
    }

    static final class BuilderImpl implements Builder {
        private String userNameAttributeField;

        private String groupAttributeField;

        private BuilderImpl() {
        }

        private BuilderImpl(JsonTokenTypeConfiguration model) {
            userNameAttributeField(model.userNameAttributeField);
            groupAttributeField(model.groupAttributeField);
        }

        public final String getUserNameAttributeField() {
            return userNameAttributeField;
        }

        public final void setUserNameAttributeField(String userNameAttributeField) {
            this.userNameAttributeField = userNameAttributeField;
        }

        @Override
        @Transient
        public final Builder userNameAttributeField(String userNameAttributeField) {
            this.userNameAttributeField = userNameAttributeField;
            return this;
        }

        public final String getGroupAttributeField() {
            return groupAttributeField;
        }

        public final void setGroupAttributeField(String groupAttributeField) {
            this.groupAttributeField = groupAttributeField;
        }

        @Override
        @Transient
        public final Builder groupAttributeField(String groupAttributeField) {
            this.groupAttributeField = groupAttributeField;
            return this;
        }

        @Override
        public JsonTokenTypeConfiguration build() {
            return new JsonTokenTypeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
