/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.Correction;
import software.amazon.awssdk.services.kendra.model.CorrectionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpellCorrectedQuery
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpellCorrectedQuery> {
    private static final SdkField<String> SUGGESTED_QUERY_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SuggestedQueryText").getter(SpellCorrectedQuery.getter(SpellCorrectedQuery::suggestedQueryText)).setter(SpellCorrectedQuery.setter(Builder::suggestedQueryText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuggestedQueryText").build()}).build();
    private static final SdkField<List<Correction>> CORRECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Corrections").getter(SpellCorrectedQuery.getter(SpellCorrectedQuery::corrections)).setter(SpellCorrectedQuery.setter(Builder::corrections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Corrections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Correction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUGGESTED_QUERY_TEXT_FIELD, CORRECTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String suggestedQueryText;
    private final List<Correction> corrections;

    private SpellCorrectedQuery(BuilderImpl builder) {
        this.suggestedQueryText = builder.suggestedQueryText;
        this.corrections = builder.corrections;
    }

    public final String suggestedQueryText() {
        return this.suggestedQueryText;
    }

    public final boolean hasCorrections() {
        return this.corrections != null && !(this.corrections instanceof SdkAutoConstructList);
    }

    public final List<Correction> corrections() {
        return this.corrections;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.suggestedQueryText());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCorrections() ? this.corrections() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpellCorrectedQuery)) {
            return false;
        }
        SpellCorrectedQuery other = (SpellCorrectedQuery)obj;
        return Objects.equals(this.suggestedQueryText(), other.suggestedQueryText()) && this.hasCorrections() == other.hasCorrections() && Objects.equals(this.corrections(), other.corrections());
    }

    public final String toString() {
        return ToString.builder((String)"SpellCorrectedQuery").add("SuggestedQueryText", (Object)this.suggestedQueryText()).add("Corrections", this.hasCorrections() ? this.corrections() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SuggestedQueryText": {
                return Optional.ofNullable(clazz.cast(this.suggestedQueryText()));
            }
            case "Corrections": {
                return Optional.ofNullable(clazz.cast(this.corrections()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpellCorrectedQuery, T> g) {
        return obj -> g.apply((SpellCorrectedQuery)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String suggestedQueryText;
        private List<Correction> corrections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SpellCorrectedQuery model) {
            this.suggestedQueryText(model.suggestedQueryText);
            this.corrections(model.corrections);
        }

        public final String getSuggestedQueryText() {
            return this.suggestedQueryText;
        }

        public final void setSuggestedQueryText(String suggestedQueryText) {
            this.suggestedQueryText = suggestedQueryText;
        }

        @Override
        @Transient
        public final Builder suggestedQueryText(String suggestedQueryText) {
            this.suggestedQueryText = suggestedQueryText;
            return this;
        }

        public final List<Correction.Builder> getCorrections() {
            List<Correction.Builder> result = CorrectionListCopier.copyToBuilder(this.corrections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCorrections(Collection<Correction.BuilderImpl> corrections) {
            this.corrections = CorrectionListCopier.copyFromBuilder(corrections);
        }

        @Override
        @Transient
        public final Builder corrections(Collection<Correction> corrections) {
            this.corrections = CorrectionListCopier.copy(corrections);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder corrections(Correction ... corrections) {
            this.corrections(Arrays.asList(corrections));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder corrections(Consumer<Correction.Builder> ... corrections) {
            this.corrections(Stream.of(corrections).map(c -> (Correction)((Correction.Builder)Correction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SpellCorrectedQuery build() {
            return new SpellCorrectedQuery(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpellCorrectedQuery> {
        public Builder suggestedQueryText(String var1);

        public Builder corrections(Collection<Correction> var1);

        public Builder corrections(Correction ... var1);

        public Builder corrections(Consumer<Correction.Builder> ... var1);
    }
}

