/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the user entity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EntityDisplayData implements SdkPojo, Serializable,
        ToCopyableBuilder<EntityDisplayData.Builder, EntityDisplayData> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(EntityDisplayData::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(EntityDisplayData::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<String> IDENTIFIED_USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentifiedUserName").getter(getter(EntityDisplayData::identifiedUserName))
            .setter(setter(Builder::identifiedUserName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentifiedUserName").build())
            .build();

    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirstName").getter(getter(EntityDisplayData::firstName)).setter(setter(Builder::firstName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()).build();

    private static final SdkField<String> LAST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastName").getter(getter(EntityDisplayData::lastName)).setter(setter(Builder::lastName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD,
            GROUP_NAME_FIELD, IDENTIFIED_USER_NAME_FIELD, FIRST_NAME_FIELD, LAST_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userName;

    private final String groupName;

    private final String identifiedUserName;

    private final String firstName;

    private final String lastName;

    private EntityDisplayData(BuilderImpl builder) {
        this.userName = builder.userName;
        this.groupName = builder.groupName;
        this.identifiedUserName = builder.identifiedUserName;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
    }

    /**
     * <p>
     * The name of the user.
     * </p>
     * 
     * @return The name of the user.
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * 
     * @return The name of the group.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The user name of the user.
     * </p>
     * 
     * @return The user name of the user.
     */
    public final String identifiedUserName() {
        return identifiedUserName;
    }

    /**
     * <p>
     * The first name of the user.
     * </p>
     * 
     * @return The first name of the user.
     */
    public final String firstName() {
        return firstName;
    }

    /**
     * <p>
     * The last name of the user.
     * </p>
     * 
     * @return The last name of the user.
     */
    public final String lastName() {
        return lastName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(identifiedUserName());
        hashCode = 31 * hashCode + Objects.hashCode(firstName());
        hashCode = 31 * hashCode + Objects.hashCode(lastName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityDisplayData)) {
            return false;
        }
        EntityDisplayData other = (EntityDisplayData) obj;
        return Objects.equals(userName(), other.userName()) && Objects.equals(groupName(), other.groupName())
                && Objects.equals(identifiedUserName(), other.identifiedUserName())
                && Objects.equals(firstName(), other.firstName()) && Objects.equals(lastName(), other.lastName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EntityDisplayData")
                .add("UserName", userName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("GroupName", groupName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("IdentifiedUserName", identifiedUserName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FirstName", firstName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LastName", lastName() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "IdentifiedUserName":
            return Optional.ofNullable(clazz.cast(identifiedUserName()));
        case "FirstName":
            return Optional.ofNullable(clazz.cast(firstName()));
        case "LastName":
            return Optional.ofNullable(clazz.cast(lastName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityDisplayData, T> g) {
        return obj -> g.apply((EntityDisplayData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EntityDisplayData> {
        /**
         * <p>
         * The name of the user.
         * </p>
         * 
         * @param userName
         *        The name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param groupName
         *        The name of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The user name of the user.
         * </p>
         * 
         * @param identifiedUserName
         *        The user name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifiedUserName(String identifiedUserName);

        /**
         * <p>
         * The first name of the user.
         * </p>
         * 
         * @param firstName
         *        The first name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstName(String firstName);

        /**
         * <p>
         * The last name of the user.
         * </p>
         * 
         * @param lastName
         *        The last name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastName(String lastName);
    }

    static final class BuilderImpl implements Builder {
        private String userName;

        private String groupName;

        private String identifiedUserName;

        private String firstName;

        private String lastName;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityDisplayData model) {
            userName(model.userName);
            groupName(model.groupName);
            identifiedUserName(model.identifiedUserName);
            firstName(model.firstName);
            lastName(model.lastName);
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        @Transient
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        @Transient
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getIdentifiedUserName() {
            return identifiedUserName;
        }

        public final void setIdentifiedUserName(String identifiedUserName) {
            this.identifiedUserName = identifiedUserName;
        }

        @Override
        @Transient
        public final Builder identifiedUserName(String identifiedUserName) {
            this.identifiedUserName = identifiedUserName;
            return this;
        }

        public final String getFirstName() {
            return firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        @Transient
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getLastName() {
            return lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        @Transient
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        @Override
        public EntityDisplayData build() {
            return new EntityDisplayData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
