/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information for users or groups in your Amazon Web Services SSO identity source with granted access to your
 * Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more
 * information on creating a search application experience, see <a
 * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
 * experience with no code</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExperienceEntitiesSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ExperienceEntitiesSummary.Builder, ExperienceEntitiesSummary> {
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityId").getter(getter(ExperienceEntitiesSummary::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()).build();

    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityType").getter(getter(ExperienceEntitiesSummary::entityTypeAsString))
            .setter(setter(Builder::entityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityType").build()).build();

    private static final SdkField<EntityDisplayData> DISPLAY_DATA_FIELD = SdkField
            .<EntityDisplayData> builder(MarshallingType.SDK_POJO).memberName("DisplayData")
            .getter(getter(ExperienceEntitiesSummary::displayData)).setter(setter(Builder::displayData))
            .constructor(EntityDisplayData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_ID_FIELD,
            ENTITY_TYPE_FIELD, DISPLAY_DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String entityId;

    private final String entityType;

    private final EntityDisplayData displayData;

    private ExperienceEntitiesSummary(BuilderImpl builder) {
        this.entityId = builder.entityId;
        this.entityType = builder.entityType;
        this.displayData = builder.displayData;
    }

    /**
     * <p>
     * The identifier of a user or group in your Amazon Web Services SSO identity source. For example, a user ID could
     * be an email.
     * </p>
     * 
     * @return The identifier of a user or group in your Amazon Web Services SSO identity source. For example, a user ID
     *         could be an email.
     */
    public final String entityId() {
        return entityId;
    }

    /**
     * <p>
     * Shows the type as <code>User</code> or <code>Group</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link EntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #entityTypeAsString}.
     * </p>
     * 
     * @return Shows the type as <code>User</code> or <code>Group</code>.
     * @see EntityType
     */
    public final EntityType entityType() {
        return EntityType.fromValue(entityType);
    }

    /**
     * <p>
     * Shows the type as <code>User</code> or <code>Group</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link EntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #entityTypeAsString}.
     * </p>
     * 
     * @return Shows the type as <code>User</code> or <code>Group</code>.
     * @see EntityType
     */
    public final String entityTypeAsString() {
        return entityType;
    }

    /**
     * <p>
     * Information about the user entity.
     * </p>
     * 
     * @return Information about the user entity.
     */
    public final EntityDisplayData displayData() {
        return displayData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(entityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(displayData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperienceEntitiesSummary)) {
            return false;
        }
        ExperienceEntitiesSummary other = (ExperienceEntitiesSummary) obj;
        return Objects.equals(entityId(), other.entityId()) && Objects.equals(entityTypeAsString(), other.entityTypeAsString())
                && Objects.equals(displayData(), other.displayData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExperienceEntitiesSummary").add("EntityId", entityId()).add("EntityType", entityTypeAsString())
                .add("DisplayData", displayData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EntityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "EntityType":
            return Optional.ofNullable(clazz.cast(entityTypeAsString()));
        case "DisplayData":
            return Optional.ofNullable(clazz.cast(displayData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExperienceEntitiesSummary, T> g) {
        return obj -> g.apply((ExperienceEntitiesSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExperienceEntitiesSummary> {
        /**
         * <p>
         * The identifier of a user or group in your Amazon Web Services SSO identity source. For example, a user ID
         * could be an email.
         * </p>
         * 
         * @param entityId
         *        The identifier of a user or group in your Amazon Web Services SSO identity source. For example, a user
         *        ID could be an email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * Shows the type as <code>User</code> or <code>Group</code>.
         * </p>
         * 
         * @param entityType
         *        Shows the type as <code>User</code> or <code>Group</code>.
         * @see EntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityType
         */
        Builder entityType(String entityType);

        /**
         * <p>
         * Shows the type as <code>User</code> or <code>Group</code>.
         * </p>
         * 
         * @param entityType
         *        Shows the type as <code>User</code> or <code>Group</code>.
         * @see EntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityType
         */
        Builder entityType(EntityType entityType);

        /**
         * <p>
         * Information about the user entity.
         * </p>
         * 
         * @param displayData
         *        Information about the user entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayData(EntityDisplayData displayData);

        /**
         * <p>
         * Information about the user entity.
         * </p>
         * This is a convenience that creates an instance of the {@link EntityDisplayData.Builder} avoiding the need to
         * create one manually via {@link EntityDisplayData#builder()}.
         *
         * When the {@link Consumer} completes, {@link EntityDisplayData.Builder#build()} is called immediately and its
         * result is passed to {@link #displayData(EntityDisplayData)}.
         * 
         * @param displayData
         *        a consumer that will call methods on {@link EntityDisplayData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #displayData(EntityDisplayData)
         */
        default Builder displayData(Consumer<EntityDisplayData.Builder> displayData) {
            return displayData(EntityDisplayData.builder().applyMutation(displayData).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String entityId;

        private String entityType;

        private EntityDisplayData displayData;

        private BuilderImpl() {
        }

        private BuilderImpl(ExperienceEntitiesSummary model) {
            entityId(model.entityId);
            entityType(model.entityType);
            displayData(model.displayData);
        }

        public final String getEntityId() {
            return entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        @Transient
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityType() {
            return entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        @Transient
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        @Transient
        public final Builder entityType(EntityType entityType) {
            this.entityType(entityType == null ? null : entityType.toString());
            return this;
        }

        public final EntityDisplayData.Builder getDisplayData() {
            return displayData != null ? displayData.toBuilder() : null;
        }

        public final void setDisplayData(EntityDisplayData.BuilderImpl displayData) {
            this.displayData = displayData != null ? displayData.build() : null;
        }

        @Override
        @Transient
        public final Builder displayData(EntityDisplayData displayData) {
            this.displayData = displayData;
            return this;
        }

        @Override
        public ExperienceEntitiesSummary build() {
            return new ExperienceEntitiesSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
