/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A corrected misspelled word in a query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Correction implements SdkPojo, Serializable, ToCopyableBuilder<Correction.Builder, Correction> {
    private static final SdkField<Integer> BEGIN_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BeginOffset").getter(getter(Correction::beginOffset)).setter(setter(Builder::beginOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffset").build()).build();

    private static final SdkField<Integer> END_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EndOffset").getter(getter(Correction::endOffset)).setter(setter(Builder::endOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffset").build()).build();

    private static final SdkField<String> TERM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Term")
            .getter(getter(Correction::term)).setter(setter(Builder::term))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Term").build()).build();

    private static final SdkField<String> CORRECTED_TERM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CorrectedTerm").getter(getter(Correction::correctedTerm)).setter(setter(Builder::correctedTerm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CorrectedTerm").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEGIN_OFFSET_FIELD,
            END_OFFSET_FIELD, TERM_FIELD, CORRECTED_TERM_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer beginOffset;

    private final Integer endOffset;

    private final String term;

    private final String correctedTerm;

    private Correction(BuilderImpl builder) {
        this.beginOffset = builder.beginOffset;
        this.endOffset = builder.endOffset;
        this.term = builder.term;
        this.correctedTerm = builder.correctedTerm;
    }

    /**
     * <p>
     * The zero-based location in the response string or text where the corrected word starts.
     * </p>
     * 
     * @return The zero-based location in the response string or text where the corrected word starts.
     */
    public final Integer beginOffset() {
        return beginOffset;
    }

    /**
     * <p>
     * The zero-based location in the response string or text where the corrected word ends.
     * </p>
     * 
     * @return The zero-based location in the response string or text where the corrected word ends.
     */
    public final Integer endOffset() {
        return endOffset;
    }

    /**
     * <p>
     * The string or text of a misspelled word in a query.
     * </p>
     * 
     * @return The string or text of a misspelled word in a query.
     */
    public final String term() {
        return term;
    }

    /**
     * <p>
     * The string or text of a corrected misspelled word in a query.
     * </p>
     * 
     * @return The string or text of a corrected misspelled word in a query.
     */
    public final String correctedTerm() {
        return correctedTerm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(beginOffset());
        hashCode = 31 * hashCode + Objects.hashCode(endOffset());
        hashCode = 31 * hashCode + Objects.hashCode(term());
        hashCode = 31 * hashCode + Objects.hashCode(correctedTerm());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Correction)) {
            return false;
        }
        Correction other = (Correction) obj;
        return Objects.equals(beginOffset(), other.beginOffset()) && Objects.equals(endOffset(), other.endOffset())
                && Objects.equals(term(), other.term()) && Objects.equals(correctedTerm(), other.correctedTerm());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Correction").add("BeginOffset", beginOffset()).add("EndOffset", endOffset()).add("Term", term())
                .add("CorrectedTerm", correctedTerm()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BeginOffset":
            return Optional.ofNullable(clazz.cast(beginOffset()));
        case "EndOffset":
            return Optional.ofNullable(clazz.cast(endOffset()));
        case "Term":
            return Optional.ofNullable(clazz.cast(term()));
        case "CorrectedTerm":
            return Optional.ofNullable(clazz.cast(correctedTerm()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Correction, T> g) {
        return obj -> g.apply((Correction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Correction> {
        /**
         * <p>
         * The zero-based location in the response string or text where the corrected word starts.
         * </p>
         * 
         * @param beginOffset
         *        The zero-based location in the response string or text where the corrected word starts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beginOffset(Integer beginOffset);

        /**
         * <p>
         * The zero-based location in the response string or text where the corrected word ends.
         * </p>
         * 
         * @param endOffset
         *        The zero-based location in the response string or text where the corrected word ends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endOffset(Integer endOffset);

        /**
         * <p>
         * The string or text of a misspelled word in a query.
         * </p>
         * 
         * @param term
         *        The string or text of a misspelled word in a query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder term(String term);

        /**
         * <p>
         * The string or text of a corrected misspelled word in a query.
         * </p>
         * 
         * @param correctedTerm
         *        The string or text of a corrected misspelled word in a query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder correctedTerm(String correctedTerm);
    }

    static final class BuilderImpl implements Builder {
        private Integer beginOffset;

        private Integer endOffset;

        private String term;

        private String correctedTerm;

        private BuilderImpl() {
        }

        private BuilderImpl(Correction model) {
            beginOffset(model.beginOffset);
            endOffset(model.endOffset);
            term(model.term);
            correctedTerm(model.correctedTerm);
        }

        public final Integer getBeginOffset() {
            return beginOffset;
        }

        public final void setBeginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
        }

        @Override
        @Transient
        public final Builder beginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
            return this;
        }

        public final Integer getEndOffset() {
            return endOffset;
        }

        public final void setEndOffset(Integer endOffset) {
            this.endOffset = endOffset;
        }

        @Override
        @Transient
        public final Builder endOffset(Integer endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public final String getTerm() {
            return term;
        }

        public final void setTerm(String term) {
            this.term = term;
        }

        @Override
        @Transient
        public final Builder term(String term) {
            this.term = term;
            return this;
        }

        public final String getCorrectedTerm() {
            return correctedTerm;
        }

        public final void setCorrectedTerm(String correctedTerm) {
            this.correctedTerm = correctedTerm;
        }

        @Override
        @Transient
        public final Builder correctedTerm(String correctedTerm) {
            this.correctedTerm = correctedTerm;
            return this;
        }

        @Override
        public Correction build() {
            return new Correction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
