/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration information for the endpoint for your Amazon Kendra experience.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExperienceEndpoint implements SdkPojo, Serializable,
        ToCopyableBuilder<ExperienceEndpoint.Builder, ExperienceEndpoint> {
    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointType").getter(getter(ExperienceEndpoint::endpointTypeAsString))
            .setter(setter(Builder::endpointType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()).build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Endpoint").getter(getter(ExperienceEndpoint::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_TYPE_FIELD,
            ENDPOINT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String endpointType;

    private final String endpoint;

    private ExperienceEndpoint(BuilderImpl builder) {
        this.endpointType = builder.endpointType;
        this.endpoint = builder.endpoint;
    }

    /**
     * <p>
     * The type of endpoint for your Amazon Kendra experience. The type currently available is <code>HOME</code>, which
     * is a unique and fully hosted URL to the home page of your Amazon Kendra experience.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link EndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The type of endpoint for your Amazon Kendra experience. The type currently available is <code>HOME</code>
     *         , which is a unique and fully hosted URL to the home page of your Amazon Kendra experience.
     * @see EndpointType
     */
    public final EndpointType endpointType() {
        return EndpointType.fromValue(endpointType);
    }

    /**
     * <p>
     * The type of endpoint for your Amazon Kendra experience. The type currently available is <code>HOME</code>, which
     * is a unique and fully hosted URL to the home page of your Amazon Kendra experience.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link EndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The type of endpoint for your Amazon Kendra experience. The type currently available is <code>HOME</code>
     *         , which is a unique and fully hosted URL to the home page of your Amazon Kendra experience.
     * @see EndpointType
     */
    public final String endpointTypeAsString() {
        return endpointType;
    }

    /**
     * <p>
     * The endpoint of your Amazon Kendra experience.
     * </p>
     * 
     * @return The endpoint of your Amazon Kendra experience.
     */
    public final String endpoint() {
        return endpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperienceEndpoint)) {
            return false;
        }
        ExperienceEndpoint other = (ExperienceEndpoint) obj;
        return Objects.equals(endpointTypeAsString(), other.endpointTypeAsString())
                && Objects.equals(endpoint(), other.endpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExperienceEndpoint").add("EndpointType", endpointTypeAsString()).add("Endpoint", endpoint())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointType":
            return Optional.ofNullable(clazz.cast(endpointTypeAsString()));
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExperienceEndpoint, T> g) {
        return obj -> g.apply((ExperienceEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExperienceEndpoint> {
        /**
         * <p>
         * The type of endpoint for your Amazon Kendra experience. The type currently available is <code>HOME</code>,
         * which is a unique and fully hosted URL to the home page of your Amazon Kendra experience.
         * </p>
         * 
         * @param endpointType
         *        The type of endpoint for your Amazon Kendra experience. The type currently available is
         *        <code>HOME</code>, which is a unique and fully hosted URL to the home page of your Amazon Kendra
         *        experience.
         * @see EndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointType
         */
        Builder endpointType(String endpointType);

        /**
         * <p>
         * The type of endpoint for your Amazon Kendra experience. The type currently available is <code>HOME</code>,
         * which is a unique and fully hosted URL to the home page of your Amazon Kendra experience.
         * </p>
         * 
         * @param endpointType
         *        The type of endpoint for your Amazon Kendra experience. The type currently available is
         *        <code>HOME</code>, which is a unique and fully hosted URL to the home page of your Amazon Kendra
         *        experience.
         * @see EndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointType
         */
        Builder endpointType(EndpointType endpointType);

        /**
         * <p>
         * The endpoint of your Amazon Kendra experience.
         * </p>
         * 
         * @param endpoint
         *        The endpoint of your Amazon Kendra experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);
    }

    static final class BuilderImpl implements Builder {
        private String endpointType;

        private String endpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(ExperienceEndpoint model) {
            endpointType(model.endpointType);
            endpoint(model.endpoint);
        }

        public final String getEndpointType() {
            return endpointType;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        @Transient
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        @Transient
        public final Builder endpointType(EndpointType endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        @Transient
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public ExperienceEndpoint build() {
            return new ExperienceEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
