/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIndexRequest extends KendraRequest implements
        ToCopyableBuilder<CreateIndexRequest.Builder, CreateIndexRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateIndexRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> EDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Edition")
            .getter(getter(CreateIndexRequest::editionAsString)).setter(setter(Builder::edition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Edition").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateIndexRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<ServerSideEncryptionConfiguration> SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<ServerSideEncryptionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ServerSideEncryptionConfiguration")
            .getter(getter(CreateIndexRequest::serverSideEncryptionConfiguration))
            .setter(setter(Builder::serverSideEncryptionConfiguration))
            .constructor(ServerSideEncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideEncryptionConfiguration")
                    .build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateIndexRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateIndexRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateIndexRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UserTokenConfiguration>> USER_TOKEN_CONFIGURATIONS_FIELD = SdkField
            .<List<UserTokenConfiguration>> builder(MarshallingType.LIST)
            .memberName("UserTokenConfigurations")
            .getter(getter(CreateIndexRequest::userTokenConfigurations))
            .setter(setter(Builder::userTokenConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserTokenConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserTokenConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserTokenConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> USER_CONTEXT_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserContextPolicy").getter(getter(CreateIndexRequest::userContextPolicyAsString))
            .setter(setter(Builder::userContextPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserContextPolicy").build()).build();

    private static final SdkField<UserGroupResolutionConfiguration> USER_GROUP_RESOLUTION_CONFIGURATION_FIELD = SdkField
            .<UserGroupResolutionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("UserGroupResolutionConfiguration")
            .getter(getter(CreateIndexRequest::userGroupResolutionConfiguration))
            .setter(setter(Builder::userGroupResolutionConfiguration))
            .constructor(UserGroupResolutionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupResolutionConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, EDITION_FIELD,
            ROLE_ARN_FIELD, SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD, DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD,
            USER_TOKEN_CONFIGURATIONS_FIELD, USER_CONTEXT_POLICY_FIELD, USER_GROUP_RESOLUTION_CONFIGURATION_FIELD));

    private final String name;

    private final String edition;

    private final String roleArn;

    private final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;

    private final String description;

    private final String clientToken;

    private final List<Tag> tags;

    private final List<UserTokenConfiguration> userTokenConfigurations;

    private final String userContextPolicy;

    private final UserGroupResolutionConfiguration userGroupResolutionConfiguration;

    private CreateIndexRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.edition = builder.edition;
        this.roleArn = builder.roleArn;
        this.serverSideEncryptionConfiguration = builder.serverSideEncryptionConfiguration;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
        this.userTokenConfigurations = builder.userTokenConfigurations;
        this.userContextPolicy = builder.userContextPolicy;
        this.userGroupResolutionConfiguration = builder.userGroupResolutionConfiguration;
    }

    /**
     * <p>
     * The name for the new index.
     * </p>
     * 
     * @return The name for the new index.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Kendra edition to use for the index. Choose <code>DEVELOPER_EDITION</code> for indexes intended for
     * development, testing, or proof of concept. Use <code>ENTERPRISE_EDITION</code> for your production databases.
     * Once you set the edition for an index, it can't be changed.
     * </p>
     * <p>
     * The <code>Edition</code> parameter is optional. If you don't supply a value, the default is
     * <code>ENTERPRISE_EDITION</code>.
     * </p>
     * <p>
     * For more information on quota limits for enterprise and developer editions, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #edition} will
     * return {@link IndexEdition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #editionAsString}.
     * </p>
     * 
     * @return The Amazon Kendra edition to use for the index. Choose <code>DEVELOPER_EDITION</code> for indexes
     *         intended for development, testing, or proof of concept. Use <code>ENTERPRISE_EDITION</code> for your
     *         production databases. Once you set the edition for an index, it can't be changed.</p>
     *         <p>
     *         The <code>Edition</code> parameter is optional. If you don't supply a value, the default is
     *         <code>ENTERPRISE_EDITION</code>.
     *         </p>
     *         <p>
     *         For more information on quota limits for enterprise and developer editions, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.
     * @see IndexEdition
     */
    public final IndexEdition edition() {
        return IndexEdition.fromValue(edition);
    }

    /**
     * <p>
     * The Amazon Kendra edition to use for the index. Choose <code>DEVELOPER_EDITION</code> for indexes intended for
     * development, testing, or proof of concept. Use <code>ENTERPRISE_EDITION</code> for your production databases.
     * Once you set the edition for an index, it can't be changed.
     * </p>
     * <p>
     * The <code>Edition</code> parameter is optional. If you don't supply a value, the default is
     * <code>ENTERPRISE_EDITION</code>.
     * </p>
     * <p>
     * For more information on quota limits for enterprise and developer editions, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #edition} will
     * return {@link IndexEdition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #editionAsString}.
     * </p>
     * 
     * @return The Amazon Kendra edition to use for the index. Choose <code>DEVELOPER_EDITION</code> for indexes
     *         intended for development, testing, or proof of concept. Use <code>ENTERPRISE_EDITION</code> for your
     *         production databases. Once you set the edition for an index, it can't be changed.</p>
     *         <p>
     *         The <code>Edition</code> parameter is optional. If you don't supply a value, the default is
     *         <code>ENTERPRISE_EDITION</code>.
     *         </p>
     *         <p>
     *         For more information on quota limits for enterprise and developer editions, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.
     * @see IndexEdition
     */
    public final String editionAsString() {
        return edition;
    }

    /**
     * <p>
     * An Identity and Access Management(IAM) role that gives Amazon Kendra permissions to access your Amazon CloudWatch
     * logs and metrics. This is also the role used when you use the <code>BatchPutDocument</code> API to index
     * documents from an Amazon S3 bucket.
     * </p>
     * 
     * @return An Identity and Access Management(IAM) role that gives Amazon Kendra permissions to access your Amazon
     *         CloudWatch logs and metrics. This is also the role used when you use the <code>BatchPutDocument</code>
     *         API to index documents from an Amazon S3 bucket.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The identifier of the KMScustomer managed key (CMK) to use to encrypt data indexed by Amazon Kendra. Amazon
     * Kendra doesn't support asymmetric CMKs.
     * </p>
     * 
     * @return The identifier of the KMScustomer managed key (CMK) to use to encrypt data indexed by Amazon Kendra.
     *         Amazon Kendra doesn't support asymmetric CMKs.
     */
    public final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration() {
        return serverSideEncryptionConfiguration;
    }

    /**
     * <p>
     * A description for the index.
     * </p>
     * 
     * @return A description for the index.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A token that you provide to identify the request to create an index. Multiple calls to the
     * <code>CreateIndex</code> API with the same client token will create only one index.
     * </p>
     * 
     * @return A token that you provide to identify the request to create an index. Multiple calls to the
     *         <code>CreateIndex</code> API with the same client token will create only one index.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs that identify the index. You can use the tags to identify and organize your resources
     * and to control access to resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs that identify the index. You can use the tags to identify and organize your
     *         resources and to control access to resources.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserTokenConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasUserTokenConfigurations() {
        return userTokenConfigurations != null && !(userTokenConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The user token configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserTokenConfigurations} method.
     * </p>
     * 
     * @return The user token configuration.
     */
    public final List<UserTokenConfiguration> userTokenConfigurations() {
        return userTokenConfigurations;
    }

    /**
     * <p>
     * The user context policy.
     * </p>
     * <dl>
     * <dt>ATTRIBUTE_FILTER</dt>
     * <dd>
     * <p>
     * All indexed content is searchable and displayable for all users. If you want to filter search results on user
     * context, you can use the attribute filters of <code>_user_id</code> and <code>_group_ids</code> or you can
     * provide user and group information in <code>UserContext</code>.
     * </p>
     * </dd>
     * <dt>USER_TOKEN</dt>
     * <dd>
     * <p>
     * Enables token-based user access control to filter search results on user context. All documents with no access
     * control and all documents accessible to the user will be searchable and displayable.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userContextPolicy}
     * will return {@link UserContextPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #userContextPolicyAsString}.
     * </p>
     * 
     * @return The user context policy.</p>
     *         <dl>
     *         <dt>ATTRIBUTE_FILTER</dt>
     *         <dd>
     *         <p>
     *         All indexed content is searchable and displayable for all users. If you want to filter search results on
     *         user context, you can use the attribute filters of <code>_user_id</code> and <code>_group_ids</code> or
     *         you can provide user and group information in <code>UserContext</code>.
     *         </p>
     *         </dd>
     *         <dt>USER_TOKEN</dt>
     *         <dd>
     *         <p>
     *         Enables token-based user access control to filter search results on user context. All documents with no
     *         access control and all documents accessible to the user will be searchable and displayable.
     *         </p>
     *         </dd>
     * @see UserContextPolicy
     */
    public final UserContextPolicy userContextPolicy() {
        return UserContextPolicy.fromValue(userContextPolicy);
    }

    /**
     * <p>
     * The user context policy.
     * </p>
     * <dl>
     * <dt>ATTRIBUTE_FILTER</dt>
     * <dd>
     * <p>
     * All indexed content is searchable and displayable for all users. If you want to filter search results on user
     * context, you can use the attribute filters of <code>_user_id</code> and <code>_group_ids</code> or you can
     * provide user and group information in <code>UserContext</code>.
     * </p>
     * </dd>
     * <dt>USER_TOKEN</dt>
     * <dd>
     * <p>
     * Enables token-based user access control to filter search results on user context. All documents with no access
     * control and all documents accessible to the user will be searchable and displayable.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userContextPolicy}
     * will return {@link UserContextPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #userContextPolicyAsString}.
     * </p>
     * 
     * @return The user context policy.</p>
     *         <dl>
     *         <dt>ATTRIBUTE_FILTER</dt>
     *         <dd>
     *         <p>
     *         All indexed content is searchable and displayable for all users. If you want to filter search results on
     *         user context, you can use the attribute filters of <code>_user_id</code> and <code>_group_ids</code> or
     *         you can provide user and group information in <code>UserContext</code>.
     *         </p>
     *         </dd>
     *         <dt>USER_TOKEN</dt>
     *         <dd>
     *         <p>
     *         Enables token-based user access control to filter search results on user context. All documents with no
     *         access control and all documents accessible to the user will be searchable and displayable.
     *         </p>
     *         </dd>
     * @see UserContextPolicy
     */
    public final String userContextPolicyAsString() {
        return userContextPolicy;
    }

    /**
     * <p>
     * Enables fetching access levels of groups and users from an Amazon Web Services Single Sign On identity source. To
     * configure this, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html"
     * >UserGroupResolutionConfiguration</a>.
     * </p>
     * 
     * @return Enables fetching access levels of groups and users from an Amazon Web Services Single Sign On identity
     *         source. To configure this, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html"
     *         >UserGroupResolutionConfiguration</a>.
     */
    public final UserGroupResolutionConfiguration userGroupResolutionConfiguration() {
        return userGroupResolutionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(editionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUserTokenConfigurations() ? userTokenConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userContextPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userGroupResolutionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIndexRequest)) {
            return false;
        }
        CreateIndexRequest other = (CreateIndexRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(editionAsString(), other.editionAsString())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(serverSideEncryptionConfiguration(), other.serverSideEncryptionConfiguration())
                && Objects.equals(description(), other.description()) && Objects.equals(clientToken(), other.clientToken())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && hasUserTokenConfigurations() == other.hasUserTokenConfigurations()
                && Objects.equals(userTokenConfigurations(), other.userTokenConfigurations())
                && Objects.equals(userContextPolicyAsString(), other.userContextPolicyAsString())
                && Objects.equals(userGroupResolutionConfiguration(), other.userGroupResolutionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIndexRequest").add("Name", name()).add("Edition", editionAsString())
                .add("RoleArn", roleArn()).add("ServerSideEncryptionConfiguration", serverSideEncryptionConfiguration())
                .add("Description", description()).add("ClientToken", clientToken()).add("Tags", hasTags() ? tags() : null)
                .add("UserTokenConfigurations", hasUserTokenConfigurations() ? userTokenConfigurations() : null)
                .add("UserContextPolicy", userContextPolicyAsString())
                .add("UserGroupResolutionConfiguration", userGroupResolutionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Edition":
            return Optional.ofNullable(clazz.cast(editionAsString()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "ServerSideEncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(serverSideEncryptionConfiguration()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "UserTokenConfigurations":
            return Optional.ofNullable(clazz.cast(userTokenConfigurations()));
        case "UserContextPolicy":
            return Optional.ofNullable(clazz.cast(userContextPolicyAsString()));
        case "UserGroupResolutionConfiguration":
            return Optional.ofNullable(clazz.cast(userGroupResolutionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateIndexRequest, T> g) {
        return obj -> g.apply((CreateIndexRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateIndexRequest> {
        /**
         * <p>
         * The name for the new index.
         * </p>
         * 
         * @param name
         *        The name for the new index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Kendra edition to use for the index. Choose <code>DEVELOPER_EDITION</code> for indexes intended
         * for development, testing, or proof of concept. Use <code>ENTERPRISE_EDITION</code> for your production
         * databases. Once you set the edition for an index, it can't be changed.
         * </p>
         * <p>
         * The <code>Edition</code> parameter is optional. If you don't supply a value, the default is
         * <code>ENTERPRISE_EDITION</code>.
         * </p>
         * <p>
         * For more information on quota limits for enterprise and developer editions, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.
         * </p>
         * 
         * @param edition
         *        The Amazon Kendra edition to use for the index. Choose <code>DEVELOPER_EDITION</code> for indexes
         *        intended for development, testing, or proof of concept. Use <code>ENTERPRISE_EDITION</code> for your
         *        production databases. Once you set the edition for an index, it can't be changed.</p>
         *        <p>
         *        The <code>Edition</code> parameter is optional. If you don't supply a value, the default is
         *        <code>ENTERPRISE_EDITION</code>.
         *        </p>
         *        <p>
         *        For more information on quota limits for enterprise and developer editions, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.
         * @see IndexEdition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexEdition
         */
        Builder edition(String edition);

        /**
         * <p>
         * The Amazon Kendra edition to use for the index. Choose <code>DEVELOPER_EDITION</code> for indexes intended
         * for development, testing, or proof of concept. Use <code>ENTERPRISE_EDITION</code> for your production
         * databases. Once you set the edition for an index, it can't be changed.
         * </p>
         * <p>
         * The <code>Edition</code> parameter is optional. If you don't supply a value, the default is
         * <code>ENTERPRISE_EDITION</code>.
         * </p>
         * <p>
         * For more information on quota limits for enterprise and developer editions, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.
         * </p>
         * 
         * @param edition
         *        The Amazon Kendra edition to use for the index. Choose <code>DEVELOPER_EDITION</code> for indexes
         *        intended for development, testing, or proof of concept. Use <code>ENTERPRISE_EDITION</code> for your
         *        production databases. Once you set the edition for an index, it can't be changed.</p>
         *        <p>
         *        The <code>Edition</code> parameter is optional. If you don't supply a value, the default is
         *        <code>ENTERPRISE_EDITION</code>.
         *        </p>
         *        <p>
         *        For more information on quota limits for enterprise and developer editions, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.
         * @see IndexEdition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexEdition
         */
        Builder edition(IndexEdition edition);

        /**
         * <p>
         * An Identity and Access Management(IAM) role that gives Amazon Kendra permissions to access your Amazon
         * CloudWatch logs and metrics. This is also the role used when you use the <code>BatchPutDocument</code> API to
         * index documents from an Amazon S3 bucket.
         * </p>
         * 
         * @param roleArn
         *        An Identity and Access Management(IAM) role that gives Amazon Kendra permissions to access your Amazon
         *        CloudWatch logs and metrics. This is also the role used when you use the <code>BatchPutDocument</code>
         *        API to index documents from an Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The identifier of the KMScustomer managed key (CMK) to use to encrypt data indexed by Amazon Kendra. Amazon
         * Kendra doesn't support asymmetric CMKs.
         * </p>
         * 
         * @param serverSideEncryptionConfiguration
         *        The identifier of the KMScustomer managed key (CMK) to use to encrypt data indexed by Amazon Kendra.
         *        Amazon Kendra doesn't support asymmetric CMKs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration);

        /**
         * <p>
         * The identifier of the KMScustomer managed key (CMK) to use to encrypt data indexed by Amazon Kendra. Amazon
         * Kendra doesn't support asymmetric CMKs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ServerSideEncryptionConfiguration.Builder} avoiding the need to create one manually via
         * {@link ServerSideEncryptionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServerSideEncryptionConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration)}.
         * 
         * @param serverSideEncryptionConfiguration
         *        a consumer that will call methods on {@link ServerSideEncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration)
         */
        default Builder serverSideEncryptionConfiguration(
                Consumer<ServerSideEncryptionConfiguration.Builder> serverSideEncryptionConfiguration) {
            return serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration.builder()
                    .applyMutation(serverSideEncryptionConfiguration).build());
        }

        /**
         * <p>
         * A description for the index.
         * </p>
         * 
         * @param description
         *        A description for the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A token that you provide to identify the request to create an index. Multiple calls to the
         * <code>CreateIndex</code> API with the same client token will create only one index.
         * </p>
         * 
         * @param clientToken
         *        A token that you provide to identify the request to create an index. Multiple calls to the
         *        <code>CreateIndex</code> API with the same client token will create only one index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A list of key-value pairs that identify the index. You can use the tags to identify and organize your
         * resources and to control access to resources.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that identify the index. You can use the tags to identify and organize your
         *        resources and to control access to resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of key-value pairs that identify the index. You can use the tags to identify and organize your
         * resources and to control access to resources.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that identify the index. You can use the tags to identify and organize your
         *        resources and to control access to resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of key-value pairs that identify the index. You can use the tags to identify and organize your
         * resources and to control access to resources.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The user token configuration.
         * </p>
         * 
         * @param userTokenConfigurations
         *        The user token configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userTokenConfigurations(Collection<UserTokenConfiguration> userTokenConfigurations);

        /**
         * <p>
         * The user token configuration.
         * </p>
         * 
         * @param userTokenConfigurations
         *        The user token configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userTokenConfigurations(UserTokenConfiguration... userTokenConfigurations);

        /**
         * <p>
         * The user token configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<UserTokenConfiguration>.Builder}
         * avoiding the need to create one manually via {@link List<UserTokenConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UserTokenConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #userTokenConfigurations(List<UserTokenConfiguration>)}.
         * 
         * @param userTokenConfigurations
         *        a consumer that will call methods on {@link List<UserTokenConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userTokenConfigurations(List<UserTokenConfiguration>)
         */
        Builder userTokenConfigurations(Consumer<UserTokenConfiguration.Builder>... userTokenConfigurations);

        /**
         * <p>
         * The user context policy.
         * </p>
         * <dl>
         * <dt>ATTRIBUTE_FILTER</dt>
         * <dd>
         * <p>
         * All indexed content is searchable and displayable for all users. If you want to filter search results on user
         * context, you can use the attribute filters of <code>_user_id</code> and <code>_group_ids</code> or you can
         * provide user and group information in <code>UserContext</code>.
         * </p>
         * </dd>
         * <dt>USER_TOKEN</dt>
         * <dd>
         * <p>
         * Enables token-based user access control to filter search results on user context. All documents with no
         * access control and all documents accessible to the user will be searchable and displayable.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param userContextPolicy
         *        The user context policy.</p>
         *        <dl>
         *        <dt>ATTRIBUTE_FILTER</dt>
         *        <dd>
         *        <p>
         *        All indexed content is searchable and displayable for all users. If you want to filter search results
         *        on user context, you can use the attribute filters of <code>_user_id</code> and
         *        <code>_group_ids</code> or you can provide user and group information in <code>UserContext</code>.
         *        </p>
         *        </dd>
         *        <dt>USER_TOKEN</dt>
         *        <dd>
         *        <p>
         *        Enables token-based user access control to filter search results on user context. All documents with
         *        no access control and all documents accessible to the user will be searchable and displayable.
         *        </p>
         *        </dd>
         * @see UserContextPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserContextPolicy
         */
        Builder userContextPolicy(String userContextPolicy);

        /**
         * <p>
         * The user context policy.
         * </p>
         * <dl>
         * <dt>ATTRIBUTE_FILTER</dt>
         * <dd>
         * <p>
         * All indexed content is searchable and displayable for all users. If you want to filter search results on user
         * context, you can use the attribute filters of <code>_user_id</code> and <code>_group_ids</code> or you can
         * provide user and group information in <code>UserContext</code>.
         * </p>
         * </dd>
         * <dt>USER_TOKEN</dt>
         * <dd>
         * <p>
         * Enables token-based user access control to filter search results on user context. All documents with no
         * access control and all documents accessible to the user will be searchable and displayable.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param userContextPolicy
         *        The user context policy.</p>
         *        <dl>
         *        <dt>ATTRIBUTE_FILTER</dt>
         *        <dd>
         *        <p>
         *        All indexed content is searchable and displayable for all users. If you want to filter search results
         *        on user context, you can use the attribute filters of <code>_user_id</code> and
         *        <code>_group_ids</code> or you can provide user and group information in <code>UserContext</code>.
         *        </p>
         *        </dd>
         *        <dt>USER_TOKEN</dt>
         *        <dd>
         *        <p>
         *        Enables token-based user access control to filter search results on user context. All documents with
         *        no access control and all documents accessible to the user will be searchable and displayable.
         *        </p>
         *        </dd>
         * @see UserContextPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserContextPolicy
         */
        Builder userContextPolicy(UserContextPolicy userContextPolicy);

        /**
         * <p>
         * Enables fetching access levels of groups and users from an Amazon Web Services Single Sign On identity
         * source. To configure this, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html"
         * >UserGroupResolutionConfiguration</a>.
         * </p>
         * 
         * @param userGroupResolutionConfiguration
         *        Enables fetching access levels of groups and users from an Amazon Web Services Single Sign On identity
         *        source. To configure this, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html"
         *        >UserGroupResolutionConfiguration</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroupResolutionConfiguration(UserGroupResolutionConfiguration userGroupResolutionConfiguration);

        /**
         * <p>
         * Enables fetching access levels of groups and users from an Amazon Web Services Single Sign On identity
         * source. To configure this, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html"
         * >UserGroupResolutionConfiguration</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserGroupResolutionConfiguration.Builder}
         * avoiding the need to create one manually via {@link UserGroupResolutionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserGroupResolutionConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #userGroupResolutionConfiguration(UserGroupResolutionConfiguration)}.
         * 
         * @param userGroupResolutionConfiguration
         *        a consumer that will call methods on {@link UserGroupResolutionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userGroupResolutionConfiguration(UserGroupResolutionConfiguration)
         */
        default Builder userGroupResolutionConfiguration(
                Consumer<UserGroupResolutionConfiguration.Builder> userGroupResolutionConfiguration) {
            return userGroupResolutionConfiguration(UserGroupResolutionConfiguration.builder()
                    .applyMutation(userGroupResolutionConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String name;

        private String edition;

        private String roleArn;

        private ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;

        private String description;

        private String clientToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<UserTokenConfiguration> userTokenConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String userContextPolicy;

        private UserGroupResolutionConfiguration userGroupResolutionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIndexRequest model) {
            super(model);
            name(model.name);
            edition(model.edition);
            roleArn(model.roleArn);
            serverSideEncryptionConfiguration(model.serverSideEncryptionConfiguration);
            description(model.description);
            clientToken(model.clientToken);
            tags(model.tags);
            userTokenConfigurations(model.userTokenConfigurations);
            userContextPolicy(model.userContextPolicy);
            userGroupResolutionConfiguration(model.userGroupResolutionConfiguration);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEdition() {
            return edition;
        }

        public final void setEdition(String edition) {
            this.edition = edition;
        }

        @Override
        public final Builder edition(String edition) {
            this.edition = edition;
            return this;
        }

        @Override
        public final Builder edition(IndexEdition edition) {
            this.edition(edition == null ? null : edition.toString());
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final ServerSideEncryptionConfiguration.Builder getServerSideEncryptionConfiguration() {
            return serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration.toBuilder() : null;
        }

        public final void setServerSideEncryptionConfiguration(
                ServerSideEncryptionConfiguration.BuilderImpl serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration
                    .build() : null;
        }

        @Override
        public final Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UserTokenConfiguration.Builder> getUserTokenConfigurations() {
            List<UserTokenConfiguration.Builder> result = UserTokenConfigurationListCopier
                    .copyToBuilder(this.userTokenConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserTokenConfigurations(Collection<UserTokenConfiguration.BuilderImpl> userTokenConfigurations) {
            this.userTokenConfigurations = UserTokenConfigurationListCopier.copyFromBuilder(userTokenConfigurations);
        }

        @Override
        public final Builder userTokenConfigurations(Collection<UserTokenConfiguration> userTokenConfigurations) {
            this.userTokenConfigurations = UserTokenConfigurationListCopier.copy(userTokenConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userTokenConfigurations(UserTokenConfiguration... userTokenConfigurations) {
            userTokenConfigurations(Arrays.asList(userTokenConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userTokenConfigurations(Consumer<UserTokenConfiguration.Builder>... userTokenConfigurations) {
            userTokenConfigurations(Stream.of(userTokenConfigurations)
                    .map(c -> UserTokenConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUserContextPolicy() {
            return userContextPolicy;
        }

        public final void setUserContextPolicy(String userContextPolicy) {
            this.userContextPolicy = userContextPolicy;
        }

        @Override
        public final Builder userContextPolicy(String userContextPolicy) {
            this.userContextPolicy = userContextPolicy;
            return this;
        }

        @Override
        public final Builder userContextPolicy(UserContextPolicy userContextPolicy) {
            this.userContextPolicy(userContextPolicy == null ? null : userContextPolicy.toString());
            return this;
        }

        public final UserGroupResolutionConfiguration.Builder getUserGroupResolutionConfiguration() {
            return userGroupResolutionConfiguration != null ? userGroupResolutionConfiguration.toBuilder() : null;
        }

        public final void setUserGroupResolutionConfiguration(
                UserGroupResolutionConfiguration.BuilderImpl userGroupResolutionConfiguration) {
            this.userGroupResolutionConfiguration = userGroupResolutionConfiguration != null ? userGroupResolutionConfiguration
                    .build() : null;
        }

        @Override
        public final Builder userGroupResolutionConfiguration(UserGroupResolutionConfiguration userGroupResolutionConfiguration) {
            this.userGroupResolutionConfiguration = userGroupResolutionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIndexRequest build() {
            return new CreateIndexRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
