/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSnapshotsResponse extends KendraResponse implements
        ToCopyableBuilder<GetSnapshotsResponse.Builder, GetSnapshotsResponse> {
    private static final SdkField<TimeRange> SNAP_SHOT_TIME_FILTER_FIELD = SdkField.<TimeRange> builder(MarshallingType.SDK_POJO)
            .memberName("SnapShotTimeFilter").getter(getter(GetSnapshotsResponse::snapShotTimeFilter))
            .setter(setter(Builder::snapShotTimeFilter)).constructor(TimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapShotTimeFilter").build())
            .build();

    private static final SdkField<List<String>> SNAPSHOTS_DATA_HEADER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SnapshotsDataHeader")
            .getter(getter(GetSnapshotsResponse::snapshotsDataHeader))
            .setter(setter(Builder::snapshotsDataHeader))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotsDataHeader").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<List<String>>> SNAPSHOTS_DATA_FIELD = SdkField
            .<List<List<String>>> builder(MarshallingType.LIST)
            .memberName("SnapshotsData")
            .getter(getter(GetSnapshotsResponse::snapshotsData))
            .setter(setter(Builder::snapshotsData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotsData").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetSnapshotsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAP_SHOT_TIME_FILTER_FIELD,
            SNAPSHOTS_DATA_HEADER_FIELD, SNAPSHOTS_DATA_FIELD, NEXT_TOKEN_FIELD));

    private final TimeRange snapShotTimeFilter;

    private final List<String> snapshotsDataHeader;

    private final List<List<String>> snapshotsData;

    private final String nextToken;

    private GetSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.snapShotTimeFilter = builder.snapShotTimeFilter;
        this.snapshotsDataHeader = builder.snapshotsDataHeader;
        this.snapshotsData = builder.snapshotsData;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The date-time for the beginning and end of the time window for the search metrics data.
     * </p>
     * 
     * @return The date-time for the beginning and end of the time window for the search metrics data.
     */
    public final TimeRange snapShotTimeFilter() {
        return snapShotTimeFilter;
    }

    /**
     * For responses, this returns true if the service returned a value for the SnapshotsDataHeader property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSnapshotsDataHeader() {
        return snapshotsDataHeader != null && !(snapshotsDataHeader instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The column headers for the search metrics data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSnapshotsDataHeader} method.
     * </p>
     * 
     * @return The column headers for the search metrics data.
     */
    public final List<String> snapshotsDataHeader() {
        return snapshotsDataHeader;
    }

    /**
     * For responses, this returns true if the service returned a value for the SnapshotsData property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSnapshotsData() {
        return snapshotsData != null && !(snapshotsData instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The search metrics data. The data returned depends on the metric type you requested.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSnapshotsData} method.
     * </p>
     * 
     * @return The search metrics data. The data returned depends on the metric type you requested.
     */
    public final List<List<String>> snapshotsData() {
        return snapshotsData;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Kendra returns this token, which you can use in a later request to retrieve
     * the next set of search metrics data.
     * </p>
     * 
     * @return If the response is truncated, Amazon Kendra returns this token, which you can use in a later request to
     *         retrieve the next set of search metrics data.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(snapShotTimeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(hasSnapshotsDataHeader() ? snapshotsDataHeader() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSnapshotsData() ? snapshotsData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSnapshotsResponse)) {
            return false;
        }
        GetSnapshotsResponse other = (GetSnapshotsResponse) obj;
        return Objects.equals(snapShotTimeFilter(), other.snapShotTimeFilter())
                && hasSnapshotsDataHeader() == other.hasSnapshotsDataHeader()
                && Objects.equals(snapshotsDataHeader(), other.snapshotsDataHeader())
                && hasSnapshotsData() == other.hasSnapshotsData() && Objects.equals(snapshotsData(), other.snapshotsData())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSnapshotsResponse").add("SnapShotTimeFilter", snapShotTimeFilter())
                .add("SnapshotsDataHeader", hasSnapshotsDataHeader() ? snapshotsDataHeader() : null)
                .add("SnapshotsData", hasSnapshotsData() ? snapshotsData() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapShotTimeFilter":
            return Optional.ofNullable(clazz.cast(snapShotTimeFilter()));
        case "SnapshotsDataHeader":
            return Optional.ofNullable(clazz.cast(snapshotsDataHeader()));
        case "SnapshotsData":
            return Optional.ofNullable(clazz.cast(snapshotsData()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSnapshotsResponse, T> g) {
        return obj -> g.apply((GetSnapshotsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSnapshotsResponse> {
        /**
         * <p>
         * The date-time for the beginning and end of the time window for the search metrics data.
         * </p>
         * 
         * @param snapShotTimeFilter
         *        The date-time for the beginning and end of the time window for the search metrics data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapShotTimeFilter(TimeRange snapShotTimeFilter);

        /**
         * <p>
         * The date-time for the beginning and end of the time window for the search metrics data.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeRange.Builder} avoiding the need to
         * create one manually via {@link TimeRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimeRange.Builder#build()} is called immediately and its result
         * is passed to {@link #snapShotTimeFilter(TimeRange)}.
         * 
         * @param snapShotTimeFilter
         *        a consumer that will call methods on {@link TimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapShotTimeFilter(TimeRange)
         */
        default Builder snapShotTimeFilter(Consumer<TimeRange.Builder> snapShotTimeFilter) {
            return snapShotTimeFilter(TimeRange.builder().applyMutation(snapShotTimeFilter).build());
        }

        /**
         * <p>
         * The column headers for the search metrics data.
         * </p>
         * 
         * @param snapshotsDataHeader
         *        The column headers for the search metrics data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotsDataHeader(Collection<String> snapshotsDataHeader);

        /**
         * <p>
         * The column headers for the search metrics data.
         * </p>
         * 
         * @param snapshotsDataHeader
         *        The column headers for the search metrics data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotsDataHeader(String... snapshotsDataHeader);

        /**
         * <p>
         * The search metrics data. The data returned depends on the metric type you requested.
         * </p>
         * 
         * @param snapshotsData
         *        The search metrics data. The data returned depends on the metric type you requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotsData(Collection<? extends Collection<String>> snapshotsData);

        /**
         * <p>
         * The search metrics data. The data returned depends on the metric type you requested.
         * </p>
         * 
         * @param snapshotsData
         *        The search metrics data. The data returned depends on the metric type you requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotsData(Collection<String>... snapshotsData);

        /**
         * <p>
         * If the response is truncated, Amazon Kendra returns this token, which you can use in a later request to
         * retrieve the next set of search metrics data.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Kendra returns this token, which you can use in a later request
         *        to retrieve the next set of search metrics data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends KendraResponse.BuilderImpl implements Builder {
        private TimeRange snapShotTimeFilter;

        private List<String> snapshotsDataHeader = DefaultSdkAutoConstructList.getInstance();

        private List<List<String>> snapshotsData = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSnapshotsResponse model) {
            super(model);
            snapShotTimeFilter(model.snapShotTimeFilter);
            snapshotsDataHeader(model.snapshotsDataHeader);
            snapshotsData(model.snapshotsData);
            nextToken(model.nextToken);
        }

        public final TimeRange.Builder getSnapShotTimeFilter() {
            return snapShotTimeFilter != null ? snapShotTimeFilter.toBuilder() : null;
        }

        public final void setSnapShotTimeFilter(TimeRange.BuilderImpl snapShotTimeFilter) {
            this.snapShotTimeFilter = snapShotTimeFilter != null ? snapShotTimeFilter.build() : null;
        }

        @Override
        public final Builder snapShotTimeFilter(TimeRange snapShotTimeFilter) {
            this.snapShotTimeFilter = snapShotTimeFilter;
            return this;
        }

        public final Collection<String> getSnapshotsDataHeader() {
            if (snapshotsDataHeader instanceof SdkAutoConstructList) {
                return null;
            }
            return snapshotsDataHeader;
        }

        public final void setSnapshotsDataHeader(Collection<String> snapshotsDataHeader) {
            this.snapshotsDataHeader = SnapshotsDataHeaderFieldsCopier.copy(snapshotsDataHeader);
        }

        @Override
        public final Builder snapshotsDataHeader(Collection<String> snapshotsDataHeader) {
            this.snapshotsDataHeader = SnapshotsDataHeaderFieldsCopier.copy(snapshotsDataHeader);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotsDataHeader(String... snapshotsDataHeader) {
            snapshotsDataHeader(Arrays.asList(snapshotsDataHeader));
            return this;
        }

        public final Collection<? extends Collection<String>> getSnapshotsData() {
            if (snapshotsData instanceof SdkAutoConstructList) {
                return null;
            }
            return snapshotsData;
        }

        public final void setSnapshotsData(Collection<? extends Collection<String>> snapshotsData) {
            this.snapshotsData = SnapshotsDataRecordsCopier.copy(snapshotsData);
        }

        @Override
        public final Builder snapshotsData(Collection<? extends Collection<String>> snapshotsData) {
            this.snapshotsData = SnapshotsDataRecordsCopier.copy(snapshotsData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotsData(Collection<String>... snapshotsData) {
            snapshotsData(Arrays.asList(snapshotsData));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetSnapshotsResponse build() {
            return new GetSnapshotsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
