/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDataSourceSyncJobsRequest extends KendraRequest implements
        ToCopyableBuilder<ListDataSourceSyncJobsRequest.Builder, ListDataSourceSyncJobsRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ListDataSourceSyncJobsRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(ListDataSourceSyncJobsRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDataSourceSyncJobsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListDataSourceSyncJobsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<TimeRange> START_TIME_FILTER_FIELD = SdkField.<TimeRange> builder(MarshallingType.SDK_POJO)
            .memberName("StartTimeFilter").getter(getter(ListDataSourceSyncJobsRequest::startTimeFilter))
            .setter(setter(Builder::startTimeFilter)).constructor(TimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimeFilter").build()).build();

    private static final SdkField<String> STATUS_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusFilter").getter(getter(ListDataSourceSyncJobsRequest::statusFilterAsString))
            .setter(setter(Builder::statusFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, INDEX_ID_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, START_TIME_FILTER_FIELD, STATUS_FILTER_FIELD));

    private final String id;

    private final String indexId;

    private final String nextToken;

    private final Integer maxResults;

    private final TimeRange startTimeFilter;

    private final String statusFilter;

    private ListDataSourceSyncJobsRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.indexId = builder.indexId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.startTimeFilter = builder.startTimeFilter;
        this.statusFilter = builder.statusFilter;
    }

    /**
     * <p>
     * The identifier of the data source.
     * </p>
     * 
     * @return The identifier of the data source.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The identifier of the index that contains the data source.
     * </p>
     * 
     * @return The identifier of the index that contains the data source.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a
     * pagination token in the response. You can use this pagination token to retrieve the next set of jobs.
     * </p>
     * 
     * @return If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a
     *         pagination token in the response. You can use this pagination token to retrieve the next set of jobs.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of synchronization jobs to return in the response. If there are fewer results in the list,
     * this response contains only the actual results.
     * </p>
     * 
     * @return The maximum number of synchronization jobs to return in the response. If there are fewer results in the
     *         list, this response contains only the actual results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * When specified, the synchronization jobs returned in the list are limited to jobs between the specified dates.
     * </p>
     * 
     * @return When specified, the synchronization jobs returned in the list are limited to jobs between the specified
     *         dates.
     */
    public final TimeRange startTimeFilter() {
        return startTimeFilter;
    }

    /**
     * <p>
     * When specified, only returns synchronization jobs with the <code>Status</code> field equal to the specified
     * status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusFilter} will
     * return {@link DataSourceSyncJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusFilterAsString}.
     * </p>
     * 
     * @return When specified, only returns synchronization jobs with the <code>Status</code> field equal to the
     *         specified status.
     * @see DataSourceSyncJobStatus
     */
    public final DataSourceSyncJobStatus statusFilter() {
        return DataSourceSyncJobStatus.fromValue(statusFilter);
    }

    /**
     * <p>
     * When specified, only returns synchronization jobs with the <code>Status</code> field equal to the specified
     * status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusFilter} will
     * return {@link DataSourceSyncJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusFilterAsString}.
     * </p>
     * 
     * @return When specified, only returns synchronization jobs with the <code>Status</code> field equal to the
     *         specified status.
     * @see DataSourceSyncJobStatus
     */
    public final String statusFilterAsString() {
        return statusFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(startTimeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(statusFilterAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataSourceSyncJobsRequest)) {
            return false;
        }
        ListDataSourceSyncJobsRequest other = (ListDataSourceSyncJobsRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(indexId(), other.indexId())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(startTimeFilter(), other.startTimeFilter())
                && Objects.equals(statusFilterAsString(), other.statusFilterAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDataSourceSyncJobsRequest").add("Id", id()).add("IndexId", indexId())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).add("StartTimeFilter", startTimeFilter())
                .add("StatusFilter", statusFilterAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "StartTimeFilter":
            return Optional.ofNullable(clazz.cast(startTimeFilter()));
        case "StatusFilter":
            return Optional.ofNullable(clazz.cast(statusFilterAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDataSourceSyncJobsRequest, T> g) {
        return obj -> g.apply((ListDataSourceSyncJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListDataSourceSyncJobsRequest> {
        /**
         * <p>
         * The identifier of the data source.
         * </p>
         * 
         * @param id
         *        The identifier of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The identifier of the index that contains the data source.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index that contains the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a
         * pagination token in the response. You can use this pagination token to retrieve the next set of jobs.
         * </p>
         * 
         * @param nextToken
         *        If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra
         *        returns a pagination token in the response. You can use this pagination token to retrieve the next set
         *        of jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of synchronization jobs to return in the response. If there are fewer results in the list,
         * this response contains only the actual results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of synchronization jobs to return in the response. If there are fewer results in
         *        the list, this response contains only the actual results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * When specified, the synchronization jobs returned in the list are limited to jobs between the specified
         * dates.
         * </p>
         * 
         * @param startTimeFilter
         *        When specified, the synchronization jobs returned in the list are limited to jobs between the
         *        specified dates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeFilter(TimeRange startTimeFilter);

        /**
         * <p>
         * When specified, the synchronization jobs returned in the list are limited to jobs between the specified
         * dates.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeRange.Builder} avoiding the need to
         * create one manually via {@link TimeRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimeRange.Builder#build()} is called immediately and its result
         * is passed to {@link #startTimeFilter(TimeRange)}.
         * 
         * @param startTimeFilter
         *        a consumer that will call methods on {@link TimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startTimeFilter(TimeRange)
         */
        default Builder startTimeFilter(Consumer<TimeRange.Builder> startTimeFilter) {
            return startTimeFilter(TimeRange.builder().applyMutation(startTimeFilter).build());
        }

        /**
         * <p>
         * When specified, only returns synchronization jobs with the <code>Status</code> field equal to the specified
         * status.
         * </p>
         * 
         * @param statusFilter
         *        When specified, only returns synchronization jobs with the <code>Status</code> field equal to the
         *        specified status.
         * @see DataSourceSyncJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceSyncJobStatus
         */
        Builder statusFilter(String statusFilter);

        /**
         * <p>
         * When specified, only returns synchronization jobs with the <code>Status</code> field equal to the specified
         * status.
         * </p>
         * 
         * @param statusFilter
         *        When specified, only returns synchronization jobs with the <code>Status</code> field equal to the
         *        specified status.
         * @see DataSourceSyncJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceSyncJobStatus
         */
        Builder statusFilter(DataSourceSyncJobStatus statusFilter);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String id;

        private String indexId;

        private String nextToken;

        private Integer maxResults;

        private TimeRange startTimeFilter;

        private String statusFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataSourceSyncJobsRequest model) {
            super(model);
            id(model.id);
            indexId(model.indexId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            startTimeFilter(model.startTimeFilter);
            statusFilter(model.statusFilter);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final TimeRange.Builder getStartTimeFilter() {
            return startTimeFilter != null ? startTimeFilter.toBuilder() : null;
        }

        public final void setStartTimeFilter(TimeRange.BuilderImpl startTimeFilter) {
            this.startTimeFilter = startTimeFilter != null ? startTimeFilter.build() : null;
        }

        @Override
        public final Builder startTimeFilter(TimeRange startTimeFilter) {
            this.startTimeFilter = startTimeFilter;
            return this;
        }

        public final String getStatusFilter() {
            return statusFilter;
        }

        public final void setStatusFilter(String statusFilter) {
            this.statusFilter = statusFilter;
        }

        @Override
        public final Builder statusFilter(String statusFilter) {
            this.statusFilter = statusFilter;
            return this;
        }

        @Override
        public final Builder statusFilter(DataSourceSyncJobStatus statusFilter) {
            this.statusFilter(statusFilter == null ? null : statusFilter.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDataSourceSyncJobsRequest build() {
            return new ListDataSourceSyncJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
