/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeIndexResponse extends KendraResponse implements
        ToCopyableBuilder<DescribeIndexResponse.Builder, DescribeIndexResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeIndexResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(DescribeIndexResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> EDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Edition")
            .getter(getter(DescribeIndexResponse::editionAsString)).setter(setter(Builder::edition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Edition").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeIndexResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<ServerSideEncryptionConfiguration> SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<ServerSideEncryptionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ServerSideEncryptionConfiguration")
            .getter(getter(DescribeIndexResponse::serverSideEncryptionConfiguration))
            .setter(setter(Builder::serverSideEncryptionConfiguration))
            .constructor(ServerSideEncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideEncryptionConfiguration")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeIndexResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeIndexResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(DescribeIndexResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(DescribeIndexResponse::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final SdkField<List<DocumentMetadataConfiguration>> DOCUMENT_METADATA_CONFIGURATIONS_FIELD = SdkField
            .<List<DocumentMetadataConfiguration>> builder(MarshallingType.LIST)
            .memberName("DocumentMetadataConfigurations")
            .getter(getter(DescribeIndexResponse::documentMetadataConfigurations))
            .setter(setter(Builder::documentMetadataConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentMetadataConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentMetadataConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentMetadataConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<IndexStatistics> INDEX_STATISTICS_FIELD = SdkField
            .<IndexStatistics> builder(MarshallingType.SDK_POJO).memberName("IndexStatistics")
            .getter(getter(DescribeIndexResponse::indexStatistics)).setter(setter(Builder::indexStatistics))
            .constructor(IndexStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexStatistics").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(DescribeIndexResponse::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<CapacityUnitsConfiguration> CAPACITY_UNITS_FIELD = SdkField
            .<CapacityUnitsConfiguration> builder(MarshallingType.SDK_POJO).memberName("CapacityUnits")
            .getter(getter(DescribeIndexResponse::capacityUnits)).setter(setter(Builder::capacityUnits))
            .constructor(CapacityUnitsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityUnits").build()).build();

    private static final SdkField<List<UserTokenConfiguration>> USER_TOKEN_CONFIGURATIONS_FIELD = SdkField
            .<List<UserTokenConfiguration>> builder(MarshallingType.LIST)
            .memberName("UserTokenConfigurations")
            .getter(getter(DescribeIndexResponse::userTokenConfigurations))
            .setter(setter(Builder::userTokenConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserTokenConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserTokenConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserTokenConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> USER_CONTEXT_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserContextPolicy").getter(getter(DescribeIndexResponse::userContextPolicyAsString))
            .setter(setter(Builder::userContextPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserContextPolicy").build()).build();

    private static final SdkField<UserGroupResolutionConfiguration> USER_GROUP_RESOLUTION_CONFIGURATION_FIELD = SdkField
            .<UserGroupResolutionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("UserGroupResolutionConfiguration")
            .getter(getter(DescribeIndexResponse::userGroupResolutionConfiguration))
            .setter(setter(Builder::userGroupResolutionConfiguration))
            .constructor(UserGroupResolutionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupResolutionConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD,
            EDITION_FIELD, ROLE_ARN_FIELD, SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD, STATUS_FIELD, DESCRIPTION_FIELD,
            CREATED_AT_FIELD, UPDATED_AT_FIELD, DOCUMENT_METADATA_CONFIGURATIONS_FIELD, INDEX_STATISTICS_FIELD,
            ERROR_MESSAGE_FIELD, CAPACITY_UNITS_FIELD, USER_TOKEN_CONFIGURATIONS_FIELD, USER_CONTEXT_POLICY_FIELD,
            USER_GROUP_RESOLUTION_CONFIGURATION_FIELD));

    private final String name;

    private final String id;

    private final String edition;

    private final String roleArn;

    private final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;

    private final String status;

    private final String description;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final List<DocumentMetadataConfiguration> documentMetadataConfigurations;

    private final IndexStatistics indexStatistics;

    private final String errorMessage;

    private final CapacityUnitsConfiguration capacityUnits;

    private final List<UserTokenConfiguration> userTokenConfigurations;

    private final String userContextPolicy;

    private final UserGroupResolutionConfiguration userGroupResolutionConfiguration;

    private DescribeIndexResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.id = builder.id;
        this.edition = builder.edition;
        this.roleArn = builder.roleArn;
        this.serverSideEncryptionConfiguration = builder.serverSideEncryptionConfiguration;
        this.status = builder.status;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.documentMetadataConfigurations = builder.documentMetadataConfigurations;
        this.indexStatistics = builder.indexStatistics;
        this.errorMessage = builder.errorMessage;
        this.capacityUnits = builder.capacityUnits;
        this.userTokenConfigurations = builder.userTokenConfigurations;
        this.userContextPolicy = builder.userContextPolicy;
        this.userGroupResolutionConfiguration = builder.userGroupResolutionConfiguration;
    }

    /**
     * <p>
     * The name of the index.
     * </p>
     * 
     * @return The name of the index.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The identifier of the index.
     * </p>
     * 
     * @return The identifier of the index.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Kendra edition used for the index. You decide the edition when you create the index.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #edition} will
     * return {@link IndexEdition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #editionAsString}.
     * </p>
     * 
     * @return The Amazon Kendra edition used for the index. You decide the edition when you create the index.
     * @see IndexEdition
     */
    public final IndexEdition edition() {
        return IndexEdition.fromValue(edition);
    }

    /**
     * <p>
     * The Amazon Kendra edition used for the index. You decide the edition when you create the index.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #edition} will
     * return {@link IndexEdition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #editionAsString}.
     * </p>
     * 
     * @return The Amazon Kendra edition used for the index. You decide the edition when you create the index.
     * @see IndexEdition
     */
    public final String editionAsString() {
        return edition;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that gives Amazon Kendra permission to write to your Amazon
     * Cloudwatch logs.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that gives Amazon Kendra permission to write to your
     *         Amazon Cloudwatch logs.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The identifier of the KMScustomer master key (CMK) that is used to encrypt your data. Amazon Kendra doesn't
     * support asymmetric CMKs.
     * </p>
     * 
     * @return The identifier of the KMScustomer master key (CMK) that is used to encrypt your data. Amazon Kendra
     *         doesn't support asymmetric CMKs.
     */
    public final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration() {
        return serverSideEncryptionConfiguration;
    }

    /**
     * <p>
     * The current status of the index. When the value is <code>ACTIVE</code>, the index is ready for use. If the
     * <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains a message
     * that explains why.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IndexStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the index. When the value is <code>ACTIVE</code>, the index is ready for use. If
     *         the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains
     *         a message that explains why.
     * @see IndexStatus
     */
    public final IndexStatus status() {
        return IndexStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the index. When the value is <code>ACTIVE</code>, the index is ready for use. If the
     * <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains a message
     * that explains why.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IndexStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the index. When the value is <code>ACTIVE</code>, the index is ready for use. If
     *         the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains
     *         a message that explains why.
     * @see IndexStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The description for the index.
     * </p>
     * 
     * @return The description for the index.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Unix datetime that the index was created.
     * </p>
     * 
     * @return The Unix datetime that the index was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Unix datetime that the index was last updated.
     * </p>
     * 
     * @return The Unix datetime that the index was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the DocumentMetadataConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDocumentMetadataConfigurations() {
        return documentMetadataConfigurations != null && !(documentMetadataConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configuration settings for any metadata applied to the documents in the index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDocumentMetadataConfigurations} method.
     * </p>
     * 
     * @return Configuration settings for any metadata applied to the documents in the index.
     */
    public final List<DocumentMetadataConfiguration> documentMetadataConfigurations() {
        return documentMetadataConfigurations;
    }

    /**
     * <p>
     * Provides information about the number of FAQ questions and answers and the number of text documents indexed.
     * </p>
     * 
     * @return Provides information about the number of FAQ questions and answers and the number of text documents
     *         indexed.
     */
    public final IndexStatistics indexStatistics() {
        return indexStatistics;
    }

    /**
     * <p>
     * When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains a
     * message that explains why.
     * </p>
     * 
     * @return When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field
     *         contains a message that explains why.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * For Enterprise Edition indexes, you can choose to use additional capacity to meet the needs of your application.
     * This contains the capacity units used for the index. A query or document storage capacity of zero indicates that
     * the index is using the default capacity. For more information on the default capacity for an index and adjusting
     * this, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html">Adjusting capacity</a>.
     * </p>
     * 
     * @return For Enterprise Edition indexes, you can choose to use additional capacity to meet the needs of your
     *         application. This contains the capacity units used for the index. A query or document storage capacity of
     *         zero indicates that the index is using the default capacity. For more information on the default capacity
     *         for an index and adjusting this, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html">Adjusting capacity</a>.
     */
    public final CapacityUnitsConfiguration capacityUnits() {
        return capacityUnits;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserTokenConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasUserTokenConfigurations() {
        return userTokenConfigurations != null && !(userTokenConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The user token configuration for the Amazon Kendra index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserTokenConfigurations} method.
     * </p>
     * 
     * @return The user token configuration for the Amazon Kendra index.
     */
    public final List<UserTokenConfiguration> userTokenConfigurations() {
        return userTokenConfigurations;
    }

    /**
     * <p>
     * The user context policy for the Amazon Kendra index.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userContextPolicy}
     * will return {@link UserContextPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #userContextPolicyAsString}.
     * </p>
     * 
     * @return The user context policy for the Amazon Kendra index.
     * @see UserContextPolicy
     */
    public final UserContextPolicy userContextPolicy() {
        return UserContextPolicy.fromValue(userContextPolicy);
    }

    /**
     * <p>
     * The user context policy for the Amazon Kendra index.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userContextPolicy}
     * will return {@link UserContextPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #userContextPolicyAsString}.
     * </p>
     * 
     * @return The user context policy for the Amazon Kendra index.
     * @see UserContextPolicy
     */
    public final String userContextPolicyAsString() {
        return userContextPolicy;
    }

    /**
     * <p>
     * Shows whether you have enabled the configuration for fetching access levels of groups and users from an Amazon
     * Web Services Single Sign On identity source.
     * </p>
     * 
     * @return Shows whether you have enabled the configuration for fetching access levels of groups and users from an
     *         Amazon Web Services Single Sign On identity source.
     */
    public final UserGroupResolutionConfiguration userGroupResolutionConfiguration() {
        return userGroupResolutionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(editionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasDocumentMetadataConfigurations() ? documentMetadataConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(indexStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(capacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserTokenConfigurations() ? userTokenConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userContextPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userGroupResolutionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIndexResponse)) {
            return false;
        }
        DescribeIndexResponse other = (DescribeIndexResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(id(), other.id())
                && Objects.equals(editionAsString(), other.editionAsString()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(serverSideEncryptionConfiguration(), other.serverSideEncryptionConfiguration())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(description(), other.description())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && hasDocumentMetadataConfigurations() == other.hasDocumentMetadataConfigurations()
                && Objects.equals(documentMetadataConfigurations(), other.documentMetadataConfigurations())
                && Objects.equals(indexStatistics(), other.indexStatistics())
                && Objects.equals(errorMessage(), other.errorMessage()) && Objects.equals(capacityUnits(), other.capacityUnits())
                && hasUserTokenConfigurations() == other.hasUserTokenConfigurations()
                && Objects.equals(userTokenConfigurations(), other.userTokenConfigurations())
                && Objects.equals(userContextPolicyAsString(), other.userContextPolicyAsString())
                && Objects.equals(userGroupResolutionConfiguration(), other.userGroupResolutionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeIndexResponse")
                .add("Name", name())
                .add("Id", id())
                .add("Edition", editionAsString())
                .add("RoleArn", roleArn())
                .add("ServerSideEncryptionConfiguration", serverSideEncryptionConfiguration())
                .add("Status", statusAsString())
                .add("Description", description())
                .add("CreatedAt", createdAt())
                .add("UpdatedAt", updatedAt())
                .add("DocumentMetadataConfigurations",
                        hasDocumentMetadataConfigurations() ? documentMetadataConfigurations() : null)
                .add("IndexStatistics", indexStatistics()).add("ErrorMessage", errorMessage())
                .add("CapacityUnits", capacityUnits())
                .add("UserTokenConfigurations", hasUserTokenConfigurations() ? userTokenConfigurations() : null)
                .add("UserContextPolicy", userContextPolicyAsString())
                .add("UserGroupResolutionConfiguration", userGroupResolutionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Edition":
            return Optional.ofNullable(clazz.cast(editionAsString()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "ServerSideEncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(serverSideEncryptionConfiguration()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "DocumentMetadataConfigurations":
            return Optional.ofNullable(clazz.cast(documentMetadataConfigurations()));
        case "IndexStatistics":
            return Optional.ofNullable(clazz.cast(indexStatistics()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "CapacityUnits":
            return Optional.ofNullable(clazz.cast(capacityUnits()));
        case "UserTokenConfigurations":
            return Optional.ofNullable(clazz.cast(userTokenConfigurations()));
        case "UserContextPolicy":
            return Optional.ofNullable(clazz.cast(userContextPolicyAsString()));
        case "UserGroupResolutionConfiguration":
            return Optional.ofNullable(clazz.cast(userGroupResolutionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIndexResponse, T> g) {
        return obj -> g.apply((DescribeIndexResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeIndexResponse> {
        /**
         * <p>
         * The name of the index.
         * </p>
         * 
         * @param name
         *        The name of the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The identifier of the index.
         * </p>
         * 
         * @param id
         *        The identifier of the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Kendra edition used for the index. You decide the edition when you create the index.
         * </p>
         * 
         * @param edition
         *        The Amazon Kendra edition used for the index. You decide the edition when you create the index.
         * @see IndexEdition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexEdition
         */
        Builder edition(String edition);

        /**
         * <p>
         * The Amazon Kendra edition used for the index. You decide the edition when you create the index.
         * </p>
         * 
         * @param edition
         *        The Amazon Kendra edition used for the index. You decide the edition when you create the index.
         * @see IndexEdition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexEdition
         */
        Builder edition(IndexEdition edition);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that gives Amazon Kendra permission to write to your Amazon
         * Cloudwatch logs.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role that gives Amazon Kendra permission to write to your
         *        Amazon Cloudwatch logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The identifier of the KMScustomer master key (CMK) that is used to encrypt your data. Amazon Kendra doesn't
         * support asymmetric CMKs.
         * </p>
         * 
         * @param serverSideEncryptionConfiguration
         *        The identifier of the KMScustomer master key (CMK) that is used to encrypt your data. Amazon Kendra
         *        doesn't support asymmetric CMKs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration);

        /**
         * <p>
         * The identifier of the KMScustomer master key (CMK) that is used to encrypt your data. Amazon Kendra doesn't
         * support asymmetric CMKs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ServerSideEncryptionConfiguration.Builder} avoiding the need to create one manually via
         * {@link ServerSideEncryptionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServerSideEncryptionConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration)}.
         * 
         * @param serverSideEncryptionConfiguration
         *        a consumer that will call methods on {@link ServerSideEncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration)
         */
        default Builder serverSideEncryptionConfiguration(
                Consumer<ServerSideEncryptionConfiguration.Builder> serverSideEncryptionConfiguration) {
            return serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration.builder()
                    .applyMutation(serverSideEncryptionConfiguration).build());
        }

        /**
         * <p>
         * The current status of the index. When the value is <code>ACTIVE</code>, the index is ready for use. If the
         * <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains a
         * message that explains why.
         * </p>
         * 
         * @param status
         *        The current status of the index. When the value is <code>ACTIVE</code>, the index is ready for use. If
         *        the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field
         *        contains a message that explains why.
         * @see IndexStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the index. When the value is <code>ACTIVE</code>, the index is ready for use. If the
         * <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains a
         * message that explains why.
         * </p>
         * 
         * @param status
         *        The current status of the index. When the value is <code>ACTIVE</code>, the index is ready for use. If
         *        the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field
         *        contains a message that explains why.
         * @see IndexStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexStatus
         */
        Builder status(IndexStatus status);

        /**
         * <p>
         * The description for the index.
         * </p>
         * 
         * @param description
         *        The description for the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Unix datetime that the index was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix datetime that the index was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Unix datetime that the index was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The Unix datetime that the index was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * Configuration settings for any metadata applied to the documents in the index.
         * </p>
         * 
         * @param documentMetadataConfigurations
         *        Configuration settings for any metadata applied to the documents in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentMetadataConfigurations(Collection<DocumentMetadataConfiguration> documentMetadataConfigurations);

        /**
         * <p>
         * Configuration settings for any metadata applied to the documents in the index.
         * </p>
         * 
         * @param documentMetadataConfigurations
         *        Configuration settings for any metadata applied to the documents in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentMetadataConfigurations(DocumentMetadataConfiguration... documentMetadataConfigurations);

        /**
         * <p>
         * Configuration settings for any metadata applied to the documents in the index.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <DocumentMetadataConfiguration>.Builder} avoiding the need to create one manually via {@link List
         * <DocumentMetadataConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DocumentMetadataConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #documentMetadataConfigurations(List<DocumentMetadataConfiguration>)}.
         * 
         * @param documentMetadataConfigurations
         *        a consumer that will call methods on {@link List<DocumentMetadataConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentMetadataConfigurations(List<DocumentMetadataConfiguration>)
         */
        Builder documentMetadataConfigurations(Consumer<DocumentMetadataConfiguration.Builder>... documentMetadataConfigurations);

        /**
         * <p>
         * Provides information about the number of FAQ questions and answers and the number of text documents indexed.
         * </p>
         * 
         * @param indexStatistics
         *        Provides information about the number of FAQ questions and answers and the number of text documents
         *        indexed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexStatistics(IndexStatistics indexStatistics);

        /**
         * <p>
         * Provides information about the number of FAQ questions and answers and the number of text documents indexed.
         * </p>
         * This is a convenience method that creates an instance of the {@link IndexStatistics.Builder} avoiding the
         * need to create one manually via {@link IndexStatistics#builder()}.
         *
         * When the {@link Consumer} completes, {@link IndexStatistics.Builder#build()} is called immediately and its
         * result is passed to {@link #indexStatistics(IndexStatistics)}.
         * 
         * @param indexStatistics
         *        a consumer that will call methods on {@link IndexStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #indexStatistics(IndexStatistics)
         */
        default Builder indexStatistics(Consumer<IndexStatistics.Builder> indexStatistics) {
            return indexStatistics(IndexStatistics.builder().applyMutation(indexStatistics).build());
        }

        /**
         * <p>
         * When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains
         * a message that explains why.
         * </p>
         * 
         * @param errorMessage
         *        When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field
         *        contains a message that explains why.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * For Enterprise Edition indexes, you can choose to use additional capacity to meet the needs of your
         * application. This contains the capacity units used for the index. A query or document storage capacity of
         * zero indicates that the index is using the default capacity. For more information on the default capacity for
         * an index and adjusting this, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html">Adjusting capacity</a>.
         * </p>
         * 
         * @param capacityUnits
         *        For Enterprise Edition indexes, you can choose to use additional capacity to meet the needs of your
         *        application. This contains the capacity units used for the index. A query or document storage capacity
         *        of zero indicates that the index is using the default capacity. For more information on the default
         *        capacity for an index and adjusting this, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html">Adjusting capacity</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityUnits(CapacityUnitsConfiguration capacityUnits);

        /**
         * <p>
         * For Enterprise Edition indexes, you can choose to use additional capacity to meet the needs of your
         * application. This contains the capacity units used for the index. A query or document storage capacity of
         * zero indicates that the index is using the default capacity. For more information on the default capacity for
         * an index and adjusting this, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html">Adjusting capacity</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacityUnitsConfiguration.Builder}
         * avoiding the need to create one manually via {@link CapacityUnitsConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link CapacityUnitsConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #capacityUnits(CapacityUnitsConfiguration)}.
         * 
         * @param capacityUnits
         *        a consumer that will call methods on {@link CapacityUnitsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityUnits(CapacityUnitsConfiguration)
         */
        default Builder capacityUnits(Consumer<CapacityUnitsConfiguration.Builder> capacityUnits) {
            return capacityUnits(CapacityUnitsConfiguration.builder().applyMutation(capacityUnits).build());
        }

        /**
         * <p>
         * The user token configuration for the Amazon Kendra index.
         * </p>
         * 
         * @param userTokenConfigurations
         *        The user token configuration for the Amazon Kendra index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userTokenConfigurations(Collection<UserTokenConfiguration> userTokenConfigurations);

        /**
         * <p>
         * The user token configuration for the Amazon Kendra index.
         * </p>
         * 
         * @param userTokenConfigurations
         *        The user token configuration for the Amazon Kendra index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userTokenConfigurations(UserTokenConfiguration... userTokenConfigurations);

        /**
         * <p>
         * The user token configuration for the Amazon Kendra index.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<UserTokenConfiguration>.Builder}
         * avoiding the need to create one manually via {@link List<UserTokenConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UserTokenConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #userTokenConfigurations(List<UserTokenConfiguration>)}.
         * 
         * @param userTokenConfigurations
         *        a consumer that will call methods on {@link List<UserTokenConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userTokenConfigurations(List<UserTokenConfiguration>)
         */
        Builder userTokenConfigurations(Consumer<UserTokenConfiguration.Builder>... userTokenConfigurations);

        /**
         * <p>
         * The user context policy for the Amazon Kendra index.
         * </p>
         * 
         * @param userContextPolicy
         *        The user context policy for the Amazon Kendra index.
         * @see UserContextPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserContextPolicy
         */
        Builder userContextPolicy(String userContextPolicy);

        /**
         * <p>
         * The user context policy for the Amazon Kendra index.
         * </p>
         * 
         * @param userContextPolicy
         *        The user context policy for the Amazon Kendra index.
         * @see UserContextPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserContextPolicy
         */
        Builder userContextPolicy(UserContextPolicy userContextPolicy);

        /**
         * <p>
         * Shows whether you have enabled the configuration for fetching access levels of groups and users from an
         * Amazon Web Services Single Sign On identity source.
         * </p>
         * 
         * @param userGroupResolutionConfiguration
         *        Shows whether you have enabled the configuration for fetching access levels of groups and users from
         *        an Amazon Web Services Single Sign On identity source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroupResolutionConfiguration(UserGroupResolutionConfiguration userGroupResolutionConfiguration);

        /**
         * <p>
         * Shows whether you have enabled the configuration for fetching access levels of groups and users from an
         * Amazon Web Services Single Sign On identity source.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserGroupResolutionConfiguration.Builder}
         * avoiding the need to create one manually via {@link UserGroupResolutionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserGroupResolutionConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #userGroupResolutionConfiguration(UserGroupResolutionConfiguration)}.
         * 
         * @param userGroupResolutionConfiguration
         *        a consumer that will call methods on {@link UserGroupResolutionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userGroupResolutionConfiguration(UserGroupResolutionConfiguration)
         */
        default Builder userGroupResolutionConfiguration(
                Consumer<UserGroupResolutionConfiguration.Builder> userGroupResolutionConfiguration) {
            return userGroupResolutionConfiguration(UserGroupResolutionConfiguration.builder()
                    .applyMutation(userGroupResolutionConfiguration).build());
        }
    }

    static final class BuilderImpl extends KendraResponse.BuilderImpl implements Builder {
        private String name;

        private String id;

        private String edition;

        private String roleArn;

        private ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;

        private String status;

        private String description;

        private Instant createdAt;

        private Instant updatedAt;

        private List<DocumentMetadataConfiguration> documentMetadataConfigurations = DefaultSdkAutoConstructList.getInstance();

        private IndexStatistics indexStatistics;

        private String errorMessage;

        private CapacityUnitsConfiguration capacityUnits;

        private List<UserTokenConfiguration> userTokenConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String userContextPolicy;

        private UserGroupResolutionConfiguration userGroupResolutionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIndexResponse model) {
            super(model);
            name(model.name);
            id(model.id);
            edition(model.edition);
            roleArn(model.roleArn);
            serverSideEncryptionConfiguration(model.serverSideEncryptionConfiguration);
            status(model.status);
            description(model.description);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            documentMetadataConfigurations(model.documentMetadataConfigurations);
            indexStatistics(model.indexStatistics);
            errorMessage(model.errorMessage);
            capacityUnits(model.capacityUnits);
            userTokenConfigurations(model.userTokenConfigurations);
            userContextPolicy(model.userContextPolicy);
            userGroupResolutionConfiguration(model.userGroupResolutionConfiguration);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getEdition() {
            return edition;
        }

        public final void setEdition(String edition) {
            this.edition = edition;
        }

        @Override
        public final Builder edition(String edition) {
            this.edition = edition;
            return this;
        }

        @Override
        public final Builder edition(IndexEdition edition) {
            this.edition(edition == null ? null : edition.toString());
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final ServerSideEncryptionConfiguration.Builder getServerSideEncryptionConfiguration() {
            return serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration.toBuilder() : null;
        }

        public final void setServerSideEncryptionConfiguration(
                ServerSideEncryptionConfiguration.BuilderImpl serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration
                    .build() : null;
        }

        @Override
        public final Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IndexStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final List<DocumentMetadataConfiguration.Builder> getDocumentMetadataConfigurations() {
            List<DocumentMetadataConfiguration.Builder> result = DocumentMetadataConfigurationListCopier
                    .copyToBuilder(this.documentMetadataConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentMetadataConfigurations(
                Collection<DocumentMetadataConfiguration.BuilderImpl> documentMetadataConfigurations) {
            this.documentMetadataConfigurations = DocumentMetadataConfigurationListCopier
                    .copyFromBuilder(documentMetadataConfigurations);
        }

        @Override
        public final Builder documentMetadataConfigurations(
                Collection<DocumentMetadataConfiguration> documentMetadataConfigurations) {
            this.documentMetadataConfigurations = DocumentMetadataConfigurationListCopier.copy(documentMetadataConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentMetadataConfigurations(DocumentMetadataConfiguration... documentMetadataConfigurations) {
            documentMetadataConfigurations(Arrays.asList(documentMetadataConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentMetadataConfigurations(
                Consumer<DocumentMetadataConfiguration.Builder>... documentMetadataConfigurations) {
            documentMetadataConfigurations(Stream.of(documentMetadataConfigurations)
                    .map(c -> DocumentMetadataConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final IndexStatistics.Builder getIndexStatistics() {
            return indexStatistics != null ? indexStatistics.toBuilder() : null;
        }

        public final void setIndexStatistics(IndexStatistics.BuilderImpl indexStatistics) {
            this.indexStatistics = indexStatistics != null ? indexStatistics.build() : null;
        }

        @Override
        public final Builder indexStatistics(IndexStatistics indexStatistics) {
            this.indexStatistics = indexStatistics;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final CapacityUnitsConfiguration.Builder getCapacityUnits() {
            return capacityUnits != null ? capacityUnits.toBuilder() : null;
        }

        public final void setCapacityUnits(CapacityUnitsConfiguration.BuilderImpl capacityUnits) {
            this.capacityUnits = capacityUnits != null ? capacityUnits.build() : null;
        }

        @Override
        public final Builder capacityUnits(CapacityUnitsConfiguration capacityUnits) {
            this.capacityUnits = capacityUnits;
            return this;
        }

        public final List<UserTokenConfiguration.Builder> getUserTokenConfigurations() {
            List<UserTokenConfiguration.Builder> result = UserTokenConfigurationListCopier
                    .copyToBuilder(this.userTokenConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserTokenConfigurations(Collection<UserTokenConfiguration.BuilderImpl> userTokenConfigurations) {
            this.userTokenConfigurations = UserTokenConfigurationListCopier.copyFromBuilder(userTokenConfigurations);
        }

        @Override
        public final Builder userTokenConfigurations(Collection<UserTokenConfiguration> userTokenConfigurations) {
            this.userTokenConfigurations = UserTokenConfigurationListCopier.copy(userTokenConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userTokenConfigurations(UserTokenConfiguration... userTokenConfigurations) {
            userTokenConfigurations(Arrays.asList(userTokenConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userTokenConfigurations(Consumer<UserTokenConfiguration.Builder>... userTokenConfigurations) {
            userTokenConfigurations(Stream.of(userTokenConfigurations)
                    .map(c -> UserTokenConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUserContextPolicy() {
            return userContextPolicy;
        }

        public final void setUserContextPolicy(String userContextPolicy) {
            this.userContextPolicy = userContextPolicy;
        }

        @Override
        public final Builder userContextPolicy(String userContextPolicy) {
            this.userContextPolicy = userContextPolicy;
            return this;
        }

        @Override
        public final Builder userContextPolicy(UserContextPolicy userContextPolicy) {
            this.userContextPolicy(userContextPolicy == null ? null : userContextPolicy.toString());
            return this;
        }

        public final UserGroupResolutionConfiguration.Builder getUserGroupResolutionConfiguration() {
            return userGroupResolutionConfiguration != null ? userGroupResolutionConfiguration.toBuilder() : null;
        }

        public final void setUserGroupResolutionConfiguration(
                UserGroupResolutionConfiguration.BuilderImpl userGroupResolutionConfiguration) {
            this.userGroupResolutionConfiguration = userGroupResolutionConfiguration != null ? userGroupResolutionConfiguration
                    .build() : null;
        }

        @Override
        public final Builder userGroupResolutionConfiguration(UserGroupResolutionConfiguration userGroupResolutionConfiguration) {
            this.userGroupResolutionConfiguration = userGroupResolutionConfiguration;
            return this;
        }

        @Override
        public DescribeIndexResponse build() {
            return new DescribeIndexResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
