/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A custom attribute value assigned to a document.
 * </p>
 * <p>
 * For more information on how to create custom document attributes, see <a
 * href="https://docs.aws.amazon.com/kendra/latest/dg/custom-attributes.html">Custom Attributes</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentAttribute implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentAttribute.Builder, DocumentAttribute> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(DocumentAttribute::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<DocumentAttributeValue> VALUE_FIELD = SdkField
            .<DocumentAttributeValue> builder(MarshallingType.SDK_POJO).memberName("Value")
            .getter(getter(DocumentAttribute::value)).setter(setter(Builder::value)).constructor(DocumentAttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String key;

    private final DocumentAttributeValue value;

    private DocumentAttribute(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
    }

    /**
     * <p>
     * The identifier for the attribute.
     * </p>
     * 
     * @return The identifier for the attribute.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * The value of the attribute.
     * </p>
     * 
     * @return The value of the attribute.
     */
    public final DocumentAttributeValue value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentAttribute)) {
            return false;
        }
        DocumentAttribute other = (DocumentAttribute) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentAttribute").add("Key", key()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentAttribute, T> g) {
        return obj -> g.apply((DocumentAttribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentAttribute> {
        /**
         * <p>
         * The identifier for the attribute.
         * </p>
         * 
         * @param key
         *        The identifier for the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The value of the attribute.
         * </p>
         * 
         * @param value
         *        The value of the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(DocumentAttributeValue value);

        /**
         * <p>
         * The value of the attribute.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentAttributeValue.Builder} avoiding
         * the need to create one manually via {@link DocumentAttributeValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link DocumentAttributeValue.Builder#build()} is called immediately and
         * its result is passed to {@link #value(DocumentAttributeValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link DocumentAttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(DocumentAttributeValue)
         */
        default Builder value(Consumer<DocumentAttributeValue.Builder> value) {
            return value(DocumentAttributeValue.builder().applyMutation(value).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private DocumentAttributeValue value;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentAttribute model) {
            key(model.key);
            value(model.value);
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final DocumentAttributeValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(DocumentAttributeValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(DocumentAttributeValue value) {
            this.value = value;
            return this;
        }

        @Override
        public DocumentAttribute build() {
            return new DocumentAttribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
