/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information to define the hierarchy for which documents users should have access to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HierarchicalPrincipal implements SdkPojo, Serializable,
        ToCopyableBuilder<HierarchicalPrincipal.Builder, HierarchicalPrincipal> {
    private static final SdkField<List<Principal>> PRINCIPAL_LIST_FIELD = SdkField
            .<List<Principal>> builder(MarshallingType.LIST)
            .memberName("PrincipalList")
            .getter(getter(HierarchicalPrincipal::principalList))
            .setter(setter(Builder::principalList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Principal> builder(MarshallingType.SDK_POJO)
                                            .constructor(Principal::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Principal> principalList;

    private HierarchicalPrincipal(BuilderImpl builder) {
        this.principalList = builder.principalList;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrincipalList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPrincipalList() {
        return principalList != null && !(principalList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists that
     * define the hierarchy for which documents users should have access to. Each hierarchical list specifies which user
     * or group has allow or deny access for each document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrincipalList} method.
     * </p>
     * 
     * @return A list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists
     *         that define the hierarchy for which documents users should have access to. Each hierarchical list
     *         specifies which user or group has allow or deny access for each document.
     */
    public final List<Principal> principalList() {
        return principalList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPrincipalList() ? principalList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HierarchicalPrincipal)) {
            return false;
        }
        HierarchicalPrincipal other = (HierarchicalPrincipal) obj;
        return hasPrincipalList() == other.hasPrincipalList() && Objects.equals(principalList(), other.principalList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HierarchicalPrincipal").add("PrincipalList", hasPrincipalList() ? principalList() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrincipalList":
            return Optional.ofNullable(clazz.cast(principalList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HierarchicalPrincipal, T> g) {
        return obj -> g.apply((HierarchicalPrincipal) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HierarchicalPrincipal> {
        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists that
         * define the hierarchy for which documents users should have access to. Each hierarchical list specifies which
         * user or group has allow or deny access for each document.
         * </p>
         * 
         * @param principalList
         *        A list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a>
         *        lists that define the hierarchy for which documents users should have access to. Each hierarchical
         *        list specifies which user or group has allow or deny access for each document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalList(Collection<Principal> principalList);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists that
         * define the hierarchy for which documents users should have access to. Each hierarchical list specifies which
         * user or group has allow or deny access for each document.
         * </p>
         * 
         * @param principalList
         *        A list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a>
         *        lists that define the hierarchy for which documents users should have access to. Each hierarchical
         *        list specifies which user or group has allow or deny access for each document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalList(Principal... principalList);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists that
         * define the hierarchy for which documents users should have access to. Each hierarchical list specifies which
         * user or group has allow or deny access for each document.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Principal>.Builder} avoiding the
         * need to create one manually via {@link List<Principal>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Principal>.Builder#build()} is called immediately and its
         * result is passed to {@link #principalList(List<Principal>)}.
         * 
         * @param principalList
         *        a consumer that will call methods on {@link List<Principal>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #principalList(List<Principal>)
         */
        Builder principalList(Consumer<Principal.Builder>... principalList);
    }

    static final class BuilderImpl implements Builder {
        private List<Principal> principalList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HierarchicalPrincipal model) {
            principalList(model.principalList);
        }

        public final List<Principal.Builder> getPrincipalList() {
            List<Principal.Builder> result = PrincipalListCopier.copyToBuilder(this.principalList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrincipalList(Collection<Principal.BuilderImpl> principalList) {
            this.principalList = PrincipalListCopier.copyFromBuilder(principalList);
        }

        @Override
        public final Builder principalList(Collection<Principal> principalList) {
            this.principalList = PrincipalListCopier.copy(principalList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principalList(Principal... principalList) {
            principalList(Arrays.asList(principalList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principalList(Consumer<Principal.Builder>... principalList) {
            principalList(Stream.of(principalList).map(c -> Principal.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public HierarchicalPrincipal build() {
            return new HierarchicalPrincipal(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
