/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateQuerySuggestionsBlockListRequest extends KendraRequest implements
        ToCopyableBuilder<UpdateQuerySuggestionsBlockListRequest.Builder, UpdateQuerySuggestionsBlockListRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(UpdateQuerySuggestionsBlockListRequest::indexId))
            .setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(UpdateQuerySuggestionsBlockListRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateQuerySuggestionsBlockListRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateQuerySuggestionsBlockListRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<S3Path> SOURCE_S3_PATH_FIELD = SdkField.<S3Path> builder(MarshallingType.SDK_POJO)
            .memberName("SourceS3Path").getter(getter(UpdateQuerySuggestionsBlockListRequest::sourceS3Path))
            .setter(setter(Builder::sourceS3Path)).constructor(S3Path::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceS3Path").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(UpdateQuerySuggestionsBlockListRequest::roleArn))
            .setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD, ID_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, SOURCE_S3_PATH_FIELD, ROLE_ARN_FIELD));

    private final String indexId;

    private final String id;

    private final String name;

    private final String description;

    private final S3Path sourceS3Path;

    private final String roleArn;

    private UpdateQuerySuggestionsBlockListRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.sourceS3Path = builder.sourceS3Path;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The identifier of the index for a block list.
     * </p>
     * 
     * @return The identifier of the index for a block list.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The unique identifier of a block list.
     * </p>
     * 
     * @return The unique identifier of a block list.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of a block list.
     * </p>
     * 
     * @return The name of a block list.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description for a block list.
     * </p>
     * 
     * @return The description for a block list.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The S3 path where your block list text file sits in S3.
     * </p>
     * <p>
     * If you update your block list and provide the same path to the block list text file in S3, then Amazon Kendra
     * reloads the file to refresh the block list. Amazon Kendra does not automatically refresh your block list. You
     * need to call the <code>UpdateQuerySuggestionsBlockList</code> API to refresh you block list.
     * </p>
     * <p>
     * If you update your block list, then Amazon Kendra asynchronously refreshes all query suggestions with the latest
     * content in the S3 file. This means changes might not take effect immediately.
     * </p>
     * 
     * @return The S3 path where your block list text file sits in S3.</p>
     *         <p>
     *         If you update your block list and provide the same path to the block list text file in S3, then Amazon
     *         Kendra reloads the file to refresh the block list. Amazon Kendra does not automatically refresh your
     *         block list. You need to call the <code>UpdateQuerySuggestionsBlockList</code> API to refresh you block
     *         list.
     *         </p>
     *         <p>
     *         If you update your block list, then Amazon Kendra asynchronously refreshes all query suggestions with the
     *         latest content in the S3 file. This means changes might not take effect immediately.
     */
    public final S3Path sourceS3Path() {
        return sourceS3Path;
    }

    /**
     * <p>
     * The IAM (Identity and Access Management) role used to access the block list text file in S3.
     * </p>
     * 
     * @return The IAM (Identity and Access Management) role used to access the block list text file in S3.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(sourceS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateQuerySuggestionsBlockListRequest)) {
            return false;
        }
        UpdateQuerySuggestionsBlockListRequest other = (UpdateQuerySuggestionsBlockListRequest) obj;
        return Objects.equals(indexId(), other.indexId()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(sourceS3Path(), other.sourceS3Path()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateQuerySuggestionsBlockListRequest").add("IndexId", indexId()).add("Id", id())
                .add("Name", name()).add("Description", description()).add("SourceS3Path", sourceS3Path())
                .add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "SourceS3Path":
            return Optional.ofNullable(clazz.cast(sourceS3Path()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateQuerySuggestionsBlockListRequest, T> g) {
        return obj -> g.apply((UpdateQuerySuggestionsBlockListRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateQuerySuggestionsBlockListRequest> {
        /**
         * <p>
         * The identifier of the index for a block list.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index for a block list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The unique identifier of a block list.
         * </p>
         * 
         * @param id
         *        The unique identifier of a block list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of a block list.
         * </p>
         * 
         * @param name
         *        The name of a block list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description for a block list.
         * </p>
         * 
         * @param description
         *        The description for a block list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The S3 path where your block list text file sits in S3.
         * </p>
         * <p>
         * If you update your block list and provide the same path to the block list text file in S3, then Amazon Kendra
         * reloads the file to refresh the block list. Amazon Kendra does not automatically refresh your block list. You
         * need to call the <code>UpdateQuerySuggestionsBlockList</code> API to refresh you block list.
         * </p>
         * <p>
         * If you update your block list, then Amazon Kendra asynchronously refreshes all query suggestions with the
         * latest content in the S3 file. This means changes might not take effect immediately.
         * </p>
         * 
         * @param sourceS3Path
         *        The S3 path where your block list text file sits in S3.</p>
         *        <p>
         *        If you update your block list and provide the same path to the block list text file in S3, then Amazon
         *        Kendra reloads the file to refresh the block list. Amazon Kendra does not automatically refresh your
         *        block list. You need to call the <code>UpdateQuerySuggestionsBlockList</code> API to refresh you block
         *        list.
         *        </p>
         *        <p>
         *        If you update your block list, then Amazon Kendra asynchronously refreshes all query suggestions with
         *        the latest content in the S3 file. This means changes might not take effect immediately.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceS3Path(S3Path sourceS3Path);

        /**
         * <p>
         * The S3 path where your block list text file sits in S3.
         * </p>
         * <p>
         * If you update your block list and provide the same path to the block list text file in S3, then Amazon Kendra
         * reloads the file to refresh the block list. Amazon Kendra does not automatically refresh your block list. You
         * need to call the <code>UpdateQuerySuggestionsBlockList</code> API to refresh you block list.
         * </p>
         * <p>
         * If you update your block list, then Amazon Kendra asynchronously refreshes all query suggestions with the
         * latest content in the S3 file. This means changes might not take effect immediately.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Path.Builder} avoiding the need to
         * create one manually via {@link S3Path#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Path.Builder#build()} is called immediately and its result is
         * passed to {@link #sourceS3Path(S3Path)}.
         * 
         * @param sourceS3Path
         *        a consumer that will call methods on {@link S3Path.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceS3Path(S3Path)
         */
        default Builder sourceS3Path(Consumer<S3Path.Builder> sourceS3Path) {
            return sourceS3Path(S3Path.builder().applyMutation(sourceS3Path).build());
        }

        /**
         * <p>
         * The IAM (Identity and Access Management) role used to access the block list text file in S3.
         * </p>
         * 
         * @param roleArn
         *        The IAM (Identity and Access Management) role used to access the block list text file in S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String indexId;

        private String id;

        private String name;

        private String description;

        private S3Path sourceS3Path;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateQuerySuggestionsBlockListRequest model) {
            super(model);
            indexId(model.indexId);
            id(model.id);
            name(model.name);
            description(model.description);
            sourceS3Path(model.sourceS3Path);
            roleArn(model.roleArn);
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final S3Path.Builder getSourceS3Path() {
            return sourceS3Path != null ? sourceS3Path.toBuilder() : null;
        }

        public final void setSourceS3Path(S3Path.BuilderImpl sourceS3Path) {
            this.sourceS3Path = sourceS3Path != null ? sourceS3Path.build() : null;
        }

        @Override
        public final Builder sourceS3Path(S3Path sourceS3Path) {
            this.sourceS3Path = sourceS3Path;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateQuerySuggestionsBlockListRequest build() {
            return new UpdateQuerySuggestionsBlockListRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
