/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetQuerySuggestionsResponse extends KendraResponse implements
        ToCopyableBuilder<GetQuerySuggestionsResponse.Builder, GetQuerySuggestionsResponse> {
    private static final SdkField<String> QUERY_SUGGESTIONS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuerySuggestionsId").getter(getter(GetQuerySuggestionsResponse::querySuggestionsId))
            .setter(setter(Builder::querySuggestionsId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuerySuggestionsId").build())
            .build();

    private static final SdkField<List<Suggestion>> SUGGESTIONS_FIELD = SdkField
            .<List<Suggestion>> builder(MarshallingType.LIST)
            .memberName("Suggestions")
            .getter(getter(GetQuerySuggestionsResponse::suggestions))
            .setter(setter(Builder::suggestions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Suggestions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Suggestion> builder(MarshallingType.SDK_POJO)
                                            .constructor(Suggestion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_SUGGESTIONS_ID_FIELD,
            SUGGESTIONS_FIELD));

    private final String querySuggestionsId;

    private final List<Suggestion> suggestions;

    private GetQuerySuggestionsResponse(BuilderImpl builder) {
        super(builder);
        this.querySuggestionsId = builder.querySuggestionsId;
        this.suggestions = builder.suggestions;
    }

    /**
     * <p>
     * The unique identifier for a list of query suggestions for an index.
     * </p>
     * 
     * @return The unique identifier for a list of query suggestions for an index.
     */
    public final String querySuggestionsId() {
        return querySuggestionsId;
    }

    /**
     * Returns true if the Suggestions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSuggestions() {
        return suggestions != null && !(suggestions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of query suggestions for an index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSuggestions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of query suggestions for an index.
     */
    public final List<Suggestion> suggestions() {
        return suggestions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(querySuggestionsId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSuggestions() ? suggestions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQuerySuggestionsResponse)) {
            return false;
        }
        GetQuerySuggestionsResponse other = (GetQuerySuggestionsResponse) obj;
        return Objects.equals(querySuggestionsId(), other.querySuggestionsId()) && hasSuggestions() == other.hasSuggestions()
                && Objects.equals(suggestions(), other.suggestions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetQuerySuggestionsResponse").add("QuerySuggestionsId", querySuggestionsId())
                .add("Suggestions", hasSuggestions() ? suggestions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QuerySuggestionsId":
            return Optional.ofNullable(clazz.cast(querySuggestionsId()));
        case "Suggestions":
            return Optional.ofNullable(clazz.cast(suggestions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetQuerySuggestionsResponse, T> g) {
        return obj -> g.apply((GetQuerySuggestionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetQuerySuggestionsResponse> {
        /**
         * <p>
         * The unique identifier for a list of query suggestions for an index.
         * </p>
         * 
         * @param querySuggestionsId
         *        The unique identifier for a list of query suggestions for an index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder querySuggestionsId(String querySuggestionsId);

        /**
         * <p>
         * A list of query suggestions for an index.
         * </p>
         * 
         * @param suggestions
         *        A list of query suggestions for an index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestions(Collection<Suggestion> suggestions);

        /**
         * <p>
         * A list of query suggestions for an index.
         * </p>
         * 
         * @param suggestions
         *        A list of query suggestions for an index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestions(Suggestion... suggestions);

        /**
         * <p>
         * A list of query suggestions for an index.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Suggestion>.Builder} avoiding the need to
         * create one manually via {@link List<Suggestion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Suggestion>.Builder#build()} is called immediately and its
         * result is passed to {@link #suggestions(List<Suggestion>)}.
         * 
         * @param suggestions
         *        a consumer that will call methods on {@link List<Suggestion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suggestions(List<Suggestion>)
         */
        Builder suggestions(Consumer<Suggestion.Builder>... suggestions);
    }

    static final class BuilderImpl extends KendraResponse.BuilderImpl implements Builder {
        private String querySuggestionsId;

        private List<Suggestion> suggestions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetQuerySuggestionsResponse model) {
            super(model);
            querySuggestionsId(model.querySuggestionsId);
            suggestions(model.suggestions);
        }

        public final String getQuerySuggestionsId() {
            return querySuggestionsId;
        }

        @Override
        public final Builder querySuggestionsId(String querySuggestionsId) {
            this.querySuggestionsId = querySuggestionsId;
            return this;
        }

        public final void setQuerySuggestionsId(String querySuggestionsId) {
            this.querySuggestionsId = querySuggestionsId;
        }

        public final List<Suggestion.Builder> getSuggestions() {
            List<Suggestion.Builder> result = SuggestionListCopier.copyToBuilder(this.suggestions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder suggestions(Collection<Suggestion> suggestions) {
            this.suggestions = SuggestionListCopier.copy(suggestions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestions(Suggestion... suggestions) {
            suggestions(Arrays.asList(suggestions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestions(Consumer<Suggestion.Builder>... suggestions) {
            suggestions(Stream.of(suggestions).map(c -> Suggestion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSuggestions(Collection<Suggestion.BuilderImpl> suggestions) {
            this.suggestions = SuggestionListCopier.copyFromBuilder(suggestions);
        }

        @Override
        public GetQuerySuggestionsResponse build() {
            return new GetQuerySuggestionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
