/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * User accounts whose documents should be indexed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OneDriveUsers implements SdkPojo, Serializable, ToCopyableBuilder<OneDriveUsers.Builder, OneDriveUsers> {
    private static final SdkField<List<String>> ONE_DRIVE_USER_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OneDriveUserList")
            .getter(getter(OneDriveUsers::oneDriveUserList))
            .setter(setter(Builder::oneDriveUserList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OneDriveUserList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<S3Path> ONE_DRIVE_USER_S3_PATH_FIELD = SdkField.<S3Path> builder(MarshallingType.SDK_POJO)
            .memberName("OneDriveUserS3Path").getter(getter(OneDriveUsers::oneDriveUserS3Path))
            .setter(setter(Builder::oneDriveUserS3Path)).constructor(S3Path::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OneDriveUserS3Path").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ONE_DRIVE_USER_LIST_FIELD,
            ONE_DRIVE_USER_S3_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> oneDriveUserList;

    private final S3Path oneDriveUserS3Path;

    private OneDriveUsers(BuilderImpl builder) {
        this.oneDriveUserList = builder.oneDriveUserList;
        this.oneDriveUserS3Path = builder.oneDriveUserS3Path;
    }

    /**
     * For responses, this returns true if the service returned a value for the OneDriveUserList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOneDriveUserList() {
        return oneDriveUserList != null && !(oneDriveUserList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of users whose documents should be indexed. Specify the user names in email format, for example,
     * <code>username@tenantdomain</code>. If you need to index the documents of more than 100 users, use the
     * <code>OneDriveUserS3Path</code> field to specify the location of a file containing a list of users.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOneDriveUserList} method.
     * </p>
     * 
     * @return A list of users whose documents should be indexed. Specify the user names in email format, for example,
     *         <code>username@tenantdomain</code>. If you need to index the documents of more than 100 users, use the
     *         <code>OneDriveUserS3Path</code> field to specify the location of a file containing a list of users.
     */
    public final List<String> oneDriveUserList() {
        return oneDriveUserList;
    }

    /**
     * <p>
     * The S3 bucket location of a file containing a list of users whose documents should be indexed.
     * </p>
     * 
     * @return The S3 bucket location of a file containing a list of users whose documents should be indexed.
     */
    public final S3Path oneDriveUserS3Path() {
        return oneDriveUserS3Path;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOneDriveUserList() ? oneDriveUserList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(oneDriveUserS3Path());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OneDriveUsers)) {
            return false;
        }
        OneDriveUsers other = (OneDriveUsers) obj;
        return hasOneDriveUserList() == other.hasOneDriveUserList()
                && Objects.equals(oneDriveUserList(), other.oneDriveUserList())
                && Objects.equals(oneDriveUserS3Path(), other.oneDriveUserS3Path());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OneDriveUsers").add("OneDriveUserList", hasOneDriveUserList() ? oneDriveUserList() : null)
                .add("OneDriveUserS3Path", oneDriveUserS3Path()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OneDriveUserList":
            return Optional.ofNullable(clazz.cast(oneDriveUserList()));
        case "OneDriveUserS3Path":
            return Optional.ofNullable(clazz.cast(oneDriveUserS3Path()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OneDriveUsers, T> g) {
        return obj -> g.apply((OneDriveUsers) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OneDriveUsers> {
        /**
         * <p>
         * A list of users whose documents should be indexed. Specify the user names in email format, for example,
         * <code>username@tenantdomain</code>. If you need to index the documents of more than 100 users, use the
         * <code>OneDriveUserS3Path</code> field to specify the location of a file containing a list of users.
         * </p>
         * 
         * @param oneDriveUserList
         *        A list of users whose documents should be indexed. Specify the user names in email format, for
         *        example, <code>username@tenantdomain</code>. If you need to index the documents of more than 100
         *        users, use the <code>OneDriveUserS3Path</code> field to specify the location of a file containing a
         *        list of users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oneDriveUserList(Collection<String> oneDriveUserList);

        /**
         * <p>
         * A list of users whose documents should be indexed. Specify the user names in email format, for example,
         * <code>username@tenantdomain</code>. If you need to index the documents of more than 100 users, use the
         * <code>OneDriveUserS3Path</code> field to specify the location of a file containing a list of users.
         * </p>
         * 
         * @param oneDriveUserList
         *        A list of users whose documents should be indexed. Specify the user names in email format, for
         *        example, <code>username@tenantdomain</code>. If you need to index the documents of more than 100
         *        users, use the <code>OneDriveUserS3Path</code> field to specify the location of a file containing a
         *        list of users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oneDriveUserList(String... oneDriveUserList);

        /**
         * <p>
         * The S3 bucket location of a file containing a list of users whose documents should be indexed.
         * </p>
         * 
         * @param oneDriveUserS3Path
         *        The S3 bucket location of a file containing a list of users whose documents should be indexed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oneDriveUserS3Path(S3Path oneDriveUserS3Path);

        /**
         * <p>
         * The S3 bucket location of a file containing a list of users whose documents should be indexed.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Path.Builder} avoiding the need to
         * create one manually via {@link S3Path#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Path.Builder#build()} is called immediately and its result is
         * passed to {@link #oneDriveUserS3Path(S3Path)}.
         * 
         * @param oneDriveUserS3Path
         *        a consumer that will call methods on {@link S3Path.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oneDriveUserS3Path(S3Path)
         */
        default Builder oneDriveUserS3Path(Consumer<S3Path.Builder> oneDriveUserS3Path) {
            return oneDriveUserS3Path(S3Path.builder().applyMutation(oneDriveUserS3Path).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> oneDriveUserList = DefaultSdkAutoConstructList.getInstance();

        private S3Path oneDriveUserS3Path;

        private BuilderImpl() {
        }

        private BuilderImpl(OneDriveUsers model) {
            oneDriveUserList(model.oneDriveUserList);
            oneDriveUserS3Path(model.oneDriveUserS3Path);
        }

        public final Collection<String> getOneDriveUserList() {
            if (oneDriveUserList instanceof SdkAutoConstructList) {
                return null;
            }
            return oneDriveUserList;
        }

        public final void setOneDriveUserList(Collection<String> oneDriveUserList) {
            this.oneDriveUserList = OneDriveUserListCopier.copy(oneDriveUserList);
        }

        @Override
        public final Builder oneDriveUserList(Collection<String> oneDriveUserList) {
            this.oneDriveUserList = OneDriveUserListCopier.copy(oneDriveUserList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder oneDriveUserList(String... oneDriveUserList) {
            oneDriveUserList(Arrays.asList(oneDriveUserList));
            return this;
        }

        public final S3Path.Builder getOneDriveUserS3Path() {
            return oneDriveUserS3Path != null ? oneDriveUserS3Path.toBuilder() : null;
        }

        public final void setOneDriveUserS3Path(S3Path.BuilderImpl oneDriveUserS3Path) {
            this.oneDriveUserS3Path = oneDriveUserS3Path != null ? oneDriveUserS3Path.build() : null;
        }

        @Override
        public final Builder oneDriveUserS3Path(S3Path oneDriveUserS3Path) {
            this.oneDriveUserS3Path = oneDriveUserS3Path;
            return this;
        }

        @Override
        public OneDriveUsers build() {
            return new OneDriveUsers(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
