/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the count of documents that match a particular attribute when doing a faceted search.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentAttributeValueCountPair implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentAttributeValueCountPair.Builder, DocumentAttributeValueCountPair> {
    private static final SdkField<DocumentAttributeValue> DOCUMENT_ATTRIBUTE_VALUE_FIELD = SdkField
            .<DocumentAttributeValue> builder(MarshallingType.SDK_POJO).memberName("DocumentAttributeValue")
            .getter(getter(DocumentAttributeValueCountPair::documentAttributeValue))
            .setter(setter(Builder::documentAttributeValue)).constructor(DocumentAttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentAttributeValue").build())
            .build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Count")
            .getter(getter(DocumentAttributeValueCountPair::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DOCUMENT_ATTRIBUTE_VALUE_FIELD, COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final DocumentAttributeValue documentAttributeValue;

    private final Integer count;

    private DocumentAttributeValueCountPair(BuilderImpl builder) {
        this.documentAttributeValue = builder.documentAttributeValue;
        this.count = builder.count;
    }

    /**
     * <p>
     * The value of the attribute. For example, "HR."
     * </p>
     * 
     * @return The value of the attribute. For example, "HR."
     */
    public final DocumentAttributeValue documentAttributeValue() {
        return documentAttributeValue;
    }

    /**
     * <p>
     * The number of documents in the response that have the attribute value for the key.
     * </p>
     * 
     * @return The number of documents in the response that have the attribute value for the key.
     */
    public final Integer count() {
        return count;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(documentAttributeValue());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentAttributeValueCountPair)) {
            return false;
        }
        DocumentAttributeValueCountPair other = (DocumentAttributeValueCountPair) obj;
        return Objects.equals(documentAttributeValue(), other.documentAttributeValue()) && Objects.equals(count(), other.count());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentAttributeValueCountPair").add("DocumentAttributeValue", documentAttributeValue())
                .add("Count", count()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentAttributeValue":
            return Optional.ofNullable(clazz.cast(documentAttributeValue()));
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentAttributeValueCountPair, T> g) {
        return obj -> g.apply((DocumentAttributeValueCountPair) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentAttributeValueCountPair> {
        /**
         * <p>
         * The value of the attribute. For example, "HR."
         * </p>
         * 
         * @param documentAttributeValue
         *        The value of the attribute. For example, "HR."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentAttributeValue(DocumentAttributeValue documentAttributeValue);

        /**
         * <p>
         * The value of the attribute. For example, "HR."
         * </p>
         * This is a convenience that creates an instance of the {@link DocumentAttributeValue.Builder} avoiding the
         * need to create one manually via {@link DocumentAttributeValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link DocumentAttributeValue.Builder#build()} is called immediately and
         * its result is passed to {@link #documentAttributeValue(DocumentAttributeValue)}.
         * 
         * @param documentAttributeValue
         *        a consumer that will call methods on {@link DocumentAttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentAttributeValue(DocumentAttributeValue)
         */
        default Builder documentAttributeValue(Consumer<DocumentAttributeValue.Builder> documentAttributeValue) {
            return documentAttributeValue(DocumentAttributeValue.builder().applyMutation(documentAttributeValue).build());
        }

        /**
         * <p>
         * The number of documents in the response that have the attribute value for the key.
         * </p>
         * 
         * @param count
         *        The number of documents in the response that have the attribute value for the key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);
    }

    static final class BuilderImpl implements Builder {
        private DocumentAttributeValue documentAttributeValue;

        private Integer count;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentAttributeValueCountPair model) {
            documentAttributeValue(model.documentAttributeValue);
            count(model.count);
        }

        public final DocumentAttributeValue.Builder getDocumentAttributeValue() {
            return documentAttributeValue != null ? documentAttributeValue.toBuilder() : null;
        }

        public final void setDocumentAttributeValue(DocumentAttributeValue.BuilderImpl documentAttributeValue) {
            this.documentAttributeValue = documentAttributeValue != null ? documentAttributeValue.build() : null;
        }

        @Override
        @Transient
        public final Builder documentAttributeValue(DocumentAttributeValue documentAttributeValue) {
            this.documentAttributeValue = documentAttributeValue;
            return this;
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        @Transient
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        @Override
        public DocumentAttributeValueCountPair build() {
            return new DocumentAttributeValueCountPair(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
