/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides text and information about where to highlight the query suggestion text.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuggestionTextWithHighlights implements SdkPojo, Serializable,
        ToCopyableBuilder<SuggestionTextWithHighlights.Builder, SuggestionTextWithHighlights> {
    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Text")
            .getter(getter(SuggestionTextWithHighlights::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final SdkField<List<SuggestionHighlight>> HIGHLIGHTS_FIELD = SdkField
            .<List<SuggestionHighlight>> builder(MarshallingType.LIST)
            .memberName("Highlights")
            .getter(getter(SuggestionTextWithHighlights::highlights))
            .setter(setter(Builder::highlights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Highlights").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SuggestionHighlight> builder(MarshallingType.SDK_POJO)
                                            .constructor(SuggestionHighlight::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, HIGHLIGHTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String text;

    private final List<SuggestionHighlight> highlights;

    private SuggestionTextWithHighlights(BuilderImpl builder) {
        this.text = builder.text;
        this.highlights = builder.highlights;
    }

    /**
     * <p>
     * The query suggestion text to display to the user.
     * </p>
     * 
     * @return The query suggestion text to display to the user.
     */
    public final String text() {
        return text;
    }

    /**
     * For responses, this returns true if the service returned a value for the Highlights property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasHighlights() {
        return highlights != null && !(highlights instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The beginning and end of the query suggestion text that should be highlighted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHighlights} method.
     * </p>
     * 
     * @return The beginning and end of the query suggestion text that should be highlighted.
     */
    public final List<SuggestionHighlight> highlights() {
        return highlights;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(hasHighlights() ? highlights() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuggestionTextWithHighlights)) {
            return false;
        }
        SuggestionTextWithHighlights other = (SuggestionTextWithHighlights) obj;
        return Objects.equals(text(), other.text()) && hasHighlights() == other.hasHighlights()
                && Objects.equals(highlights(), other.highlights());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SuggestionTextWithHighlights").add("Text", text())
                .add("Highlights", hasHighlights() ? highlights() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        case "Highlights":
            return Optional.ofNullable(clazz.cast(highlights()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuggestionTextWithHighlights, T> g) {
        return obj -> g.apply((SuggestionTextWithHighlights) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SuggestionTextWithHighlights> {
        /**
         * <p>
         * The query suggestion text to display to the user.
         * </p>
         * 
         * @param text
         *        The query suggestion text to display to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * The beginning and end of the query suggestion text that should be highlighted.
         * </p>
         * 
         * @param highlights
         *        The beginning and end of the query suggestion text that should be highlighted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder highlights(Collection<SuggestionHighlight> highlights);

        /**
         * <p>
         * The beginning and end of the query suggestion text that should be highlighted.
         * </p>
         * 
         * @param highlights
         *        The beginning and end of the query suggestion text that should be highlighted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder highlights(SuggestionHighlight... highlights);

        /**
         * <p>
         * The beginning and end of the query suggestion text that should be highlighted.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SuggestionHighlight>.Builder} avoiding the
         * need to create one manually via {@link List<SuggestionHighlight>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SuggestionHighlight>.Builder#build()} is called immediately
         * and its result is passed to {@link #highlights(List<SuggestionHighlight>)}.
         * 
         * @param highlights
         *        a consumer that will call methods on {@link List<SuggestionHighlight>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #highlights(List<SuggestionHighlight>)
         */
        Builder highlights(Consumer<SuggestionHighlight.Builder>... highlights);
    }

    static final class BuilderImpl implements Builder {
        private String text;

        private List<SuggestionHighlight> highlights = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SuggestionTextWithHighlights model) {
            text(model.text);
            highlights(model.highlights);
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        @Transient
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final List<SuggestionHighlight.Builder> getHighlights() {
            List<SuggestionHighlight.Builder> result = SuggestionHighlightListCopier.copyToBuilder(this.highlights);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHighlights(Collection<SuggestionHighlight.BuilderImpl> highlights) {
            this.highlights = SuggestionHighlightListCopier.copyFromBuilder(highlights);
        }

        @Override
        @Transient
        public final Builder highlights(Collection<SuggestionHighlight> highlights) {
            this.highlights = SuggestionHighlightListCopier.copy(highlights);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder highlights(SuggestionHighlight... highlights) {
            highlights(Arrays.asList(highlights));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder highlights(Consumer<SuggestionHighlight.Builder>... highlights) {
            highlights(Stream.of(highlights).map(c -> SuggestionHighlight.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SuggestionTextWithHighlights build() {
            return new SuggestionTextWithHighlights(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
