/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies a document for which to retrieve status information
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentInfo implements SdkPojo, Serializable, ToCopyableBuilder<DocumentInfo.Builder, DocumentInfo> {
    private static final SdkField<String> DOCUMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentId").getter(getter(DocumentInfo::documentId)).setter(setter(Builder::documentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentId").build()).build();

    private static final SdkField<List<DocumentAttribute>> ATTRIBUTES_FIELD = SdkField
            .<List<DocumentAttribute>> builder(MarshallingType.LIST)
            .memberName("Attributes")
            .getter(getter(DocumentInfo::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_ID_FIELD,
            ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String documentId;

    private final List<DocumentAttribute> attributes;

    private DocumentInfo(BuilderImpl builder) {
        this.documentId = builder.documentId;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * The unique identifier of the document.
     * </p>
     * 
     * @return The unique identifier of the document.
     */
    public final String documentId() {
        return documentId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Attributes that identify a specific version of a document to check.
     * </p>
     * <p>
     * The only valid attributes are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * version
     * </p>
     * </li>
     * <li>
     * <p>
     * datasourceId
     * </p>
     * </li>
     * <li>
     * <p>
     * jobExecutionId
     * </p>
     * </li>
     * </ul>
     * <p>
     * The attributes follow these rules:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>dataSourceId</code> and <code>jobExecutionId</code> must be used together.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>version</code> is ignored if <code>dataSourceId</code> and <code>jobExecutionId</code> are not provided.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>dataSourceId</code> and <code>jobExecutionId</code> are provided, but <code>version</code> is not, the
     * version defaults to "0".
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return Attributes that identify a specific version of a document to check.</p>
     *         <p>
     *         The only valid attributes are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         version
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         datasourceId
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         jobExecutionId
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The attributes follow these rules:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>dataSourceId</code> and <code>jobExecutionId</code> must be used together.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>version</code> is ignored if <code>dataSourceId</code> and <code>jobExecutionId</code> are not
     *         provided.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If <code>dataSourceId</code> and <code>jobExecutionId</code> are provided, but <code>version</code> is
     *         not, the version defaults to "0".
     *         </p>
     *         </li>
     */
    public final List<DocumentAttribute> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(documentId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentInfo)) {
            return false;
        }
        DocumentInfo other = (DocumentInfo) obj;
        return Objects.equals(documentId(), other.documentId()) && hasAttributes() == other.hasAttributes()
                && Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentInfo").add("DocumentId", documentId())
                .add("Attributes", hasAttributes() ? attributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentId":
            return Optional.ofNullable(clazz.cast(documentId()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentInfo, T> g) {
        return obj -> g.apply((DocumentInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentInfo> {
        /**
         * <p>
         * The unique identifier of the document.
         * </p>
         * 
         * @param documentId
         *        The unique identifier of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentId(String documentId);

        /**
         * <p>
         * Attributes that identify a specific version of a document to check.
         * </p>
         * <p>
         * The only valid attributes are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * version
         * </p>
         * </li>
         * <li>
         * <p>
         * datasourceId
         * </p>
         * </li>
         * <li>
         * <p>
         * jobExecutionId
         * </p>
         * </li>
         * </ul>
         * <p>
         * The attributes follow these rules:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>dataSourceId</code> and <code>jobExecutionId</code> must be used together.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>version</code> is ignored if <code>dataSourceId</code> and <code>jobExecutionId</code> are not
         * provided.
         * </p>
         * </li>
         * <li>
         * <p>
         * If <code>dataSourceId</code> and <code>jobExecutionId</code> are provided, but <code>version</code> is not,
         * the version defaults to "0".
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributes
         *        Attributes that identify a specific version of a document to check.</p>
         *        <p>
         *        The only valid attributes are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        version
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        datasourceId
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        jobExecutionId
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The attributes follow these rules:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>dataSourceId</code> and <code>jobExecutionId</code> must be used together.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>version</code> is ignored if <code>dataSourceId</code> and <code>jobExecutionId</code> are not
         *        provided.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If <code>dataSourceId</code> and <code>jobExecutionId</code> are provided, but <code>version</code> is
         *        not, the version defaults to "0".
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<DocumentAttribute> attributes);

        /**
         * <p>
         * Attributes that identify a specific version of a document to check.
         * </p>
         * <p>
         * The only valid attributes are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * version
         * </p>
         * </li>
         * <li>
         * <p>
         * datasourceId
         * </p>
         * </li>
         * <li>
         * <p>
         * jobExecutionId
         * </p>
         * </li>
         * </ul>
         * <p>
         * The attributes follow these rules:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>dataSourceId</code> and <code>jobExecutionId</code> must be used together.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>version</code> is ignored if <code>dataSourceId</code> and <code>jobExecutionId</code> are not
         * provided.
         * </p>
         * </li>
         * <li>
         * <p>
         * If <code>dataSourceId</code> and <code>jobExecutionId</code> are provided, but <code>version</code> is not,
         * the version defaults to "0".
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributes
         *        Attributes that identify a specific version of a document to check.</p>
         *        <p>
         *        The only valid attributes are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        version
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        datasourceId
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        jobExecutionId
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The attributes follow these rules:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>dataSourceId</code> and <code>jobExecutionId</code> must be used together.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>version</code> is ignored if <code>dataSourceId</code> and <code>jobExecutionId</code> are not
         *        provided.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If <code>dataSourceId</code> and <code>jobExecutionId</code> are provided, but <code>version</code> is
         *        not, the version defaults to "0".
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(DocumentAttribute... attributes);

        /**
         * <p>
         * Attributes that identify a specific version of a document to check.
         * </p>
         * <p>
         * The only valid attributes are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * version
         * </p>
         * </li>
         * <li>
         * <p>
         * datasourceId
         * </p>
         * </li>
         * <li>
         * <p>
         * jobExecutionId
         * </p>
         * </li>
         * </ul>
         * <p>
         * The attributes follow these rules:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>dataSourceId</code> and <code>jobExecutionId</code> must be used together.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>version</code> is ignored if <code>dataSourceId</code> and <code>jobExecutionId</code> are not
         * provided.
         * </p>
         * </li>
         * <li>
         * <p>
         * If <code>dataSourceId</code> and <code>jobExecutionId</code> are provided, but <code>version</code> is not,
         * the version defaults to "0".
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link List<DocumentAttribute>.Builder} avoiding
         * the need to create one manually via {@link List<DocumentAttribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DocumentAttribute>.Builder#build()} is called immediately
         * and its result is passed to {@link #attributes(List<DocumentAttribute>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link List<DocumentAttribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(List<DocumentAttribute>)
         */
        Builder attributes(Consumer<DocumentAttribute.Builder>... attributes);
    }

    static final class BuilderImpl implements Builder {
        private String documentId;

        private List<DocumentAttribute> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentInfo model) {
            documentId(model.documentId);
            attributes(model.attributes);
        }

        public final String getDocumentId() {
            return documentId;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final List<DocumentAttribute.Builder> getAttributes() {
            List<DocumentAttribute.Builder> result = DocumentAttributeListCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<DocumentAttribute.BuilderImpl> attributes) {
            this.attributes = DocumentAttributeListCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Collection<DocumentAttribute> attributes) {
            this.attributes = DocumentAttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(DocumentAttribute... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<DocumentAttribute.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> DocumentAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DocumentInfo build() {
            return new DocumentInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
