/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFaqResponse extends KendraResponse implements
        ToCopyableBuilder<DescribeFaqResponse.Builder, DescribeFaqResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(DescribeFaqResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(DescribeFaqResponse::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeFaqResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeFaqResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(DescribeFaqResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(DescribeFaqResponse::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final SdkField<S3Path> S3_PATH_FIELD = SdkField.<S3Path> builder(MarshallingType.SDK_POJO)
            .memberName("S3Path").getter(getter(DescribeFaqResponse::s3Path)).setter(setter(Builder::s3Path))
            .constructor(S3Path::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Path").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeFaqResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeFaqResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(DescribeFaqResponse::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileFormat").getter(getter(DescribeFaqResponse::fileFormatAsString)).setter(setter(Builder::fileFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileFormat").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(DescribeFaqResponse::languageCode)).setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, INDEX_ID_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, S3_PATH_FIELD, STATUS_FIELD, ROLE_ARN_FIELD,
            ERROR_MESSAGE_FIELD, FILE_FORMAT_FIELD, LANGUAGE_CODE_FIELD));

    private final String id;

    private final String indexId;

    private final String name;

    private final String description;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final S3Path s3Path;

    private final String status;

    private final String roleArn;

    private final String errorMessage;

    private final String fileFormat;

    private final String languageCode;

    private DescribeFaqResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.indexId = builder.indexId;
        this.name = builder.name;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.s3Path = builder.s3Path;
        this.status = builder.status;
        this.roleArn = builder.roleArn;
        this.errorMessage = builder.errorMessage;
        this.fileFormat = builder.fileFormat;
        this.languageCode = builder.languageCode;
    }

    /**
     * <p>
     * The identifier of the FAQ.
     * </p>
     * 
     * @return The identifier of the FAQ.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The identifier of the index that contains the FAQ.
     * </p>
     * 
     * @return The identifier of the index that contains the FAQ.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The name that you gave the FAQ when it was created.
     * </p>
     * 
     * @return The name that you gave the FAQ when it was created.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the FAQ that you provided when it was created.
     * </p>
     * 
     * @return The description of the FAQ that you provided when it was created.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The date and time that the FAQ was created.
     * </p>
     * 
     * @return The date and time that the FAQ was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time that the FAQ was last updated.
     * </p>
     * 
     * @return The date and time that the FAQ was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * Returns the value of the S3Path property for this object.
     * 
     * @return The value of the S3Path property for this object.
     */
    public final S3Path s3Path() {
        return s3Path;
    }

    /**
     * <p>
     * The status of the FAQ. It is ready to use when the status is <code>ACTIVE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FaqStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the FAQ. It is ready to use when the status is <code>ACTIVE</code>.
     * @see FaqStatus
     */
    public final FaqStatus status() {
        return FaqStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the FAQ. It is ready to use when the status is <code>ACTIVE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FaqStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the FAQ. It is ready to use when the status is <code>ACTIVE</code>.
     * @see FaqStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role that provides access to the S3 bucket containing the input files for
     * the FAQ.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role that provides access to the S3 bucket containing the input
     *         files for the FAQ.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * If the <code>Status</code> field is <code>FAILED</code>, the <code>ErrorMessage</code> field contains the reason
     * why the FAQ failed.
     * </p>
     * 
     * @return If the <code>Status</code> field is <code>FAILED</code>, the <code>ErrorMessage</code> field contains the
     *         reason why the FAQ failed.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The file format used by the input files for the FAQ.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link FaqFileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileFormatAsString}.
     * </p>
     * 
     * @return The file format used by the input files for the FAQ.
     * @see FaqFileFormat
     */
    public final FaqFileFormat fileFormat() {
        return FaqFileFormat.fromValue(fileFormat);
    }

    /**
     * <p>
     * The file format used by the input files for the FAQ.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link FaqFileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileFormatAsString}.
     * </p>
     * 
     * @return The file format used by the input files for the FAQ.
     * @see FaqFileFormat
     */
    public final String fileFormatAsString() {
        return fileFormat;
    }

    /**
     * <p>
     * The code for a language. This shows a supported language for the FAQ document. English is supported by default.
     * For more information on supported languages, including their codes, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages other
     * than English</a>.
     * </p>
     * 
     * @return The code for a language. This shows a supported language for the FAQ document. English is supported by
     *         default. For more information on supported languages, including their codes, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in
     *         languages other than English</a>.
     */
    public final String languageCode() {
        return languageCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(s3Path());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(fileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(languageCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFaqResponse)) {
            return false;
        }
        DescribeFaqResponse other = (DescribeFaqResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(indexId(), other.indexId())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(s3Path(), other.s3Path()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(fileFormatAsString(), other.fileFormatAsString())
                && Objects.equals(languageCode(), other.languageCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFaqResponse").add("Id", id()).add("IndexId", indexId()).add("Name", name())
                .add("Description", description()).add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt())
                .add("S3Path", s3Path()).add("Status", statusAsString()).add("RoleArn", roleArn())
                .add("ErrorMessage", errorMessage()).add("FileFormat", fileFormatAsString()).add("LanguageCode", languageCode())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "S3Path":
            return Optional.ofNullable(clazz.cast(s3Path()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "FileFormat":
            return Optional.ofNullable(clazz.cast(fileFormatAsString()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFaqResponse, T> g) {
        return obj -> g.apply((DescribeFaqResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFaqResponse> {
        /**
         * <p>
         * The identifier of the FAQ.
         * </p>
         * 
         * @param id
         *        The identifier of the FAQ.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The identifier of the index that contains the FAQ.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index that contains the FAQ.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The name that you gave the FAQ when it was created.
         * </p>
         * 
         * @param name
         *        The name that you gave the FAQ when it was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the FAQ that you provided when it was created.
         * </p>
         * 
         * @param description
         *        The description of the FAQ that you provided when it was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date and time that the FAQ was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the FAQ was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time that the FAQ was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time that the FAQ was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * Sets the value of the S3Path property for this object.
         *
         * @param s3Path
         *        The new value for the S3Path property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Path(S3Path s3Path);

        /**
         * Sets the value of the S3Path property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3Path.Builder} avoiding the need to
         * create one manually via {@link S3Path#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Path.Builder#build()} is called immediately and its result is
         * passed to {@link #s3Path(S3Path)}.
         * 
         * @param s3Path
         *        a consumer that will call methods on {@link S3Path.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Path(S3Path)
         */
        default Builder s3Path(Consumer<S3Path.Builder> s3Path) {
            return s3Path(S3Path.builder().applyMutation(s3Path).build());
        }

        /**
         * <p>
         * The status of the FAQ. It is ready to use when the status is <code>ACTIVE</code>.
         * </p>
         * 
         * @param status
         *        The status of the FAQ. It is ready to use when the status is <code>ACTIVE</code>.
         * @see FaqStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FaqStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the FAQ. It is ready to use when the status is <code>ACTIVE</code>.
         * </p>
         * 
         * @param status
         *        The status of the FAQ. It is ready to use when the status is <code>ACTIVE</code>.
         * @see FaqStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FaqStatus
         */
        Builder status(FaqStatus status);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role that provides access to the S3 bucket containing the input files
         * for the FAQ.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the role that provides access to the S3 bucket containing the input
         *        files for the FAQ.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * If the <code>Status</code> field is <code>FAILED</code>, the <code>ErrorMessage</code> field contains the
         * reason why the FAQ failed.
         * </p>
         * 
         * @param errorMessage
         *        If the <code>Status</code> field is <code>FAILED</code>, the <code>ErrorMessage</code> field contains
         *        the reason why the FAQ failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The file format used by the input files for the FAQ.
         * </p>
         * 
         * @param fileFormat
         *        The file format used by the input files for the FAQ.
         * @see FaqFileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FaqFileFormat
         */
        Builder fileFormat(String fileFormat);

        /**
         * <p>
         * The file format used by the input files for the FAQ.
         * </p>
         * 
         * @param fileFormat
         *        The file format used by the input files for the FAQ.
         * @see FaqFileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FaqFileFormat
         */
        Builder fileFormat(FaqFileFormat fileFormat);

        /**
         * <p>
         * The code for a language. This shows a supported language for the FAQ document. English is supported by
         * default. For more information on supported languages, including their codes, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages
         * other than English</a>.
         * </p>
         * 
         * @param languageCode
         *        The code for a language. This shows a supported language for the FAQ document. English is supported by
         *        default. For more information on supported languages, including their codes, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in
         *        languages other than English</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageCode(String languageCode);
    }

    static final class BuilderImpl extends KendraResponse.BuilderImpl implements Builder {
        private String id;

        private String indexId;

        private String name;

        private String description;

        private Instant createdAt;

        private Instant updatedAt;

        private S3Path s3Path;

        private String status;

        private String roleArn;

        private String errorMessage;

        private String fileFormat;

        private String languageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFaqResponse model) {
            super(model);
            id(model.id);
            indexId(model.indexId);
            name(model.name);
            description(model.description);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            s3Path(model.s3Path);
            status(model.status);
            roleArn(model.roleArn);
            errorMessage(model.errorMessage);
            fileFormat(model.fileFormat);
            languageCode(model.languageCode);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final S3Path.Builder getS3Path() {
            return s3Path != null ? s3Path.toBuilder() : null;
        }

        public final void setS3Path(S3Path.BuilderImpl s3Path) {
            this.s3Path = s3Path != null ? s3Path.build() : null;
        }

        @Override
        public final Builder s3Path(S3Path s3Path) {
            this.s3Path = s3Path;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FaqStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getFileFormat() {
            return fileFormat;
        }

        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        public final Builder fileFormat(FaqFileFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public DescribeFaqResponse build() {
            return new DescribeFaqResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
