/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration information of the URLs to crawl.
 * </p>
 * <p>
 * You can only crawl websites that use the secure communication protocol, Hypertext Transfer Protocol Secure (HTTPS).
 * If you receive an error when crawling a website, it could be that the website is blocked from crawling.
 * </p>
 * <p>
 * <i>When selecting websites to index, you must adhere to the <a href="https://aws.amazon.com/aup/">Amazon Acceptable
 * Use Policy</a> and all other Amazon terms. Remember that you must only use Amazon Kendra Web Crawler to index your
 * own webpages, or webpages that you have authorization to index.</i>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Urls implements SdkPojo, Serializable, ToCopyableBuilder<Urls.Builder, Urls> {
    private static final SdkField<SeedUrlConfiguration> SEED_URL_CONFIGURATION_FIELD = SdkField
            .<SeedUrlConfiguration> builder(MarshallingType.SDK_POJO).memberName("SeedUrlConfiguration")
            .getter(getter(Urls::seedUrlConfiguration)).setter(setter(Builder::seedUrlConfiguration))
            .constructor(SeedUrlConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeedUrlConfiguration").build())
            .build();

    private static final SdkField<SiteMapsConfiguration> SITE_MAPS_CONFIGURATION_FIELD = SdkField
            .<SiteMapsConfiguration> builder(MarshallingType.SDK_POJO).memberName("SiteMapsConfiguration")
            .getter(getter(Urls::siteMapsConfiguration)).setter(setter(Builder::siteMapsConfiguration))
            .constructor(SiteMapsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SiteMapsConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEED_URL_CONFIGURATION_FIELD,
            SITE_MAPS_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final SeedUrlConfiguration seedUrlConfiguration;

    private final SiteMapsConfiguration siteMapsConfiguration;

    private Urls(BuilderImpl builder) {
        this.seedUrlConfiguration = builder.seedUrlConfiguration;
        this.siteMapsConfiguration = builder.siteMapsConfiguration;
    }

    /**
     * <p>
     * Configuration of the seed or starting point URLs of the websites you want to crawl.
     * </p>
     * <p>
     * You can choose to crawl only the website host names, or the website host names with subdomains, or the website
     * host names with subdomains and other domains that the webpages link to.
     * </p>
     * <p>
     * You can list up to 100 seed URLs.
     * </p>
     * 
     * @return Configuration of the seed or starting point URLs of the websites you want to crawl.</p>
     *         <p>
     *         You can choose to crawl only the website host names, or the website host names with subdomains, or the
     *         website host names with subdomains and other domains that the webpages link to.
     *         </p>
     *         <p>
     *         You can list up to 100 seed URLs.
     */
    public final SeedUrlConfiguration seedUrlConfiguration() {
        return seedUrlConfiguration;
    }

    /**
     * <p>
     * Configuration of the sitemap URLs of the websites you want to crawl.
     * </p>
     * <p>
     * Only URLs belonging to the same website host names are crawled. You can list up to three sitemap URLs.
     * </p>
     * 
     * @return Configuration of the sitemap URLs of the websites you want to crawl.</p>
     *         <p>
     *         Only URLs belonging to the same website host names are crawled. You can list up to three sitemap URLs.
     */
    public final SiteMapsConfiguration siteMapsConfiguration() {
        return siteMapsConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(seedUrlConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(siteMapsConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Urls)) {
            return false;
        }
        Urls other = (Urls) obj;
        return Objects.equals(seedUrlConfiguration(), other.seedUrlConfiguration())
                && Objects.equals(siteMapsConfiguration(), other.siteMapsConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Urls").add("SeedUrlConfiguration", seedUrlConfiguration())
                .add("SiteMapsConfiguration", siteMapsConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SeedUrlConfiguration":
            return Optional.ofNullable(clazz.cast(seedUrlConfiguration()));
        case "SiteMapsConfiguration":
            return Optional.ofNullable(clazz.cast(siteMapsConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Urls, T> g) {
        return obj -> g.apply((Urls) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Urls> {
        /**
         * <p>
         * Configuration of the seed or starting point URLs of the websites you want to crawl.
         * </p>
         * <p>
         * You can choose to crawl only the website host names, or the website host names with subdomains, or the
         * website host names with subdomains and other domains that the webpages link to.
         * </p>
         * <p>
         * You can list up to 100 seed URLs.
         * </p>
         * 
         * @param seedUrlConfiguration
         *        Configuration of the seed or starting point URLs of the websites you want to crawl.</p>
         *        <p>
         *        You can choose to crawl only the website host names, or the website host names with subdomains, or the
         *        website host names with subdomains and other domains that the webpages link to.
         *        </p>
         *        <p>
         *        You can list up to 100 seed URLs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder seedUrlConfiguration(SeedUrlConfiguration seedUrlConfiguration);

        /**
         * <p>
         * Configuration of the seed or starting point URLs of the websites you want to crawl.
         * </p>
         * <p>
         * You can choose to crawl only the website host names, or the website host names with subdomains, or the
         * website host names with subdomains and other domains that the webpages link to.
         * </p>
         * <p>
         * You can list up to 100 seed URLs.
         * </p>
         * This is a convenience method that creates an instance of the {@link SeedUrlConfiguration.Builder} avoiding
         * the need to create one manually via {@link SeedUrlConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SeedUrlConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #seedUrlConfiguration(SeedUrlConfiguration)}.
         * 
         * @param seedUrlConfiguration
         *        a consumer that will call methods on {@link SeedUrlConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #seedUrlConfiguration(SeedUrlConfiguration)
         */
        default Builder seedUrlConfiguration(Consumer<SeedUrlConfiguration.Builder> seedUrlConfiguration) {
            return seedUrlConfiguration(SeedUrlConfiguration.builder().applyMutation(seedUrlConfiguration).build());
        }

        /**
         * <p>
         * Configuration of the sitemap URLs of the websites you want to crawl.
         * </p>
         * <p>
         * Only URLs belonging to the same website host names are crawled. You can list up to three sitemap URLs.
         * </p>
         * 
         * @param siteMapsConfiguration
         *        Configuration of the sitemap URLs of the websites you want to crawl.</p>
         *        <p>
         *        Only URLs belonging to the same website host names are crawled. You can list up to three sitemap URLs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder siteMapsConfiguration(SiteMapsConfiguration siteMapsConfiguration);

        /**
         * <p>
         * Configuration of the sitemap URLs of the websites you want to crawl.
         * </p>
         * <p>
         * Only URLs belonging to the same website host names are crawled. You can list up to three sitemap URLs.
         * </p>
         * This is a convenience method that creates an instance of the {@link SiteMapsConfiguration.Builder} avoiding
         * the need to create one manually via {@link SiteMapsConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SiteMapsConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #siteMapsConfiguration(SiteMapsConfiguration)}.
         * 
         * @param siteMapsConfiguration
         *        a consumer that will call methods on {@link SiteMapsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #siteMapsConfiguration(SiteMapsConfiguration)
         */
        default Builder siteMapsConfiguration(Consumer<SiteMapsConfiguration.Builder> siteMapsConfiguration) {
            return siteMapsConfiguration(SiteMapsConfiguration.builder().applyMutation(siteMapsConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SeedUrlConfiguration seedUrlConfiguration;

        private SiteMapsConfiguration siteMapsConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Urls model) {
            seedUrlConfiguration(model.seedUrlConfiguration);
            siteMapsConfiguration(model.siteMapsConfiguration);
        }

        public final SeedUrlConfiguration.Builder getSeedUrlConfiguration() {
            return seedUrlConfiguration != null ? seedUrlConfiguration.toBuilder() : null;
        }

        public final void setSeedUrlConfiguration(SeedUrlConfiguration.BuilderImpl seedUrlConfiguration) {
            this.seedUrlConfiguration = seedUrlConfiguration != null ? seedUrlConfiguration.build() : null;
        }

        @Override
        public final Builder seedUrlConfiguration(SeedUrlConfiguration seedUrlConfiguration) {
            this.seedUrlConfiguration = seedUrlConfiguration;
            return this;
        }

        public final SiteMapsConfiguration.Builder getSiteMapsConfiguration() {
            return siteMapsConfiguration != null ? siteMapsConfiguration.toBuilder() : null;
        }

        public final void setSiteMapsConfiguration(SiteMapsConfiguration.BuilderImpl siteMapsConfiguration) {
            this.siteMapsConfiguration = siteMapsConfiguration != null ? siteMapsConfiguration.build() : null;
        }

        @Override
        public final Builder siteMapsConfiguration(SiteMapsConfiguration siteMapsConfiguration) {
            this.siteMapsConfiguration = siteMapsConfiguration;
            return this;
        }

        @Override
        public Urls build() {
            return new Urls(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
