/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information for your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search
 * application. For more information on creating a search application experience, see <a
 * href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
 * experience with no code</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExperiencesSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ExperiencesSummary.Builder, ExperiencesSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ExperiencesSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ExperiencesSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(ExperiencesSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ExperiencesSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<ExperienceEndpoint>> ENDPOINTS_FIELD = SdkField
            .<List<ExperienceEndpoint>> builder(MarshallingType.LIST)
            .memberName("Endpoints")
            .getter(getter(ExperiencesSummary::endpoints))
            .setter(setter(Builder::endpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExperienceEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExperienceEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD,
            CREATED_AT_FIELD, STATUS_FIELD, ENDPOINTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String id;

    private final Instant createdAt;

    private final String status;

    private final List<ExperienceEndpoint> endpoints;

    private ExperiencesSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.id = builder.id;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
        this.endpoints = builder.endpoints;
    }

    /**
     * <p>
     * The name of your Amazon Kendra experience.
     * </p>
     * 
     * @return The name of your Amazon Kendra experience.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The identifier of your Amazon Kendra experience.
     * </p>
     * 
     * @return The identifier of your Amazon Kendra experience.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The date-time your Amazon Kendra experience was created.
     * </p>
     * 
     * @return The date-time your Amazon Kendra experience was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The processing status of your Amazon Kendra experience.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExperienceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The processing status of your Amazon Kendra experience.
     * @see ExperienceStatus
     */
    public final ExperienceStatus status() {
        return ExperienceStatus.fromValue(status);
    }

    /**
     * <p>
     * The processing status of your Amazon Kendra experience.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExperienceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The processing status of your Amazon Kendra experience.
     * @see ExperienceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Endpoints property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEndpoints() {
        return endpoints != null && !(endpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The endpoint URLs for your Amazon Kendra experiences. The URLs are unique and fully hosted by Amazon Web
     * Services.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndpoints} method.
     * </p>
     * 
     * @return The endpoint URLs for your Amazon Kendra experiences. The URLs are unique and fully hosted by Amazon Web
     *         Services.
     */
    public final List<ExperienceEndpoint> endpoints() {
        return endpoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpoints() ? endpoints() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperiencesSummary)) {
            return false;
        }
        ExperiencesSummary other = (ExperiencesSummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(id(), other.id())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasEndpoints() == other.hasEndpoints() && Objects.equals(endpoints(), other.endpoints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExperiencesSummary").add("Name", name()).add("Id", id()).add("CreatedAt", createdAt())
                .add("Status", statusAsString()).add("Endpoints", hasEndpoints() ? endpoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Endpoints":
            return Optional.ofNullable(clazz.cast(endpoints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExperiencesSummary, T> g) {
        return obj -> g.apply((ExperiencesSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExperiencesSummary> {
        /**
         * <p>
         * The name of your Amazon Kendra experience.
         * </p>
         * 
         * @param name
         *        The name of your Amazon Kendra experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The identifier of your Amazon Kendra experience.
         * </p>
         * 
         * @param id
         *        The identifier of your Amazon Kendra experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The date-time your Amazon Kendra experience was created.
         * </p>
         * 
         * @param createdAt
         *        The date-time your Amazon Kendra experience was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The processing status of your Amazon Kendra experience.
         * </p>
         * 
         * @param status
         *        The processing status of your Amazon Kendra experience.
         * @see ExperienceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExperienceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The processing status of your Amazon Kendra experience.
         * </p>
         * 
         * @param status
         *        The processing status of your Amazon Kendra experience.
         * @see ExperienceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExperienceStatus
         */
        Builder status(ExperienceStatus status);

        /**
         * <p>
         * The endpoint URLs for your Amazon Kendra experiences. The URLs are unique and fully hosted by Amazon Web
         * Services.
         * </p>
         * 
         * @param endpoints
         *        The endpoint URLs for your Amazon Kendra experiences. The URLs are unique and fully hosted by Amazon
         *        Web Services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(Collection<ExperienceEndpoint> endpoints);

        /**
         * <p>
         * The endpoint URLs for your Amazon Kendra experiences. The URLs are unique and fully hosted by Amazon Web
         * Services.
         * </p>
         * 
         * @param endpoints
         *        The endpoint URLs for your Amazon Kendra experiences. The URLs are unique and fully hosted by Amazon
         *        Web Services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(ExperienceEndpoint... endpoints);

        /**
         * <p>
         * The endpoint URLs for your Amazon Kendra experiences. The URLs are unique and fully hosted by Amazon Web
         * Services.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ExperienceEndpoint>.Builder}
         * avoiding the need to create one manually via {@link List<ExperienceEndpoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ExperienceEndpoint>.Builder#build()} is called immediately
         * and its result is passed to {@link #endpoints(List<ExperienceEndpoint>)}.
         * 
         * @param endpoints
         *        a consumer that will call methods on {@link List<ExperienceEndpoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoints(List<ExperienceEndpoint>)
         */
        Builder endpoints(Consumer<ExperienceEndpoint.Builder>... endpoints);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String id;

        private Instant createdAt;

        private String status;

        private List<ExperienceEndpoint> endpoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExperiencesSummary model) {
            name(model.name);
            id(model.id);
            createdAt(model.createdAt);
            status(model.status);
            endpoints(model.endpoints);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExperienceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<ExperienceEndpoint.Builder> getEndpoints() {
            List<ExperienceEndpoint.Builder> result = ExperienceEndpointsCopier.copyToBuilder(this.endpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpoints(Collection<ExperienceEndpoint.BuilderImpl> endpoints) {
            this.endpoints = ExperienceEndpointsCopier.copyFromBuilder(endpoints);
        }

        @Override
        public final Builder endpoints(Collection<ExperienceEndpoint> endpoints) {
            this.endpoints = ExperienceEndpointsCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(ExperienceEndpoint... endpoints) {
            endpoints(Arrays.asList(endpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Consumer<ExperienceEndpoint.Builder>... endpoints) {
            endpoints(Stream.of(endpoints).map(c -> ExperienceEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ExperiencesSummary build() {
            return new ExperiencesSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
